/*******************************/
/* Inclusion des bibliotheques */
/*******************************/

#include "vxWorks.h"	/* Bibliotheque de base de vxworks */
#include "ioLib.h"	/* Bibliotheque d'entrees/sorties de vxworks */
#include "msgQLib.h"    /* Bibliotheque de manipulation des messages queues */
#include "semLib.h"	/* Bibliotheque de manipulation des semaphores */
#include "pipeDrv.h"	/* Bibliotheque de manipulation des tubes */
#include "stdio.h"	/* Bibliotheque d'entrees/sorties standard */
#include "time.h"	/* Bibliotheque de gestion des dates */
#include "stdlib.h"	/* Bibliotheque de definitions generales */
#include "string.h"	/* Bibliotheque de gestion des chaines */
#include "socket.h"
#include "types.h"
#include "in.h"
#include <acq.h>


/***************************/
/* Declaration des defines */
/***************************/

#define LONGUEUR 1 /* Longueur des messages manipules dans les queues */
#define NOMBRE	1 /* Nombre de messages manipules dans les queues */

/**************************************/
/* Declaration des variables externes */
/**************************************/ 

extern char *nom_tube_fenetre;
extern struct tb_acq *pt_str;	/*structure d acquisition*/
extern short *pt_fen;		/*fenetres d acquisition*/
extern long *pt_etat;		/*table d etat*/
extern short *pt_cor;		/*table de correction*/
extern MSG_Q_ID queue_etat_mecanique_id;
extern MSG_Q_ID queue_etat_integration_id;
extern MSG_Q_ID queue_reveil_mecanique_id;
extern MSG_Q_ID queue_integration_1_id;
extern MSG_Q_ID queue_integration_2_id;
extern MSG_Q_ID queue_demande_integration_1_id;
extern MSG_Q_ID queue_demande_integration_2_id;
extern SEM_ID semaphore_dma_id;
extern SEM_ID semaphore_plan_vide_id;
extern SEM_ID semaphore_numerisation_id;
extern SEM_ID semaphore_fin_cadence_id;

/**************************************/
/* Definition de moniteur de controle */
/**************************************/

typedef struct {int integration;
		int numerisation;
		int mecanique;
		int dma;
		int plans;
		int precedente;
		int info[6];} structure_moniteur;

structure_moniteur plan_moniteur;


/**************************/	
/* Definition des modules */
/**************************/

VOID transfert (char *nom_tube_fenetre,
		SEM_ID semaphore_dma_id,
		SEM_ID semaphore_numerisation_id,
		SEM_ID semaphore_plan_vide_id);

VOID dma (char *nom_tube_fenetre,
		     SEM_ID semaphore_dma_id);

VOID inter_ctrl(MSG_Q_ID queue_reveil_mecanique_id,
		      MSG_Q_ID queue_etat_integration_id,
		      MSG_Q_ID queue_etat_mecanique_id);

VOID lorin (MSG_Q_ID queue_integration_1_id,
		       MSG_Q_ID queue_integration_2_id,
		       SEM_ID semaphore_numerisation_id,
                       SEM_ID semaphore_plan_vide_id);

time_t acqu_elem (MSG_Q_ID queue_demande_integration_1_id, 
			        MSG_Q_ID queue_demande_integration_2_id, 
			        MSG_Q_ID queue_integration_1_id,
			        MSG_Q_ID queue_integration_2_id, 
			        SEM_ID semaphore_numerisation_id,
			        int niveau);

VOID interface_vme (MSG_Q_ID queue_etat_mecanique_id,
		MSG_Q_ID queue_etat_integration_id,
		MSG_Q_ID queue_demande_integration_1_id, 
		MSG_Q_ID queue_demande_integration_2_id);

VOID cadenceur (int cadence,
		MSG_Q_ID queue_demande_integration_1_id,
		MSG_Q_ID queue_demande_integration_2_id,
		MSG_Q_ID queue_integration_1_id,
		MSG_Q_ID queue_integration_2_id,
		SEM_ID semaphore_numerisation_id,
		SEM_ID semaphore_fin_cadence_id);

VOID moniteur_vme (void);
