/*------------------------------------------------------------------------
 *				ACQ.H
 ------------------------------------------------------------------------*/




#ifndef _prec_acq_h
#define _prec_acq_h

#define TAB_SIZE		0x600000L /* Taille de la memoire data */
	
#define NB_MAX_EMPL	        50	/* Nbre de tampons MAX memoire en mode \
					soleil entier */
#define NB_STOCKES_EMPL		2	/* Nbre de tampons memoire en mode\
					   CCD 288*384 */
#define NB_MAX_OBT		8	
#define NB_MAX_VOIE		6	/*Nombre de voies Soleil entier */


#define SUN_BUSY 		1	/*vu de la SUN, c'est occupe */
#define SUN_NOT_BUSY		0	/*vu de la SUN, c'est libre */

#define VME_BUSY		0	/*vu du VME, c'est occupe */
#define VME_NOT_BUSY		1	/*vu du VME, c'est libre */


#define TPS_NUM			250	/*tps de numerisation en ms */
#define TPS_NUM_PRAT            300     /*+offset evite fin de num err */
#define TPS_INTG_MIN            5       /* tps min d'ineg */
#define TPS_LECT                70      /* tps de lecture d'1 fenetre */
#define CAMERA_SOLEIL_ENTIER    31


#define 	NB_MAX_FEN		40
#define         ADR_DMA         16
#define 	NOTH		-1
#define         ZERO            0
#define         IMAGE           2

#define TAILLE_BLOC_FITS    2880     /*2880 octets*/
#define NB_LI_BLOC_FITS     36       /*header fits: 36lignes de 80 characteres = 2880 octets*/
#define TAILLE_MAX_LIST_ORDO    8     /*taille maximale d'une liste de mot cle ordonnes*/
                                      /*associe a un type de header. cf Type_header */

#define DYN_FLAG_ON    0       /*vu de la SUN, la nouvelle information dynamique est disponible*/
#define DYN_FLAG_OFF   1       /*vu de la SUN, pas de nouvelle information dynamique*/

#ifndef _prec_tb_ctrl_cam_h	
#include "tb_ctrl_cam.h"
#endif




typedef short Datum;

#define TAILLE_VAL 70

typedef char chfits[TAILLE_VAL+1];


typedef struct ent_fen
{
long nval;
long num;
long hr;
}      Ent_fen;


typedef struct coor_fen
{
long	ligdb;	/* indice de la ligne de debut	*/
long	coldb;	/* indice de la colonne de debut*/
long	nblig;	/* nombre de lignes	*/
long	nbcol;	/* nombre de colonnes	*/
}	Coor_fen;



typedef struct ent_acq
{
long	info1;	
long	info2;	
long    info3;  
long	hr;	/* heure d'acquisition de la fenetre */
}	Ent_acq;

typedef struct tb_index
{
  long  count;
  long  seq_ind;
  long  nbreg;
  long  ind_reg;
  float stepx;
  long  nbstepx;
  long indstepx;
  float stepy;
  long  nbstepy;
  long indstepy;
  long  nbstep;
  long  indstep;
  long  stokes;
  long  indlambd;
  long  nblambd;
}       Tb_index;



typedef struct tb_dyn
{
  float   longitud;
  float   latitud;
  chfits  date_obs;
  float   posrot;
  float   alpha;
  float   delta;
  float   polarang;
  float   svector;
  float   eleva;
  float   azimuth;
  long    posqwp1;
  long    posqwp2;
  float   prefente;
  float   dist_ew;
  float   dist_ns;
  float   longcarr;
  float   solar_p0;
  float   solar_b0;
  float   ngcarr;
  long   solar_n;
  float   solar_r;
  float tempqwp1;
  float tempqwp2;
  float tempbmsp;
  float predang;
  float echelang;
}       Tb_dyn;



typedef struct fen_info
{
long	sens;	/* sens de lecture de la fenetre */
long	nocam;	/* numero de la camera	*/
long    nobuf;   /* numero du buffer */
long	noplan;	/* numero du plan  */
long	type;	/* type de donnees */ 
long    mem_offset; /* position dans la memoire en shorts */
}	Fen_info;



typedef struct tb_acq
{
long	enfen;			/*nombre d'octets de l'entete de fenetre*/
long	nbfen;			/*nombre de fenetres max=NB_MAX_FEN*/
Coor_fen 	tab_fen[NB_MAX_FEN]; 		/*description des fenetres*/
Fen_info 	tab_info_fen[NB_MAX_FEN];	/*info suppl pour l'acq	*/
long		dintg[NB_MAX_OBT]; 		/*duree d'integration	*/
Tb_index        index;
Tb_dyn          dyn; 
long	nbcam; 			/* nombre de cameras */
long	nbacq;			/*nombre d'acquisitions */
long	cadac;			/*cadence d'acquisition des fenetres*/
long	ctrac;			/*controle de l'acquisition	*/
long	modob;			/*mode d'observation		*/
long	meca;			/*synchro meca ou pas	*/
long	monit;			/*moniteur de controle ou pas	*/
long	npix;			/*nombre de pixels par voie du soleil entier*/
long	obscur;			/*mesure des courants d obscurite si = 1*/
long	vison; 			/*visu en fonctionnement si = 1*/
unsigned long	sec_dep;	/*heure de demarrage du soleil entier*/
unsigned long	nsec_dep;	/*nanosecondes	"	"	*/
long    themisff;                /* type du fichier fits */
}	Tb_acq;




typedef enum dyn_flag
{
DFLAG_INDEX,
DFLAG_INDLAMBD,
DFLAG_STEP,
DFLAG_STOKES,
DFLAG_PPOU,
DFLAG_PLAM,
NB_DYN_FLAGS
} Dyn_flag;



/* pour le partage de la memoire */

typedef struct tb_ctrl
{
long	nb_empl;	/* nombre d'emplacements reserves	*/
long	taille_empl;	/* taille d'une place (deplacement)	*/
long	verrou[NB_MAX_EMPL];	/* verrous sur les emplacements*/
long	vervis[NB_MAX_EMPL];	/* verrous sur les emplacements pour visu*/
long    dyn_flags[NB_DYN_FLAGS];    /* flags pour les infos dynamiques */   
}	Tb_ctrl;



typedef struct tb_point
{
Tb_acq		*pt_tab_acq;	/* pointeur sur la tb_acq*/
Tb_ctrl		*pt_ctrl;	/* pointeur sur la tb_ctrl*/
Datum  		*pt_data;	/* pointeur sur la zone de donnees*/
Tb_ctrl_cam 	*pt_cam;	/*pointeur sur le ctrl cameras	*/
}	Tb_point;


#ifndef _prec_param_h	
#include "param.h"
#endif

/*nom des differents types possibles pour les infos a ecrire dans les entetes FITS*/

typedef enum param_type
{
TYPE_CHAR,
TYPE_LONG,
TYPE_DOUBLE,
TYPE_CHFITS
} Param_type;

/*Union regroupant les differents types possibles pour les infos a ecrire dans les ent. FITS*/

typedef union param_value
{
char type_char;
long type_long;
double type_double;
chfits type_chfits;
} Param_value;


/*Structure regroupant toutes les infos concernant un mot cle FITS*/

typedef struct param_info
{
  Ind_mcle indice;     /*indice du mot cle*/
  Param_type type;     /*type de ce mot cle*/
  Param_value value;   /*valeur de ce mot cle: accessible via value.type_xxxx*/
  int fenetre;         /*numero de la fenetre associe a cette valeur du mot cle*/
} Param_info;

/*Structure decrivant les ententes FITS en memoires*/

typedef struct mem_header
{
  char *common;
  char de_fen[NB_MAX_FEN][TAILLE_BLOC_FITS+1];
  long common_size;
} Mem_header;

typedef enum type_header
{
TOP_HEADER,
DYN_HEADER,
NB_TYPE_HEADER
} Type_header;

#endif	/* _prec_acq */







