/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.xmlrpc.XmlRpcClient;

public class PlasticUtils {
    public static final String XMLRPC_PREFIX = Double.parseDouble("0.4") > 0.399 ? null : "plastic.client";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.plastic");
    public static boolean WARN_ABOUT_NOSUCHELEMENTEXCEPTIONS = true;

    private PlasticUtils() {
    }

    public static XmlRpcClient createXmlRpcClient(URL url) {
        return new XmlRpcClient(url);
    }

    static int getUnusedPort(int startPort) throws IOException {
        int nTry = 20;
        for (int iPort = startPort; iPort < startPort + 20; ++iPort) {
            try {
                Socket trySocket = new Socket("localhost", iPort);
                if (trySocket.isClosed()) continue;
                if (WARN_ABOUT_NOSUCHELEMENTEXCEPTIONS) {
                    WARN_ABOUT_NOSUCHELEMENTEXCEPTIONS = false;
                    System.err.println("Please ignore spurious \"java.util.NoSuchElementException\" messages.");
                }
                trySocket.close();
                continue;
            }
            catch (ConnectException e) {
                return iPort;
            }
        }
        throw new IOException("Can't locate an unused port in range " + startPort + " ... " + (startPort + 20));
    }
}

