/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.xmlrpc;

import java.io.IOException;
import java.util.Collections;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.xmlrpc.CallableClientServer;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServerFactory;
import org.astrogrid.samp.xmlrpc.XmlRpcHubConnection;

class StandardHubConnection
extends XmlRpcHubConnection {
    private final SampXmlRpcServerFactory serverFactory_;
    private final String clientKey_ = this.getRegInfo().getPrivateKey();
    private CallableClientServer callableServer_;

    public StandardHubConnection(SampXmlRpcClient xClient, SampXmlRpcServerFactory serverFactory, String secret) throws SampException {
        super(xClient, "samp.hub.", Collections.singletonList(secret));
        this.serverFactory_ = serverFactory;
    }

    public Object getClientKey() {
        return this.clientKey_;
    }

    public void setCallable(CallableClient callable) throws SampException {
        if (this.callableServer_ == null) {
            try {
                this.callableServer_ = CallableClientServer.getInstance(this.serverFactory_.getServer());
            }
            catch (IOException e) {
                throw new SampException("Can't start client XML-RPC server", e);
            }
        }
        this.callableServer_.addClient(this, callable);
        this.exec("setXmlrpcCallback", new Object[]{this.callableServer_.getUrl().toString()});
    }

    public void unregister() throws SampException {
        if (this.callableServer_ != null) {
            this.callableServer_.removeClient(this);
        }
        super.unregister();
    }
}

