/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.astrogrid.samp.hub.HubProfile;
import org.astrogrid.samp.hub.HubProfileFactory;
import org.astrogrid.samp.hub.MessageRestriction;
import org.astrogrid.samp.web.ClientAuthorizer;
import org.astrogrid.samp.web.ClientAuthorizers;
import org.astrogrid.samp.web.ExtremeSwingClientAuthorizer;
import org.astrogrid.samp.web.HubSwingClientAuthorizer;
import org.astrogrid.samp.web.ListMessageRestriction;
import org.astrogrid.samp.web.OriginAuthorizers;
import org.astrogrid.samp.web.WebHubProfile;

public class WebHubProfileFactory
implements HubProfileFactory {
    private static final String logUsage_ = "[-web:log none|http|xml|rpc]";
    private static final String authUsage_ = "[-web:auth swing|true|false|extreme]";
    private static final String corsUsage_ = "[-web:[no]cors]";
    private static final String flashUsage_ = "[-web:[no]flash]";
    private static final String silverlightUsage_ = "[-web:[no]silverlight]";
    private static final String urlcontrolUsage_ = "[-web:[no]urlcontrol]";
    private static final String restrictMtypeUsage_ = "[-web:[no]restrictmtypes]";

    public String getName() {
        return "web";
    }

    public String[] getFlagsUsage() {
        return new String[]{logUsage_, authUsage_, corsUsage_, flashUsage_, silverlightUsage_, urlcontrolUsage_, restrictMtypeUsage_};
    }

    public HubProfile createHubProfile(List flagList) throws IOException {
        ClientAuthorizer clientAuth;
        String logType = "none";
        String authType = "swing";
        boolean useCors = true;
        boolean useFlash = true;
        boolean useSilverlight = false;
        boolean urlControl = true;
        boolean restrictMtypes = true;
        Iterator it = flagList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-web:log")) {
                it.remove();
                if (it.hasNext()) {
                    logType = (String)it.next();
                    it.remove();
                    continue;
                }
                throw new IllegalArgumentException("Usage: [-web:log none|http|xml|rpc]");
            }
            if (arg.equals("-web:auth")) {
                it.remove();
                if (it.hasNext()) {
                    authType = (String)it.next();
                    it.remove();
                    continue;
                }
                throw new IllegalArgumentException("Usage: [-web:auth swing|true|false|extreme]");
            }
            if (arg.equals("-web:cors")) {
                it.remove();
                useCors = true;
                continue;
            }
            if (arg.equals("-web:nocors")) {
                it.remove();
                useCors = false;
                continue;
            }
            if (arg.equals("-web:flash")) {
                it.remove();
                useFlash = true;
                continue;
            }
            if (arg.equals("-web:noflash")) {
                it.remove();
                useFlash = false;
                continue;
            }
            if (arg.equals("-web:silverlight")) {
                it.remove();
                useSilverlight = true;
                continue;
            }
            if (arg.equals("-web:nosilverlight")) {
                it.remove();
                useSilverlight = false;
                continue;
            }
            if (arg.equals("-web:urlcontrol")) {
                urlControl = true;
                continue;
            }
            if (arg.equals("-web:nourlcontrol")) {
                urlControl = false;
                continue;
            }
            if (arg.equals("-web:restrictmtypes")) {
                restrictMtypes = true;
                continue;
            }
            if (!arg.equals("-web:norestrictmtypes")) continue;
            restrictMtypes = false;
        }
        WebHubProfile.ServerFactory sfact = new WebHubProfile.ServerFactory();
        try {
            sfact.setLogType(logType);
        }
        catch (IllegalArgumentException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unknown log type " + logType + "; Usage: " + logUsage_).initCause(e);
        }
        sfact.setOriginAuthorizer(useCors ? OriginAuthorizers.TRUE : OriginAuthorizers.FALSE);
        sfact.setAllowFlash(useFlash);
        sfact.setAllowSilverlight(useSilverlight);
        if ("swing".equalsIgnoreCase(authType)) {
            clientAuth = ClientAuthorizers.createLoggingClientAuthorizer(new HubSwingClientAuthorizer(null), Level.INFO, Level.INFO);
        } else if ("extreme".equalsIgnoreCase(authType)) {
            clientAuth = ClientAuthorizers.createLoggingClientAuthorizer(new ExtremeSwingClientAuthorizer(null), Level.WARNING, Level.INFO);
        } else if ("true".equalsIgnoreCase(authType)) {
            clientAuth = ClientAuthorizers.TRUE;
        } else if ("false".equalsIgnoreCase(authType)) {
            clientAuth = ClientAuthorizers.FALSE;
        } else {
            throw new IllegalArgumentException("Unknown authorizer type " + authType + "; Usage: " + authUsage_);
        }
        MessageRestriction mrestrict = restrictMtypes ? ListMessageRestriction.DEFAULT : null;
        return new WebHubProfile(sfact, clientAuth, mrestrict, WebHubProfile.createKeyGenerator(), urlControl);
    }

    public Class getHubProfileClass() {
        return WebHubProfile.class;
    }
}

