/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.web.OriginAuthorizer;

public class CorsHttpServer
extends HttpServer {
    private final OriginAuthorizer authorizer_;
    private static final String ORIGIN_KEY = "Origin";
    private static final String ALLOW_ORIGIN_KEY = "Access-Control-Allow-Origin";
    private static final String REQUEST_METHOD_KEY = "Access-Control-Request-Method";
    private static final String ALLOW_METHOD_KEY = "Access-Control-Allow-Methods";
    private static final String ALLOW_HEADERS_KEY = "Access-Control-Allow-Headers";
    private static final Pattern ORIGIN_REGEX = Pattern.compile("http://[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*(:[0-9]+)?");
    private static final Logger logger_ = Logger.getLogger(CorsHttpServer.class.getName());

    public CorsHttpServer(ServerSocket socket, OriginAuthorizer authorizer) throws IOException {
        super(socket);
        this.authorizer_ = authorizer;
    }

    public HttpServer.Response serve(HttpServer.Request request) {
        if (!CorsHttpServer.isLocalHost(request.getRemoteAddress())) {
            return this.createNonLocalErrorResponse(request);
        }
        Map hdrMap = request.getHeaderMap();
        String method = request.getMethod();
        String originTxt = CorsHttpServer.getHeader(hdrMap, ORIGIN_KEY);
        if (originTxt != null) {
            String reqMethod = CorsHttpServer.getHeader(hdrMap, REQUEST_METHOD_KEY);
            if (method.equals("OPTIONS") && reqMethod != null) {
                return this.servePreflightOriginRequest(request, originTxt, reqMethod);
            }
            return this.serveSimpleOriginRequest(request, originTxt);
        }
        return super.serve(request);
    }

    private HttpServer.Response serveSimpleOriginRequest(HttpServer.Request request, String originTxt) {
        Map headerMap;
        HttpServer.Response response = super.serve(request);
        if (this.isAuthorized(originTxt) && CorsHttpServer.getHeader(headerMap = response.getHeaderMap(), ALLOW_ORIGIN_KEY) == null) {
            headerMap.put(ALLOW_ORIGIN_KEY, originTxt);
        }
        return response;
    }

    private HttpServer.Response servePreflightOriginRequest(HttpServer.Request request, String originTxt, String reqMethod) {
        LinkedHashMap<String, String> hdrMap = new LinkedHashMap<String, String>();
        hdrMap.put("Content-Length", "0");
        if (this.isAuthorized(originTxt)) {
            hdrMap.put(ALLOW_ORIGIN_KEY, originTxt);
            hdrMap.put(ALLOW_METHOD_KEY, reqMethod);
            hdrMap.put(ALLOW_HEADERS_KEY, "Content-Type");
        }
        return new HttpServer.Response(200, "OK", hdrMap){

            public void writeBody(OutputStream out) {
            }
        };
    }

    private HttpServer.Response createNonLocalErrorResponse(HttpServer.Request request) {
        byte[] mbuf;
        int status = 403;
        String msg = "Forbidden";
        String method = request.getMethod();
        if ("HEAD".equals(method)) {
            return CorsHttpServer.createErrorResponse(status, msg);
        }
        LinkedHashMap<String, String> hdrMap = new LinkedHashMap<String, String>();
        hdrMap.put("Content-Type", "text/plain");
        try {
            mbuf = "Access to server from non-local hosts is not permitted.\r\n".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger_.warning("Unsupported UTF-8??");
            mbuf = new byte[]{};
        }
        final byte[] mbuf1 = mbuf;
        hdrMap.put("Content-Length", Integer.toString(mbuf1.length));
        return new HttpServer.Response(status, msg, hdrMap){

            public void writeBody(OutputStream out) throws IOException {
                out.write(mbuf1);
                out.flush();
            }
        };
    }

    private boolean isAuthorized(String originTxt) {
        boolean hasLegalOrigin;
        try {
            CorsHttpServer.checkOriginList(originTxt);
            hasLegalOrigin = true;
        }
        catch (RuntimeException e) {
            logger_.warning("Origin header: " + e.getMessage());
            hasLegalOrigin = false;
        }
        return hasLegalOrigin && this.authorizer_.authorize(originTxt);
    }

    public static boolean isLocalHost(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetAddress iAddress = ((InetSocketAddress)address).getAddress();
            if (iAddress == null) {
                return false;
            }
            if (iAddress.isLoopbackAddress()) {
                return true;
            }
            try {
                return iAddress.equals(InetAddress.getLocalHost());
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
        logger_.warning("Socket address not from internet? " + address);
        return false;
    }

    private static void checkOriginList(String originTxt) {
        String[] origins = originTxt.split(" +");
        if (origins.length > 0) {
            for (int i = 0; i < origins.length; ++i) {
                if (ORIGIN_REGEX.matcher(origins[i]).matches()) continue;
                throw new IllegalArgumentException("Bad origin syntax: \"" + origins[i] + "\"");
            }
        } else {
            throw new IllegalArgumentException("No origins supplied");
        }
    }
}

