/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcClientRequestProcessor;
import org.apache.xmlrpc.XmlRpcClientResponseProcessor;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcTransport;

public class XmlRpcClientWorker {
    protected XmlRpcClientRequestProcessor requestProcessor;
    protected XmlRpcClientResponseProcessor responseProcessor;
    private static final Object PROCESSING_ERROR_FLAG = new Object();

    public XmlRpcClientWorker() {
        this(new XmlRpcClientRequestProcessor(), new XmlRpcClientResponseProcessor());
    }

    public XmlRpcClientWorker(XmlRpcClientRequestProcessor requestProcessor, XmlRpcClientResponseProcessor responseProcessor) {
        this.requestProcessor = requestProcessor;
        this.responseProcessor = responseProcessor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(XmlRpcClientRequest xmlRpcRequest, XmlRpcTransport transport) throws XmlRpcException, XmlRpcClientException, IOException {
        Object object;
        Object response;
        block13: {
            long now = 0L;
            response = PROCESSING_ERROR_FLAG;
            if (XmlRpc.debug) {
                now = System.currentTimeMillis();
            }
            try {
                try {
                    byte[] request = this.requestProcessor.encodeRequestBytes(xmlRpcRequest, this.responseProcessor.getEncoding());
                    InputStream is = transport.sendXmlRpc(request);
                    object = response = this.responseProcessor.decodeResponse(is);
                    Object var10_11 = null;
                    if (!XmlRpc.debug) break block13;
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (XmlRpcClientException xrce) {
                    throw xrce;
                }
                catch (RuntimeException x) {
                    if (!XmlRpc.debug) throw new XmlRpcClientException("Unexpected exception in client processing", x);
                    x.printStackTrace();
                    throw new XmlRpcClientException("Unexpected exception in client processing", x);
                }
                System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis in request/process/response");
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (XmlRpc.debug) {
                    System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis in request/process/response");
                }
                try {
                    transport.endClientRequest();
                    throw throwable;
                }
                catch (Throwable t) {
                    boolean haveFault = response instanceof XmlRpcException;
                    if (!haveFault && response != PROCESSING_ERROR_FLAG) {
                        if (!(t instanceof XmlRpcException)) throw new XmlRpcClientException("Unable to end request", t);
                        throw (XmlRpcException)t;
                    }
                    System.err.println("Avoiding obscuring previous error by supressing error encountered while ending request: " + t);
                    if (!haveFault) throw throwable;
                    throw (XmlRpcException)response;
                }
            }
        }
        try {}
        catch (Throwable t) {
            boolean haveFault = response instanceof XmlRpcException;
            if (!haveFault && response != PROCESSING_ERROR_FLAG) {
                if (!(t instanceof XmlRpcException)) throw new XmlRpcClientException("Unable to end request", t);
                throw (XmlRpcException)t;
            }
            System.err.println("Avoiding obscuring previous error by supressing error encountered while ending request: " + t);
            if (!haveFault) return object;
            throw (XmlRpcException)response;
        }
        transport.endClientRequest();
        return object;
    }
}

