/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.IOException;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.Vector;
import org.apache.xmlrpc.DefaultXmlRpcTransport;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcClientWorker;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcTransport;
import org.apache.xmlrpc.XmlRpcTransportFactory;

public class XmlRpcClient
implements XmlRpcHandler {
    protected URL url;
    private String storedUser;
    private String storedPassword;
    protected Stack pool = new Stack();
    protected int workers = 0;
    protected int asyncWorkers = 0;
    protected XmlRpcTransportFactory transportFactory;
    private int maxThreads = -1;

    public XmlRpcClient(URL url) {
        this.url = url;
        if (XmlRpc.debug) {
            System.out.println("Created client to url space " + url);
        }
    }

    public int getMaxThreads() {
        if (this.maxThreads == -1) {
            return XmlRpc.getMaxThreads();
        }
        return this.maxThreads;
    }

    public Object execute(String method, Vector params) throws XmlRpcException, IOException {
        if (this.storedUser != null && this.storedPassword != null && this.transportFactory == null) {
            DefaultXmlRpcTransport transport = this.createDefaultTransport();
            transport.setBasicAuthentication(this.storedUser, this.storedPassword);
            return this.execute(new XmlRpcRequest(method, params), transport);
        }
        return this.execute(new XmlRpcRequest(method, params));
    }

    public Object execute(XmlRpcClientRequest request) throws XmlRpcException, IOException {
        return this.execute(request, this.createTransport());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(XmlRpcClientRequest request, XmlRpcTransport transport) throws XmlRpcException, IOException {
        XmlRpcClientWorker worker = this.getWorker(false);
        try {
            Object retval;
            Object object = retval = worker.execute(request, transport);
            return object;
        }
        finally {
            this.releaseWorker(worker, false);
        }
    }

    synchronized XmlRpcClientWorker getWorker(boolean async) throws IOException {
        try {
            XmlRpcClientWorker w = (XmlRpcClientWorker)this.pool.pop();
            if (async) {
                ++this.asyncWorkers;
            } else {
                ++this.workers;
            }
            return w;
        }
        catch (EmptyStackException x) {
            if (this.workers < this.getMaxThreads()) {
                if (async) {
                    ++this.asyncWorkers;
                } else {
                    ++this.workers;
                }
                return new XmlRpcClientWorker();
            }
            throw new IOException("XML-RPC System overload");
        }
    }

    synchronized void releaseWorker(XmlRpcClientWorker w, boolean async) {
        if (this.pool.size() < 20) {
            this.pool.push(w);
        }
        if (async) {
            --this.asyncWorkers;
        } else {
            --this.workers;
        }
    }

    protected XmlRpcTransport createTransport() throws XmlRpcClientException {
        if (this.transportFactory == null) {
            return this.createDefaultTransport();
        }
        return this.transportFactory.createTransport();
    }

    private DefaultXmlRpcTransport createDefaultTransport() {
        return new DefaultXmlRpcTransport(this.url);
    }
}

