/*
 * Decompiled with CFR 0.152.
 */
package net.ladypleaser.rmilite;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;

public class RemoteInvocationException
extends RuntimeException {
    private Throwable cause;

    public RemoteInvocationException(String method, Throwable cause) {
        super("error invoking " + method + ": " + cause);
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        if (this.cause != null) {
            stream.println("caused by: ");
            this.cause.printStackTrace(stream);
        }
    }

    public static void rethrow(Method method, RemoteInvocationException e) throws Throwable {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        int i = 0;
        while (i < exceptionTypes.length) {
            if (exceptionTypes[i].isAssignableFrom(cause.getClass())) {
                throw cause;
            }
            ++i;
        }
        throw e;
    }

    public static void rethrow(Method method, RemoteException e) {
        if (e.detail != null) {
            throw new RemoteInvocationException(method.getName(), e);
        }
        throw new RemoteInvocationException(method.getName(), e);
    }
}

