/*
 * Decompiled with CFR 0.152.
 */
package healpix.essentials;

import healpix.essentials.HealpixBase;
import healpix.essentials.HealpixUtils;
import healpix.essentials.Moc;
import healpix.essentials.Scheme;
import healpix.essentials.Vec3;
import java.util.ArrayList;

public class MocQuery {
    public static Moc doMocQuery(int order, ArrayList<MocQueryComponent> comp) throws Exception {
        return new queryHelper(order, order, false, comp).result();
    }

    private static double isLeft(Vec3 a, Vec3 b, Vec3 c) {
        return a.cross(b).dot(c);
    }

    private static int[] getHull(Vec3[] vert, int[] P) throws Exception {
        int n = P.length;
        int[] D = new int[2 * n + 1];
        int bot = n - 2;
        int top = bot + 3;
        D[bot] = D[top] = P[2];
        if (MocQuery.isLeft(vert[P[0]], vert[P[1]], vert[P[2]]) > 0.0) {
            D[bot + 1] = P[0];
            D[bot + 2] = P[1];
        } else {
            D[bot + 1] = P[1];
            D[bot + 2] = P[0];
        }
        for (int i = 3; i < n; ++i) {
            if (MocQuery.isLeft(vert[D[bot]], vert[D[bot + 1]], vert[P[i]]) > 0.0 && MocQuery.isLeft(vert[D[top - 1]], vert[D[top]], vert[P[i]]) > 0.0) continue;
            while (MocQuery.isLeft(vert[D[bot]], vert[D[bot + 1]], vert[P[i]]) <= 0.0) {
                ++bot;
            }
            D[--bot] = P[i];
            while (MocQuery.isLeft(vert[D[top - 1]], vert[D[top]], vert[P[i]]) <= 0.0) {
                --top;
            }
            D[++top] = P[i];
        }
        int nout = top - bot;
        int[] res = new int[nout];
        for (int h = 0; h < nout; ++h) {
            res[h] = D[bot + h + 1];
        }
        return res;
    }

    public static ArrayList<MocQueryComponent> prepPolyHelper(Vec3[] vv, int[] P, ArrayList<MocQueryComponent> comp) throws Exception {
        int i;
        int[] hull = MocQuery.getHull(vv, P);
        for (i = 0; i < hull.length; ++i) {
            comp.add(new MocQueryComponent(vv[hull[i]].cross(vv[hull[(i + 1) % hull.length]]).norm(), 1.5707963267948966));
        }
        for (i = 1; i < hull.length; ++i) {
            comp.add(new MocQueryComponent(MocQueryOp.AND));
        }
        int ihull = 0;
        int ipoly = 0;
        int nhull = hull.length;
        int npoly = P.length;
        while (hull[ihull] != P[ipoly]) {
            ++ipoly;
        }
        do {
            int ipoly_next;
            int ihull_next;
            if (hull[ihull_next = (ihull + 1) % nhull] == P[ipoly_next = (ipoly + 1) % npoly]) {
                ihull = ihull_next;
                ipoly = ipoly_next;
                continue;
            }
            int nvpocket = 2;
            while (P[ipoly_next] != hull[ihull_next]) {
                ipoly_next = (ipoly_next + 1) % npoly;
                ++nvpocket;
            }
            int[] ppocket = new int[nvpocket];
            int idx = 0;
            int ipoly_bw = ipoly_next;
            while (P[ipoly_bw] != hull[ihull]) {
                ppocket[idx++] = P[ipoly_bw];
                ipoly_bw = (ipoly_bw + npoly - 1) % npoly;
            }
            ppocket[idx] = hull[ihull];
            comp = MocQuery.prepPolyHelper(vv, ppocket, comp);
            comp.add(new MocQueryComponent(MocQueryOp.NOT));
            comp.add(new MocQueryComponent(MocQueryOp.AND));
            ihull = ihull_next;
            ipoly = ipoly_next;
        } while (ihull != 0);
        return comp;
    }

    public static ArrayList<MocQueryComponent> prepPolygon(ArrayList<Vec3> vertex) throws Exception {
        HealpixUtils.check(vertex.size() >= 3, "not enough vertices in polygon");
        Vec3[] vv = new Vec3[vertex.size()];
        for (int i = 0; i < vertex.size(); ++i) {
            vv[i] = vertex.get(i).norm();
        }
        int[] P = new int[vv.length];
        for (int i = 0; i < P.length; ++i) {
            P[i] = i;
        }
        ArrayList<MocQueryComponent> comp = new ArrayList<MocQueryComponent>();
        return MocQuery.prepPolyHelper(vv, P, comp);
    }

    public static Moc queryGeneralPolygon(ArrayList<Vec3> vertex, int order) throws Exception {
        return MocQuery.doMocQuery(order, MocQuery.prepPolygon(vertex));
    }

    private static class queryHelper {
        private int order;
        private int omax;
        private int ncomp;
        private boolean inclusive;
        private HealpixBase[] base;
        private double[] cr;
        private double[][] crmin;
        private double[][] crmax;
        private int[] shortcut;
        private MocQueryOp[] op;
        private Vec3[] center;
        private pstack stk;
        private long pix;
        private int o;
        private Vec3 pv;
        private int loc;

        private void check_pixel(int zone, Moc pixset) {
            if (zone == 0) {
                return;
            }
            if (this.o < this.order) {
                if (zone >= 3) {
                    pixset.addPixel(this.o, this.pix);
                } else {
                    for (int i = 0; i < 4; ++i) {
                        this.stk.push(4L * this.pix + 3L - (long)i, this.o + 1);
                    }
                }
            } else if (this.o > this.order) {
                if (zone >= 2) {
                    pixset.addPixel(this.order, this.pix >>> 2 * (this.o - this.order));
                    this.stk.popToMark();
                } else if (this.o < this.omax) {
                    for (int i = 0; i < 4; ++i) {
                        this.stk.push(4L * this.pix + 3L - (long)i, this.o + 1);
                    }
                } else {
                    pixset.addPixel(this.order, this.pix >>> 2 * (this.o - this.order));
                    this.stk.popToMark();
                }
            } else if (zone >= 2) {
                pixset.addPixel(this.order, this.pix);
            } else if (this.inclusive) {
                if (this.order < this.omax) {
                    this.stk.mark();
                    for (int i = 0; i < 4; ++i) {
                        this.stk.push(4L * this.pix + 3L - (long)i, this.o + 1);
                    }
                } else {
                    pixset.addPixel(this.order, this.pix);
                }
            }
        }

        void correctLoc() throws Exception {
            int myloc;
            HealpixUtils.check((myloc = this.loc--) >= 0 && myloc < this.ncomp, "inconsistency");
            switch (this.op[myloc]) {
                case AND: 
                case OR: 
                case XOR: {
                    this.correctLoc();
                    this.correctLoc();
                    break;
                }
                case NOT: {
                    this.correctLoc();
                    break;
                }
            }
        }

        int getZone(int zmin, int zmax) {
            if (zmin == zmax) {
                this.loc = this.shortcut[this.loc];
                return zmin;
            }
            int myloc = this.loc--;
            switch (this.op[myloc]) {
                case AND: {
                    int z1 = this.getZone(zmin, zmax);
                    return this.getZone(zmin, z1);
                }
                case OR: {
                    int z1 = this.getZone(zmin, zmax);
                    return this.getZone(z1, zmax);
                }
                case XOR: {
                    int z1 = this.getZone(0, 3);
                    int z2 = this.getZone(0, 3);
                    return Math.max(zmin, Math.min(zmax, Math.max(Math.min(z1, 3 - z2), Math.min(3 - z1, z2))));
                }
                case NOT: {
                    return 3 - this.getZone(3 - zmax, 3 - zmin);
                }
                case NONE: {
                    int res = zmax;
                    double crad = this.pv.dot(this.center[myloc]);
                    if (crad <= this.crmax[this.o][myloc]) {
                        res = 0;
                    } else if (crad <= this.cr[myloc]) {
                        res = 1;
                    } else if (crad <= this.crmin[this.o][myloc]) {
                        res = 2;
                    }
                    return Math.max(zmin, Math.min(zmax, res));
                }
            }
            return -1;
        }

        public queryHelper(int order_, int omax_, boolean inclusive_, ArrayList<MocQueryComponent> comp) throws Exception {
            int i;
            this.order = order_;
            this.omax = omax_;
            this.ncomp = comp.size();
            this.inclusive = inclusive_;
            this.base = new HealpixBase[this.omax + 1];
            this.cr = new double[this.ncomp];
            this.crmin = new double[this.omax + 1][this.ncomp];
            this.crmax = new double[this.omax + 1][this.ncomp];
            HealpixUtils.check(this.ncomp >= 1, "bad query component ArrayList");
            HealpixUtils.check(this.order <= this.omax, "order>omax");
            if (!this.inclusive) {
                HealpixUtils.check(this.order == this.omax, "inconsistency");
            }
            HealpixUtils.check(this.omax <= 29, "omax too high");
            this.op = new MocQueryOp[this.ncomp];
            this.center = new Vec3[this.ncomp];
            for (i = 0; i < this.ncomp; ++i) {
                this.op[i] = comp.get((int)i).op;
                this.center[i] = comp.get((int)i).center;
                if (this.op[i] != MocQueryOp.NONE) continue;
                this.cr[i] = Math.cos(comp.get((int)i).radius);
            }
            this.o = 0;
            while (this.o <= this.omax) {
                this.base[this.o] = new HealpixBase(1 << this.o, Scheme.NESTED);
                double dr = this.base[this.o].maxPixrad();
                for (int i2 = 0; i2 < this.ncomp; ++i2) {
                    if (this.op[i2] != MocQueryOp.NONE) continue;
                    double r = comp.get((int)i2).radius;
                    this.crmax[this.o][i2] = r + dr >= Math.PI ? -1.01 : Math.cos(r + dr);
                    this.crmin[this.o][i2] = r - dr <= 0.0 ? 1.01 : Math.cos(r - dr);
                }
                ++this.o;
            }
            this.stk = new pstack(12 + 3 * this.omax);
            this.shortcut = new int[this.ncomp];
            for (i = 0; i < this.ncomp; ++i) {
                this.loc = i;
                this.correctLoc();
                this.shortcut[i] = this.loc;
            }
        }

        Moc result() throws Exception {
            Moc pixset = new Moc();
            this.stk.clear();
            this.stk.mark();
            for (int i = 0; i < 12; ++i) {
                this.stk.push(11 - i, 0);
            }
            while (!this.stk.empty()) {
                this.pix = this.stk.ptop();
                this.o = this.stk.otop();
                this.stk.pop();
                this.pv = this.base[this.o].pix2vec(this.pix);
                this.loc = this.ncomp - 1;
                int zone = this.getZone(0, 3);
                this.check_pixel(zone, pixset);
                HealpixUtils.check(this.loc == -1, "stack not used up");
            }
            return pixset;
        }

        private final class pstack {
            private long[] p;
            private int[] o;
            private int s;
            private int m;

            public pstack(int sz) {
                this.p = new long[sz];
                this.o = new int[sz];
                this.m = 0;
                this.s = 0;
            }

            public void push(long p_, int o_) {
                this.p[this.s] = p_;
                this.o[this.s] = o_;
                ++this.s;
            }

            public void pop() {
                --this.s;
            }

            public void popToMark() {
                this.s = this.m;
            }

            public int size() {
                return this.s;
            }

            public void mark() {
                this.m = this.s;
            }

            public int otop() {
                return this.o[this.s - 1];
            }

            public long ptop() {
                return this.p[this.s - 1];
            }

            public void clear() {
                this.m = 0;
                this.s = 0;
            }

            public boolean empty() {
                return this.s == 0;
            }
        }
    }

    public static class MocQueryComponent {
        public MocQueryOp op;
        public Vec3 center;
        public double radius;

        public MocQueryComponent(MocQueryOp op_) throws Exception {
            this.op = op_;
            HealpixUtils.check(op_ != MocQueryOp.NONE, "bad operator");
        }

        public MocQueryComponent(Vec3 cnt, double rad) {
            this.op = MocQueryOp.NONE;
            this.center = new Vec3(cnt);
            this.center.normalize();
            this.radius = rad;
        }
    }

    public static enum MocQueryOp {
        AND,
        OR,
        XOR,
        NOT,
        NONE;

    }
}

