/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.tools.Util;
import cds.xml.XMLConsumer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;

public final class XMLParser {
    private XMLConsumer ac;
    private MyInputStream dis;
    private Stack stack;
    public int nstack;
    private String name;
    private Hashtable param;
    private char[] ch;
    private int start;
    private int length;
    private int end;
    private byte[] tmp;
    private int offset;
    private int max;
    private String error;
    private boolean beforeXML;
    private String endTag;
    private int line;
    static final int BUFSIZE = 65536;
    static final int MAXBUF = 64512;
    static final String[] mKey = new String[]{"&amp;", "&gt;", "&lt;", "&apos;", "&quot;"};
    static final String[] mValue = new String[]{"&", ">", "<", "'", "\""};
    private static final char EOF = '\u001a';
    private static final char[] COM = new char[]{'!', '-', '-'};
    private boolean flagCOM;
    private static final char[] CDATA = new char[]{'!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private boolean flagCDATA;
    private boolean flagDoublePoint;
    private StringBuilder curString = new StringBuilder();
    private StringBuilder macro = new StringBuilder();

    public XMLParser(XMLConsumer ac) {
        this(ac, false);
    }

    public XMLParser(XMLConsumer ac, boolean withStack) {
        this.ac = ac;
        this.stack = withStack ? new Stack() : null;
        this.nstack = 0;
        this.param = new Hashtable();
        this.tmp = new byte[65536];
        this.max = 0;
        this.offset = 0;
        this.beforeXML = true;
        this.error = null;
    }

    public int getCurrentLine() {
        return this.line;
    }

    public boolean parse(MyInputStream dis) throws Exception {
        boolean rep;
        this.dis = dis;
        this.endTag = null;
        this.line = 0;
        this.setTestBeforeXML(dis);
        try {
            rep = this.xmlBeforeTag();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                System.out.println("XML parse error at line " + this.line);
            }
            throw e;
        }
        try {
            if (dis != null) {
                dis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rep;
    }

    public boolean parse(MyInputStream dis, String endTag) throws Exception {
        boolean rep;
        this.dis = dis;
        this.endTag = endTag;
        this.line = 0;
        this.setTestBeforeXML(dis);
        try {
            rep = this.xmlBeforeTag();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                System.out.println("XML parse error at line " + this.line);
            }
            throw e;
        }
        return rep;
    }

    private void setTestBeforeXML(MyInputStream dis) throws Exception {
        this.beforeXML = (dis.getType() & 0x100L) == 0L;
    }

    public Stack getStack() throws Exception {
        if (this.stack == null) {
            throw new Exception("No XML stack");
        }
        return this.stack;
    }

    public int getDepth() {
        return this.nstack;
    }

    public boolean in(String nameList) throws Exception {
        if (this.stack == null) {
            throw new Exception("No XML stack");
        }
        Enumeration e = this.stack.elements();
        StringTokenizer st = new StringTokenizer(nameList, ", /.\t\n\r\f");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            boolean found = false;
            while (e.hasMoreElements() && !(found = s.equals(e.nextElement()))) {
            }
            if (found) continue;
            return false;
        }
        return !e.hasMoreElements();
    }

    public String getError() {
        return this.error;
    }

    private void setError(String s) {
        this.error = s + "\n";
    }

    public static String XMLEncode(String s) {
        StringBuffer b = new StringBuffer();
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            int j;
            char c = s.charAt(i);
            for (j = 0; j < mValue.length && mValue[j].charAt(0) != c; ++j) {
            }
            if (j < mValue.length) {
                b.append(mKey[j]);
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String XMLDecode(String s) {
        StringBuffer b = new StringBuffer();
        StringBuffer c = null;
        int mode = 0;
        int n = s.length();
        block4: for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            switch (mode) {
                case 0: {
                    if (ch == '&') {
                        c = new StringBuffer();
                        c.append(ch);
                        mode = 1;
                        continue block4;
                    }
                    b.append(ch);
                    continue block4;
                }
                case 1: {
                    int j;
                    c.append(ch);
                    if (ch != ';') continue block4;
                    String tmp = c.toString();
                    for (j = 0; j < mKey.length && !tmp.equals(mKey[j]); ++j) {
                    }
                    if (j >= mKey.length) {
                        if (Aladin.levelTrace >= 3) {
                            System.err.println("XMlParser.XMLDecode(" + s + ") macro unknown => ignored !");
                        }
                        return s;
                    }
                    b.append(mValue[j]);
                    mode = 0;
                }
            }
        }
        if (mode == 1) {
            return null;
        }
        return b.toString();
    }

    public byte[] getUnreadBuffer() {
        if (this.max == -1) {
            return null;
        }
        byte[] buf = new byte[this.max - this.offset];
        System.arraycopy(this.tmp, this.offset, buf, 0, this.max - this.offset);
        return buf;
    }

    private char xmlGetc() {
        if (this.offset >= this.max) {
            try {
                this.max = this.dis.read(this.tmp);
            }
            catch (IOException e) {
                this.setError("Stream error: " + e);
                return '\u001a';
            }
            if (this.max == -1) {
                return '\u001a';
            }
            this.offset = 0;
        }
        return (char)this.tmp[this.offset++];
    }

    private char xmlGetString(int mode) throws Exception {
        int l = 0;
        int ol = -1;
        char c = '\u0000';
        char c1 = '\u0000';
        boolean space = false;
        boolean ospace = false;
        boolean encore = true;
        boolean inCDATA = true;
        boolean inCOM = true;
        boolean flagNL = false;
        int spaceChar = 32;
        boolean endminus = false;
        boolean ominus = false;
        boolean minus = false;
        boolean endbracket = false;
        boolean obracket = false;
        boolean bracket = false;
        boolean xml4 = false;
        boolean xml3 = false;
        boolean xml2 = false;
        boolean xml1 = false;
        boolean xml0 = false;
        this.flagCOM = false;
        this.flagCDATA = false;
        this.flagDoublePoint = false;
        Util.resetString(this.curString);
        Util.resetString(this.macro);
        while (encore) {
            c1 = c = this.xmlGetc();
            if (c == '\u001a') break;
            if (!(mode != 0 && mode != 2 || c != '&' && this.macro.length() <= 0)) {
                this.macro.append(c);
                if (c != ';') continue;
                String m = this.macro.toString();
                if (m.charAt(1) == '#') {
                    try {
                        boolean hexa = m.charAt(m.length() - 2) == 'x';
                        int code = Integer.parseInt(m.substring(2, m.length() - (hexa ? 2 : 1)), hexa ? 16 : 10);
                        c1 = (char)code;
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace >= 3) {
                            System.err.println("XMlParser.xmlGetString(...) unresolved macro [" + m + "] => ignored !");
                        }
                    }
                } else {
                    int i;
                    for (i = 0; i < mKey.length && !m.equals(mKey[i]); ++i) {
                    }
                    if (i < mKey.length) {
                        c1 = mValue[i].charAt(0);
                    } else if (Aladin.levelTrace >= 3) {
                        System.err.println("XMlParser.xmlGetString(...) unknown macro [" + m + "] => ignored !");
                    }
                }
                Util.resetString(this.macro);
            }
            if (space = Character.isSpace(c)) {
                spaceChar = c;
            }
            switch (mode) {
                case 0: {
                    boolean bl = encore = !space && c != '>';
                    if (c == ':') {
                        this.flagDoublePoint = true;
                    }
                    if (inCOM) {
                        if (c != COM[l]) {
                            inCOM = false;
                        } else if (l == COM.length - 1) {
                            this.flagCOM = true;
                            return c;
                        }
                    }
                    if (!inCDATA) break;
                    if (c != CDATA[l]) {
                        inCDATA = false;
                        break;
                    }
                    if (l != CDATA.length - 1) break;
                    this.flagCDATA = true;
                    return c;
                }
                case 1: {
                    encore = c != '>';
                    break;
                }
                case 2: {
                    boolean bl = encore = c != '<';
                    if (l < 64512 || !flagNL) break;
                    this.ch = this.curString.toString().toCharArray();
                    this.ac.characters(this.ch, 0, this.ch.length - 1);
                    Util.resetString(this.curString);
                    l = 0;
                    ol = 0;
                    break;
                }
                case 3: {
                    encore = !endbracket || c != '>';
                    bracket = c == ']';
                    endbracket = obracket && bracket;
                    obracket = bracket;
                    if (l < 64512 || !flagNL) break;
                    this.ch = this.curString.toString().toCharArray();
                    this.ac.characters(this.ch, 0, this.ch.length - 1);
                    Util.resetString(this.curString);
                    l = 0;
                    ol = 0;
                    break;
                }
                case 4: {
                    encore = !endminus || c != '>';
                    minus = c == '-';
                    endminus = ominus && minus;
                    ominus = minus;
                    break;
                }
                case 5: {
                    encore = !xml4 || c != '>';
                    xml4 = xml3 && (c == 'l' || c == 'L') || xml4;
                    xml3 = xml2 && (c == 'm' || c == 'M');
                    xml2 = xml1 && (c == 'x' || c == 'X');
                    xml1 = xml0 && c == '?';
                    boolean bl = xml0 = c == '<';
                    if (!xml0) break;
                    ol = l;
                }
            }
            if (mode == 3 || mode == 5 || (!space || space && !ospace) && mode < 3) {
                if (mode != 3 && mode != 5 && space) {
                    c1 = ' ';
                }
                this.curString.append(c1);
                ++l;
            }
            ospace = space;
            boolean bl = flagNL = c == '\n' || c == '\r';
            if (c != '\n') continue;
            ++this.line;
        }
        if (mode != 4) {
            this.ch = this.curString.toString().toCharArray();
        }
        this.start = 0;
        int n = mode == 3 ? this.ch.length - 3 : (this.length = mode == 5 && xml4 && ol >= 0 ? ol : this.ch.length - 1);
        if (this.length < 0) {
            this.length = 0;
        }
        return c1;
    }

    private String getNameParam() {
        while (this.start < this.end && Character.isSpace(this.ch[this.start])) {
            ++this.start;
        }
        int a = this.start;
        boolean flagMacro = false;
        while (this.start < this.end && !Character.isSpace(this.ch[this.start]) && this.ch[this.start] != '=') {
            if (!flagMacro && this.ch[this.start] == '&') {
                flagMacro = true;
            }
            ++this.start;
        }
        if (flagMacro) {
            String s = XMLParser.XMLDecode(new String(this.ch, a, this.start - a));
            if (s == null) {
                this.setError("Macro error");
                return null;
            }
            return s;
        }
        return new String(this.ch, a, this.start - a);
    }

    private String getValueParam() {
        while (this.start < this.end && (Character.isSpace(this.ch[this.start]) || this.ch[this.start] == '=')) {
            ++this.start;
        }
        char stop = ' ';
        if (this.start < this.end && (this.ch[this.start] == '\"' || this.ch[this.start] == '\'')) {
            stop = this.ch[this.start];
            ++this.start;
        }
        int a = this.start;
        boolean flagMacro = false;
        while (this.start < this.end && (stop == ' ' && !Character.isSpace(this.ch[this.start]) || stop != ' ' && this.ch[this.start] != stop)) {
            if (!flagMacro && this.ch[this.start] == '&') {
                flagMacro = true;
            }
            ++this.start;
        }
        int debut = this.start++;
        if (stop != ' ') {
            // empty if block
        }
        while (this.start < this.end && Character.isSpace(this.ch[this.start])) {
            ++this.start;
        }
        if (flagMacro) {
            String s = XMLParser.XMLDecode(new String(this.ch, a, debut - a));
            if (s == null) {
                this.setError("Macro error");
                return null;
            }
            return s;
        }
        return new String(this.ch, a, debut - a);
    }

    private int xmlGetParamTag(int mode) throws Exception {
        int code = 0;
        char c = this.xmlGetString(mode == -1 ? 4 : 1);
        if (this.length > 0 && this.ch[this.start + this.length - 1] == '/') {
            code = 3;
            --this.length;
        }
        if (c != '>') {
            this.setError("No end tag (mode=" + mode + ")");
            return -1;
        }
        if (mode == 1) {
            this.param.clear();
            this.end = this.start + this.length;
            while (this.start < this.end) {
                String n = this.getNameParam();
                String v = this.getValueParam();
                if (v == null) {
                    return -1;
                }
                this.param.put(n, v);
                this.param.put(n.toLowerCase(), v);
            }
        }
        return code;
    }

    private int xmlGetNameTag() throws Exception {
        int code = 1;
        char c = this.xmlGetString(0);
        if (c == '\u0000') {
            this.setError("stream truncated");
            return -1;
        }
        if (this.flagCDATA) {
            return 4;
        }
        if (this.flagCOM) {
            return 5;
        }
        if (this.length > 0 && this.ch[this.start] == '/') {
            code = 2;
            ++this.start;
            --this.length;
        } else if (this.length > 1 && this.ch[this.start + this.length - 1] == '/') {
            code = 3;
            --this.length;
        }
        if (code == 1 && c != '>') {
            code = 0;
        }
        if (this.flagDoublePoint) {
            int debut = this.start;
            int longueur = this.length;
            for (int i = this.start; i < this.start + this.length; ++i) {
                if (this.ch[i] != ':') continue;
                debut = i + 1;
                longueur = this.length - (i - this.start) - 1;
                break;
            }
            this.name = new String(this.ch, debut, longueur);
        } else {
            this.name = new String(this.ch, this.start, this.length);
        }
        return code;
    }

    private boolean partialParsing(String tag) {
        return this.endTag != null && this.endTag.equals(tag);
    }

    private int xmlInTag() throws Exception {
        int code = this.xmlGetNameTag();
        if (code < 0) {
            return 0;
        }
        if (code == 4) {
            int gap;
            char c = this.xmlGetString(3);
            int n = gap = this.ch[this.start] == '\n' ? 1 : 0;
            if (this.length > 1) {
                this.ac.characters(this.ch, this.start + gap, this.length - gap);
            }
            return c != '\u0000' ? 1 : 0;
        }
        if (code == 5) {
            return this.xmlGetParamTag(-1) >= 0 ? 1 : 0;
        }
        char c = this.ch[this.start];
        if (c == '?' || c == '!') {
            return this.xmlGetParamTag(0) >= 0 ? 1 : 0;
        }
        if (code == 0) {
            code = this.xmlGetParamTag(1);
        } else if (code == 1) {
            this.param.clear();
        }
        if (code < 0) {
            return 0;
        }
        if (code == 3) {
            if (this.stack != null) {
                this.stack.push(this.name);
            }
            ++this.nstack;
            this.ac.startElement(this.name, this.param);
            if (this.stack != null) {
                this.stack.pop();
            }
            --this.nstack;
            this.ac.endElement(this.name);
            return this.partialParsing(this.name) ? -1 : 1;
        }
        if (code == 2) {
            String s;
            if (this.nstack == 0) {
                this.setError("Unexpected end tag (</" + this.name + ">)");
                return 0;
            }
            --this.nstack;
            if (this.stack != null && !(s = (String)this.stack.pop()).equals(this.name)) {
                this.setError("Tags unbalanced (<" + s + ">...</" + this.name + ">)");
                return 0;
            }
            this.ac.endElement(this.name);
            return this.partialParsing(this.name) ? -1 : 1;
        }
        if (this.stack != null) {
            this.stack.push(this.name);
        }
        ++this.nstack;
        this.ac.startElement(this.name, this.param);
        return 1;
    }

    private boolean xmlBeforeTag() throws Exception {
        while (true) {
            char c = this.xmlGetString(this.beforeXML ? 5 : 2);
            if (this.length > 0 && (this.length != 1 || this.ch[this.start] != ' ')) {
                this.ac.characters(this.ch, this.start, this.length);
            }
            if (this.beforeXML) {
                this.beforeXML = false;
                continue;
            }
            if (c == '\u001a') {
                return this.error == null;
            }
            switch (this.xmlInTag()) {
                case 0: {
                    return false;
                }
                case -1: {
                    this.xmlGetString(1);
                    return true;
                }
            }
        }
    }
}

