/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.Save;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Astropos;
import cds.astro.Astrotime;
import cds.astro.Ecliptic;
import cds.astro.FK4;
import cds.astro.FK5;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.astro.Supergal;
import cds.astro.Unit;
import cds.fits.HeaderFits;
import cds.tools.Util;
import cds.xml.Field;
import cds.xml.TableParserConsumer;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.io.EOFException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class TableParser
implements XMLConsumer {
    static final Astroframe AF_FK4 = new FK4();
    static final Astroframe AF_FK5 = new FK5();
    static final Astroframe AF_GAL = new Galactic();
    static final Astroframe AF_SGAL = new Supergal();
    static final Astroframe AF_ICRS = new ICRS();
    static final Astroframe AF_ECLI = new Ecliptic();
    public static final int FMT_UNKNOWN = 0;
    public static final int FMT_DECIMAL = 1;
    public static final int FMT_SEXAGESIMAL = 2;
    private TableParserConsumer consumer;
    private XMLParser xmlparser;
    private int nField;
    private int nRecord;
    private int nRA;
    private int nDEC;
    private int nPMRA;
    private int nPMDEC;
    private int nX;
    private int nY;
    private String sFreq;
    private String sFlux;
    private String sFluxErr;
    private String sSedId;
    private int nFreq;
    private int nFlux;
    private int nFluxErr;
    private int nSedId;
    private int qualRA;
    private int qualDEC;
    private int qualPMRA;
    private int qualPMDEC;
    private int qualX;
    private int qualY;
    private Field f;
    private Vector<Field> memoField;
    private Field[] tsvField;
    private String fieldSub = null;
    private String tableSub = null;
    private String resourceSub = null;
    private boolean inCSV = false;
    private boolean flagTSV;
    private boolean inError;
    private boolean inLinkField = false;
    private boolean inFieldDesc = false;
    private boolean inEncode64 = false;
    private boolean inBinary = false;
    private boolean inBinary2 = false;
    private boolean inFits = false;
    private boolean inGroup = false;
    private int fitsExtNum;
    private boolean inTD;
    private boolean valueInTD;
    private int ngroup;
    private String colsep;
    private String recsep;
    private String headlines;
    private String error;
    private String filename;
    private int format;
    private boolean flagXY;
    private String[] record;
    private Vector<String> vRecord;
    private int row;
    private boolean flagNewTable;
    private boolean flagSkip;
    private long typeFmt;
    private Hashtable<String, String> coosys;
    private Hashtable<String, String> cooepoch;
    private Hashtable<String, String> cooequinox;
    private Hashtable<String, String> cooFieldref;
    private boolean inAstroCoords;
    private String astroCoordsID;
    private Astroframe srcAstroFrame = null;
    private Astroframe trgAstroFrame = AF_ICRS;
    private Astropos c = new Astropos();
    private String filter;
    private boolean inSEDGroup;
    private HeaderFits headerFits;
    private Aladin aladin;
    private char[] type = null;
    private int[] pos = null;
    private int[] len = null;
    private int[] prec = null;
    private int sizeRecord = 0;
    private int nbField = 0;
    private byte[] memoB = null;
    private byte[] nullMask = null;
    private boolean maskRead = false;
    static final int[] MASK = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    static final char BLC = ' ';
    static final char TABC = '\t';
    static final byte BLB = 32;
    static final byte TABB = 9;
    private static int ASTROID = 1;
    private static final String DEFAULT = "Default";
    private Astroframe lastCoordSys = null;

    public TableParser(Aladin aladin, TableParserConsumer consumer, long type) {
        this.aladin = aladin;
        this.consumer = consumer;
        this.typeFmt = type;
    }

    public TableParser(Aladin aladin, TableParserConsumer consumer, HeaderFits headerFits, boolean flagSkip) {
        this.aladin = aladin;
        this.consumer = consumer;
        this.headerFits = headerFits;
        this.flagSkip = flagSkip;
    }

    public void setFileName(String file) {
        this.filename = file;
    }

    private void hrefCall(String uri) throws Exception {
        MyInputStream in = this.aladin.glu.getMyInputStream(uri, false);
        if (this.inBinary || this.inBinary2) {
            this.consumer.tableParserInfo("\nParsing VOTable data from an external" + (this.inBinary2 ? " BINARY2" : " BINARY") + " stream:\n => " + uri);
            byte[] buf = in.readFully();
            this.parseBin(buf, 0, buf.length, this.inBinary2);
        } else if (this.inFits) {
            this.aladin.calque.seekFitsExt(in, this.fitsExtNum);
            this.consumer.tableParserInfo("\nParsing VOTable data from a FITS stream:\n => " + uri + (this.fitsExtNum > 0 ? " (ext=" + this.fitsExtNum + ")" : ""));
            in.resetType();
            in.getType();
            this.headerFits = new HeaderFits(in);
            this.parseFits(in, true);
        }
        in.close();
    }

    private void parseBase64(char[] ch, int pos, int len, boolean inBinary2) throws Exception {
        if (this.memoField != null) {
            this.consumer.tableParserInfo("\nParsing VOTable data from a" + (inBinary2 ? " BINARY2" : " BINARY") + " base64 stream");
        }
        byte[] b = new byte[len];
        int offset = 0;
        if (this.memoB != null) {
            b = new byte[len + this.memoB.length];
            offset = this.memoB.length;
            System.arraycopy(this.memoB, 0, b, 0, offset);
            this.memoB = null;
        } else {
            b = new byte[len];
        }
        int n = Save.get64(b, offset, ch, pos, len);
        this.parseBin(b, 0, n, inBinary2);
    }

    private boolean parseBin(byte[] b, int offset, int length, boolean inBinary2) throws Exception {
        if (this.memoField != null) {
            this.nbField = this.memoField.size();
            this.type = new char[this.nbField];
            this.pos = new int[this.nbField];
            this.len = new int[this.nbField];
            this.prec = new int[this.nbField];
            if (inBinary2) {
                this.nullMask = new byte[(this.nbField + 7) / 8];
            }
            this.nRecord = 0;
            this.nField = 0;
            boolean variableField = false;
            for (int i = 0; i < this.nbField; ++i) {
                Field f = this.memoField.elementAt(i);
                String t = Field.typeVOTable2Fits(f.datatype);
                if (t == null) {
                    throw new Exception("Missing definition for field " + i + ". Parsing aborted");
                }
                this.type[i] = t.charAt(0);
                this.len[i] = 1;
                if (f.arraysize != null && f.arraysize.equals("*")) {
                    this.len[i] = -1;
                    this.sizeRecord = -1;
                    variableField = true;
                } else {
                    try {
                        this.len[i] = Integer.parseInt(f.arraysize);
                    }
                    catch (Exception e) {
                        this.len[i] = 1;
                    }
                }
                if (!variableField) {
                    if (i < this.nbField - 1) {
                        this.pos[i + 1] = this.pos[i] + this.binSizeOf(this.type[i], this.len[i]);
                    } else {
                        this.sizeRecord = this.pos[i] + this.binSizeOf(this.type[i], this.len[i]);
                    }
                } else {
                    this.pos[i] = -1;
                }
                this.prec[i] = 6;
                try {
                    this.prec[i] = Integer.parseInt(f.precision);
                    continue;
                }
                catch (Exception e) {
                    this.prec[i] = 6;
                }
            }
            this.pos[0] = 0;
            this.memoField = null;
        }
        int position = offset;
        while (position < length) {
            int nbBytes;
            if (this.nField == this.nbField) {
                this.nField = 0;
            }
            if (inBinary2 && this.nField == 0 && !this.maskRead) {
                int n = length - position;
                if (n < this.nullMask.length) {
                    this.memoB = new byte[n];
                    System.arraycopy(b, position, this.memoB, 0, n);
                    return true;
                }
                position += this.nullMask.length;
                this.maskRead = true;
            } else {
                this.maskRead = false;
            }
            int n = nbBytes = this.len[this.nField] == -1 ? -1 : this.binSizeOf(this.type[this.nField], this.len[this.nField]);
            if (nbBytes == -1) {
                int n2 = length - position;
                if (n2 < 4) {
                    this.memoB = new byte[n2];
                    System.arraycopy(b, position, this.memoB, 0, n2);
                    return true;
                }
                nbBytes = this.getInt(b, position);
                position += 4;
            } else if (nbBytes == 0) {
                return true;
            }
            int nextPosition = position + nbBytes;
            if (nextPosition > length) {
                if (this.len[this.nField] == -1) {
                    position -= 4;
                }
                int n3 = length - position;
                this.memoB = new byte[n3];
                System.arraycopy(b, position, this.memoB, 0, n3);
                return true;
            }
            this.record[this.nField] = inBinary2 && this.isNull(this.nullMask, this.nField) ? "null" : this.getBinField(b, position, this.len[this.nField] == -1 ? nbBytes : this.len[this.nField], this.type[this.nField], this.prec[this.nField], 0.0, 1.0, false, 0);
            position = nextPosition;
            ++this.nField;
            if (this.nField != this.nbField) continue;
            this.consumeRecord(this.record, this.nRecord++);
        }
        return true;
    }

    private boolean isNull(byte[] nullMask, int nField) {
        int nByte = nField / 8;
        int nBit = nField % 8;
        return (0xFF & nullMask[nByte] & MASK[nBit]) != 0;
    }

    private boolean parseFits(MyInputStream in, boolean hrefVotable) {
        block73: {
            this.error = null;
            if (!hrefVotable) {
                this.initTable();
                this.coosys = new Hashtable(10);
                this.cooepoch = new Hashtable(10);
                this.cooequinox = new Hashtable(10);
                this.cooFieldref = new Hashtable(10);
            }
            try {
                int offset;
                int k;
                String s;
                boolean flagBin;
                boolean bl = flagBin = (in.getType() & 0x1000000L) != 0L;
                if (!hrefVotable) {
                    this.consumer.tableParserInfo("FITS " + (flagBin ? "BINTABLE" : "TABLE") + " format");
                    this.consumer.startResource("RESOURCE-FITS");
                    try {
                        s = this.headerFits.getStringFromHeader("EXTNAME");
                        this.consumer.setResourceInfo("NAME", s);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                this.consumer.startTable("TABLE-FITS");
                int nRecord = this.headerFits.getIntFromHeader("NAXIS2");
                int sizeRecord = this.headerFits.getIntFromHeader("NAXIS1");
                this.nField = this.headerFits.getIntFromHeader("TFIELDS");
                char[] type = null;
                int[] pos = new int[this.nField];
                int[] len = new int[this.nField];
                boolean flagTzeroTscal = false;
                double[] tzero = new double[this.nField];
                double[] tscal = new double[this.nField];
                String[] tnull = new String[this.nField];
                int[] tinull = new int[this.nField];
                int[] prec = new int[this.nField];
                for (k = 0; k < this.nField; ++k) {
                    prec[k] = -1;
                }
                for (k = 0; k < this.nField; ++k) {
                    tscal[k] = 1.0;
                }
                if (flagBin) {
                    type = new char[this.nField];
                }
                for (int i = 0; i < this.nField; ++i) {
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TTYPE" + (i + 1));
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    if (s == null) {
                        s = "Col-" + (i + 1);
                    }
                    Field f = new Field(s);
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TUNIT" + (i + 1));
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    if (s != null) {
                        f.unit = s;
                    }
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TCOMM" + (i + 1));
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    if (s != null) {
                        f.description = s;
                    }
                    double x = 0.0;
                    try {
                        x = this.headerFits.getDoubleFromHeader("TZERO" + (i + 1));
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    if (x != 0.0) {
                        tzero[i] = x;
                        flagTzeroTscal = true;
                    }
                    x = 0.0;
                    try {
                        x = this.headerFits.getDoubleFromHeader("TSCAL" + (i + 1));
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    if (x != 0.0) {
                        tscal[i] = x;
                        flagTzeroTscal = true;
                    }
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TNULL" + (i + 1));
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    if (s != null) {
                        tnull[i] = s.trim();
                        if (flagBin) {
                            try {
                                tinull[i] = this.headerFits.getIntFromHeader("TNULL" + (i + 1));
                            }
                            catch (Exception e1) {
                                // empty catch block
                            }
                        }
                    }
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TUCD" + (i + 1));
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    if (s != null) {
                        f.ucd = s;
                    }
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TFORM" + (i + 1));
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    if (s != null) {
                        if (!flagBin) {
                            char code = s.charAt(0);
                            if (code == 'E' || code == 'F') {
                                code = 'D';
                            }
                            f.datatype = code + "";
                            int k2 = s.indexOf(46);
                            if (k2 < 0) {
                                k2 = s.length();
                            }
                            if (k2 > 1) {
                                f.width = s.substring(1, k2);
                                f.computeColumnSize();
                            }
                            if ((k2 = s.indexOf(46)) > 0) {
                                prec[i] = 0;
                                ++k2;
                                while (k2 < s.length() && Character.isDigit(s.charAt(k2))) {
                                    prec[i] = prec[i] * 10 + (s.charAt(k2) - 48);
                                    ++k2;
                                }
                            }
                        } else {
                            int k3;
                            len[i] = 0;
                            for (k3 = 0; k3 < s.length() && Character.isDigit(s.charAt(k3)); ++k3) {
                                len[i] = len[i] * 10 + (s.charAt(k3) - 48);
                            }
                            if (k3 == 0) {
                                len[i] = 1;
                            } else {
                                f.arraysize = len[i] + "";
                            }
                            type[i] = s.charAt(k3);
                            int n = pos[i] = i == 0 ? 0 : pos[i - 1] + this.binSizeOf(type[i - 1], len[i - 1]);
                        }
                    }
                    if (flagBin && f.datatype == null) {
                        f.datatype = type[i] + "";
                    }
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TDISP" + (i + 1));
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    if (s != null) {
                        int k4 = s.indexOf(46);
                        if (k4 < 0) {
                            k4 = s.length();
                        }
                        if (k4 > 1) {
                            f.width = s.substring(1, k4);
                            f.computeColumnSize();
                        }
                        if ((k4 = s.indexOf(46)) > 0) {
                            prec[i] = 0;
                            ++k4;
                            while (k4 < s.length() && Character.isDigit(s.charAt(k4))) {
                                prec[i] = prec[i] * 10 + (s.charAt(k4) - 48);
                                ++k4;
                            }
                        }
                    }
                    if (!flagBin) {
                        pos[i] = this.headerFits.getIntFromHeader("TBCOL" + (i + 1));
                        int p = sizeRecord;
                        try {
                            p = this.headerFits.getIntFromHeader("TBCOL" + (i + 2));
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                        len[i] = p - pos[i];
                        int n = i;
                        pos[n] = pos[n] - 1;
                        f.width = len[i] + "";
                    }
                    this.detectPosField(f, i);
                    if (hrefVotable) continue;
                    this.consumer.setField(f);
                }
                if (!hrefVotable) {
                    this.posChooser();
                }
                if (this.flagSkip) {
                    in.skip(nRecord * sizeRecord);
                } else {
                    byte[] buf = new byte[(nRecord < 1000 ? nRecord : 1000) * sizeRecord];
                    this.record = new String[this.nField];
                    offset = buf.length;
                    int i = 0;
                    while (i < nRecord) {
                        if (offset == buf.length) {
                            try {
                                in.readFully(buf);
                            }
                            catch (EOFException e) {
                                // empty catch block
                            }
                            offset = 0;
                        }
                        for (int j = 0; j < this.nField; ++j) {
                            if (!flagBin) {
                                this.record[j] = TableParser.getStringTrim(buf, offset + pos[j], len[j]);
                                if (tnull[j] != null && this.record[j].equals(tnull[j])) {
                                    this.record[j] = "";
                                    continue;
                                }
                                if (!flagTzeroTscal && prec[j] < 0) continue;
                                try {
                                    this.record[j] = this.fmt(Double.valueOf(this.record[j]), prec[j], tzero[j], tscal[j]);
                                }
                                catch (Exception e) {
                                    this.record[j] = "[?X?]";
                                }
                                continue;
                            }
                            this.record[j] = this.getBinField(buf, offset + pos[j], len[j], type[j], prec[j], flagTzeroTscal ? tzero[j] : 0.0, flagTzeroTscal ? tscal[j] : 1.0, tnull[j] != null, tinull[j]);
                        }
                        this.consumeRecord(this.record, i);
                        ++i;
                        offset += sizeRecord;
                    }
                }
                if (hrefVotable) break block73;
                this.consumer.endTable();
                this.consumer.endResource();
                try {
                    offset = this.headerFits.getIntFromHeader("PCOUNT");
                    if (offset != 0) {
                        in.skip(offset);
                    }
                }
                catch (Exception e1) {}
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error = e.getMessage();
            }
        }
        return this.error == null;
    }

    protected final int binSizeOf(char type, int n) {
        int sizeOf;
        if (type == 'X') {
            return n / 8 + (n % 8 > 0 ? 1 : 0);
        }
        int n2 = type == 'L' ? 1 : (type == 'B' ? 1 : (type == 'I' ? 2 : (type == 'J' ? 4 : (type == 'K' ? 8 : (type == 'A' ? 1 : (type == 'E' ? 4 : (type == 'D' ? 8 : (type == 'C' ? 8 : (type == 'M' ? 16 : (sizeOf = type == 'P' ? 8 : 0))))))))));
        if (sizeOf == 0) {
            System.out.println("Probl\u00e8me s\u00e9rieux pour [" + type + "]");
        }
        return sizeOf * n;
    }

    private final String getBinField(byte[] t, int i, int n, char type, int prec, double tzero, double tscale, boolean hasNull, int tnull) {
        if (n == 0) {
            return "";
        }
        if (type == 'A') {
            return TableParser.getStringTrim(t, i, n);
        }
        if (n == 1) {
            return this.getBinField(t, i, type, prec, tzero, tscale, hasNull, tnull);
        }
        StringBuffer a = null;
        for (int j = 0; j < n; ++j) {
            if (j == 0) {
                a = new StringBuffer();
            } else {
                a.append(' ');
            }
            a.append(this.getBinField(t, i + this.binSizeOf(type, j), type, prec, tzero, tscale, hasNull, tnull));
        }
        return a + "";
    }

    private final String getBinField(byte[] t, int i, char type, int p, double z, double s, boolean hasNull, int n) {
        String a = this.getBinField1(t, i, type, p, z, s, hasNull, n);
        return a;
    }

    private final String getBinField1(byte[] t, int i, char type, int p, double z, double s, boolean hasNull, int n) {
        switch (type) {
            case 'L': {
                return t[i] != 0 ? "T" : "F";
            }
            case 'B': {
                return this.fmtInt(t[i] & 0xFF, p, z, s, hasNull, n);
            }
            case 'I': {
                return this.fmtInt(this.getShort(t, i), p, z, s, hasNull, n);
            }
            case 'J': {
                return this.fmtInt(this.getInt(t, i), p, z, s, hasNull, n);
            }
            case 'K': {
                long a = (long)this.getInt(t, i) << 32 | (long)this.getInt(t, i + 4) & 0xFFFFFFFFL;
                return this.fmtLong(a, p, z, s, hasNull, n);
            }
            case 'E': {
                return this.fmt(Float.intBitsToFloat(this.getInt(t, i)), p, z, s);
            }
            case 'D': {
                long a = (long)this.getInt(t, i) << 32 | (long)this.getInt(t, i + 4) & 0xFFFFFFFFL;
                return this.fmt(Double.longBitsToDouble(a), p, z, s);
            }
            case 'C': {
                int c = this.getInt(t, i + 4);
                return this.fmt(Float.intBitsToFloat(this.getInt(t, i)), p, z, s) + (c >= 0 ? "+" : "-") + this.fmt(Float.intBitsToFloat(c), p, z, s) + "i";
            }
            case 'M': {
                long a = (long)this.getInt(t, i) << 32 | (long)this.getInt(t, i + 4) & 0xFFFFFFFFL;
                long b = (long)this.getInt(t, i + 8) << 32 | (long)this.getInt(t, i + 12) & 0xFFFFFFFFL;
                return this.fmt(Double.longBitsToDouble(a), p, z, s) + (b >= 0L ? "+" : "-") + this.fmt(Double.longBitsToDouble(b), p, z, s) + "i";
            }
            case 'A': {
                return "" + (char)t[i];
            }
        }
        return "[???]";
    }

    private final String fmtInt(long x, int prec, double tzero, double tscale, boolean hasNull, int tnull) {
        if (hasNull && (long)tnull == x) {
            return "";
        }
        double y = x;
        if (tscale != 1.0) {
            y *= tscale;
        }
        if (tzero != 0.0) {
            y += tzero;
        }
        if (prec >= 0) {
            y = Util.round(y, prec);
        }
        if (y != (double)x) {
            return y + "";
        }
        return x + "";
    }

    private final String fmtLong(long x, int prec, double tzero, double tscale, boolean hasNull, int tnull) {
        if (hasNull && (long)tnull == x) {
            return "";
        }
        if (tscale == 1.0 && tzero == 0.0) {
            return x + "";
        }
        if ((double)((long)tscale) == tscale && (double)((long)tzero) == tzero) {
            long y = x;
            if (tscale != 1.0) {
                y *= (long)tscale;
            }
            if (tzero != 0.0) {
                y += (long)tzero;
            }
            return y + "";
        }
        double y = x;
        if (tscale != 1.0) {
            y *= tscale;
        }
        if (tzero != 0.0) {
            y += tzero;
        }
        if (prec >= 0) {
            y = Util.round(y, prec);
        }
        if (y != (double)x) {
            return y + "";
        }
        return x + "";
    }

    private final String fmt(double x, int prec, double tzero, double tscale) {
        if (Double.isNaN(x)) {
            return "";
        }
        if (tscale != 1.0) {
            x *= tscale;
        }
        if (tzero != 0.0) {
            x += tzero;
        }
        if (prec >= 0) {
            x = Util.round(x, prec);
        }
        return x + "";
    }

    private final int getInt(byte[] t, int i) {
        return t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
    }

    private final int getShort(byte[] t, int i) {
        return (t[i] & 0xFF) << 8 | t[i + 1] & 0xFF;
    }

    public static final String getStringTrim(byte[] s, int offset, int len) {
        if (len < 0 || offset + len > s.length) {
            System.err.println("problem s.length=" + s.length + " offset=" + offset + " len=" + len + " !!");
            return new String(s, offset, s.length - offset);
        }
        return new String(s, offset, len).trim();
    }

    public static final String getStringTrim(char[] s, int offset, int len) {
        return new String(s, offset, len).trim();
    }

    public TableParser(Aladin aladin, TableParserConsumer consumer) {
        this(aladin, consumer, null);
    }

    public TableParser(Aladin aladin, TableParserConsumer consumer, String colsep) {
        this.aladin = aladin;
        this.consumer = consumer;
        if (colsep != null) {
            this.colsep = colsep;
        }
        this.xmlparser = new XMLParser(this);
    }

    public boolean parse(MyInputStream dis) throws Exception {
        if (this.headerFits != null) {
            return this.parseFits(dis, false);
        }
        return this.parse(dis, null);
    }

    public boolean parse(MyInputStream dis, String endTag) throws Exception {
        this.initTable();
        this.error = null;
        this.flagTSV = true;
        this.inError = false;
        this.ngroup = 0;
        this.coosys = new Hashtable(10);
        this.cooepoch = new Hashtable(10);
        this.cooequinox = new Hashtable(10);
        this.cooFieldref = new Hashtable(10);
        return this.xmlparser.parse(dis, endTag) && this.error == null;
    }

    public byte[] getUnreadBuffer() {
        return this.xmlparser.getUnreadBuffer();
    }

    private void initTable() {
        this.nY = -1;
        this.nX = -1;
        this.nPMDEC = -1;
        this.nPMRA = -1;
        this.nDEC = -1;
        this.nRA = -1;
        this.qualY = 1000;
        this.qualX = 1000;
        this.qualDEC = 1000;
        this.qualRA = 1000;
        this.qualDEC = 1000;
        this.qualRA = 1000;
        this.format = 0;
        this.nField = 0;
        this.record = null;
        this.vRecord = null;
        this.flagNewTable = true;
        this.astroCoordsID = null;
        this.inAstroCoords = false;
        this.inSEDGroup = false;
    }

    public String getError() {
        return this.error != null ? this.error : this.xmlparser.getError();
    }

    private void memoStartGroup(String name, Hashtable atts) {
        StringBuffer s = new StringBuffer("<" + name);
        Enumeration e = atts.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            s.append(" " + k + "=\"" + atts.get(k) + "\"");
        }
        s.append(">\n");
        this.consumer.setTableInfo("GROUP", s.toString());
    }

    private void memoEndGroup(String name) {
        this.consumer.setTableInfo("GROUP", "</" + name + ">\n");
    }

    private void memoInGroup(char[] s, int offset, int length) {
        this.consumer.setTableInfo("GROUP", new String(s, offset, length));
    }

    private void resetGroup() {
        System.err.println("TableParser.resetGroupe => FIELD GROUP not yet supported => remove all GROUP definition !");
        this.consumer.setTableInfo("GROUP", null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startElement(String name, Hashtable atts) {
        depth = this.xmlparser.getDepth();
        if (this.inGroup) {
            this.memoStartGroup(name, atts);
        }
        if (name.charAt(0) == 'G' && depth >= 1 && name.equalsIgnoreCase("GROUP")) {
            ++this.ngroup;
            if (!this.inGroup) {
                this.memoStartGroup(name, atts);
            }
            this.inGroup = true;
            att = (String)atts.get("utype");
            id = (String)atts.get("ID");
            if (att != null && (att.equalsIgnoreCase("stc:AstroCoords") || att.equalsIgnoreCase("stc:AstroCoordSystem") || att.equalsIgnoreCase("stc:CatalogEntryLocation"))) {
                this.inAstroCoords = true;
                this.astroCoordsID = (String)atts.get("ID");
                v = (String)atts.get("ref");
                if (v != null && this.astroCoordsID != null) {
                    this.coosys.put(this.astroCoordsID, v);
                }
            } else if (att != null && att.equalsIgnoreCase("spec:PhotometryPoint") || id != null && id.equals("gsed")) {
                this.inSEDGroup = true;
            }
            return;
        }
        depth -= this.ngroup;
        if (this.inSEDGroup && name.equalsIgnoreCase("FIELDref") && (att = (String)atts.get("utype")) != null) {
            if (att.equalsIgnoreCase("photdm:PhotometryFilter.SpectralAxis.Coverage.Location.Value")) {
                this.sFreq = (String)atts.get("ref");
            } else if (att.equalsIgnoreCase("spec:PhotometryPoint")) {
                this.sFlux = (String)atts.get("ref");
            } else if (att.equalsIgnoreCase("spec:PhotoMetryPointError")) {
                this.sFluxErr = (String)atts.get("ref");
            } else if (att.equalsIgnoreCase("photdm:PhotometryFilter.identifier")) {
                this.sSedId = (String)atts.get("ref");
            }
        }
        if (this.inAstroCoords) {
            if (this.astroCoordsID == null) {
                this.astroCoordsID = "_DEFAULTID_" + TableParser.ASTROID++;
            }
            if (name.equalsIgnoreCase("PARAM")) {
                att = (String)atts.get("utype");
                if (att != null && (att.equalsIgnoreCase("stc:AstroCoords.coord_sys_id") || att.equalsIgnoreCase("stc:AstroCoords.coord_system_id") || att.equalsIgnoreCase("stc:AstroCoordSystem.href") || att.equalsIgnoreCase("stc:AstroCoordSystem.SpaceFrame.CoordRefFrame"))) {
                    v = (String)atts.get("value");
                    if (v != null) {
                        this.coosys.put(this.astroCoordsID, v);
                    }
                } else if (att != null && (Util.matchMaskIgnoreCase("stc:Astrocoords.Position?D.Epoch", att) || att.equalsIgnoreCase("stc:AstroCoords.SpaceFrame.Epoch"))) {
                    v = (String)atts.get("value");
                    if (v != null) {
                        if (!Character.isDigit(v.charAt(0)) && (s = this.cooepoch.get(this.astroCoordsID)) != null && s.length() == 1) {
                            v = s + v;
                        }
                        this.cooepoch.put(this.astroCoordsID, v);
                    }
                } else if (att != null && Util.matchMaskIgnoreCase("stc:Astrocoords.Position?D.Epoch.yearDef", att)) {
                    v = (String)atts.get("value");
                    if (v != null) {
                        s = this.cooepoch.get(this.astroCoordsID);
                        if (s != null && Character.isDigit(s.charAt(0))) {
                            v = v + s;
                        }
                        this.cooepoch.put(this.astroCoordsID, v);
                    }
                } else if (att != null && att.equalsIgnoreCase("stc:AstroCoordSystem.SpaceFrame.CoordRefFrame.Equinox")) {
                    v = (String)atts.get("value");
                    if (v != null) {
                        if (!Character.isDigit(v.charAt(0)) && (s = this.cooequinox.get(this.astroCoordsID)) != null && s.length() == 1) {
                            v = s + v;
                        }
                        this.cooequinox.put(this.astroCoordsID, v);
                    }
                } else if (att != null && att.equalsIgnoreCase("stc:AstroCoordSystem.SpaceFrame.CoordRefFrame.Equinox.yearDef")) {
                    v = (String)atts.get("value");
                    if (v != null) {
                        s = this.cooequinox.get(this.astroCoordsID);
                        if (s != null && Character.isDigit(s.charAt(0))) {
                            v = v + s;
                        }
                        this.cooequinox.put(this.astroCoordsID, v);
                    }
                } else if (att != null) {
                    this.consumer.tableParserInfo("      *** AstroCoord PARAM utype unknown => ignored: [" + att + "]");
                }
            } else if (name.equalsIgnoreCase("FIELDref")) {
                att = (String)atts.get("utype");
                if (att != null && Util.matchMaskIgnoreCase("stc:Astrocoords.Position?D.Value*", att)) {
                    v = (String)atts.get("ref");
                    if (v != null) {
                        this.cooFieldref.put(v, this.astroCoordsID);
                    }
                } else if (att != null) {
                    this.consumer.tableParserInfo("      *** AstroCoord FIELDref utype unknown => ignored: [" + att + "]");
                }
            }
        }
        if (depth < 4) {
            if (name.equals("INFO")) {
                att = (String)atts.get("name");
                if (att != null && att.equals("AladinFilter")) {
                    this.filter = "";
                    att = (String)atts.get("value");
                    if (att != null) {
                        this.filter = "#" + att + "\n";
                    }
                    if ((att = (String)atts.get("ID")) != null) {
                        this.filter = this.filter + "filter " + att + " {\n";
                    }
                } else if (att != null && att.equals("QUERY_STATUS")) {
                    att = (String)atts.get("value");
                    if (att.equals("OVERFLOW")) {
                        this.consumer.tableParserWarning("!!! Truncated result (server OVERFLOW)");
                    } else if (att.equals("ERROR")) {
                        this.consumer.tableParserWarning("!!! Result error (server ERROR)");
                    }
                }
            } else if (name.equalsIgnoreCase("COOSYS") && (id = (String)atts.get("ID")) != null) {
                att = (String)atts.get("system");
                if (att != null) {
                    this.coosys.put(id, att);
                }
                if ((att = (String)atts.get("epoch")) != null) {
                    this.cooepoch.put(id, att);
                }
                if ((att = (String)atts.get("equinox")) != null) {
                    this.cooequinox.put(id, att);
                }
            }
        }
        switch (depth) {
            case 6: {
                if (name.equalsIgnoreCase("TR")) {
                    this.row = 0;
                    break;
                }
                if (!name.equalsIgnoreCase("STREAM")) break;
                att = (String)atts.get("encoding");
                if (att != null && att.equalsIgnoreCase("base64")) {
                    this.inEncode64 = true;
                    break;
                }
                att = (String)atts.get("href");
                try {
                    this.hrefCall(att);
                    break;
                }
                catch (Exception e) {
                    this.inError = true;
                    this.error = "VOTable external reference error [" + att + "]";
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    return;
                }
            }
            case 7: {
                if (!name.equalsIgnoreCase("TD")) break;
                this.inTD = true;
                break;
            }
            case 1: {
                if (!name.equalsIgnoreCase("ASTRO")) ** GOTO lbl152
                this.consumer.tableParserInfo("Astrores format");
                this.flagTSV = false;
                ** GOTO lbl155
lbl152:
                // 1 sources

                if (name.equalsIgnoreCase("VOTABLE")) {
                    this.consumer.tableParserInfo("VOTable format");
                    this.flagTSV = false;
                }
            }
lbl155:
            // 5 sources

            case 2: {
                if (name.equalsIgnoreCase("INFO")) {
                    att = (String)atts.get("name");
                    if (att != null && (att.equalsIgnoreCase("ERRORS") || att.equalsIgnoreCase("ERROR"))) {
                        att = (String)atts.get("value");
                        this.error = att == null ? "Unknown VOTable error" : att;
                        return;
                    }
                    att = (String)atts.get("ID");
                    if (att == null || !att.equals("Target") || (att = (String)atts.get("value")) == null) break;
                    this.consumer.setTarget(att);
                    break;
                }
                if (!name.equalsIgnoreCase("RESOURCE")) break;
                att = (String)atts.get("ID");
                if (att != null) {
                    this.consumer.startResource(att);
                    break;
                }
                this.consumer.startResource((String)atts.get("name"));
                break;
            }
            case 3: {
                if (name.equalsIgnoreCase("INFO")) {
                    att = (String)atts.get("name");
                    if (att == null || !att.equals("QUERY_STATUS") || (att = (String)atts.get("value")) == null || !att.equalsIgnoreCase("ERROR")) break;
                    this.error = "je me suis plant\u00e9";
                    this.inError = true;
                    return;
                }
                if (!name.equalsIgnoreCase("TABLE")) break;
                this.initTable();
                att = (String)atts.get("name");
                if (att != null) {
                    this.consumer.startTable(att);
                } else {
                    att = (String)atts.get("ID");
                    this.consumer.startTable(att);
                }
                this.consumer.tableParserInfo(".Table " + att);
                att = (String)atts.get("name");
                if (att == null) break;
                this.consumer.setTableInfo("name", att);
                break;
            }
            case 4: {
                if (name.equalsIgnoreCase("FIELD")) {
                    if (this.inGroup) {
                        this.resetGroup();
                        this.inGroup = false;
                    }
                    this.f = new Field(atts);
                    break;
                }
                if (name.equalsIgnoreCase("PARAM")) {
                    this.f = new Field(atts);
                    break;
                }
                if (!name.equalsIgnoreCase("DATA")) break;
                this.record = new String[this.nField];
                this.posChooser();
                break;
            }
            case 5: {
                if (name.equalsIgnoreCase("LINK")) {
                    this.f.addInfo("href", (String)atts.get("href"));
                    this.f.addInfo("gref", (String)atts.get("gref"));
                    this.f.addInfo("refValue", (String)atts.get("content-type"));
                    this.f.addInfo("refText", (String)atts.get("title"));
                    this.inLinkField = true;
                    break;
                }
                if (name.equalsIgnoreCase("VALUES")) {
                    this.f.nullValue = (String)atts.get("null");
                    break;
                }
                if (name.equalsIgnoreCase("DESCRIPTION")) {
                    this.inFieldDesc = true;
                    break;
                }
                if (name.equalsIgnoreCase("CSV")) {
                    this.inCSV = true;
                    this.colsep = (String)atts.get("colsep");
                    this.recsep = (String)atts.get("recsep");
                    this.headlines = (String)atts.get("headlines");
                    break;
                }
                if (name.equalsIgnoreCase("BINARY")) {
                    this.inBinary = true;
                    break;
                }
                if (name.equalsIgnoreCase("BINARY2")) {
                    this.inBinary2 = true;
                    break;
                }
                if (!name.equalsIgnoreCase("FITS")) break;
                this.inFits = true;
                att = (String)atts.get("extnum");
                this.fitsExtNum = att != null ? Integer.parseInt(att) : 1;
            }
        }
        if (depth > 4) {
            this.fieldSub = name;
        } else if (depth > 3) {
            this.tableSub = name;
        } else if (depth > 2) {
            this.resourceSub = name;
        }
    }

    private void posChooser() {
        block23: {
            this.inAstroCoords = false;
            if (this.inSEDGroup) {
                this.consumer.tableParserInfo("   -SED system found:");
                if (this.sFreq != null) {
                    this.consumer.tableParserInfo("      .frequence col #" + this.nFreq + 1);
                }
                if (this.sFlux != null) {
                    this.consumer.tableParserInfo("      .flux col      #" + this.nFlux + 1);
                }
                if (this.sFluxErr != null) {
                    this.consumer.tableParserInfo("      .fluxError col #" + this.nFluxErr + 1);
                }
                if (this.sSedId != null) {
                    this.consumer.tableParserInfo("      .SEDid col     #" + this.nSedId + 1);
                }
                this.inSEDGroup = false;
            }
            this.srcAstroFrame = null;
            if (this.nRA < 0) {
                this.flagXY = this.nX >= 0 && this.nY >= 0;
                if (!this.flagXY) {
                    this.nRA = 0;
                    this.nDEC = 1;
                } else {
                    this.consumer.setTableInfo("__XYPOS", "true");
                }
            }
            this.consumer.setTableRaDecXYIndex(this.nRA, this.nDEC, this.nPMRA, this.nPMDEC, this.nX, this.nY, !(this.qualRA != 1000 && this.qualDEC != 1000 || this.nX != 1000 && this.nY != 1000));
            if (this.flagXY) {
                this.consumer.tableParserInfo("   -assuming XY positions (column " + (this.nX + 1) + " for X and " + (this.nY + 1) + " for Y)");
            } else if (this.nRA >= 0) {
                this.consumer.tableParserInfo("   -assuming RADEC" + (this.format == 0 ? " " : (this.format == 2 ? " in sexagesimal" : " in degrees")) + " (column " + (this.nRA + 1) + " for RA and " + (this.nDEC + 1) + " for DEC)");
                if (this.nPMRA >= 0) {
                    this.consumer.tableParserInfo("   -Proper motion fields found (column " + (this.nPMRA + 1) + " for PMRA and " + (this.nPMDEC + 1) + " for PMDEC)");
                }
            }
            this.consumer.tableParserInfo("      [RA=" + this.nRA + " (" + this.qualRA + ") DE=" + this.nDEC + " (" + this.qualDEC + ") " + "PMRA=" + this.nPMRA + " (" + this.qualPMRA + ") PMDEC=" + this.nPMDEC + " (" + this.qualPMDEC + ") " + "X=" + this.nX + " (" + this.qualX + ") Y=" + this.nY + " (" + this.qualY + ")]");
            if (this.coosys != null && this.coosys.size() > 0) {
                this.consumer.tableParserInfo("   -Coordinate system references found:");
                Enumeration<String> ce = this.coosys.keys();
                while (ce.hasMoreElements()) {
                    String k = ce.nextElement();
                    String epoch = this.cooepoch.get(k);
                    String equinox = this.cooequinox.get(k);
                    String s = "      ID=\"" + k + "\" => " + this.coosys.get(k) + (equinox == null ? "" : " Eq=" + equinox) + (epoch == null ? "" : " Ep=" + epoch);
                    this.consumer.tableParserInfo(s);
                }
                try {
                    Field f = this.memoField.elementAt(this.nRA);
                    if (f.ref != null) {
                        this.setSourceAstroFrame(f.ref, null, null, 0);
                    } else {
                        String coosysID = this.cooFieldref.get(f.ID);
                        if (coosysID != null) {
                            this.setSourceAstroFrame(coosysID, null, null, 0);
                        }
                    }
                }
                catch (Exception e) {
                    if (this.coosys.size() == 1) {
                        try {
                            this.setSourceAstroFrame(this.coosys.keys().nextElement(), null, null, 0);
                        }
                        catch (Exception exception) {}
                        break block23;
                    }
                    this.consumer.tableParserInfo("!!! Coordinate system assignation error... assuming ICRS");
                }
            } else {
                this.consumer.tableParserInfo("   -No coordinate system reference found... assuming ICRS");
            }
        }
    }

    private void setSourceAstroFrame(String ref, String eq, String ep, int n) throws Exception {
        if (n > 4) {
            throw new Exception();
        }
        String sys = this.coosys.get(ref);
        if (ep == null) {
            ep = this.cooepoch.get(ref);
        }
        if (eq == null) {
            eq = this.cooequinox.get(ref);
        }
        if (sys.indexOf("FK4") >= 0) {
            this.srcAstroFrame = eq == null ? AF_FK4 : new FK4(new Astrotime(eq).getByr());
            if (ep != null) {
                this.srcAstroFrame.setFrameEpoch(new Astrotime(ep).getByr());
            }
        } else if (sys.indexOf("B1950") >= 0) {
            this.srcAstroFrame = AF_FK4;
        } else if (sys.indexOf("FK5") >= 0) {
            this.srcAstroFrame = eq == null ? AF_FK5 : new FK5(new Astrotime(eq).getJyr());
            if (ep != null) {
                this.srcAstroFrame.setFrameEpoch(new Astrotime(ep).getJyr());
            }
        } else if (sys.indexOf("J2000") >= 0) {
            this.srcAstroFrame = AF_FK5;
        } else if (sys.indexOf("ECLIPTIC") >= 0 || sys.indexOf("ECL") >= 0) {
            this.srcAstroFrame = eq == null ? AF_ECLI : new Ecliptic(new Astrotime(eq).getJyr());
            if (ep != null) {
                this.srcAstroFrame.setFrameEpoch(new Astrotime(ep).getJyr());
            }
        } else if (sys.indexOf("SUPER_GALACTIC") >= 0 || sys.indexOf("SGAL") >= 0) {
            this.srcAstroFrame = AF_SGAL;
        } else if (sys.indexOf("GALACTIC") >= 0 || sys.indexOf("GAL") >= 0) {
            this.srcAstroFrame = AF_GAL;
        } else if (sys.indexOf("ICRS") >= 0 && ep != null) {
            this.srcAstroFrame = new ICRS(new Astrotime(ep).getJyr());
        } else if (sys.indexOf("ICRS") < 0) {
            String sref = this.coosys.get(sys);
            if (sref != null) {
                this.setSourceAstroFrame(sys, eq, ep, n + 1);
                return;
            }
            this.consumer.tableParserInfo("      !!! Coordinate system unknown... assuming ICRS");
        }
        if (this.srcAstroFrame == AF_FK5 || (this.srcAstroFrame + "").equals("ICRS") || (this.srcAstroFrame + "").equals("FK5(J2000.0)")) {
            this.srcAstroFrame = null;
        }
        if (ref == null) {
            ref = "null";
        }
        if (this.srcAstroFrame != null) {
            this.c = new Astropos(this.srcAstroFrame);
            this.consumer.tableParserInfo("      => RA/DEC coordinate conversion: ref=\"" + ref + "\" => " + this.srcAstroFrame + " to " + this.trgAstroFrame);
        } else {
            this.consumer.tableParserInfo("      => RA/DEC coordinate system used: ref=\"" + ref + "\" => " + this.trgAstroFrame);
        }
    }

    private void setDefaultField() {
        this.tsvField = new Field[this.nField];
        for (int i = 0; i < this.nField; ++i) {
            Field f = this.tsvField[i] = new Field("C" + (i + 1));
            f.datatype = "D";
            this.consumer.setField(f);
        }
    }

    public static int getRaDec(Astrocoo c, String ra, String dec, int format) throws Exception {
        block10: {
            char ss;
            block9: {
                if (format == 0) {
                    try {
                        ss = dec.charAt(0);
                        format = TableParser.isSexa(ra + (ss != '-' && ss != '+' ? " +" : " ") + dec) ? 2 : 1;
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace <= 3) break block9;
                        e.printStackTrace();
                    }
                }
            }
            if (format == 2) {
                try {
                    ss = dec.charAt(0);
                    String s = ss == '-' || ss == '+' ? ra + " " + dec : ra + " +" + dec;
                    c.set(s);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace > 3) {
                        e.printStackTrace();
                    }
                    break block10;
                }
            }
            try {
                c.set(Double.parseDouble(ra), Double.parseDouble(dec));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return format;
    }

    private static boolean isSexa(String s) {
        int n = s.length();
        int nbb = 0;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == ':' || c == ' ' || c == '\t') {
                ++nbb;
            }
            if (nbb <= 1) continue;
            return true;
        }
        return false;
    }

    private int raName(String s) {
        if (s.equalsIgnoreCase("_RAJ2000")) {
            this.setEq();
            return 0;
        }
        if (s.equalsIgnoreCase("RAJ2000")) {
            this.setEq();
            return 1;
        }
        if (s.equalsIgnoreCase("_RA")) {
            this.setEq();
            return 2;
        }
        if (s.equalsIgnoreCase("RA(ICRS)")) {
            this.setEq();
            return 3;
        }
        if (s.equalsIgnoreCase("RA")) {
            this.setEq();
            return 4;
        }
        if (s.equalsIgnoreCase("ALPHA_J2000")) {
            this.setEq();
            return 5;
        }
        if (s.equalsIgnoreCase("GLON")) {
            this.setGal();
            return 6;
        }
        if (s.equalsIgnoreCase("SGLON")) {
            this.setSGal();
            return 6;
        }
        if (s.equalsIgnoreCase("SLON")) {
            this.setSGal();
            return 6;
        }
        if (s.equalsIgnoreCase("ELON")) {
            this.setEcl();
            return 6;
        }
        return -1;
    }

    private int raSubName(String s) {
        if ((s = s.toLowerCase()).indexOf("radius") >= 0) {
            this.setEq();
            return -1;
        }
        if (s.startsWith("_ra")) {
            this.setEq();
            return 0;
        }
        if (s.startsWith("ra")) {
            this.setEq();
            return 1;
        }
        if (s.startsWith("alpha")) {
            this.setEq();
            return 2;
        }
        if (s.startsWith("GLON")) {
            this.setGal();
            return 0;
        }
        if (s.startsWith("SGLON")) {
            this.setSGal();
            return 0;
        }
        if (s.startsWith("SLON")) {
            this.setSGal();
            return 0;
        }
        if (s.startsWith("ELON")) {
            this.setEcl();
            return 0;
        }
        return -1;
    }

    private int deName(String s) {
        if (s.equalsIgnoreCase("_DEJ2000")) {
            this.setEq();
            return 0;
        }
        if (s.equalsIgnoreCase("_DECJ2000")) {
            this.setEq();
            return 1;
        }
        if (s.equalsIgnoreCase("DEJ2000")) {
            this.setEq();
            return 2;
        }
        if (s.equalsIgnoreCase("DECJ2000")) {
            this.setEq();
            return 3;
        }
        if (s.equalsIgnoreCase("_DE")) {
            this.setEq();
            return 4;
        }
        if (s.equalsIgnoreCase("_DEC")) {
            this.setEq();
            return 5;
        }
        if (s.equalsIgnoreCase("DE(ICRS)")) {
            this.setEq();
            return 6;
        }
        if (s.equalsIgnoreCase("DEC(ICRS)")) {
            this.setEq();
            return 6;
        }
        if (s.equalsIgnoreCase("DEC")) {
            this.setEq();
            return 7;
        }
        if (s.equalsIgnoreCase("DE")) {
            this.setEq();
            return 8;
        }
        if (s.equalsIgnoreCase("DELTA_J2000")) {
            this.setEq();
            return 8;
        }
        if (s.equalsIgnoreCase("GLAT")) {
            this.setGal();
            return 9;
        }
        if (s.equalsIgnoreCase("SGLAT")) {
            this.setSGal();
            return 9;
        }
        if (s.equalsIgnoreCase("SLAT")) {
            this.setSGal();
            return 9;
        }
        if (s.equalsIgnoreCase("ELAT")) {
            this.setEcl();
            return 9;
        }
        return -1;
    }

    private int deSubName(String s) {
        if ((s = s.toLowerCase()).startsWith("_dec")) {
            this.setEq();
            return 0;
        }
        if (s.startsWith("_de")) {
            this.setEq();
            return 1;
        }
        if (s.startsWith("dec")) {
            this.setEq();
            return 2;
        }
        if (s.startsWith("de")) {
            this.setEq();
            return 3;
        }
        if (s.indexOf("de") > 0) {
            this.setEq();
            return 4;
        }
        if (s.startsWith("delta")) {
            this.setEq();
            return 5;
        }
        if (s.startsWith("GLAT")) {
            this.setGal();
            return 0;
        }
        if (s.startsWith("SGLAT")) {
            this.setSGal();
            return 0;
        }
        if (s.startsWith("SLAT")) {
            this.setSGal();
            return 0;
        }
        if (s.startsWith("ELAT")) {
            this.setEcl();
            return 0;
        }
        return -1;
    }

    private void validLastCoordSys() {
        this.srcAstroFrame = this.lastCoordSys;
        if (this.srcAstroFrame == AF_GAL) {
            this.coosys.put(DEFAULT, "GAL");
        } else if (this.srcAstroFrame == AF_SGAL) {
            this.coosys.put(DEFAULT, "SGAL");
        } else if (this.srcAstroFrame == AF_SGAL) {
            this.coosys.put(DEFAULT, "ECL");
        } else {
            this.coosys.remove(DEFAULT);
        }
    }

    private void setGal() {
        this.lastCoordSys = AF_GAL;
    }

    private void setSGal() {
        this.lastCoordSys = AF_SGAL;
    }

    private void setEcl() {
        this.lastCoordSys = AF_ECLI;
    }

    private void setEq() {
        this.lastCoordSys = null;
    }

    private int pmraName(String s) {
        if (s.equalsIgnoreCase("PMRA")) {
            return 0;
        }
        return -1;
    }

    private int pmraSubName(String s) {
        if ((s = s.toLowerCase()).startsWith("pmra")) {
            return 0;
        }
        return -1;
    }

    private int pmdecName(String s) {
        if (s.equalsIgnoreCase("PMDE")) {
            return 0;
        }
        if (s.equalsIgnoreCase("PMDEC")) {
            return 1;
        }
        return -1;
    }

    private int pmdecSubName(String s) {
        if ((s = s.toLowerCase()).startsWith("pmde")) {
            return 0;
        }
        return -1;
    }

    private int xName(String s) {
        if (s.equalsIgnoreCase("XPOS")) {
            return 0;
        }
        if (s.equalsIgnoreCase("XPIX")) {
            return 1;
        }
        if (s.equalsIgnoreCase("X")) {
            return 2;
        }
        if (s.equalsIgnoreCase("POSX")) {
            return 3;
        }
        if (s.equalsIgnoreCase("X_IMAGE")) {
            return 4;
        }
        return -1;
    }

    private int xSubName(String s) {
        if (s.startsWith("XPOS") || s.startsWith("Xpos")) {
            return 0;
        }
        if (s.startsWith("XPIX") || s.startsWith("Xpix")) {
            return 1;
        }
        if (s.indexOf("XPOS") >= 0 || s.indexOf("Xpos") >= 0 || s.indexOf("XPIX") >= 0 || s.indexOf("Xpix") >= 0) {
            return 2;
        }
        if ((s.startsWith("X") || s.startsWith("x")) && !Character.isLetterOrDigit(s.charAt(1))) {
            return 3;
        }
        return -1;
    }

    private int yName(String s) {
        if (s.equalsIgnoreCase("YPOS")) {
            return 0;
        }
        if (s.equalsIgnoreCase("YPIX")) {
            return 1;
        }
        if (s.equalsIgnoreCase("Y")) {
            return 2;
        }
        if (s.equalsIgnoreCase("POSY")) {
            return 3;
        }
        if (s.equalsIgnoreCase("Y_IMAGE")) {
            return 4;
        }
        return -1;
    }

    private int ySubName(String s) {
        if (s.startsWith("YPOS") || s.startsWith("Ypos")) {
            return 0;
        }
        if (s.startsWith("YPIX") || s.startsWith("Ypix")) {
            return 1;
        }
        if (s.indexOf("YPOS") >= 0 || s.indexOf("Ypos") >= 0 || s.indexOf("YPIX") >= 0 || s.indexOf("Ypix") >= 0) {
            return 2;
        }
        if ((s.startsWith("Y") || s.startsWith("y")) && !Character.isLetterOrDigit(s.charAt(1))) {
            return 3;
        }
        return -1;
    }

    private void detectSEDField(Field f, int nField) {
        String name;
        String string = name = f.ID != null ? f.ID : f.name;
        if (name == null) {
            return;
        }
        if (this.sFreq != null && name.equals(this.sFreq)) {
            f.sed = 1;
            this.nFreq = nField;
        } else if (this.sFlux != null && name.equals(this.sFlux)) {
            f.sed = 2;
            this.nFlux = nField;
        } else if (this.sFluxErr != null && name.equals(this.sFluxErr)) {
            f.sed = 3;
            this.nFluxErr = nField;
        } else if (this.sSedId != null && name.equals(this.sSedId)) {
            f.sed = 4;
            this.nSedId = nField;
        } else {
            return;
        }
    }

    private void detectPosField(Field f, int nField) {
        int n;
        String name = f.name == null ? "" : f.name;
        String ucd = f.ucd == null ? "" : f.ucd;
        String unit = f.unit == null ? "" : f.unit;
        boolean numeric = f.isNumDataType();
        if (this.memoField == null) {
            this.memoField = new Vector();
        }
        this.memoField.addElement(f);
        if (ucd.equals("pos.eq") || ucd.equals("pos.eq;meta.main")) {
            this.nRA = this.nDEC = nField;
            this.format = unit.length() == 0 ? 0 : (unit.indexOf("h") >= 0 && unit.indexOf("m") >= 0 && unit.indexOf("s") >= 0 ? 2 : 1);
            this.validLastCoordSys();
            this.qualDEC = 0;
            this.qualRA = 0;
            return;
        }
        int qual = -1;
        if (ucd.equals("POS_EQ_RA_MAIN") || ucd.equals("pos.eq.ra;meta.main")) {
            qual = 0;
        } else if (ucd.startsWith("POS_EQ_RA") || ucd.startsWith("pos.eq.ra")) {
            qual = 100;
        } else {
            n = this.raName(name);
            if (n >= 0) {
                qual = unit.indexOf("h:m:s") >= 0 ? 200 + n : (unit.indexOf("deg") >= 0 ? 200 + n : (numeric ? 200 + n : 400 + n));
            } else {
                n = this.raSubName(name);
                if (n >= 0) {
                    qual = unit.indexOf("h:m:s") >= 0 ? 300 + n : (unit.indexOf("deg") >= 0 ? 300 + n : (numeric ? 300 + n : 450 + n));
                }
            }
        }
        if (qual >= 0 && this.qualRA > qual) {
            this.nRA = nField;
            this.qualRA = qual;
            this.format = unit.length() == 0 ? 0 : (unit.indexOf("h") >= 0 && unit.indexOf("m") >= 0 && unit.indexOf("s") >= 0 ? 2 : 1);
            this.validLastCoordSys();
        }
        qual = -1;
        if (ucd.equals("POS_EQ_DEC_MAIN") || ucd.equals("pos.eq.dec;meta.main")) {
            qual = 0;
        } else if (ucd.startsWith("POS_EQ_DEC") || ucd.startsWith("pos.eq.dec")) {
            qual = 100;
        } else {
            n = this.deName(name);
            if (n >= 0) {
                qual = unit.indexOf("d:m:s") >= 0 ? 200 + n : (unit.startsWith("deg") ? 200 + n : (numeric ? 200 + n : 400 + n));
            } else {
                n = this.deSubName(name);
                if (n >= 0) {
                    qual = unit.indexOf("d:m:s") >= 0 ? 300 + n : (unit.startsWith("deg") ? 300 + n : (numeric ? 300 + n : 450 + n));
                }
            }
        }
        if (qual > 0 && this.nRA == nField - 1 && this.nRA >= 0) {
            --qual;
        }
        if (qual >= 0 && this.qualDEC > qual) {
            this.nDEC = nField;
            this.qualDEC = qual;
        }
        qual = -1;
        if (ucd.equals("POS_PMRA") || ucd.equals("pos.pm;pos.eq.ra")) {
            try {
                new Unit(unit).convertTo(new Unit("mas/yr"));
                qual = 0;
            }
            catch (Exception e) {
                qual = 1;
            }
        } else {
            n = this.pmraName(name);
            if (n >= 0) {
                if (ucd.startsWith("pos.pm")) {
                    qual = 200 + n;
                } else {
                    try {
                        new Unit(unit).convertTo(new Unit("mas/yr"));
                        qual = 300 + n;
                    }
                    catch (Exception e) {
                        qual = 600 + n;
                    }
                }
            } else {
                n = this.pmraSubName(name);
                if (n >= 0) {
                    if (ucd.startsWith("pos.pm")) {
                        qual = 400 + n;
                    } else {
                        try {
                            new Unit(unit).convertTo(new Unit("mas/yr"));
                            qual = 500 + n;
                        }
                        catch (Exception e) {
                            qual = 700 + n;
                        }
                    }
                }
            }
        }
        if (qual >= 0 && this.qualX > qual) {
            this.nPMRA = nField;
            this.qualPMRA = qual;
        }
        qual = -1;
        if (ucd.equals("POS_PMDE") || ucd.equals("pos.pm;pos.eq.dec")) {
            qual = 0;
        } else {
            n = this.pmdecName(name);
            if (n >= 0) {
                if (ucd.startsWith("pos.pm")) {
                    qual = 200 + n;
                }
                try {
                    new Unit(unit).convertTo(new Unit("mas/yr"));
                    qual = 300 + n;
                }
                catch (Exception e) {
                    qual = 600 + n;
                }
            } else {
                n = this.pmdecSubName(name);
                if (n >= 0) {
                    if (ucd.startsWith("pos.pm")) {
                        qual = 400 + n;
                    } else {
                        try {
                            new Unit(unit).convertTo(new Unit("mas/yr"));
                            qual = 500 + n;
                        }
                        catch (Exception e) {
                            qual = 700 + n;
                        }
                    }
                }
            }
        }
        if (qual >= 0 && this.qualX > qual) {
            this.nPMDEC = nField;
            this.qualPMDEC = qual;
        }
        qual = -1;
        if (ucd.equals("POS_CCD_X") || ucd.equals("pos.cartesian.x;instr.det")) {
            qual = 0;
        } else if (ucd.startsWith("pos.cartesian.x")) {
            qual = 100;
        } else {
            n = this.xName(name);
            if (n >= 0) {
                qual = ucd.startsWith("pos.det") ? 200 + n : (unit.equals("pix") || unit.equals("mm") ? 300 + n : 600 + n);
            } else {
                n = this.xSubName(name);
                if (n >= 0) {
                    qual = ucd.startsWith("pos.det") ? 400 + n : (unit.equals("pix") || unit.equals("mm") ? 500 + n : 700 + n);
                }
            }
        }
        if (qual >= 0 && this.qualX > qual) {
            this.nX = nField;
            this.qualX = qual;
        }
        qual = -1;
        if (ucd.equals("POS_CCD_Y") || ucd.equals("pos.cartesian.y;instr.det")) {
            qual = 0;
        } else if (ucd.startsWith("pos.cartesian.y")) {
            qual = 100;
        } else {
            n = this.yName(name);
            if (n >= 0) {
                qual = ucd.startsWith("pos.det") ? 200 + n : (unit.equals("pix") || unit.equals("mm") ? 300 + n : 600 + n);
            } else {
                n = this.ySubName(name);
                if (n >= 0) {
                    qual = ucd.startsWith("pos.det") ? 400 + n : (unit.equals("pix") || unit.equals("mm") ? 500 + n : 700 + n);
                }
            }
        }
        if (qual >= 0 && this.qualY > qual) {
            this.nY = nField;
            this.qualY = qual;
        }
    }

    @Override
    public void endElement(String name) {
        if (this.inError) {
            this.inError = false;
        }
        int depth = this.xmlparser.getDepth() + 1;
        if (this.inGroup) {
            this.memoEndGroup(name);
        }
        if (name.charAt(0) == 'G' && depth >= 1 && name.equalsIgnoreCase("GROUP")) {
            --this.ngroup;
            this.inGroup = false;
            return;
        }
        if ((depth -= this.ngroup) == 7 && name.equalsIgnoreCase("TD")) {
            this.inTD = false;
            if (!this.valueInTD) {
                this.record[this.row] = null;
            }
            this.valueInTD = false;
            ++this.row;
        } else if (depth == 6 && name.equalsIgnoreCase("TR")) {
            this.consumeRecord(this.record, -1);
        } else if (depth == 6 && name.equalsIgnoreCase("STREAM")) {
            this.inEncode64 = false;
        } else if (depth == 3 && name.equalsIgnoreCase("TABLE")) {
            this.tableSub = null;
            this.fieldSub = null;
            this.consumer.endTable();
        } else if (depth == 2 && name.equalsIgnoreCase("RESOURCE")) {
            this.resourceSub = null;
            this.tableSub = null;
            this.fieldSub = null;
            this.consumer.endResource();
        } else if (name.equalsIgnoreCase("DESCRIPTION")) {
            this.inFieldDesc = false;
        } else if (depth == 5 && name.equalsIgnoreCase("LINK")) {
            this.inLinkField = false;
        } else if (depth == 5 && name.equalsIgnoreCase("CSV")) {
            this.inCSV = false;
        } else if (depth == 5 && name.equalsIgnoreCase("BINARY")) {
            this.inBinary = false;
        } else if (depth == 5 && name.equalsIgnoreCase("BINARY2")) {
            this.inBinary2 = false;
        } else if (depth == 5 && name.equalsIgnoreCase("FITS")) {
            this.inFits = false;
        } else if (depth == 4 && name.equalsIgnoreCase("FIELD")) {
            this.fieldSub = null;
            if (this.f.name == null) {
                this.f.name = this.f.ID;
            }
            this.detectPosField(this.f, this.nField);
            this.detectSEDField(this.f, this.nField);
            ++this.nField;
            this.consumer.setField(this.f);
        } else if (depth != 4 || name.equalsIgnoreCase("PARAM")) {
            // empty if block
        }
    }

    private boolean isEmpty(char[] ch, int start, int length) {
        for (int i = 0; i < length; ++i) {
            if (Character.isSpace(ch[i + start])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws Exception {
        try {
            if (this.inGroup) {
                this.memoInGroup(ch, start, length);
                return;
            }
            if (this.inEncode64) {
                this.parseBase64(ch, start, length, this.inBinary2);
                return;
            }
            if (this.isEmpty(ch, start, length)) {
                return;
            }
            if (this.inLinkField) {
                if (this.f.refText == null) {
                    this.f.addInfo("refText", TableParser.getStringTrim(ch, start, length));
                }
            } else if (this.inFieldDesc) {
                if (this.f != null) {
                    this.f.addInfo("DESCRIPTION", TableParser.getStringTrim(ch, start, length));
                }
            } else if (this.inCSV || this.flagTSV) {
                this.dataParse(ch, start, length);
            } else if (this.inTD) {
                this.record[this.row] = TableParser.getStringTrim(ch, start, length);
                this.valueInTD = length > 0;
            } else if (this.inError) {
                this.error = TableParser.getStringTrim(ch, start, length);
            } else if (this.f != null && this.fieldSub != null) {
                this.f.addInfo(this.fieldSub, TableParser.getStringTrim(ch, start, length));
            } else if (this.filter != null) {
                this.consumeFilter(TableParser.getStringTrim(ch, start, length));
            } else if (this.tableSub != null) {
                this.consumer.setTableInfo(this.tableSub, TableParser.getStringTrim(ch, start, length));
            } else if (this.resourceSub != null) {
                this.consumer.setResourceInfo(this.resourceSub, TableParser.getStringTrim(ch, start, length));
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace == 4) {
                System.err.println("TableParser.character() exception: table line " + this.xmlparser.getCurrentLine());
            }
            throw e;
        }
    }

    private void consumeFilter(String filterRule) {
        this.consumer.setFilter(this.filter + filterRule + (this.filter.length() > 0 ? "\n}\n" : ""));
        this.filter = null;
    }

    private void consumeRecord(String[] rec, int nbRecord) {
        try {
            if (this.flagXY) {
                double x = Double.parseDouble(rec[this.nX]);
                double y = Double.parseDouble(rec[this.nY]);
                this.consumer.setRecord(x, y, rec);
            } else {
                String dec;
                String ra;
                if (this.nRA != this.nDEC) {
                    ra = rec[this.nRA];
                    dec = rec[this.nDEC];
                } else {
                    String s = rec[this.nRA];
                    int i = s.indexOf(43);
                    if (i < 0) {
                        i = s.indexOf(45);
                    }
                    if (i < 0 && (i = s.indexOf(44)) > 0) {
                        ++i;
                    }
                    if (i < 0) {
                        i = s.indexOf(32);
                    }
                    if (i < 0) {
                        throw new Exception("Unsupported syntax for coordinates expressed as an unique field");
                    }
                    ra = s.substring(0, i).trim();
                    dec = s.substring(i).trim();
                }
                this.format = TableParser.getRaDec(this.c, ra, dec, this.format);
                if (this.srcAstroFrame != null) {
                    this.c.convertTo(this.trgAstroFrame);
                    this.consumer.setRecord(this.c.getLon(), this.c.getLat(), rec);
                    this.c = new Astropos(this.srcAstroFrame);
                } else {
                    this.consumer.setRecord(this.c.getLon(), this.c.getLat(), rec);
                }
            }
        }
        catch (Exception e1) {
            System.err.println("Table parser error " + (nbRecord != -1 ? "(record " + (nbRecord + 1) + ")" : "") + ": " + e1);
            e1.printStackTrace();
        }
    }

    private static final char isColSep(char c, char[] cs) {
        for (int i = 0; i < cs.length; ++i) {
            if (c != cs[i]) continue;
            return c;
        }
        return '\u0000';
    }

    public static int countColumn(String s, char[] cs) {
        char[] ch = s.toCharArray();
        int cur = 0;
        int end = ch.length;
        int sep = 0;
        int ncol = 0;
        while (cur < end) {
            while (cur < end) {
                char c = TableParser.isColSep(ch[cur], cs);
                sep = c;
                if (c != '\u0000') break;
                ++cur;
            }
            ++ncol;
            if (sep == 32) {
                while (cur < end && ch[cur] == ' ') {
                    ++cur;
                }
                continue;
            }
            ++cur;
        }
        return ncol;
    }

    private int getField(char[] ch, int cur, int end, char rs, char[] cs, int nbRecord) throws Exception {
        String value;
        boolean excelCSV;
        int start = cur;
        int sep = 0;
        boolean bl = excelCSV = cs.length > 0 && cs[0] == ',';
        if (excelCSV) {
            boolean inQuote = false;
            while (cur < end) {
                if (ch[cur] == '\"') {
                    boolean bl2 = inQuote = !inQuote;
                }
                if (!inQuote) {
                    char c = TableParser.isColSep(ch[cur], cs);
                    sep = c;
                    if (c != '\u0000' || ch[cur] == rs) break;
                }
                ++cur;
            }
            if (inQuote) {
                throw new Exception("Bad CSV: Excel quote delimiters not balanced (record " + (nbRecord + 1) + " field[" + this.row + "]=[" + TableParser.getStringTrim(ch, start, cur - start) + "])");
            }
        } else {
            while (cur < end) {
                char c = TableParser.isColSep(ch[cur], cs);
                sep = c;
                if (c != '\u0000' || ch[cur] == rs) break;
                ++cur;
            }
        }
        if (excelCSV) {
            value = cur - start > 1 && ch[start] == '\"' && ch[cur - 1] == '\"' ? TableParser.getStringTrim(ch, start + 1, cur - start - 2) : TableParser.getStringTrim(ch, start, cur - start);
        } else {
            if (sep == 32) {
                ++cur;
                while (cur < end && ch[cur] == ' ' && ch[cur] != rs) {
                    ++cur;
                }
                --cur;
            }
            value = TableParser.getStringTrim(ch, start, cur - start);
        }
        if (sep == 32 && this.row == 0 && value.length() == 0) {
            return cur;
        }
        if (this.record != null) {
            if (this.row >= this.record.length) {
                String s = "Not aligned CSV catalog (record=" + (nbRecord + 1) + " extra row value=\"" + value + "\") => ignored\n";
                this.aladin.command.printConsole(s);
            } else {
                this.record[this.row] = value;
            }
        } else {
            if (this.vRecord == null) {
                this.vRecord = new Vector();
            }
            this.vRecord.addElement(value);
        }
        ++this.row;
        return cur;
    }

    private int getRecord(char[] ch, int cur, int end, char rs, char[] cs, int nbRecord) throws Exception {
        this.row = 0;
        int un = 0;
        while (cur < end && ch[cur] != rs) {
            cur = this.getField(ch, cur + un, end, rs, cs, nbRecord);
            un = 1;
        }
        if (!(this.record == null || this.row >= this.record.length || this.row == 1 && this.record[0].equals("[EOD]"))) {
            String s = "Not aligned CSV catalog (record=" + (nbRecord + 1) + " missing rows nbRow=" + this.row + "/" + this.record.length + ") => ignored" + (this.filename != null ? this.filename : "");
            this.aladin.command.printConsole(s);
        }
        return cur;
    }

    protected static int skipRecSep(char[] ch, int cur, char rs) {
        if (ch[cur] == rs) {
            cur = rs == '\n' && cur < ch.length - 1 && ch[cur + 1] == '\r' ? (cur += 2) : ++cur;
        }
        return cur;
    }

    protected static int skipRec(char[] ch, int cur, char rs) {
        while (ch[cur] != rs && cur < ch.length - 1) {
            ++cur;
        }
        return TableParser.skipRecSep(ch, cur, rs);
    }

    private boolean vide(char[] ch, int cur, int end, char rs) {
        if (ch[cur] == '#') {
            return true;
        }
        while (cur < end && (ch[cur] == ' ' || ch[cur] == '\t' || ch[cur] == '\r')) {
            ++cur;
        }
        return ch[cur] == rs;
    }

    private boolean isSimpleDahsLine(char[] ch, int cur, int end, char rs) {
        while (cur < end && ch[cur] == '-') {
            ++cur;
        }
        return ch[cur] == rs;
    }

    private String colSepInfo(char[] cs) {
        String s = null;
        for (int i = 0; i < cs.length; ++i) {
            String s1;
            switch (cs[i]) {
                case '\t': {
                    s1 = "Tab";
                    break;
                }
                case '|': {
                    s1 = "Pipe (|)";
                    break;
                }
                case ';': {
                    s1 = "Semi-column (;)";
                    break;
                }
                case ',': {
                    s1 = "Comma (,)";
                    break;
                }
                case ' ': {
                    s1 = "One or several spaces";
                    break;
                }
                default: {
                    s1 = cs[i] + "";
                }
            }
            s = i == 0 ? s1 : s + ", " + s1;
        }
        return s;
    }

    private void dataParse(char[] ch, int start, int length) throws Exception {
        int i;
        char rs = '\n';
        char[] cs = "\t".toCharArray();
        int cur = start;
        int end = start + length;
        int n = 0;
        int nbRecord = 0;
        if (this.recsep != null) {
            rs = this.recsep.charAt(0);
        }
        if (this.colsep != null) {
            cs = this.colsep.toCharArray();
        }
        int h = this.headlines == null ? 0 : Integer.parseInt(this.headlines);
        this.headlines = null;
        n = 0;
        boolean flagHeader = false;
        boolean dashLine = false;
        boolean flagDejaLu = false;
        if (this.flagNewTable) {
            if (this.flagTSV) {
                this.consumer.tableParserInfo("CSV format [" + this.colSepInfo(cs) + "]");
            } else {
                this.consumer.tableParserInfo("   -found CSV DATA (field sep=" + this.colSepInfo(cs) + " record sep=" + (rs == '\n' ? "\\n" : "[" + (byte)rs + "]") + ")");
                if (h == 0) {
                    this.consumer.tableParserInfo("   -No CSV header");
                }
            }
            this.flagNewTable = false;
        }
        for (n = 0; cur < end && (this.flagTSV || n < h); ++n) {
            int j;
            if (this.vide(ch, cur, end, rs) || n == 1 && this.isSimpleDahsLine(ch, cur, end, rs)) {
                --n;
                cur = TableParser.skipRec(ch, cur, rs);
                continue;
            }
            cur = this.getRecord(ch, cur, end, rs, cs, nbRecord);
            if (this.record == null) {
                this.nField = this.vRecord.size();
                this.consumer.tableParserInfo("   -found CSV DATA (" + this.nField + " fields)");
                this.record = new String[this.nField];
                Enumeration<String> e = this.vRecord.elements();
                for (i = 0; i < this.nField; ++i) {
                    this.record[i] = e.nextElement();
                }
            }
            dashLine = true;
            for (i = 0; i < this.nField && dashLine; ++i) {
                char[] a = this.record[i].toCharArray();
                for (j = 0; j < a.length && a[j] == '-'; ++j) {
                }
                if (j >= a.length) continue;
                dashLine = false;
                break;
            }
            if (dashLine) {
                this.consumer.tableParserInfo("   -Found " + (n + 1) + " lines CVS header with dash separator");
                cur = TableParser.skipRecSep(ch, cur, rs);
                break;
            }
            if (!this.flagTSV) continue;
            if (n == 0 || n == 1 && (this.qualRA < 500 && this.qualDEC < 500 || this.qualX < 700 && this.qualY < 700)) {
                int p = 0;
                int r = 1;
                if (n == 1) {
                    if (this.qualRA < 500) {
                        p = this.nRA;
                        r = this.nDEC;
                    } else {
                        p = this.nX;
                        r = this.nY;
                    }
                }
                flagHeader = false;
                for (i = 0; i < 2; ++i) {
                    char q;
                    int k;
                    int n2 = k = i == 0 ? p : r;
                    if (k >= this.nField) {
                        flagHeader = true;
                        break;
                    }
                    char[] a = this.record[k].toCharArray();
                    for (j = 0; j < a.length && ((q = a[j]) >= '0' && q <= '9' || q == '.' || q == '+' || q == 'e' || q == 'E' || q == '-' || q == ':' || q == ' '); ++j) {
                    }
                    if (j != 0 && j >= a.length) continue;
                    flagHeader = true;
                    break;
                }
                if (!flagHeader) {
                    flagDejaLu = true;
                    if (n == 0) {
                        this.consumer.tableParserInfo("   -No CSV header found!");
                        this.setDefaultField();
                    } else {
                        this.consumer.tableParserInfo("   -Found one line CVS header");
                    }
                    this.posChooser();
                    break;
                }
            }
            if (flagHeader && n == 0 && (this.nRA < 0 || this.flagTSV)) {
                this.tsvField = new Field[this.nField];
                for (i = 0; i < this.nField; ++i) {
                    Field f = this.tsvField[i] = new Field(this.record[i]);
                    f.datatype = "D";
                    this.detectPosField(f, i);
                    if (!this.flagTSV) continue;
                    this.consumer.setField(f);
                }
                this.posChooser();
            }
            cur = TableParser.skipRecSep(ch, cur, rs);
        }
        while (cur < end || flagDejaLu) {
            if (!flagDejaLu) {
                if (this.vide(ch, cur, end, rs)) {
                    cur = TableParser.skipRec(ch, cur, rs);
                    continue;
                }
                cur = this.getRecord(ch, cur, end, rs, cs, nbRecord);
            } else {
                flagDejaLu = false;
            }
            ++nbRecord;
            if (this.row == 1 && this.record[0].equals("[EOD]")) {
                this.consumer.tableParserInfo("   -Stop parsing at SkyCat [EOD] tag");
                cur = end;
                break;
            }
            while (this.row < this.nField) {
                this.record[this.row++] = "???";
            }
            if (this.tsvField != null) {
                for (i = 0; i < this.tsvField.length; ++i) {
                    if (this.tsvField[i].datatype == null || !this.tsvField[i].datatype.equals("D")) continue;
                    try {
                        String s1 = this.record[i].trim();
                        if (s1.length() <= 0 || s1.equals("-") || s1.equalsIgnoreCase("null")) continue;
                        Double.parseDouble(s1);
                        continue;
                    }
                    catch (Exception e) {
                        this.tsvField[i].datatype = null;
                    }
                }
            }
            this.consumeRecord(this.record, nbRecord);
            cur = TableParser.skipRecSep(ch, cur, rs);
        }
        if (nbRecord == 0) {
            String s = TableParser.getStringTrim(ch, start, length > 200 ? 200 : length);
            throw new Exception("Data parsing error:\n \n[" + s + "...]");
        }
    }
}

