/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.tools.Util;
import java.util.Hashtable;

public final class Field {
    private static String NUMDATATYPE = "JKEFGDI";
    public String ID;
    public String name;
    public String description;
    public String title;
    public String type;
    public String unit;
    public String ucd;
    public String datatype;
    public String width;
    public String utype;
    public String arraysize;
    public String precision;
    public String href;
    public String gref;
    public String refText;
    public String refValue;
    public String nullValue;
    public int columnSize = 10;
    public static final int RA = 1;
    public static final int DE = 2;
    public static final int PMRA = 3;
    public static final int PMDE = 4;
    public static final int X = 5;
    public static final int Y = 6;
    public static final String[] COOSIGN = new String[]{"", "RA", "DE", "PMRA", "PMDE", "X", "Y"};
    public int coo;
    public static final int FREQ = 1;
    public static final int FLUX = 2;
    public static final int FLUXERR = 3;
    public static final int SEDID = 4;
    public static final String[] SEDLABEL = new String[]{"", "SED_FREQ", "SED_FLUX", "SED_FLUXERR", "SED_SEDID"};
    public int sed;
    public String ref;
    public int sort;
    public boolean visible = true;
    public String hpxFinderPattern;
    public static final int UNSORT = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;

    public Field(Hashtable atts) {
        this.ID = (String)atts.get("ID");
        this.name = (String)atts.get("name");
        this.unit = (String)atts.get("unit");
        this.ucd = (String)atts.get("UCD");
        if (this.ucd == null) {
            this.ucd = (String)atts.get("ucd");
        }
        this.utype = (String)atts.get("utype");
        this.datatype = Field.typeVOTable2Fits((String)atts.get("datatype"));
        this.width = (String)atts.get("width");
        this.nullValue = (String)atts.get("nullValue");
        this.precision = (String)atts.get("precision");
        this.type = (String)atts.get("type");
        this.arraysize = (String)atts.get("arraysize");
        this.ref = (String)atts.get("ref");
        this.sort = 0;
        this.computeColumnSize();
    }

    public Field(Field f) {
        this.description = f.description;
        this.ID = f.ID;
        this.name = f.name;
        this.unit = f.unit;
        this.ucd = f.ucd;
        this.utype = f.utype;
        this.datatype = f.datatype;
        this.width = f.width;
        this.precision = f.precision;
        this.type = f.type;
        this.arraysize = f.arraysize;
        this.href = f.href;
        this.gref = f.gref;
        this.refText = f.refText;
        this.refValue = f.refValue;
        this.ref = f.ref;
        this.coo = f.coo;
        this.title = f.title;
        this.sort = 0;
        this.visible = f.visible;
        this.columnSize = f.columnSize;
        this.nullValue = f.nullValue;
    }

    public void computeColumnSize() {
        int n = 0;
        if (this.width != null) {
            try {
                n = Integer.parseInt(this.width);
            }
            catch (Exception e) {
                n = 0;
            }
        }
        if (n == 0 && this.arraysize != null) {
            try {
                n = !this.arraysize.endsWith("*") ? Integer.parseInt(this.arraysize) : Integer.parseInt(this.arraysize.substring(0, this.arraysize.length() - 1));
                if (n > 20) {
                    n = 0;
                }
            }
            catch (Exception e) {
                n = 0;
            }
        }
        if (n == 0) {
            n = 10;
        }
        this.columnSize = n;
    }

    public boolean equals(Field f) {
        if (this == f) {
            return true;
        }
        if (this.utype != null && this.utype.equals(f.utype)) {
            return true;
        }
        if (this.name != null && !this.name.equals(f.name)) {
            return false;
        }
        if (this.unit != null && !this.unit.equals(f.unit)) {
            return false;
        }
        return this.ucd == null || this.ucd.equals(f.ucd);
    }

    public int getFieldSignature() {
        return this.coo;
    }

    public boolean isRa() {
        return this.coo == 1;
    }

    public boolean isDe() {
        return this.coo == 2;
    }

    public boolean isPmRa() {
        return this.coo == 3;
    }

    public boolean isPmDe() {
        return this.coo == 4;
    }

    public boolean isX() {
        return this.coo == 5;
    }

    public boolean isY() {
        return this.coo == 6;
    }

    public String getCooSignature() {
        return COOSIGN[this.coo];
    }

    public Field(String name) {
        this.name = name;
    }

    public void addInfo(String name, String value) {
        if (name.equals("DESCRIPTION")) {
            this.description = (this.description == null ? "" : this.description) + value;
        } else if (name.equals("TITLE")) {
            this.title = (this.title == null ? "" : this.title) + value;
        } else if (name.equals("href")) {
            this.href = value;
        } else if (name.equals("gref")) {
            this.gref = value;
        } else if (name.equals("refText")) {
            this.refText = value;
        } else if (name.equals("refValue")) {
            this.refValue = value;
        } else if (name.equals("sed")) {
            this.setSEDtag(value);
        } else {
            return;
        }
    }

    public boolean isNumDataType() {
        return this.datatype != null && NUMDATATYPE.indexOf(this.datatype) >= 0;
    }

    public String getSEDtag() {
        if (this.sed == 0 || this.sed >= SEDLABEL.length) {
            return null;
        }
        return SEDLABEL[this.sed];
    }

    private void setSEDtag(String tag) {
        int i = Util.indexInArrayOf(tag, SEDLABEL, true);
        if (i == -1) {
            i = 0;
        }
        this.sed = i;
    }

    public static String typeFits2VOTable(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() > 1) {
            return s;
        }
        if (s.equals("J")) {
            return "int";
        }
        if (s.equals("K")) {
            return "long";
        }
        if (s.equals("A")) {
            return "char";
        }
        if (s.equals("E")) {
            return "float";
        }
        if (s.equals("D")) {
            return "double";
        }
        if (s.equals("F")) {
            return "double";
        }
        if (s.equals("G")) {
            return "double";
        }
        if (s.equals("L")) {
            return "boolean";
        }
        if (s.equals("I")) {
            return "short";
        }
        if (s.equals("X")) {
            return "bit";
        }
        if (s.equals("B")) {
            return "unsignedByte";
        }
        if (s.equals("C")) {
            return "floatComplex";
        }
        if (s.equals("M")) {
            return "doubleComplex";
        }
        return "float";
    }

    public static String typeVOTable2Fits(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() < 2) {
            return s;
        }
        if (s.startsWith("int")) {
            return "J";
        }
        if (s.equals("long")) {
            return "K";
        }
        if (s.startsWith("char")) {
            return "A";
        }
        if (s.equals("string")) {
            return "A";
        }
        if (s.equals("float")) {
            return "E";
        }
        if (s.equals("double")) {
            return "D";
        }
        if (s.equals("boolean")) {
            return "L";
        }
        if (s.equals("short")) {
            return "I";
        }
        if (s.equals("bit")) {
            return "X";
        }
        if (s.equals("unsignedByte")) {
            return "B";
        }
        if (s.equals("floatComplex")) {
            return "C";
        }
        if (s.equals("doubleComplex")) {
            return "M";
        }
        return "E";
    }

    public String toString() {
        return (this.ID == null ? "" : " ID=" + this.ID) + (this.name == null ? "" : " name=" + this.name) + (this.unit == null ? "" : " unit=" + this.unit) + (this.ucd == null ? "" : " ucd=" + this.ucd) + (this.utype == null ? "" : " utype=" + this.utype) + (this.datatype == null ? "" : " datatype=" + this.datatype) + (this.precision == null ? "" : " precision=" + this.precision) + (this.type == null ? "" : " type=" + this.type) + " coo=" + this.getCooSignature() + (this.arraysize == null ? "" : " arraysize=" + this.arraysize) + (this.nullValue == null ? "" : " nullValue=" + this.nullValue);
    }
}

