/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import cds.tools.TwoColorJTable;
import cds.tools.Util;
import cds.vizier.VizieRCatalog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public final class VizieRTable
extends TwoColorJTable {
    public static final int SURVEY_MODE = 0;
    public static final int SEARCH_MODE = 1;
    protected JTextField catalog;
    protected JButton getReadMe;
    protected JButton getMoc;
    protected Vector vCats;
    protected Vector v;
    private final int mode;
    static final boolean LSCREEN = Toolkit.getDefaultToolkit().getScreenSize().width > 1000;
    protected static final int SIZE = LSCREEN ? 12 : 10;
    protected static Font COURIER = new Font("Monospaced", 0, SIZE);
    private int colIdx = -1;
    boolean ascending = true;
    private Vector selectedCats;

    public VizieRTable(JTextField catalog, JButton getReadMe, JButton getMoc, Vector v) {
        this(catalog, getReadMe, getMoc, v, 20, 0);
    }

    public VizieRTable(JTextField catalog, JButton getReadMe, JButton getMoc, Vector v, int rows, int mode) {
        this.mode = mode;
        this.v = v;
        this.vCats = this.createObjectsFromRows(v);
        this.catalog = catalog;
        this.getReadMe = getReadMe;
        this.getMoc = getMoc;
        this.setGridColor(Color.lightGray);
        this.setModel(new VizieRTableModel());
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().addMouseListener(new VizieRTableHeaderListener());
        if (mode == 1) {
            this.addMouseListener(new VizieRTableMouseListener());
        }
        if (mode == 0) {
            this.getColumnModel().getColumn(0).setPreferredWidth(80);
            this.getColumnModel().getColumn(1).setPreferredWidth(300);
            this.getColumnModel().getColumn(2).setPreferredWidth(100);
        } else {
            this.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.getColumnModel().getColumn(1).setPreferredWidth(90);
            this.getColumnModel().getColumn(2).setPreferredWidth(70);
            this.getColumnModel().getColumn(3).setPreferredWidth(60);
            this.getColumnModel().getColumn(4).setPreferredWidth(330);
        }
        this.setVisibleRowCount(rows);
        this.getTableHeader().setDefaultRenderer(new VizieRTableHeaderRenderer(this.getTableHeader().getDefaultRenderer()));
        this.setFont(COURIER);
        this.getSelectionModel().addListSelectionListener(new VizieRTableSelectionListener());
    }

    public VizieRTable(Vector v) {
        this(null, null, null, v, 20, 0);
    }

    private void setVisibleRowCount(int nbRows) {
        int height = this.getRowHeight() * nbRows;
        this.setPreferredScrollableViewportSize(new Dimension(560, height));
    }

    private Vector createObjectsFromRows(Vector v) {
        int nbPartsExpected;
        Vector<VizieRCatalog> result = new Vector<VizieRCatalog>();
        Enumeration e = v.elements();
        int n = nbPartsExpected = this.mode == 0 ? 3 : 4;
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            String name = null;
            String desc = null;
            int nbKRow = -1;
            String category = null;
            int density = -1;
            String[] parts = s.split("\t", -1);
            if (parts.length < nbPartsExpected) continue;
            if (this.mode == 0) {
                name = parts[0];
                desc = parts[1];
                try {
                    nbKRow = Integer.parseInt(parts[2]);
                }
                catch (NumberFormatException nfe) {
                    nbKRow = 0;
                }
            } else {
                name = parts[0];
                category = parts[1];
                try {
                    density = Integer.parseInt(parts[2]);
                }
                catch (NumberFormatException nfe) {
                    density = 0;
                }
                desc = parts[3];
            }
            result.add(new VizieRCatalog(name, desc, category, density, nbKRow));
        }
        return result;
    }

    public void selectCatalog(String catName) {
        Enumeration e = this.vCats.elements();
        int k = 0;
        while (e.hasMoreElements()) {
            if (((VizieRCatalog)e.nextElement()).getName().equals(catName)) {
                this.setRowSelectionInterval(k, k);
            }
            ++k;
        }
    }

    public JTextField getCatalogField() {
        return this.catalog;
    }

    public JTextField getCatalogTextField() {
        return this.catalog;
    }

    public Vector getList() {
        return this.v;
    }

    public void resetList() {
        if (this.mode == 1) {
            this.colIdx = -1;
            this.getTableHeader().repaint();
        }
        this.clearSelection();
        this.selectedCats = null;
        ((AbstractTableModel)this.getModel()).fireTableRowsUpdated(0, this.vCats.size() - 1);
    }

    protected void preSelection(Vector v) {
        this.v = v;
        this.vCats = this.createObjectsFromRows(v);
        this.selectedCats = null;
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
    }

    public void setReadMeButton(JButton getReadMe) {
        this.getReadMe = getReadMe;
    }

    public void setCatalogTextField(JTextField catalog) {
        this.catalog = catalog;
    }

    public JButton getReadMeButton() {
        return this.getReadMe;
    }

    private void sort(Vector data, boolean ascending, Comparator comp) {
        List<Object> l = Arrays.asList(data.toArray());
        Collections.sort(l, comp);
        if (!ascending) {
            Collections.reverse(l);
        }
        this.vCats = new Vector<Object>(l);
        ((AbstractTableModel)this.getModel()).fireTableRowsUpdated(0, this.vCats.size() - 1);
        this.getTableHeader().repaint();
    }

    private boolean isSelected(int row) {
        int[] selected = this.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            if (row != selected[i]) continue;
            return true;
        }
        return false;
    }

    private Vector getSelectedCats() {
        int[] idx = this.getSelectedRows();
        Vector v = new Vector();
        for (int i = 0; i < idx.length; ++i) {
            v.add(this.vCats.get(idx[i]));
        }
        return v;
    }

    class VizieRTableMouseListener
    extends MouseAdapter {
        VizieRTableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            super.mousePressed(me);
            int row = VizieRTable.this.rowAtPoint(me.getPoint());
            int col = VizieRTable.this.columnAtPoint(me.getPoint());
            if (col == 0) {
                VizieRCatalog clickedCat = (VizieRCatalog)VizieRTable.this.vCats.get(row);
                if (VizieRTable.this.selectedCats != null) {
                    for (int i = 0; i < VizieRTable.this.vCats.size(); ++i) {
                        VizieRCatalog vCat = (VizieRCatalog)VizieRTable.this.vCats.get(i);
                        if (!VizieRTable.this.selectedCats.contains(vCat)) continue;
                        if (vCat == clickedCat) {
                            VizieRTable.this.removeRowSelectionInterval(i, i);
                            continue;
                        }
                        VizieRTable.this.addRowSelectionInterval(i, i);
                    }
                }
            }
            VizieRTable.this.selectedCats = VizieRTable.this.getSelectedCats();
        }
    }

    class VizieRTableHeaderRenderer
    extends DefaultTableCellRenderer {
        TableCellRenderer renderer;

        public VizieRTableHeaderRenderer(TableCellRenderer defaultRenderer) {
            this.renderer = defaultRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel) {
                if (column == VizieRTable.this.colIdx) {
                    ImageIcon icon = VizieRTable.this.ascending ? Util.getAscSortIcon() : Util.getDescSortIcon();
                    ((JLabel)comp).setIcon(icon);
                    ((JLabel)comp).setHorizontalTextPosition(10);
                } else {
                    ((JLabel)comp).setIcon(null);
                }
            }
            return comp;
        }
    }

    class VizieRTableHeaderListener
    extends MouseAdapter {
        VizieRTableHeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = VizieRTable.this.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            final int column = VizieRTable.this.convertColumnIndexToModel(viewColumn);
            VizieRTable.this.colIdx = column;
            if (VizieRTable.this.mode == 1 && column == 0) {
                return;
            }
            if (e.getClickCount() == 1 && column != -1) {
                Comparator surveyComp = new Comparator(){

                    public final int compare(Object a, Object b) {
                        Object val2 = null;
                        Object val1 = null;
                        if (VizieRTable.this.mode == 0) {
                            switch (column) {
                                case 0: {
                                    val1 = ((VizieRCatalog)a).getName();
                                    val2 = ((VizieRCatalog)b).getName();
                                    break;
                                }
                                case 1: {
                                    val1 = ((VizieRCatalog)a).getDesc();
                                    val2 = ((VizieRCatalog)b).getDesc();
                                    break;
                                }
                                case 2: {
                                    val1 = new Integer(((VizieRCatalog)a).getNbKRow());
                                    val2 = new Integer(((VizieRCatalog)b).getNbKRow());
                                }
                            }
                        } else {
                            switch (column) {
                                case 1: {
                                    val1 = ((VizieRCatalog)a).getName();
                                    val2 = ((VizieRCatalog)b).getName();
                                    break;
                                }
                                case 2: {
                                    val1 = ((VizieRCatalog)a).getCategory();
                                    val2 = ((VizieRCatalog)b).getCategory();
                                    break;
                                }
                                case 3: {
                                    val1 = new Integer(((VizieRCatalog)a).getDensity());
                                    val2 = new Integer(((VizieRCatalog)b).getDensity());
                                    break;
                                }
                                case 4: {
                                    val1 = ((VizieRCatalog)a).getDesc();
                                    val2 = ((VizieRCatalog)b).getDesc();
                                }
                            }
                        }
                        return ((Comparable)val1).compareTo(val2);
                    }
                };
                final Vector selected = VizieRTable.this.getSelectedCats();
                VizieRTable.this.sort(VizieRTable.this.vCats, VizieRTable.this.ascending, surveyComp);
                VizieRTable.this.ascending = !VizieRTable.this.ascending;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VizieRTable.this.clearSelection();
                        for (int i = 0; i < VizieRTable.this.vCats.size(); ++i) {
                            VizieRCatalog cat = (VizieRCatalog)VizieRTable.this.vCats.get(i);
                            if (!selected.contains(cat)) continue;
                            VizieRTable.this.addRowSelectionInterval(i, i);
                        }
                    }
                });
            }
        }
    }

    class VizieRTableModel
    extends AbstractTableModel {
        VizieRTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            if (VizieRTable.this.mode == 0) {
                switch (col) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Description";
                    }
                    case 2: {
                        return "Nb of KRows";
                    }
                }
                return "";
            }
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Category";
                }
                case 3: {
                    return "Density";
                }
                case 4: {
                    return "Description";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return VizieRTable.this.vCats == null ? 0 : VizieRTable.this.vCats.size();
        }

        @Override
        public int getColumnCount() {
            return VizieRTable.this.mode == 0 ? 3 : 5;
        }

        public Class getColumnClass(int column) {
            if (VizieRTable.this.mode == 1 && column == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (VizieRTable.this.mode == 0) {
                switch (col) {
                    case 0: {
                        return ((VizieRCatalog)VizieRTable.this.vCats.get(row)).getName();
                    }
                    case 1: {
                        return ((VizieRCatalog)VizieRTable.this.vCats.get(row)).getDesc();
                    }
                    case 2: {
                        return new Integer(((VizieRCatalog)VizieRTable.this.vCats.get(row)).getNbKRow());
                    }
                }
                return "";
            }
            switch (col) {
                case 0: {
                    return VizieRTable.this.isSelected(row) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 1: {
                    return ((VizieRCatalog)VizieRTable.this.vCats.get(row)).getName();
                }
                case 2: {
                    return ((VizieRCatalog)VizieRTable.this.vCats.get(row)).getCategory();
                }
                case 3: {
                    return new Integer(((VizieRCatalog)VizieRTable.this.vCats.get(row)).getDensity());
                }
                case 4: {
                    return ((VizieRCatalog)VizieRTable.this.vCats.get(row)).getDesc();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return VizieRTable.this.mode == 1 && col == 0;
        }
    }

    class VizieRTableSelectionListener
    implements ListSelectionListener {
        VizieRTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int i;
            String s = "";
            int[] idx = VizieRTable.this.getSelectedRows();
            VizieRCatalog[] cats = new VizieRCatalog[idx.length];
            for (i = 0; i < idx.length; ++i) {
                cats[i] = (VizieRCatalog)VizieRTable.this.vCats.get(idx[i]);
            }
            for (i = 0; i < cats.length; ++i) {
                String id = cats[i].getName();
                s = !s.equals("") ? s + "," + id : id;
            }
            if (VizieRTable.this.catalog != null) {
                VizieRTable.this.catalog.setText(s);
            }
            if (VizieRTable.this.getReadMe != null) {
                VizieRTable.this.getReadMe.setEnabled(i == 1);
            }
            if (VizieRTable.this.getMoc != null) {
                VizieRTable.this.getMoc.setEnabled(i == 1);
            }
        }
    }
}

