/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.pixtools;

import cds.aladin.Coord;
import cds.tools.pixtools.CDSHealpix;
import java.io.File;

public class Util {
    public static final int DIRSIZE = 10000;
    public static final String FS = cds.tools.Util.FS;
    public static final String CR = cds.tools.Util.CR;
    private static double twothird = 0.6666666666666666;
    static int[] HPX1024XY = new int[0x100001];

    public static Coord[] getCorners(int order, long npix) throws Exception {
        return Util.getCorners(null, order, npix);
    }

    public static Coord[] getCorners(Coord[] corners, int order, long npix) throws Exception {
        long nside = CDSHealpix.pow2(order);
        double[][] x = CDSHealpix.corners(nside, npix);
        if (corners == null) {
            corners = new Coord[4];
        }
        for (int i = 0; i < 4; ++i) {
            corners[i] = new Coord(x[i][0], x[i][1]);
        }
        return corners;
    }

    public static String getFilePath(String survey, int order, long npix) {
        return Util.getFilePath(survey, order, npix, 0);
    }

    public static String getFilePath(String survey, int order, long npix, int z) {
        String prefix = survey != null && survey.length() > 0 ? survey : "";
        String suffix = Util.getFilePath(order, npix, z);
        return cds.tools.Util.concatDir(prefix, suffix);
    }

    public static String getFilePath(int order, long npix) {
        return Util.getFilePath(order, npix, 0);
    }

    public static String getFilePath(int order, long npix, int z) {
        return "Norder" + order + "/" + "Dir" + npix / 10000L * 10000L + "/" + "Npix" + npix + (z <= 0 ? "" : "_" + z);
    }

    public static int getOrderFromPath(String filename) {
        int fromIndex = filename.indexOf("Norder");
        if (fromIndex == -1) {
            return -1;
        }
        int order = Integer.parseInt(filename.substring(fromIndex + 6, filename.indexOf(FS, fromIndex)));
        return order;
    }

    public static long getNpixFromPath(String filename) {
        int fromIndex = filename.lastIndexOf("Npix");
        if (fromIndex < 0) {
            return -1L;
        }
        int lastIndex = filename.indexOf(95, fromIndex);
        if (lastIndex < 0) {
            lastIndex = filename.indexOf(46, fromIndex);
        }
        if (lastIndex < 0) {
            lastIndex = filename.length();
        }
        return Long.parseLong(filename.substring(fromIndex + 4, lastIndex));
    }

    public static long getNDirFromPath(String filename) {
        int fromIndex = filename.indexOf("Dir");
        long npix = Long.parseLong(filename.substring(fromIndex + 3, filename.indexOf(FS, fromIndex)));
        return npix;
    }

    public static int getMaxOrderByPath(String path) {
        int maxOrder = -1;
        File f = new File(path);
        File[] sf = f.listFiles();
        if (sf != null) {
            for (int i = 0; i < sf.length; ++i) {
                int n;
                String name;
                if (!sf[i].isDirectory() || !(name = sf[i].getName()).startsWith("Norder") || (n = Integer.parseInt(name.substring(6))) <= maxOrder) continue;
                maxOrder = n;
            }
        }
        return maxOrder;
    }

    public static int computeNFiles(File dir) {
        int sum = 0;
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                int n = Util.computeNFiles(new File(dir, children[i]));
                sum += n;
            }
        } else {
            ++sum;
        }
        return sum;
    }

    private static void fillUp(int[] npix, int nsize, int[] pos) {
        int i;
        int size = nsize * nsize;
        int[][] fils = new int[4][size / 4];
        int[] nb = new int[4];
        for (i = 0; i < size; ++i) {
            int dg = i % nsize < nsize / 2 ? 0 : 1;
            int bh = i < size / 2 ? 1 : 0;
            int quad = dg << 1 | bh;
            int j = pos == null ? i : pos[i];
            npix[j] = npix[j] << 2 | quad;
            int n = quad;
            int n2 = nb[n];
            nb[n] = n2 + 1;
            fils[quad][n2] = j;
        }
        if (size > 4) {
            for (i = 0; i < 4; ++i) {
                Util.fillUp(npix, nsize / 2, fils[i]);
            }
        }
    }

    public static int[] createHpx2xy(int order) {
        int[] xy2hpx = null;
        int[] hpx2xy = null;
        if (order == 0) {
            hpx2xy = new int[]{0};
            return hpx2xy;
        }
        int nsize = (int)CDSHealpix.pow2(order);
        xy2hpx = new int[nsize * nsize];
        hpx2xy = new int[nsize * nsize];
        Util.fillUp(xy2hpx, nsize, null);
        for (int i = 0; i < xy2hpx.length; ++i) {
            hpx2xy[xy2hpx[i]] = i;
        }
        return hpx2xy;
    }

    public static int[] createXy2Hpx(int order) {
        int[] xy2hpx = null;
        if (order == 0) {
            xy2hpx = new int[]{0};
            return xy2hpx;
        }
        int nsize = (int)CDSHealpix.pow2(order);
        xy2hpx = new int[nsize * nsize];
        Util.fillUp(xy2hpx, nsize, null);
        return xy2hpx;
    }

    public static int[] hpx2XY(int n) {
        int[] xy = new int[2];
        xy[1] = HPX1024XY[n + 1] / 1024;
        xy[0] = HPX1024XY[n + 1] - xy[1] * 1024;
        return xy;
    }

    public static int[] hpx2XY(long n, int MAX_LEVEL) {
        double limLo = 0.0;
        double limHi = Math.pow(2.0, MAX_LEVEL) * Math.pow(2.0, MAX_LEVEL);
        int[] partX = new int[MAX_LEVEL];
        int[] partY = new int[MAX_LEVEL];
        for (int level = MAX_LEVEL - 1; level >= 0; --level) {
            limHi = Math.pow(2.0, level + 1) * Math.pow(2.0, level + 1);
            if ((double)n <= limLo + (limHi - limLo) / 4.0) {
                partX[level] = 0;
                partY[level] = 0;
                continue;
            }
            if ((double)n <= limLo + (limHi - limLo) / 2.0) {
                partX[level] = 1;
                partY[level] = 0;
                n -= (long)Math.pow(4.0, level);
                continue;
            }
            if ((double)n <= limLo + 3.0 * (limHi - limLo) / 4.0) {
                partX[level] = 0;
                partY[level] = 1;
                n -= 2L * (long)Math.pow(4.0, level);
                continue;
            }
            if (!((double)n <= limHi)) continue;
            partX[level] = 1;
            partY[level] = 1;
            n -= 3L * (long)Math.pow(4.0, level);
        }
        int[] xy = new int[]{0, 0};
        for (int level = 0; level < MAX_LEVEL; ++level) {
            xy[0] = (int)((long)xy[0] + (long)partX[level] * (long)Math.pow(2.0, level));
            xy[1] = (int)((long)xy[1] + (long)partY[level] * (long)Math.pow(2.0, level));
        }
        return xy;
    }

    public static long XY2Hpx(int x, int y, int MAX_LEVEL) {
        double limLox = 0.0;
        double limHix = Math.pow(2.0, MAX_LEVEL);
        double limLoy = 0.0;
        double limHiy = Math.pow(2.0, MAX_LEVEL);
        int[] N = new int[MAX_LEVEL];
        for (int level = MAX_LEVEL - 1; level >= 0; --level) {
            double limidx = (limLox + limHix) / 2.0;
            double limidy = (limLoy + limHiy) / 2.0;
            if ((double)x < limidx && (double)y < limidy) {
                N[level] = 0;
                limHix = limidx;
                limHiy = limidy;
                continue;
            }
            if ((double)x >= limidx && (double)y < limidy) {
                N[level] = 1;
                limLox = limidx;
                limHiy = limidy;
                continue;
            }
            if ((double)x < limidx && (double)y >= limidy) {
                N[level] = 2;
                limLoy = limidy;
                limHix = limidx;
                continue;
            }
            if (!((double)x >= limidx) || !((double)y >= limidy)) continue;
            N[level] = 3;
            limLox = limidx;
            limLoy = limidy;
        }
        long n = 0L;
        for (int level = 0; level < MAX_LEVEL; ++level) {
            n += (long)N[level] * (long)Math.pow(4.0, level);
        }
        return n;
    }

    public static long RingNum(long nside, double z, boolean floor) {
        long iring = 0L;
        iring = floor ? (long)Math.floor((double)nside * (2.0 - 1.5 * z)) : (long)Math.ceil((double)nside * (2.0 - 1.5 * z));
        if (z > twothird && (iring = floor ? (long)Math.floor((double)nside * Math.sqrt(3.0 * (1.0 - z))) : (long)Math.ceil((double)nside * Math.sqrt(3.0 * (1.0 - z)))) == 0L) {
            iring = 1L;
        }
        if (z < -twothird) {
            iring = floor ? (long)Math.floor((double)nside * Math.sqrt(3.0 * (1.0 + z))) : (long)Math.ceil((double)nside * Math.sqrt(3.0 * (1.0 + z)));
            if (iring == 0L) {
                iring = 1L;
            }
            iring = 4L * nside - iring;
        }
        return iring;
    }

    public static final int nside(int order) {
        return 1 << order;
    }

    public static final int order(int nside) {
        int i = 0;
        while (nside >>> ++i > 0) {
        }
        return --i;
    }

    public static final long nbrPix(int nside) {
        return 12L * (long)nside * (long)nside;
    }

    public static final long idx(long idx, int orderFrom, int orderTo) {
        if (orderFrom < orderTo) {
            throw new IllegalArgumentException("'orderFrom' must be greatest than 'orderTo'!");
        }
        return idx >>> (orderFrom - orderTo << 1);
    }

    public static final int min(int idx, int orderFrom, int orderTo) {
        if (orderFrom > orderTo) {
            throw new IllegalArgumentException("'orderFrom' must be smaller than 'orderTo'!");
        }
        return idx << (orderTo - orderFrom << 1);
    }

    public static final int max(int idx, int orderFrom, int orderTo) {
        if (orderFrom > orderTo) {
            throw new IllegalArgumentException("'orderFrom' must be smaller than 'orderTo'!");
        }
        return (++idx << (orderTo - orderFrom << 1)) - 1;
    }
}

