/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.pixtools;

import cds.aladin.Coord;
import cds.aladin.HealpixKey;
import cds.aladin.Localisation;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.ViewSimple;
import cds.moc.MocCell;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Graphics;
import java.awt.Polygon;

public final class Hpix
extends MocCell {
    private static final int[] ORDRE = new int[]{0, 1, 3, 2};
    private int frame;
    private long ovIZ;
    private PointD[] viewCorners;
    private Coord[] corners;
    private int nNull;
    private boolean computeCorners;

    public Hpix(String s) throws Exception {
        int i = s.indexOf(47);
        this.init(Integer.parseInt(s.substring(0, i)), Long.parseLong(s.substring(i + 1)), 3);
    }

    public Hpix(int order, long npix) {
        this.init(order, npix, 3);
    }

    public Hpix(int order, long npix, int frame) {
        this.init(order, npix, frame);
    }

    public int getFrame() {
        return this.frame;
    }

    public Coord[] getCorners() {
        if (!this.computeCorners) {
            this.computeCorners();
        }
        return this.corners;
    }

    public void fill(Graphics g, ViewSimple v) {
        PointD[] b = this.getProjViewCorners(v);
        if (b == null) {
            return;
        }
        double maxSize = this.getMaxSize(v);
        Polygon pol = new Polygon();
        int d = -1;
        for (int i = 0; i < b.length; ++i) {
            int f = ORDRE[i];
            if (b[f] == null || d >= 0 && HealpixKey.dist(b, d, f) > maxSize * maxSize) continue;
            pol.addPoint((int)b[f].x, (int)b[f].y);
            d = f;
        }
        g.fillPolygon(pol);
    }

    public void draw(Graphics g, ViewSimple v, boolean border) {
        double dist;
        int f;
        int d;
        int i;
        PointD[] b = this.getProjViewCorners(v);
        if (b == null) {
            return;
        }
        boolean drawnOk = true;
        double min = Double.MAX_VALUE;
        for (i = 0; i < 4; ++i) {
            d = ORDRE[i == 0 ? 3 : i - 1];
            f = ORDRE[i];
            if (b[d] == null || b[f] == null) {
                drawnOk = false;
                continue;
            }
            dist = Math.sqrt(HealpixKey.dist(b, d, f));
            if (!(dist < min)) continue;
            min = dist;
        }
        if (min == Double.MAX_VALUE) {
            min = 0.0;
        }
        if (drawnOk) {
            for (i = 0; i < 4; ++i) {
                d = ORDRE[i == 0 ? 3 : i - 1];
                f = ORDRE[i];
                if (b[d] == null || b[f] == null) {
                    drawnOk = false;
                    continue;
                }
                dist = Math.sqrt(HealpixKey.dist(b, d, f));
                if (dist > 1.0 && min > 0.0 && dist > 6.0 * min) {
                    drawnOk = false;
                    continue;
                }
                if (!border) continue;
                g.drawLine((int)b[d].x, (int)b[d].y, (int)b[f].x, (int)b[f].y);
            }
        }
    }

    public double getDiag2(ViewSimple v) {
        PointD[] b = this.getProjViewCorners(v);
        if (b == null) {
            return 0.0;
        }
        if (b[0] == null || b[1] == null || b[2] == null || b[3] == null) {
            return 0.0;
        }
        double d0 = HealpixKey.dist(b, 3, 0);
        double d1 = HealpixKey.dist(b, 2, 1);
        return Math.max(d0, d1);
    }

    public PointD[] getProjViewCorners(ViewSimple v) {
        int i;
        long vIZ = v.getIZ();
        if (this.ovIZ == vIZ) {
            if (this.nNull > 1) {
                return null;
            }
            return this.viewCorners;
        }
        Projection proj = v.getProj();
        Coord[] corners = this.getCorners();
        if (proj == null || corners == null) {
            return null;
        }
        this.nNull = 0;
        if (this.viewCorners == null) {
            this.viewCorners = new PointD[corners.length];
        }
        for (i = 0; i < corners.length; ++i) {
            Coord c = corners[i];
            proj.getXY(c);
            if (Double.isNaN(c.x)) {
                ++this.nNull;
                if (this.nNull > 1) {
                    return null;
                }
                this.viewCorners[i] = null;
                continue;
            }
            if (this.viewCorners[i] == null) {
                this.viewCorners[i] = new PointD(c.x, c.y);
                continue;
            }
            this.viewCorners[i].x = c.x;
            this.viewCorners[i].y = c.y;
        }
        for (i = 0; i < corners.length; ++i) {
            if (this.viewCorners[i] == null) continue;
            v.getViewCoordDble(this.viewCorners[i], this.viewCorners[i].x, this.viewCorners[i].y);
        }
        this.ovIZ = vIZ;
        return this.viewCorners;
    }

    public boolean isOutView(ViewSimple v) {
        return this.isOutView(v, null);
    }

    public boolean isOutView(ViewSimple v, PointD[] b) {
        double maxY;
        double maxX;
        if (v.isAllSky()) {
            return false;
        }
        int w = v.getWidth();
        int h = v.getHeight();
        if (b == null) {
            b = this.getProjViewCorners(v);
        }
        if (b == null) {
            return true;
        }
        if (b[0] == null || b[1] == null || b[2] == null || b[3] == null) {
            return false;
        }
        double minX = maxX = b[0].x;
        double minY = maxY = b[0].y;
        for (int i = 1; i < 4; ++i) {
            if (b[i].x < minX) {
                minX = b[i].x;
            } else if (b[i].x > maxX) {
                maxX = b[i].x;
            }
            if (b[i].y < minY) {
                minY = b[i].y;
                continue;
            }
            if (!(b[i].y > maxY)) continue;
            maxY = b[i].y;
        }
        if (minX < 0.0 && maxX < 0.0 || minX >= (double)w && maxX >= (double)w) {
            return true;
        }
        return minY < 0.0 && maxY < 0.0 || minY >= (double)h && maxY >= (double)h;
    }

    @Override
    public String toString() {
        return this.order + "/" + this.npix + (this.computeCorners ? ": " + this.corners[0] + " / " + this.corners[1] + " / " + this.corners[2] + " / " + this.corners[3] : "");
    }

    private void init(int order, long npix, int frame) {
        this.order = order;
        this.npix = npix;
        this.frame = frame;
        this.computeCorners = false;
    }

    private void computeCorners() {
        try {
            long nside = CDSHealpix.pow2(this.order);
            double[][] x = CDSHealpix.corners(nside, this.npix);
            this.corners = new Coord[4];
            for (int i = 0; i < x.length; ++i) {
                this.corners[i] = new Coord(x[i][0], x[i][1]);
            }
            this.corners = this.computeCornersToICRS(this.corners);
            this.computeCorners = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Coord[] computeCornersToICRS(Coord[] corners) {
        if (this.frame == 0) {
            return corners;
        }
        for (int i = 0; i < 4; ++i) {
            corners[i] = Localisation.frameToFrame(corners[i], this.frame, 0);
        }
        return corners;
    }

    private double getMaxSize(ViewSimple v) {
        double maxSize = 200.0;
        if (!v.isAllSky()) {
            double pixRes = CDSHealpix.pixRes(CDSHealpix.pow2(this.order)) / 3600.0;
            double pixelViewSize = v.getPixelSize();
            maxSize = pixRes / pixelViewSize * 4.0;
        }
        return maxSize;
    }
}

