/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.pixtools;

import healpix.essentials.HealpixBase;
import healpix.essentials.Pointing;
import healpix.essentials.RangeSet;
import healpix.essentials.Scheme;
import healpix.essentials.Vec3;
import java.util.ArrayList;

public final class CDSHealpix {
    public static final int MAXORDER = 29;
    private static HealpixBase[] hpxBase = new HealpixBase[30];
    public static final double cPr = Math.PI / 180;
    private static final int[] A = new int[]{3, 2, 0, 1};

    public static HealpixBase getHealpixBase(int order) throws Exception {
        if (hpxBase[order] == null) {
            CDSHealpix.hpxBase[order] = new HealpixBase((int)CDSHealpix.pow2(order), Scheme.NESTED);
        }
        return hpxBase[order];
    }

    private static int init(long nside) throws Exception {
        int order = (int)CDSHealpix.log2(nside);
        if (hpxBase[order] != null) {
            return order;
        }
        CDSHealpix.hpxBase[order] = new HealpixBase((int)nside, Scheme.NESTED);
        return order;
    }

    public static double[] pix2ang_nest(long nside, long ipix) throws Exception {
        Pointing res = hpxBase[CDSHealpix.init(nside)].pix2ang(ipix);
        return new double[]{res.theta, res.phi};
    }

    public static long ang2pix_nest(long nside, double theta, double phi) throws Exception {
        return hpxBase[CDSHealpix.init(nside)].ang2pix(new Pointing(theta, phi));
    }

    public static long[] query_disc(long nside, double ra, double dec, double radius) throws Exception {
        return CDSHealpix.query_disc(nside, ra, dec, radius, true);
    }

    public static long[] query_disc(long nside, double ra, double dec, double radius, boolean inclusive) throws Exception {
        RangeSet list;
        int order = CDSHealpix.init(nside);
        RangeSet rangeSet = list = inclusive ? hpxBase[order].queryDiscInclusive(CDSHealpix.pointing(ra, dec), radius, 4) : hpxBase[order].queryDisc(CDSHealpix.pointing(ra, dec), radius);
        if (list == null) {
            return new long[0];
        }
        return list.toArray();
    }

    public static long[] query_polygon(long nside, ArrayList<double[]> cooList) throws Exception {
        int order = CDSHealpix.init(nside);
        Pointing[] vertex = new Pointing[cooList.size()];
        int i = 0;
        for (double[] coo : cooList) {
            vertex[i++] = CDSHealpix.pointing(coo[0], coo[1]);
        }
        RangeSet list = hpxBase[order].queryPolygonInclusive(vertex, 4);
        if (list == null) {
            return new long[0];
        }
        return list.toArray();
    }

    private static double dec(Pointing ptg) {
        return (1.5707963267948966 - ptg.theta) / (Math.PI / 180);
    }

    private static double ra(Pointing ptg) {
        return ptg.phi / (Math.PI / 180);
    }

    public static Pointing pointing(double ra, double dec) {
        return new Pointing(1.5707963267948966 - Math.PI / 180 * dec, ra * (Math.PI / 180));
    }

    public static double[][] corners(long nside, long npix) throws Exception {
        Vec3[] tvec = hpxBase[CDSHealpix.init(nside)].boundaries(npix, 1);
        double[][] corners = new double[tvec.length][2];
        for (int i = 0; i < tvec.length; ++i) {
            Pointing pt = new Pointing(tvec[i]);
            int j = A[i];
            corners[j][0] = CDSHealpix.ra(pt);
            corners[j][1] = CDSHealpix.dec(pt);
        }
        return corners;
    }

    public static double[][] borders(long nside, long npix, int step) throws Exception {
        Vec3[] tvec = hpxBase[CDSHealpix.init(nside)].boundaries(npix, step);
        double[][] borders = new double[tvec.length][2];
        for (int i = 0; i < tvec.length; ++i) {
            Pointing pt = new Pointing(tvec[i]);
            borders[i][0] = CDSHealpix.ra(pt);
            borders[i][1] = CDSHealpix.dec(pt);
        }
        return borders;
    }

    public static long[] neighbours(long nside, long npix) throws Exception {
        return hpxBase[CDSHealpix.init(nside)].neighbours(npix);
    }

    public static long nest2ring(long nside, long npix) throws Exception {
        return hpxBase[CDSHealpix.init(nside)].nest2ring(npix);
    }

    public static long ring2nest(long nside, long npix) throws Exception {
        return hpxBase[CDSHealpix.init(nside)].ring2nest(npix);
    }

    public static double pixRes(long nside) {
        double res = 0.0;
        double degrad = Math.toDegrees(1.0);
        double skyArea = Math.PI * 4 * degrad * degrad;
        double arcSecArea = skyArea * 3600.0 * 3600.0;
        long npixels = 12L * nside * nside;
        res = arcSecArea / (double)npixels;
        res = Math.sqrt(res);
        return res;
    }

    static long nsidepix2uniq(long nside, long npix) {
        return 4L * nside * nside + npix;
    }

    static long[] uniq2nsidepix(long uniq) {
        return CDSHealpix.uniq2nsidepix(uniq, null);
    }

    static long[] uniq2nsidepix(long uniq, long[] nsidepix) {
        if (nsidepix == null) {
            nsidepix = new long[2];
        }
        long order = CDSHealpix.log2(uniq / 4L) / 2L;
        nsidepix[0] = CDSHealpix.pow2(order);
        nsidepix[1] = uniq - 4L * nsidepix[0] * nsidepix[0];
        return nsidepix;
    }

    public static final long pow2(long order) {
        return 1L << (int)order;
    }

    public static final long log2(long nside) {
        int i = 0;
        while (nside >>> ++i > 0L) {
        }
        return --i;
    }

    public static double[] radecToPolar(double[] radec) {
        return CDSHealpix.radecToPolar(radec, new double[2]);
    }

    public static double[] radecToPolar(double[] radec, double[] polar) {
        polar[0] = 1.5707963267948966 - radec[1] / 180.0 * Math.PI;
        polar[1] = radec[0] / 180.0 * Math.PI;
        return polar;
    }

    public static double[] polarToRadec(double[] polar) {
        return CDSHealpix.polarToRadec(polar, new double[2]);
    }

    public static double[] polarToRadec(double[] polar, double[] radec) {
        radec[1] = (1.5707963267948966 - polar[0]) * 180.0 / Math.PI;
        radec[0] = polar[1] * 180.0 / Math.PI;
        return radec;
    }

    public static void main(String[] argv) {
        try {
            String survey = "int gal 35-80 flux";
            int order = 2;
            try {
                order = Integer.parseInt(argv[1]);
            }
            catch (Exception e) {
                // empty catch block
            }
            long nside = CDSHealpix.pow2(order);
            long size = 12L * nside * nside;
            double sideDeg = 1.1 * Math.sqrt(2.0) * CDSHealpix.pixRes(nside) / 3600.0;
            String skyview = "java XXX -Duser.language=en Float Survey=\"" + survey + "\" Projection=Sin Pixels=300 Sampler=NN Size=" + sideDeg;
            String batch = "-cp Skyview.jar skyview.executive.Batch Skyview-batch.txt";
            String jar = "-jar Skyview.jar";
            int pix = 0;
            while ((long)pix < size) {
                double[] polar = CDSHealpix.pix2ang_nest(nside, pix);
                double[] radec = CDSHealpix.polarToRadec(polar);
                if (pix == 0) {
                    String s1 = skyview.replace("XXX", jar);
                    String s2 = skyview.replace("XXX", batch);
                    System.out.println("Test:    " + s1 + " position=\"" + radec[0] + " " + radec[1] + "\" output=Test");
                    System.out.println("Command: " + s2 + "\n");
                }
                System.out.println("position=\"" + radec[0] + " " + radec[1] + "\" output=Img" + pix);
                ++pix;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

