/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import cds.aladin.Aladin;
import cds.aladin.Forme;
import cds.aladin.MyInputStream;
import cds.aladin.Tok;
import cds.image.EPSGraphics;
import cds.tools.Astrodate;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public final class Util {
    public static String CR = System.getProperty("line.separator");
    public static String FS = System.getProperty("file.separator");
    static DecimalFormat DF = new DecimalFormat();
    static final Color CEBOX;
    static final Color CIBOX;
    private static final Color[] CINT;
    private static final String DEFAULT_FILENAME = "-";
    private static String HEX;
    private static ImageIcon DESC_ICON;
    private static ImageIcon ASC_ICON;
    public static final String[] unites;
    private static String B64;

    public static MyInputStream openAnyStream(String urlOrFile) throws Exception {
        if (urlOrFile.startsWith("http:") || urlOrFile.startsWith("https:") || urlOrFile.startsWith("ftp:")) {
            return Util.openStream(urlOrFile);
        }
        FileInputStream f = new FileInputStream(urlOrFile);
        MyInputStream is = new MyInputStream(f);
        return is.startRead();
    }

    public static MyInputStream openStream(String u) throws Exception {
        return Util.openStream(new URL(u), true, 10000);
    }

    public static MyInputStream openStream(String u, boolean useCache, int timeOut) throws Exception {
        return Util.openStream(new URL(u), useCache, timeOut);
    }

    public static MyInputStream openStream(URL u) throws Exception {
        return Util.openStream(u, true, 10000);
    }

    public static MyInputStream openStream(URL u, boolean useCache, int timeOut) throws Exception {
        URLConnection conn = u.openConnection();
        if (!useCache) {
            conn.setUseCaches(false);
        }
        conn.setConnectTimeout(timeOut);
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)conn;
            http.setRequestProperty("http.agent", "Aladin/v8.155");
        }
        MyInputStream mis = new MyInputStream(Util.openConnectionCheckRedirects(conn));
        return mis.startRead();
    }

    private static InputStream openConnectionCheckRedirects(URLConnection conn) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
            }
            in = conn.getInputStream();
            redir = false;
            if (!(conn instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)conn).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            conn = target.openConnection();
            try {
                conn.setUseCaches(http.getUseCaches());
            }
            catch (Exception e) {
                // empty catch block
            }
            ++redirects;
        } while (redir);
        return in;
    }

    public static boolean matchMaskIgnoreCase(String mask, String word) {
        if (word == null || mask == null) {
            return false;
        }
        return Util.matchMask(Util.toUpper(mask), Util.toUpper(word));
    }

    public static boolean matchMask(String mask, String word) {
        if (word == null || mask == null) {
            return false;
        }
        mask = mask + '\u0000';
        word = word + '\u0000';
        int indiceA = 0;
        int indiceM = 0;
        String stringB = null;
        String stringC = null;
        while (mask.charAt(indiceM) != '\u0000' || word.charAt(indiceA) != '\u0000') {
            if (mask.charAt(indiceM) == '\\') {
                ++indiceM;
                continue;
            }
            if (mask.charAt(indiceM) == '*' && (indiceM == 0 || mask.charAt(indiceM - 1) != '\\')) {
                stringB = mask.substring(++indiceM);
                continue;
            }
            if (stringB != null && !stringB.equals(mask) && word.charAt(indiceA) == word.charAt(0)) {
                stringC = word.substring(indiceA);
            }
            if (mask.charAt(indiceM) == word.charAt(indiceA) || mask.charAt(indiceM) == '?') {
                if (mask.charAt(indiceM) == '\u0000') {
                    if (stringB == null) {
                        return false;
                    }
                } else {
                    ++indiceM;
                }
                if (word.charAt(indiceA) == '\u0000') {
                    return false;
                }
                ++indiceA;
                continue;
            }
            if (stringB != null) {
                mask = stringB;
                indiceM = 0;
                if (stringC != null) {
                    word = stringC;
                    indiceA = 0;
                    stringC = null;
                    continue;
                }
                if (stringB.charAt(0) == word.charAt(indiceA) && word.charAt(indiceA) != '\\') continue;
                if (word.charAt(indiceA) == '\u0000') {
                    return false;
                }
                ++indiceA;
                continue;
            }
            return false;
        }
        return true;
    }

    public static String myRound(double x) {
        int posV;
        String s = x + "";
        int posE = s.indexOf(69);
        if (posE > 0 && (posV = s.indexOf(46)) > 0) {
            if (posV + 4 > posE) {
                return s;
            }
            return s.substring(0, posV + 4) + s.substring(posE);
        }
        double y = Math.abs(x);
        if (y > 1000.0) {
            DF.setMaximumFractionDigits(0);
        } else if (y > 100.0) {
            DF.setMaximumFractionDigits(1);
        } else if (y > 10.0) {
            DF.setMaximumFractionDigits(2);
        } else if (y > 1.0) {
            DF.setMaximumFractionDigits(3);
        } else if (y > 0.1) {
            DF.setMaximumFractionDigits(4);
        } else if (y > 0.01) {
            DF.setMaximumFractionDigits(5);
        } else {
            DF.setMaximumFractionDigits(6);
        }
        return DF.format(x);
    }

    public static String myRound(String x) {
        return Util.myRound(x, 0);
    }

    public static String myRound(String x, int p) {
        char[] a = x.toCharArray();
        char[] b = new char[a.length];
        int j = 0;
        int mode = 0;
        int len = x.indexOf(69);
        if (len < 0) {
            len = x.indexOf(101);
        }
        int n = len < 0 ? a.length : len;
        block6: for (int i = 0; i < n; ++i) {
            switch (mode) {
                case 0: {
                    if (a[i] == '.') {
                        if (p == 0) {
                            return new String(b, 0, j);
                        }
                        mode = 1;
                    }
                    b[j++] = a[i];
                    continue block6;
                }
                case 1: {
                    if (--p == 0) {
                        mode = 2;
                    }
                    if (i + 1 < a.length && Character.isDigit(a[i + 1]) && a[i + 1] >= '5') {
                        int n2 = j++;
                        int n3 = i;
                        char c = a[n3];
                        a[n3] = (char)(c + '\u0001');
                        b[n2] = c;
                        continue block6;
                    }
                    b[j++] = a[i];
                    continue block6;
                }
                case 2: {
                    if (Character.isDigit(a[i])) continue block6;
                    mode = 3;
                }
                case 3: {
                    b[j++] = a[i];
                }
            }
        }
        String s = new String(b, 0, j);
        if (len >= 0) {
            return s + x.substring(len);
        }
        return s;
    }

    public static String[] split(String s, String sep, char c1, char c2, boolean trim) {
        if (s == null) {
            return null;
        }
        char[] c = s.toCharArray();
        Vector<String> v = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        int nbC1 = 0;
        int nbC2 = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == c1) {
                ++nbC1;
            }
            if (c[i] == c2) {
                ++nbC2;
            }
            if (sep.indexOf(c[i]) >= 0 && nbC1 == nbC2) {
                if (sb.length() > 0) {
                    v.addElement(trim ? sb.toString().trim() : sb.toString());
                }
                sb = new StringBuffer();
                continue;
            }
            sb.append(c[i]);
        }
        if (sb.length() > 0) {
            v.addElement(trim ? sb.toString().trim() : sb.toString());
        }
        Object[] tokens = new String[v.size()];
        v.copyInto(tokens);
        v = null;
        return tokens;
    }

    public static int[] splitAsInt(String s, String sep) {
        String[] items = Util.split(s, sep, '@', '@');
        int[] ret = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            ret[i] = Integer.parseInt(items[i]);
        }
        return ret;
    }

    public static char[] splitAschar(String s, String sep) {
        String[] items = Util.split(s, sep, '@', '@');
        char[] ret = new char[items.length];
        for (int i = 0; i < items.length; ++i) {
            ret[i] = items[i].charAt(0);
        }
        return ret;
    }

    public static String[] split(String s, String sep) {
        return Util.split(s, sep, '@', '@');
    }

    public static String[] split(String s, String sep, char c1, char c2) {
        return Util.split(s, sep, c1, c2, false);
    }

    public static String join(String[] items, char c) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(items[i]);
        }
        return sb.toString();
    }

    public static String join(int[] items, char c) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            if (i != 0) {
                sb.append(c);
            }
            sb.append(items[i]);
        }
        return sb.toString();
    }

    public static String join(char[] items, char c) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            if (i != 0) {
                sb.append(c);
            }
            sb.append(items[i]);
        }
        return sb.toString();
    }

    public static String align(String key, int n) {
        return Util.align(key, n, "");
    }

    public static String align(String key, int n, String suffixe) {
        int i = key.length();
        if (i >= n) {
            return key + suffixe + " ";
        }
        StringBuffer s = new StringBuffer();
        for (int j = 0; j < n - i; ++j) {
            s.append(' ');
        }
        return key + suffixe + s;
    }

    public static String align3(int x) {
        if (x < 10) {
            return "00" + x;
        }
        if (x < 100) {
            return "0" + x;
        }
        return "" + x;
    }

    public static String align2(int x) {
        if (x < 10) {
            return "0" + x;
        }
        return "" + x;
    }

    public static double round(double d, int nbDec) {
        double fact = Math.pow(10.0, nbDec);
        return (double)Math.round(d * fact) / fact;
    }

    public static String fold(String s) {
        return Util.fold(s, 80, false);
    }

    public static String fold(String s, int limit) {
        return Util.fold(s, limit, false);
    }

    public static String fold(String s, int limit, boolean html) {
        if (s == null || s.trim().length() == 0) {
            return s;
        }
        char[] a = s.toCharArray();
        String NL = !html ? "\n" : "<BR>";
        StringBuffer res = new StringBuffer(a.length + 30);
        if (html) {
            res.append("<html>");
        }
        boolean debut = true;
        int i = 0;
        int k = 0;
        int marge = 0;
        while (i < a.length) {
            boolean space = Character.isSpaceChar(a[i]);
            if (debut) {
                if (space) {
                    ++marge;
                } else {
                    debut = false;
                }
            }
            if (a[i] == '\n') {
                k = 0;
                res.append(NL);
            } else {
                if (k > limit + 10 || k > limit && space) {
                    res.append(NL);
                    for (int j = 0; j < marge; ++j) {
                        res.append(' ');
                    }
                    k = 0;
                }
                if (k != 0 || !space) {
                    res.append(a[i]);
                }
            }
            ++i;
            ++k;
        }
        if (html) {
            res.append("</html>");
        }
        return res.toString();
    }

    public static byte[] getTableCM(ColorModel cm, int component) {
        byte[] tcm = new byte[256];
        for (int i = 0; i < tcm.length; ++i) {
            tcm[i] = (byte)(0xFF & (component == 0 ? cm.getRed(i) : (component == 1 ? cm.getGreen(i) : cm.getBlue(i))));
        }
        return tcm;
    }

    public static Color getReverseColor(Color c) {
        if (c == null) {
            return null;
        }
        return new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
    }

    public static void drawEdge(Graphics g, int w, int h) {
        Util.drawEdge(g, 0, 0, w, h);
    }

    public static void drawEdge(Graphics g, int x, int y, int w, int h) {
        g.setColor(CIBOX);
        g.drawLine(x, y, x + w - 1, y);
        g.drawLine(x, y, x, y + h - 1);
        g.setColor(Color.lightGray);
        g.drawLine(x + w - 1, y + h - 1, x, y + h - 1);
        g.drawLine(x + w - 1, y + h - 1, x + w - 1, y);
    }

    public static void drawCircle8(Graphics g, int x, int y) {
        if (!(g instanceof Graphics2D)) {
            g.drawOval(x - 4, y - 4, 8, 8);
            return;
        }
        g.drawLine(x - 3, y - 1, x - 3, y + 2);
        g.drawLine(x + 4, y - 1, x + 4, y + 2);
        g.drawLine(x - 1, y - 3, x + 2, y - 3);
        g.drawLine(x - 1, y + 4, x + 2, y + 4);
        g.drawLine(x - 2, y - 2, x - 2, y - 2);
        g.drawLine(x - 2, y + 3, x - 2, y + 3);
        g.drawLine(x + 3, y + 3, x + 3, y + 3);
        g.drawLine(x + 3, y - 2, x + 3, y - 2);
    }

    public static void fillCircle8(Graphics g, int x, int y) {
        if (!(g instanceof Graphics2D)) {
            g.drawOval(x - 4, y - 4, 8, 8);
            g.fillOval(x - 4, y - 4, 8, 8);
            return;
        }
        g.fillRect(x - 2, y - 2, 6, 6);
        Util.drawCircle8(g, x, y);
    }

    public static void drawCircle7(Graphics g, int x, int y) {
        if (!(g instanceof Graphics2D)) {
            g.drawOval(x - 3, y - 3, 6, 6);
            return;
        }
        g.drawLine(x - 3, y - 1, x - 3, y + 1);
        g.drawLine(x + 3, y - 1, x + 3, y + 1);
        g.drawLine(x - 1, y - 3, x + 1, y - 3);
        g.drawLine(x - 1, y + 3, x + 1, y + 3);
        g.drawLine(x - 2, y - 2, x - 2, y - 2);
        g.drawLine(x - 2, y + 2, x - 2, y + 2);
        g.drawLine(x + 2, y + 2, x + 2, y + 2);
        g.drawLine(x + 2, y - 2, x + 2, y - 2);
    }

    public static void fillCircle7(Graphics g, int x, int y) {
        if (!(g instanceof Graphics2D)) {
            g.fillOval(x - 3, y - 3, 6, 6);
            g.drawOval(x - 3, y - 3, 6, 6);
            return;
        }
        g.fillRect(x - 2, y - 2, 5, 5);
        Util.drawCircle7(g, x, y);
    }

    public static void drawCircle5(Graphics g, int x, int y) {
        if (!(g instanceof Graphics2D)) {
            g.drawOval(x - 2, y - 2, 4, 4);
            return;
        }
        g.drawLine(x - 2, y - 1, x - 2, y + 1);
        g.drawLine(x + 2, y - 1, x + 2, y + 1);
        g.drawLine(x - 1, y - 2, x + 1, y - 2);
        g.drawLine(x - 1, y + 2, x + 1, y + 2);
    }

    public static void fillCircle5(Graphics g, int x, int y) {
        if (!(g instanceof Graphics2D)) {
            g.fillOval(x - 2, y - 2, 4, 4);
            g.drawOval(x - 2, y - 2, 4, 4);
            return;
        }
        g.fillRect(x - 1, y - 1, 3, 3);
        Util.drawCircle5(g, x, y);
    }

    public static void fillCircle2(Graphics g, int x, int y) {
        if (!(g instanceof Graphics2D)) {
            g.fillOval(x - 1, y - 1, 2, 2);
            g.drawOval(x - 1, y - 1, 2, 2);
            return;
        }
        g.drawLine(x, y - 1, x, y + 1);
        g.drawLine(x - 1, y, x + 1, y);
    }

    private static void drawFleche1(Graphics g, double x, double y, double x1, double y1, int L) {
        double theta;
        g.drawLine((int)x, (int)y, (int)x1, (int)y1);
        if (x != x1) {
            theta = Math.atan((y1 - y) / (x1 - x));
            if (x > x1) {
                theta += Math.PI;
            }
        } else {
            theta = y < y1 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double delta = 2.356194490192345;
        double dx1 = (double)L * Math.cos(theta + delta);
        double dy1 = (double)L * Math.sin(theta + delta);
        double dx2 = (double)L * Math.cos(theta - delta);
        double dy2 = (double)L * Math.sin(theta - delta);
        g.drawLine((int)(x1 + dx1), (int)(y1 + dy1), (int)x1, (int)y1);
        g.drawLine((int)x1, (int)y1, (int)(x1 + dx2), (int)(y1 + dy2));
    }

    public static void drawFlecheOutLine(Graphics g, double x, double y, double x1, double y1, int L, String s) {
        boolean fd2 = g instanceof Graphics2D;
        Graphics2D g2 = fd2 ? (Graphics2D)g : null;
        Object aliasing = null;
        Stroke st = null;
        Color c = g.getColor();
        if (fd2) {
            g.setColor(Color.black);
            aliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            st = g2.getStroke();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(new BasicStroke(2.4f, 1, 0));
            Util.drawFleche1(g, x, y, x1, y1, L);
            g2.setStroke(st);
            g.setColor(c);
        }
        Util.drawFleche1(g, x, y, x1, y1, L);
        if (s != null) {
            x1 = x1 < x ? (x1 -= 10.0) : (x1 += 2.0);
            y1 = y1 > y ? (y1 += 10.0) : (y1 -= 2.0);
            if (fd2) {
                Util.drawStringOutline(g, s, (int)x1, (int)y1, null, null);
            } else {
                g.drawString(s, (int)x1, (int)y1);
            }
        }
        if (fd2) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aliasing);
        }
    }

    public static void drawFleche(Graphics g, double x, double y, double x1, double y1, int L, String s) {
        Util.drawFleche1(g, x, y, x1, y1, L);
        if (s != null) {
            x1 = x1 < x ? (x1 -= 10.0) : (x1 += 2.0);
            y1 = y1 > y ? (y1 += 10.0) : (y1 -= 2.0);
            g.drawString(s, (int)x1, (int)y1);
        }
    }

    public static void drawFillOval(Graphics gr, int x, int y, int w, int h, float transparency, Color bg) {
        if (bg != null) {
            gr.setColor(bg);
        }
        try {
            Graphics2D g = (Graphics2D)gr;
            Composite saveComposite = g.getComposite();
            g.setComposite(Util.getImageComposite(transparency));
            g.fillOval(x, y, w, h);
            g.setComposite(saveComposite);
        }
        catch (Exception e) {
            // empty catch block
        }
        gr.drawOval(x, y, w, h);
    }

    public static void drawFillPolygon(Graphics gr, Polygon pol, float transparency, Color bg) {
        if (bg != null) {
            gr.setColor(bg);
        }
        try {
            Graphics2D g = (Graphics2D)gr;
            Composite saveComposite = g.getComposite();
            g.setComposite(Util.getImageComposite(transparency));
            g.fillPolygon(pol);
            g.setComposite(saveComposite);
        }
        catch (Exception e) {
            // empty catch block
        }
        gr.drawPolygon(pol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawStringOutline(Graphics g, String s, int x, int y, Color c, Color cOutLine) {
        if (c == null) {
            c = g.getColor();
        }
        if (cOutLine == null) {
            cOutLine = Color.black;
        }
        if (!(g instanceof Graphics2D)) {
            g.drawString(s, x, y);
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Color cb = g2.getColor();
        Object aliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform t = g2.getTransform();
        try {
            Font f = g2.getFont();
            FontMetrics fm = g2.getFontMetrics(f);
            GlyphVector v = f.createGlyphVector(fm.getFontRenderContext(), s);
            Shape s1 = v.getOutline();
            g2.translate(x, y);
            Stroke st = g2.getStroke();
            g2.setStroke(new BasicStroke(1.6f, 2, 2));
            g.setColor(cOutLine);
            g2.draw(s1);
            g2.setStroke(st);
            g2.setColor(c);
            g2.fill(s1);
        }
        finally {
            g2.setTransform(t);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aliasing);
        g2.setColor(cb);
    }

    public static void drawCartouche(Graphics gr, int x, int y, int w, int h, float transparency, Color fg, Color bg) {
        Color c;
        block6: {
            if (h % 2 == 1) {
                --h;
            }
            c = gr.getColor();
            try {
                Graphics2D g = (Graphics2D)gr;
                Composite saveComposite = g.getComposite();
                Composite myComposite = Util.getImageComposite(transparency);
                g.setComposite(myComposite);
                if (bg != null) {
                    g.setColor(bg);
                    g.fillRect(x, y, w, h);
                    g.fillArc(x - h / 2, y, h, h, 90, 180);
                    g.fillArc(x + w - h / 2, y, h, h, 90, -180);
                }
                if (fg != null) {
                    g.setColor(fg);
                    g.drawLine(x, y, x + w, y);
                    g.drawLine(x, y + h, x + w, y + h);
                    g.drawArc(x - h / 2, y, h, h, 90, 180);
                    g.drawArc(x + w - h / 2, y, h, h, 90, -180);
                }
                g.setComposite(saveComposite);
            }
            catch (Exception e) {
                if (bg != null) {
                    gr.setColor(bg);
                    gr.fillRect(x, y, w, h);
                    gr.fillArc(x - h / 2, y, h, h, 90, 180);
                    gr.fillArc(x + w - h / 2, y, h, h, 90, -180);
                }
                if (fg == null) break block6;
                gr.setColor(fg);
                gr.drawLine(x, y, x + w, y);
                gr.drawLine(x, y + h, x + w, y + h);
                gr.drawArc(x - h / 2, y, h, h, 90, 180);
                gr.drawArc(x + w - h / 2, y, h, h, 90, -180);
            }
        }
        gr.setColor(c);
    }

    public static void drawRoundRect(Graphics g, int x, int y, int w, int h, int r, Color ch, Color cb) {
        g.setColor(ch);
        g.drawLine(x + r, y, x + w - r, y);
        g.drawLine(x, y + r, x, y + h - r);
        g.drawArc(x, y, r * 2, r * 2, 90, 90);
        g.drawArc(x + w - r * 2, y, r * 2, r * 2, 90, -45);
        g.drawArc(x, y + h - r * 2, r * 2, r * 2, 180, 45);
        g.setColor(cb);
        g.drawLine(x + r, y + h, x + w - r, y + h);
        g.drawLine(x + w, y + r, x + w, y + h - r);
        g.drawArc(x + w - 2 * r, y + h - 2 * r, r * 2, r * 2, 270, 90);
        g.drawArc(x + w - r * 2, y, r * 2, r * 2, 45, -45);
        g.drawArc(x, y + h - r * 2, r * 2, r * 2, 225, 45);
    }

    public static void drawStar(Graphics g, int x, int y) {
        g.drawLine(x, y - 3, x, y - 2);
        g.drawLine(x - 1, y - 1, x + 1, y - 1);
        g.drawLine(x - 3, y, x + 3, y);
        g.drawLine(x - 2, y + 1, x + 2, y + 1);
        g.drawLine(x - 1, y + 2, x + 1, y + 2);
        g.drawLine(x - 2, y + 3, x - 2, y + 3);
        g.drawLine(x + 2, y + 3, x + 2, y + 3);
    }

    public static void drawRadio(Graphics g, int x, int y, Color colorBord, Color colorFond, Color colorCoche, boolean selected) {
        int w = CINT.length + 1;
        if (colorFond != null) {
            g.setColor(colorFond);
            g.fillRect(x + 1, y + 1, w, w);
        } else {
            for (int i = 0; i < CINT.length; ++i) {
                g.setColor(CINT[i]);
                g.drawLine(x + 1, y + 1 + i, x + CINT.length, y + 1 + i);
            }
        }
        g.setColor(colorBord);
        g.drawArc(x, y, w, w, 0, 360);
        if (selected) {
            g.setColor(colorCoche == null ? Color.black : colorCoche);
            g.fillArc(x + 2, y + 2, w - 4, w - 4, 0, 360);
        }
    }

    public static void drawCheckbox(Graphics g, int x, int y, Color colorBord, Color colorFond, Color colorCoche, boolean selected) {
        int i;
        int w = CINT.length + 1;
        g.setColor(colorBord);
        g.drawRect(x, y, w, w);
        if (colorFond != null) {
            g.setColor(colorFond);
            g.fillRect(x + 1, y + 1, w, w);
        } else {
            for (i = 0; i < CINT.length; ++i) {
                g.setColor(CINT[i]);
                g.drawLine(x + 1, y + 1 + i, x + CINT.length, y + 1 + i);
            }
        }
        if (selected) {
            g.setColor(colorCoche == null ? Color.black : colorCoche);
            g.fillRect(x + 3, y + 4, 2, 5);
            for (i = 0; i < 4; ++i) {
                g.drawLine(x + 5 + i, y + 6 - i, x + 5 + i, y + 7 - i);
            }
        }
    }

    public static void drawEllipse(Graphics g, double xCenter, double yCenter, double semiMA, double semiMI, double angle) {
        if (g instanceof EPSGraphics) {
            ((EPSGraphics)g).drawEllipse(xCenter, yCenter, semiMA, semiMI, angle);
        } else if (!(g instanceof Graphics2D)) {
            Util.drawEllipseOld(g, xCenter, yCenter, semiMA, semiMI, angle);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform saveTransform = g2d.getTransform();
            angle = angle * Math.PI / 180.0;
            g2d.rotate(angle, xCenter, yCenter);
            g2d.draw(new Ellipse2D.Double(xCenter - semiMA, yCenter - semiMI, semiMA * 2.0, semiMI * 2.0));
            g2d.setTransform(saveTransform);
        }
    }

    public static void fillEllipse(Graphics g, double xCenter, double yCenter, double semiMA, double semiMI, double angle) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform saveTransform = g2d.getTransform();
        angle = angle * Math.PI / 180.0;
        g2d.rotate(angle, xCenter, yCenter);
        g2d.fill(new Ellipse2D.Double(xCenter - semiMA, yCenter - semiMI, semiMA * 2.0, semiMI * 2.0));
        g2d.setTransform(saveTransform);
    }

    private static void drawEllipseOld(Graphics g, double xCenter, double yCenter, double semiMA, double semiMI, double angle) {
        int i;
        angle = angle * Math.PI / 180.0;
        int nbIt = 30;
        Point[] p = new Point[nbIt];
        for (i = 0; i < nbIt; ++i) {
            double curAngle = 2.0 * (double)i / (double)nbIt * Math.PI;
            double tmpX = semiMA * Math.cos(curAngle);
            double tmpY = semiMI * Math.sin(curAngle);
            double x = tmpX * Math.cos(angle) - tmpY * Math.sin(angle) + xCenter;
            double y = tmpX * Math.sin(angle) + tmpY * Math.cos(angle) + yCenter;
            p[i] = new Point((int)x, (int)y);
        }
        for (i = 0; i < nbIt - 1; ++i) {
            g.drawLine(p[i].x, p[i].y, p[i + 1].x, p[i + 1].y);
        }
        g.drawLine(p[nbIt - 1].x, p[nbIt - 1].y, p[0].x, p[0].y);
    }

    public static void toolTip(JComponent c, String s) {
        Util.toolTip(c, s, false);
    }

    public static void toolTip(JComponent c, String s, boolean fold) {
        if (fold) {
            s = Util.fold(s, 40, true);
        }
        String o = c.getToolTipText();
        if (s != null && s.length() == 0) {
            s = null;
        }
        if (o == s) {
            return;
        }
        if (o == null || s == null || !o.equals(s)) {
            c.setToolTipText(s);
        }
    }

    public static void setCloseShortcut(JFrame f, boolean dispose) {
        Util.setCloseShortcut(f, dispose, Aladin.aladin);
    }

    public static void setCloseShortcut(final JFrame f, final boolean dispose, final Aladin aladinInst) {
        if (aladinInst != null) {
            f.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (aladinInst.getCommand().robotMode) {
                        aladinInst.stopRobot(f);
                        return;
                    }
                    if (dispose) {
                        f.dispose();
                    } else {
                        f.setVisible(false);
                    }
                }
            }, KeyStroke.getKeyStroke(27, 0), 2);
        }
        f.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dispose) {
                    f.dispose();
                } else {
                    f.setVisible(false);
                }
            }
        }, KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 2);
    }

    public static void pause(int ms) {
        try {
            Thread.currentThread();
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int indexInArrayOf(Object o, Object[] array) {
        if (o == null || array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!o.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexInArrayOf(String s, String[] array) {
        return Util.indexInArrayOf(s, array, false);
    }

    public static int indexInArrayOf(String s, String[] array, boolean caseInsensitive) {
        if (s == null || array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if ((caseInsensitive || !s.equals(array[i])) && (!caseInsensitive || !s.equalsIgnoreCase(array[i]))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String s, String w) {
        return Util.indexOfIgnoreCase(s, w, 0);
    }

    public static int indexOfIgnoreCase(String s, String w, int offset) {
        s = Util.toUpper(s);
        w = Util.toUpper(w);
        return s.indexOf(w, offset);
    }

    public static String fillWithBlank(String s, int totLength) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = s.length(); i < totLength; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String slash(String s) {
        StringBuffer res = new StringBuffer();
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == '/') {
                res.append('\\');
            }
            res.append(a[i]);
        }
        return res.toString();
    }

    public static void resetString(StringBuffer s) {
        int n = s.length();
        if (n == 0) {
            return;
        }
        s.delete(0, n);
    }

    public static void resetString(StringBuilder s) {
        int n = s.length();
        if (n == 0) {
            return;
        }
        s.delete(0, n);
    }

    public static String getShortPath(String path, int width) {
        try {
            if (path.length() > width) {
                File f = new File(path);
                StringTokenizer st = new StringTokenizer(f.getCanonicalPath(), FS, true);
                StringBuffer s = new StringBuffer();
                width -= f.getName().length();
                String w = null;
                while (s.length() < width && st.hasMoreTokens()) {
                    w = st.nextToken();
                    s.append(w);
                }
                if (st.hasMoreTokens()) {
                    if (w != null && !w.equals(FS)) {
                        s.append(st.nextToken());
                    }
                    w = st.nextToken();
                    if (st.hasMoreElements()) {
                        s.append("..." + FS);
                    }
                    s.append(f.getName());
                }
                return s.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public static String concatDir(String path1, String path2) {
        return Util.concatDir(path1, path2, FS.charAt(0));
    }

    public static String concatDir(String path1, String path2, char FS) {
        StringBuffer s = new StringBuffer(100);
        char c = '\u0000';
        char FSS = FS == '/' ? (char)'\\' : '/';
        for (int i = 0; i < 2; ++i) {
            if (c != FS && s.length() > 0) {
                s.append(FS);
            }
            String path = i == 0 ? path1 : path2;
            path = path == null ? "" : path.trim();
            int n = path.length();
            for (int j = 0; j < n; ++j) {
                c = path.charAt(j);
                if (c == FSS) {
                    c = FS;
                }
                s.append(c);
            }
        }
        return s.toString();
    }

    public static String toUpper(String s) {
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = Character.toUpperCase(a[i]);
        }
        return new String(a);
    }

    public static String toLower(String s) {
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            a[i] = Character.toLowerCase(a[i]);
        }
        return new String(a);
    }

    public static String toUpLower(String s) {
        char[] a = s.toCharArray();
        boolean space = true;
        for (int i = 0; i < a.length; ++i) {
            a[i] = space ? Character.toUpperCase(a[i]) : Character.toLowerCase(a[i]);
            space = Character.isSpace(a[i]);
        }
        return new String(a);
    }

    public static JButton getHelpButton(final Component f, final String help) {
        JButton h = new JButton(new ImageIcon(Aladin.aladin.getImagette("Help.gif")));
        h.setMargin(new Insets(0, 0, 0, 0));
        h.setBorderPainted(false);
        h.setContentAreaFilled(false);
        if (help != null) {
            h.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Aladin.info(f, help);
                }
            });
        }
        return h;
    }

    public static boolean isUrlResponding(String url) {
        try {
            return Util.isUrlResponding(new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static boolean isUrlResponding(URL url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            int code = conn.getResponseCode();
            return code / 100 == 2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isJPEGColored(String file) throws Exception {
        RandomAccessFile f = null;
        byte[] buf = null;
        try {
            f = new RandomAccessFile(file, "r");
            buf = new byte[(int)f.length()];
            f.readFully(buf);
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
        return Util.isColoredImage(buf);
    }

    public static boolean isColoredImage(byte[] buf) throws Exception {
        JButton obs = new JButton();
        Image img = Toolkit.getDefaultToolkit().createImage(buf);
        boolean encore = true;
        while (encore) {
            try {
                MediaTracker mt = new MediaTracker(Aladin.aladin);
                mt.addImage(img, 0);
                mt.waitForID(0);
                encore = false;
            }
            catch (InterruptedException e) {}
        }
        int width = img.getWidth(obs);
        int height = img.getHeight(obs);
        if (width == -1) {
            throw new Exception("width = -1");
        }
        BufferedImage imgBuf = new BufferedImage(width, height, 2);
        Graphics g = imgBuf.getGraphics();
        g.drawImage(img, 0, 0, obs);
        g.finalize();
        g = null;
        int taille = width * height;
        int[] rgb = ((DataBufferInt)imgBuf.getRaster().getDataBuffer()).getData();
        imgBuf.flush();
        imgBuf = null;
        for (int i = 0; i < taille; ++i) {
            int p = rgb[i];
            int red = p >>> 16 & 0xFF;
            int green = p >>> 8 & 0xFF;
            int blue = p & 0xFF;
            if (red == green && green == blue) continue;
            return true;
        }
        return false;
    }

    public static long dirSize(File dir) {
        if (dir == null) {
            return 0L;
        }
        if (dir.isFile()) {
            return dir.length();
        }
        long length = 0L;
        File[] files = dir.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            File file = files[i];
            length += Util.dirSize(file);
        }
        return length;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Util.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteDir(File dir, String regex) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Util.deleteDir(new File(dir, children[i]), regex);
                if (success) continue;
                return false;
            }
        } else if (dir.getAbsolutePath().matches(regex)) {
            return dir.delete();
        }
        return true;
    }

    public static boolean touch(File file, boolean createIfNeeded) {
        if (file.exists()) {
            if (!file.setLastModified(System.currentTimeMillis())) {
                return false;
            }
        } else if (createIfNeeded) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public static void createPath(String filename) throws Exception {
        File f = new File(new File(filename).getParent());
        f.mkdirs();
        if (!f.exists()) {
            throw new Exception("Cannot create directory for " + filename);
        }
    }

    public static String dirBrowser(Component c, String currentDirectoryPath) {
        JFileChooser fd = new JFileChooser(currentDirectoryPath);
        fd.setAcceptAllFileFilterUsed(false);
        if (fd.showOpenDialog(c) == 0) {
            try {
                return Util.concatDir(fd.getCurrentDirectory().getAbsolutePath(), fd.getSelectedFile().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String dirBrowser(Frame parent, String title, String initDir, JTextField field) {
        FileDialog fd = new FileDialog(parent, title);
        if (initDir != null) {
            fd.setDirectory(initDir);
        }
        fd.setFile(DEFAULT_FILENAME);
        fd.setVisible(true);
        String dir = fd.getDirectory();
        String name = fd.getFile();
        boolean isDir = false;
        if (name != null && name.equals(DEFAULT_FILENAME)) {
            name = "";
            isDir = true;
        }
        String t = (dir == null ? "" : dir) + (name == null ? "" : name);
        if (field != null) {
            field.setText(t);
        }
        if (name != null && name.length() > 0 || isDir) {
            return t;
        }
        return null;
    }

    public static String hex(char c) {
        return Util.hex((int)c);
    }

    public static String hex(int b) {
        return "" + HEX.charAt(b / 16) + HEX.charAt(b % 16);
    }

    public static Composite getFootprintComposite(float opacityLevel) {
        return AlphaComposite.getInstance(3, opacityLevel);
    }

    public static Composite getImageComposite(float opacityLevel) {
        return AlphaComposite.getInstance(3, opacityLevel);
    }

    public static void drawArea(Aladin aladin, Graphics g, Rectangle rect, Color color) {
        Util.drawArea(aladin, g, rect.x, rect.y, rect.width, rect.height, color, 0.15f, true);
    }

    public static void drawArea(Aladin aladin, Graphics g, int x, int y, int width, int height, Color color, float transparency, boolean withBord) {
        Color c = g.getColor();
        g.setColor(color);
        if (g instanceof Graphics2D && aladin.configuration.isTransparent()) {
            Graphics2D g2d = (Graphics2D)g;
            Composite saveComposite = g2d.getComposite();
            Composite myComposite = Util.getImageComposite(transparency);
            g2d.setComposite(myComposite);
            g2d.fillRect(x, y, width, height);
            g2d.setComposite(saveComposite);
            int x1 = x + width;
            int y1 = y + height;
            if (withBord) {
                g2d.drawLine(x, y, x1, y);
                g2d.drawLine(x, y, x, y1);
                g2d.setColor(color);
                g2d.drawLine(x1, y1, x1, y);
                g2d.drawLine(x1, y1, x, y1);
            }
        } else if (withBord) {
            g.drawRect(x, y, width, height);
        }
        g.setColor(c);
    }

    public static ImageIcon getDescSortIcon() {
        if (DESC_ICON == null) {
            DESC_ICON = new ImageIcon(Aladin.aladin.getImagette("arrow_up.gif"));
        }
        return DESC_ICON;
    }

    public static ImageIcon getAscSortIcon() {
        if (ASC_ICON == null) {
            ASC_ICON = new ImageIcon(Aladin.aladin.getImagette("arrow_down.gif"));
        }
        return ASC_ICON;
    }

    public static void decreasePriority(Thread ref, Thread runme) {
        try {
            runme.setPriority(ref.getPriority() - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getDateFromMJD(String mjd) {
        try {
            String s = Astrodate.JDToDate(Astrodate.MJDToJD(Double.parseDouble(mjd)));
            int i = s.indexOf("T");
            return i > 0 ? s.substring(0, i) : s;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getTemps(long ms) {
        return Util.getTemps(ms, false);
    }

    public static String getTemps(long ms, boolean round) {
        StringBuffer s = new StringBuffer();
        if (ms > 86400000L) {
            long j = ms / 86400000L;
            ms -= j * 86400000L;
            s.append(j + "j");
        }
        if (ms > 3600000L) {
            long h = ms / 3600000L;
            ms -= h * 3600000L;
            if (s.length() > 0) {
                s.append(' ');
            }
            s.append(h + "h");
        }
        if (ms > 60000L) {
            long m = ms / 60000L;
            ms -= m * 60000L;
            if (s.length() > 0) {
                s.append(' ');
            }
            s.append(m + "m");
        }
        if (s.length() > 0) {
            s.append(' ');
        }
        s.append((round ? "" + ms / 1000L : "" + (double)ms / 1000.0) + "s");
        return s.toString();
    }

    public static final long getTime() {
        return Util.getTime(1);
    }

    public static final long getTime(int unit) {
        return unit == 1 ? System.currentTimeMillis() : (unit == 0 ? System.nanoTime() : System.currentTimeMillis() / 1000L);
    }

    public static final char getFitsType(String form) {
        int l = form.indexOf(40);
        if (l == -1) {
            l = form.length();
        }
        return form.charAt(l - 1);
    }

    public static final int binSizeOf(String form) throws Exception {
        try {
            int l = form.indexOf(40);
            if (l == -1) {
                l = form.length();
            }
            if (l == 1) {
                return Util.binSizeOf(form.charAt(0), 1);
            }
            if (l > 1 && form.charAt(l - 2) == 'P') {
                return 8;
            }
            int n = Integer.parseInt(form.substring(0, l - 1));
            return Util.binSizeOf(form.charAt(l - 1), n);
        }
        catch (Exception e) {
            System.err.println("Pb pour " + form);
            throw e;
        }
    }

    public static final int binSizeOf(char type, int n) {
        if (type == 'X') {
            return n / 8 + (n % 8 > 0 ? 1 : 0);
        }
        int sizeOf = type == 'L' ? 1 : (type == 'B' ? 1 : (type == 'I' ? 2 : (type == 'J' ? 4 : (type == 'A' ? 1 : (type == 'E' ? 4 : (type == 'D' ? 8 : (type == 'K' ? 8 : (type == 'C' ? 8 : (type == 'M' ? 16 : (type == 'P' ? 8 : 0))))))))));
        return sizeOf * n;
    }

    public static final String getUnitDisk(long val) {
        return Util.getUnitDisk(val, 2);
    }

    public static final String getUnitDisk(long val, int format) {
        int unit = 0;
        long rest = 0L;
        boolean neg = false;
        if (val < 0L) {
            neg = true;
            val = -val;
        }
        while (val >= 1024L && unit < unites.length - 1) {
            ++unit;
            long div = val / 1024L;
            rest = val % 1024L;
            val = div;
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(format);
        double x = (double)val + (double)rest / 1024.0;
        return (neg ? DEFAULT_FILENAME : "") + nf.format(x) + unites[unit];
    }

    public static ArrayList<File> getFiles(String path, String suffix) {
        File[] files;
        ArrayList<File> flist = new ArrayList<File>();
        for (File file : files = new File(path).listFiles()) {
            if (file.isDirectory()) {
                flist.addAll(Util.getFiles(file.getAbsolutePath(), suffix));
                continue;
            }
            if (!file.getName().endsWith(suffix)) continue;
            flist.add(file);
        }
        return flist;
    }

    public static boolean find(String path, String suffix) {
        File[] files;
        for (File file : files = new File(path).listFiles()) {
            if (file.isDirectory()) {
                return Util.find(file.getAbsolutePath(), suffix);
            }
            if (!file.getName().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static void httpsInit() {
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                System.out.println("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        catch (KeyManagementException kme) {
            kme.printStackTrace();
        }
    }

    public static final double tand(double x) {
        return Math.tan(x * (Math.PI / 180));
    }

    public static final double cosd(double x) {
        return Math.cos(x * (Math.PI / 180));
    }

    public static String createVOTable(List<Forme> formes) {
        StringBuffer sb = new StringBuffer().append("<?xml version=\"1.0\"?>\n").append("<VOTABLE version=\"1.2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n").append("xmlns=\"http://www.ivoa.net/xml/VOTable/v1.2\"\n").append("xmlns:stc=\"http://www.ivoa.net/xml/STC/v1.30\" >\n").append("<RESOURCE>\n").append("<TABLE>\n").append("<GROUP ID=\"J2000\" utype=\"stc:AstroCoords\">\n").append("  <PARAM datatype=\"char\" arraysize=\"*\" ucd=\"pos.frame\" name=\"cooframe\"\n").append("    utype=\"stc:AstroCoords.coord_system_id\" value=\"ICRS\" />\n").append("  <FIELDref ref=\"ra\"/>\n").append("  <FIELDref ref=\"dec\"/>\n").append("</GROUP>\n").append("<FIELD name=\"RA\" ID=\"ra\" ucd=\"pos.eq.ra;meta.main\" ref=\"J2000\"\n").append("  utype=\"stc:AstroCoords.Position2D.Value2.C1\"\n").append("  datatype=\"double\" unit=\"deg\" />\n").append("<FIELD name=\"Dec\" ID=\"dec\" ucd=\"pos.eq.dec;meta.main\" ref=\"J2000\"\n").append("  utype=\"stc:AstroCoords.Position2D.Value2.C2\"\n").append("  datatype=\"double\" unit=\"deg\" />\n").append("<DATA><TABLEDATA>\n");
        for (Forme forme : formes) {
            sb.append(String.format((Locale)null, "<TR><TD>%.5f</TD><TD>%.5f</TD></TR>\n", forme.o[0].getRa(), forme.o[0].getDec()));
        }
        sb.append("</TABLEDATA></DATA>\n").append("</TABLE>\n").append("</RESOURCE>\n").append("</VOTABLE>");
        return sb.toString();
    }

    public static String extractJSON(String key, String s) {
        String k = "\"" + key + "\"";
        int o1 = s.indexOf(key);
        if (o1 < 0) {
            return null;
        }
        int o2 = s.indexOf(34, o1 + k.length() + 1);
        if (o2 < 0) {
            return null;
        }
        return Tok.unQuote(new Tok(s.substring(o2), "},").nextToken());
    }

    public static String toB64(byte[] p) {
        StringBuffer res = new StringBuffer((int)((double)p.length * 1.25));
        char[] tab = B64.toCharArray();
        char[] b4 = new char[4];
        int nb = 0;
        int i = 0;
        while (i < p.length) {
            int c = p[i++] & 0xFF;
            int c3 = c << 16;
            b4[3] = 61;
            b4[2] = 61;
            if (i < p.length) {
                c = p[i++] & 0xFF;
                c3 |= c << 8;
                b4[2] = '\u0000';
                if (i < p.length) {
                    c = p[i++] & 0xFF;
                    c3 |= c;
                    b4[3] = '\u0000';
                }
            }
            if (b4[3] == '\u0000') {
                b4[3] = tab[c3 & 0x3F];
            }
            c3 >>= 6;
            if (b4[2] == '\u0000') {
                b4[2] = tab[c3 & 0x3F];
            }
            b4[1] = tab[(c3 >>= 6) & 0x3F];
            b4[0] = tab[(c3 >>= 6) & 0x3F];
            res.append(b4);
            if ((nb += 4) % 64 != 0) continue;
            res.append(CR + " ");
        }
        return res.toString();
    }

    static {
        DF.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        DF.setGroupingSize(0);
        CEBOX = new Color(172, 168, 153);
        CIBOX = new Color(113, 111, 100);
        CINT = new Color[]{new Color(232, 239, 246), new Color(243, 247, 250), new Color(255, 255, 255), new Color(243, 247, 251), new Color(232, 239, 247), new Color(221, 232, 243), new Color(215, 228, 241), new Color(210, 224, 239), new Color(205, 221, 237)};
        HEX = "0123456789ABCDEF";
        unites = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB"};
        B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    }
}

