/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

public class Astrodate {
    public static double JDToMJD(double JD) {
        return JD - 2400000.5;
    }

    public static double MJDToJD(double MJD) {
        return MJD + 2400000.5;
    }

    public static double dateToJD(double A, double M, double J, double HH, double MM, double SS) {
        long B;
        if (M < 3.0) {
            A -= 1.0;
            M += 12.0;
        }
        if (A > 1582.0 || A == 1582.0 && M > 10.0 || A == 1582.0 && M == 10.0 && J >= 15.0) {
            long C = (long)(A / 100.0);
            B = 2L - C + C / 4L;
        } else {
            B = 0L;
        }
        double T = HH / 24.0 + MM / 1440.0 + SS / 86400.0;
        return (double)((long)(365.25 * (A + 4716.0)) + (long)(30.6001 * (M + 1.0))) + J + T + (double)B - 1524.5;
    }

    public static String JDToDate(double JD) {
        long G;
        long Z = (long)(JD + 0.5);
        double F = JD + 0.5 - (double)Z;
        if (Z < 2299161L) {
            G = Z;
        } else {
            long a = (long)(((double)Z - 1867216.25) / 36524.25);
            G = Z + 1L + a - a / 4L;
        }
        long B = G + 1524L;
        long C = (long)(((double)B - 122.1) / 365.25);
        long D = (long)(365.25 * (double)C);
        long E = (long)((double)(B - D) / 30.6001);
        double j = (double)(B - D - (long)(30.6001 * (double)E)) + F;
        long J = (long)j;
        long M = (double)E < 13.5 ? E - 1L : E - 13L;
        long A = (double)M < 2.5 ? C - 4715L : C - 4716L;
        long s = (long)((j - (double)J) * 86400.0);
        long HH = s / 3600L;
        long MM = (s - HH * 3600L) / 60L;
        long SS = s - HH * 3600L - MM * 60L;
        return A + "-" + Astrodate.dd(M) + "-" + Astrodate.dd(J) + "T" + Astrodate.dd(HH) + ":" + Astrodate.dd(MM) + ":" + Astrodate.dd(SS);
    }

    private static String dd(long x) {
        return x < 10L ? "0" + x : "" + x;
    }

    public static double YdToJD(double Yd) {
        return 2451545.0 + (Yd - 2000.0) * 365.25;
    }

    public static double JDToYd(double JD) {
        return (JD - 2451545.0) / 365.25 + 2000.0;
    }
}

