/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.pull;

import cds.savot.common.Markups;
import cds.savot.model.SavotBinary;
import cds.savot.model.SavotCoosys;
import cds.savot.model.SavotData;
import cds.savot.model.SavotDefinitions;
import cds.savot.model.SavotField;
import cds.savot.model.SavotFieldRef;
import cds.savot.model.SavotFits;
import cds.savot.model.SavotGroup;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotLink;
import cds.savot.model.SavotMax;
import cds.savot.model.SavotMin;
import cds.savot.model.SavotOption;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotParamRef;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotStream;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotTableData;
import cds.savot.model.SavotVOTable;
import cds.savot.model.SavotValues;
import cds.savot.pull.SavotStatistics;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;

public class SavotPullEngine
implements Markups {
    public static int FULL = 0;
    public static int FULLREAD = 0;
    public static int SEQUENTIAL = 1;
    public static int RESOURCEREAD = 1;
    public static int ROWREAD = 2;
    private SavotVOTable currentVOTable = new SavotVOTable();
    private SavotResource currentResource = new SavotResource();
    private SavotTR currentTR = new SavotTR();
    private long rowCounter = 0L;
    private long resourceCounter = 0L;
    private long tableCounter = 0L;
    private long dataCounter = 0L;
    private boolean trace = false;
    Vector<String> father = new Vector();
    private Vector<SavotResource> resourcestack = new Vector();
    private Vector<SavotOption> optionstack = new Vector();
    private Vector<SavotGroup> groupstack = new Vector();
    String name = new String();
    String currentMarkup = "XML";
    boolean resourceComplete = false;
    boolean TRComplete = false;
    int includedResource = 0;
    int includedOption = 0;
    int includedGroup = 0;
    SavotTable currentTable = null;
    SavotField currentField = null;
    SavotFieldRef currentFieldRef = null;
    SavotGroup currentGroup = null;
    SavotParam currentParam = null;
    SavotParamRef currentParamRef = null;
    SavotData currentData = null;
    SavotValues currentValues = null;
    SavotTableData currentTableData = null;
    String currentDescription = null;
    SavotLink currentLink = null;
    SavotInfo currentInfo = null;
    SavotMin currentMin = null;
    SavotMax currentMax = null;
    SavotOption currentOption = null;
    SavotCoosys currentCoosys = null;
    SavotDefinitions currentDefinitions = null;
    SavotBinary currentBinary = null;
    SavotFits currentFits = null;
    SavotStream currentStream = null;
    SavotTD currentTD = null;
    SavotStatistics stats;
    public Hashtable idRefLinks = new Hashtable();
    protected XmlPullParser parser = null;

    public SavotPullEngine(XmlPullParser parser, String file, int mode, boolean debug, SavotStatistics stats) {
        try {
            this.parser = parser;
            this.stats = stats;
            this.enableDebug(debug);
            FileInputStream inStream = new FileInputStream(new File(file));
            BufferedInputStream dataBuffInStream = new BufferedInputStream(inStream);
            parser.setInput(dataBuffInStream, "UTF-8");
            if (mode == FULLREAD) {
                this.parse(parser, mode);
            }
        }
        catch (IOException e) {
            System.err.println("Exception SavotPullEngine : " + e);
        }
        catch (Exception f) {
            System.err.println("Exception SavotPullEngine : " + f);
        }
    }

    public SavotPullEngine(XmlPullParser parser, URL url, int mode, String enc, boolean debug, SavotStatistics stats) {
        try {
            this.parser = parser;
            this.stats = stats;
            this.enableDebug(debug);
            parser.setInput(new DataInputStream(url.openStream()), enc);
            if (mode == FULLREAD) {
                this.parse(parser, mode);
            }
        }
        catch (IOException e) {
            System.err.println("Exception SavotPullEngine : " + e);
        }
        catch (Exception f) {
            System.err.println("Exception SavotPullEngine : " + f);
        }
    }

    public SavotPullEngine(XmlPullParser parser, InputStream instream, int mode, String enc, boolean debug, SavotStatistics stats) {
        try {
            this.parser = parser;
            this.stats = stats;
            this.enableDebug(debug);
            BufferedInputStream dataBuffInStream = new BufferedInputStream(instream);
            parser.setInput(dataBuffInStream, enc);
            if (mode == FULLREAD) {
                this.parse(parser, mode);
            }
        }
        catch (IOException e) {
            System.err.println("Exception SavotPullEngine : " + e);
        }
        catch (Exception f) {
            System.err.println("Exception SavotPullEngine : " + f);
        }
    }

    public void reset() {
        this.currentVOTable = new SavotVOTable();
        this.currentResource = new SavotResource();
        this.rowCounter = 0L;
        this.resourceCounter = 0L;
        this.tableCounter = 0L;
        this.dataCounter = 0L;
        this.idRefLinks.clear();
        this.resourcestack.removeAllElements();
        this.optionstack.removeAllElements();
        this.groupstack.removeAllElements();
    }

    private void putResourceStack(SavotResource res) {
        this.resourcestack.addElement(res);
    }

    private void putOptionStack(SavotOption res) {
        this.optionstack.addElement(res);
    }

    private void putGroupStack(SavotGroup res) {
        this.groupstack.addElement(res);
    }

    private SavotResource getResourceStack() {
        SavotResource res = this.resourcestack.lastElement();
        this.resourcestack.removeElementAt(this.resourcestack.size() - 1);
        return res;
    }

    private SavotOption getOptionStack() {
        SavotOption res = this.optionstack.lastElement();
        this.optionstack.removeElementAt(this.optionstack.size() - 1);
        return res;
    }

    private SavotGroup getGroupStack() {
        SavotGroup res = this.groupstack.lastElement();
        this.groupstack.removeElementAt(this.groupstack.size() - 1);
        return res;
    }

    public int parse(XmlPullParser parser, int parsingType) throws IOException {
        block369: {
            if (parsingType != ROWREAD && parsingType != RESOURCEREAD) {
                this.name = new String();
                this.currentMarkup = "XML";
                this.resourceComplete = false;
                this.includedResource = 0;
                this.includedOption = 0;
                this.includedGroup = 0;
                this.currentTable = new SavotTable();
                this.currentField = new SavotField();
                this.currentFieldRef = new SavotFieldRef();
                this.currentGroup = new SavotGroup();
                this.currentParam = new SavotParam();
                this.currentParamRef = new SavotParamRef();
                this.currentData = new SavotData();
                this.currentValues = new SavotValues();
                this.currentTableData = new SavotTableData();
                this.currentDescription = new String();
                this.currentLink = new SavotLink();
                this.currentInfo = new SavotInfo();
                this.currentMin = new SavotMin();
                this.currentMax = new SavotMax();
                this.currentOption = new SavotOption();
                this.currentCoosys = new SavotCoosys();
                this.currentDefinitions = new SavotDefinitions();
                this.currentBinary = new SavotBinary();
                this.currentFits = new SavotFits();
                this.currentStream = new SavotStream();
            }
            this.TRComplete = false;
            this.currentTR = null;
            this.currentTD = new SavotTD();
            try {
                int eventType = parser.getEventType();
                while (eventType != 1) {
                    switch (eventType) {
                        case 2: {
                            try {
                                this.name = parser.getName();
                                if (this.trace) {
                                    System.err.println("Name ---> " + parser.getName());
                                }
                                if (this.name != null) {
                                    int i;
                                    if (this.name.equalsIgnoreCase("VOTABLE")) {
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("version") == 0) {
                                                this.currentVOTable.setVersion(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("xmlns:xsi") == 0) {
                                                this.currentVOTable.setXmlnsxsi(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("xsi:noNamespaceSchemaLocation") == 0) {
                                                this.currentVOTable.setXsinoschema(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("xsi:schemaLocation") == 0) {
                                                this.currentVOTable.setXsischema(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("xmlns") == 0) {
                                                this.currentVOTable.setXmlns(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("id") == 0) {
                                                this.currentVOTable.setId(parser.getAttributeValue(i));
                                                this.idRefLinks.put(parser.getAttributeValue(i), this.currentVOTable);
                                            }
                                            ++i;
                                        }
                                        if (this.trace) {
                                            System.err.println("VOTABLE begin");
                                        }
                                        this.currentMarkup = "VOTABLE";
                                    } else if (this.name.equalsIgnoreCase("DESCRIPTION")) {
                                        this.currentMarkup = "DESCRIPTION";
                                        if (this.trace) {
                                            System.err.println("DESCRIPTION begin");
                                        }
                                    } else if (this.name.equalsIgnoreCase("RESOURCE")) {
                                        this.stats.iResourcesInc();
                                        if (this.includedResource > 0) {
                                            this.putResourceStack(this.currentResource);
                                            if (this.trace) {
                                                System.err.println("RESOURCE - included");
                                            }
                                        } else if (this.trace) {
                                            System.err.println("RESOURCE - not included");
                                        }
                                        ++this.includedResource;
                                        if (this.trace) {
                                            System.err.println("RESOURCE begin");
                                        }
                                        this.currentMarkup = "RESOURCE";
                                        ++this.resourceCounter;
                                        if (parsingType == FULL || this.currentResource == null || parsingType == ROWREAD) {
                                            this.currentResource = new SavotResource();
                                        } else {
                                            this.currentResource.init();
                                        }
                                        this.currentResource.setType("");
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("name") == 0) {
                                                this.currentResource.setName(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("type") == 0) {
                                                this.currentResource.setType(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("utype") == 0) {
                                                this.currentResource.setUtype(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("id") == 0) {
                                                this.currentResource.setId(parser.getAttributeValue(i));
                                                if (parsingType == FULL) {
                                                    this.idRefLinks.put(parser.getAttributeValue(i), this.currentResource);
                                                }
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("TABLE")) {
                                        this.stats.iTablesGlobalInc();
                                        this.stats.iTablesLocalInc();
                                        this.currentTable = new SavotTable();
                                        this.currentMarkup = "TABLE";
                                        if (this.trace) {
                                            System.err.println("on passe dans Name ---> TABLE");
                                        }
                                        ++this.tableCounter;
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("name") == 0) {
                                                this.currentTable.setName(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("ucd") == 0) {
                                                this.currentTable.setUcd(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("utype") == 0) {
                                                this.currentTable.setUtype(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("ref") == 0) {
                                                this.currentTable.setRef(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("nrows") == 0) {
                                                this.currentTable.setNrows(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("id") == 0) {
                                                this.currentTable.setId(parser.getAttributeValue(i));
                                                if (parsingType == FULL) {
                                                    this.idRefLinks.put(parser.getAttributeValue(i), this.currentTable);
                                                    if (this.trace) {
                                                        System.err.println(parser.getAttributeValue(i));
                                                    }
                                                }
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("FIELD")) {
                                        this.currentField = new SavotField();
                                        this.currentMarkup = "FIELD";
                                        if (this.trace) {
                                            System.err.println("on passe dans Name ---> FIELD");
                                        }
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("unit") == 0) {
                                                this.currentField.setUnit(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("datatype") == 0) {
                                                this.currentField.setDataType(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("precision") == 0) {
                                                this.currentField.setPrecision(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("width") == 0) {
                                                this.currentField.setWidth(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("ref") == 0) {
                                                this.currentField.setRef(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("name") == 0) {
                                                this.currentField.setName(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("ucd") == 0) {
                                                this.currentField.setUcd(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("arraysize") == 0) {
                                                this.currentField.setArraySize(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("type") == 0) {
                                                this.currentField.setType(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("utype") == 0) {
                                                this.currentField.setUtype(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("id") == 0) {
                                                this.currentField.setId(parser.getAttributeValue(i));
                                                this.idRefLinks.put(parser.getAttributeValue(i), this.currentField);
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("FIELDref")) {
                                        this.currentFieldRef = new SavotFieldRef();
                                        this.currentMarkup = "FIELDref";
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("ref") == 0) {
                                                this.currentFieldRef.setRef(parser.getAttributeValue(i));
                                            }
                                            if (parser.getAttributeName(i).compareToIgnoreCase("ucd") == 0) {
                                                this.currentFieldRef.setUcd(parser.getAttributeValue(i));
                                            }
                                            if (parser.getAttributeName(i).compareToIgnoreCase("utype") == 0) {
                                                this.currentFieldRef.setUtype(parser.getAttributeValue(i));
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("VALUES")) {
                                        this.currentValues = new SavotValues();
                                        this.currentMarkup = "VALUES";
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("type") == 0) {
                                                this.currentValues.setType(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("null") == 0) {
                                                this.currentValues.setNull(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("invalid") == 0) {
                                                this.currentValues.setInvalid(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("ref") == 0) {
                                                this.currentValues.setRef(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("id") == 0) {
                                                this.currentValues.setId(parser.getAttributeValue(i));
                                                this.idRefLinks.put(parser.getAttributeValue(i), this.currentValues);
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("STREAM")) {
                                        this.currentStream = new SavotStream();
                                        this.currentMarkup = "STREAM";
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("type") == 0) {
                                                this.currentStream.setType(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("href") == 0) {
                                                this.currentStream.setHref(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("actuate") == 0) {
                                                this.currentStream.setActuate(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("encoding") == 0) {
                                                this.currentStream.setEncoding(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("expires") == 0) {
                                                this.currentStream.setExpires(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("rights") == 0) {
                                                this.currentStream.setRights(parser.getAttributeValue(i));
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("TR")) {
                                        if (this.trace) {
                                            System.err.println("TR begin");
                                        }
                                        this.currentMarkup = "TR";
                                        this.stats.iTDLocalReset();
                                        this.stats.iTDLocalInc();
                                        this.stats.iTDGlobalInc();
                                        this.currentTR = new SavotTR();
                                        this.currentTR.setLineInXMLFile(parser.getLineNumber());
                                    } else if (this.name.equalsIgnoreCase("TD")) {
                                        if (this.trace) {
                                            System.err.println("TD begin");
                                        }
                                        this.currentMarkup = "TD";
                                        this.currentTD = new SavotTD();
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("encoding") == 0) {
                                                this.currentTD.setEncoding(parser.getAttributeValue(i));
                                            }
                                            ++i;
                                        }
                                        ++this.dataCounter;
                                    } else if (this.name.equalsIgnoreCase("DATA")) {
                                        this.currentData = new SavotData();
                                        this.currentMarkup = "DATA";
                                    } else if (this.name.equalsIgnoreCase("BINARY")) {
                                        this.currentBinary = new SavotBinary();
                                        this.currentMarkup = "BINARY";
                                    } else if (this.name.equalsIgnoreCase("FITS")) {
                                        this.currentFits = new SavotFits();
                                        this.currentMarkup = "FITS";
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("ref") == 0) {
                                                this.currentFits.setExtnum(parser.getAttributeValue(i));
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("TABLEDATA")) {
                                        this.currentTableData = new SavotTableData();
                                        this.currentMarkup = "TABLEDATA";
                                        if (parsingType == ROWREAD) {
                                            if (this.stats.iTablesLocal > 1) {
                                                this.currentVOTable.getResources().removeItemAt(this.currentVOTable.getResources().getItemCount() - 1);
                                            }
                                            this.currentResource.getTables().addItem(this.currentTable);
                                            this.currentVOTable.getResources().addItem(this.currentResource);
                                        }
                                    } else if (this.name.equalsIgnoreCase("PARAM")) {
                                        this.currentParam = new SavotParam();
                                        this.currentMarkup = "PARAM";
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("unit") == 0) {
                                                this.currentParam.setUnit(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("datatype") == 0) {
                                                this.currentParam.setDataType(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("precision") == 0) {
                                                this.currentParam.setPrecision(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("width") == 0) {
                                                this.currentParam.setWidth(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("ref") == 0) {
                                                this.currentParam.setRef(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("name") == 0) {
                                                this.currentParam.setName(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("ucd") == 0) {
                                                this.currentParam.setUcd(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("utype") == 0) {
                                                this.currentParam.setUtype(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("value") == 0) {
                                                this.currentParam.setValue(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("xtype") == 0) {
                                                this.currentParam.setXtype(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("arraysize") == 0) {
                                                this.currentParam.setArraySize(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("xtype") == 0) {
                                                this.currentParam.setXtype(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("id") == 0) {
                                                this.currentParam.setId(parser.getAttributeValue(i));
                                                this.idRefLinks.put(parser.getAttributeValue(i), this.currentParam);
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("PARAMref")) {
                                        this.currentParamRef = new SavotParamRef();
                                        this.currentMarkup = "PARAMref";
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("ref") == 0) {
                                                this.currentParamRef.setRef(parser.getAttributeValue(i));
                                            }
                                            if (parser.getAttributeName(i).compareToIgnoreCase("ucd") == 0) {
                                                this.currentParamRef.setUcd(parser.getAttributeValue(i));
                                            }
                                            if (parser.getAttributeName(i).compareToIgnoreCase("utype") == 0) {
                                                this.currentParamRef.setUtype(parser.getAttributeValue(i));
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("LINK")) {
                                        this.currentLink = new SavotLink();
                                        this.currentMarkup = "LINK";
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("content-role") == 0) {
                                                this.currentLink.setContentRole(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("content-type") == 0) {
                                                this.currentLink.setContentType(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("title") == 0) {
                                                this.currentLink.setTitle(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("value") == 0) {
                                                this.currentLink.setValue(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("href") == 0) {
                                                this.currentLink.setHref(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("gref") == 0) {
                                                this.currentLink.setGref(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("action") == 0) {
                                                this.currentLink.setAction(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("id") == 0) {
                                                this.currentLink.setID(parser.getAttributeValue(i));
                                                this.idRefLinks.put(parser.getAttributeValue(i), this.currentLink);
                                            }
                                            ++i;
                                        }
                                        if (this.trace) {
                                            System.err.println("LINK");
                                        }
                                    } else if (this.name.equalsIgnoreCase("INFO")) {
                                        this.currentInfo = new SavotInfo();
                                        this.currentMarkup = "INFO";
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("name") == 0) {
                                                this.currentInfo.setName(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("value") == 0) {
                                                this.currentInfo.setValue(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("xtype") == 0) {
                                                this.currentInfo.setXtype(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("unit") == 0) {
                                                this.currentInfo.setUnit(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("ucd") == 0) {
                                                this.currentInfo.setUcd(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("utype") == 0) {
                                                this.currentInfo.setUtype(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("ref") == 0) {
                                                this.currentInfo.setRef(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("id") == 0) {
                                                this.currentInfo.setId(parser.getAttributeValue(i));
                                                this.idRefLinks.put(parser.getAttributeValue(i), this.currentInfo);
                                            }
                                            ++i;
                                        }
                                        if (this.trace) {
                                            System.err.println("INFO");
                                        }
                                    } else if (this.name.equalsIgnoreCase("min")) {
                                        if (this.trace) {
                                            System.err.println("MIN");
                                        }
                                        this.currentMarkup = "min";
                                        this.currentMin = new SavotMin();
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("value") == 0) {
                                                this.currentMin.setValue(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("inclusive") == 0) {
                                                this.currentMin.setInclusive(parser.getAttributeValue(i));
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("max")) {
                                        if (this.trace) {
                                            System.err.println("MAX");
                                        }
                                        this.currentMarkup = "max";
                                        this.currentMax = new SavotMax();
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("value") == 0) {
                                                this.currentMax.setValue(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("inclusive") == 0) {
                                                this.currentMax.setInclusive(parser.getAttributeValue(i));
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("OPTION")) {
                                        if (this.includedOption > 0) {
                                            this.putOptionStack(this.currentOption);
                                            if (this.trace) {
                                                System.err.println("OPTION - included");
                                            }
                                        } else if (this.trace) {
                                            System.err.println("OPTION - not included");
                                        }
                                        ++this.includedOption;
                                        this.currentMarkup = "OPTION";
                                        if (this.trace) {
                                            System.err.println("OPTION");
                                        }
                                        this.currentOption = new SavotOption();
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("name") == 0) {
                                                this.currentOption.setName(parser.getAttributeValue(i));
                                            }
                                            if (parser.getAttributeName(i).compareToIgnoreCase("value") == 0) {
                                                this.currentOption.setValue(parser.getAttributeValue(i));
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("GROUP")) {
                                        this.stats.iGroupsGlobalInc();
                                        if (this.includedGroup > 0) {
                                            this.putGroupStack(this.currentGroup);
                                            if (this.trace) {
                                                System.err.println("GROUP - included");
                                            }
                                        } else if (this.trace) {
                                            System.err.println("GROUP - not included");
                                        }
                                        ++this.includedGroup;
                                        this.currentMarkup = "GROUP";
                                        if (this.trace) {
                                            System.err.println("GROUP");
                                        }
                                        this.currentGroup = new SavotGroup();
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("ref") == 0) {
                                                this.currentGroup.setRef(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("name") == 0) {
                                                this.currentGroup.setName(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("ucd") == 0) {
                                                this.currentGroup.setUcd(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("utype") == 0) {
                                                this.currentGroup.setUtype(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("id") == 0) {
                                                this.currentGroup.setId(parser.getAttributeValue(i));
                                                this.idRefLinks.put(parser.getAttributeValue(i), this.currentGroup);
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("COOSYS")) {
                                        this.currentMarkup = "COOSYS";
                                        if (this.trace) {
                                            System.err.println("COOSYS");
                                        }
                                        this.currentCoosys = new SavotCoosys();
                                        int counter = parser.getAttributeCount();
                                        i = 0;
                                        while (i < counter) {
                                            if (parser.getAttributeName(i).compareToIgnoreCase("equinox") == 0) {
                                                this.currentCoosys.setEquinox(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("epoch") == 0) {
                                                this.currentCoosys.setEpoch(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("SYSTEM") == 0) {
                                                this.currentCoosys.setSystem(parser.getAttributeValue(i));
                                            } else if (parser.getAttributeName(i).compareToIgnoreCase("id") == 0) {
                                                this.currentCoosys.setId(parser.getAttributeValue(i));
                                                this.idRefLinks.put(parser.getAttributeValue(i), this.currentCoosys);
                                            }
                                            ++i;
                                        }
                                    } else if (this.name.equalsIgnoreCase("DEFINITIONS")) {
                                        this.currentMarkup = "DEFINITIONS";
                                        this.currentDefinitions = new SavotDefinitions();
                                        if (this.trace) {
                                            System.err.println("DEFINITIONS");
                                        }
                                    } else {
                                        System.err.println("VOTable markup error : " + this.name + " at line " + parser.getLineNumber());
                                    }
                                }
                                this.currentMarkup = this.name;
                            }
                            catch (Exception e) {
                                System.err.println("Exception START_TAG : " + e + " at line " + parser.getLineNumber());
                            }
                            break;
                        }
                        case 3: {
                            this.name = parser.getName();
                            try {
                                if (this.trace) {
                                    System.err.println("End ---> " + this.name);
                                }
                                if (this.name.equalsIgnoreCase("DESCRIPTION")) {
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("VOTABLE")) {
                                        this.currentVOTable.setDescription(this.currentDescription);
                                        this.currentMarkup = "";
                                        break;
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("RESOURCE")) {
                                        this.currentResource.setDescription(this.currentDescription);
                                        this.currentMarkup = "";
                                        break;
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("PARAM")) {
                                        this.currentParam.setDescription(this.currentDescription);
                                        this.currentMarkup = "";
                                        break;
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("TABLE")) {
                                        this.currentTable.setDescription(this.currentDescription);
                                        this.currentMarkup = "";
                                        break;
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("FIELD")) {
                                        this.currentField.setDescription(this.currentDescription);
                                        this.currentMarkup = "";
                                        break;
                                    }
                                    if (!this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("GROUP")) break;
                                    this.currentGroup.setDescription(this.currentDescription);
                                    this.currentMarkup = "";
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("TABLE")) {
                                    this.currentResource.getTables().addItem(this.currentTable);
                                    this.currentMarkup = "";
                                    if (!this.trace) break;
                                    System.err.println(this.currentTable.getName());
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("FIELD")) {
                                    if (this.trace) {
                                        System.err.println("FIELD from father = " + this.father.elementAt(this.father.size() - 1));
                                    }
                                    if (!this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("TABLE")) break;
                                    this.currentTable.getFields().addItem(this.currentField);
                                    if (!this.trace) break;
                                    System.err.println("FIELD from TABLE father = " + this.father);
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("FIELDref")) {
                                    if (!this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("GROUP")) break;
                                    this.currentGroup.getFieldsRef().addItem(this.currentFieldRef);
                                    if (!this.trace) break;
                                    System.err.println("FIELDRef from GROUP father = " + this.father);
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("TR")) {
                                    if (this.trace) {
                                        System.err.println("TR end");
                                    }
                                    this.currentMarkup = "";
                                    this.stats.iTRGlobalInc();
                                    this.stats.iTRLocalInc();
                                    this.stats.iTDLocalReset();
                                    if (parsingType != ROWREAD) {
                                        this.currentTableData.getTRs().addItem(this.currentTR);
                                    } else {
                                        this.TRComplete = true;
                                    }
                                    ++this.rowCounter;
                                    if (!this.trace) break;
                                    System.err.println("ADD row");
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("DATA")) {
                                    this.currentMarkup = "";
                                    this.currentTable.setData(this.currentData);
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("TD")) {
                                    this.stats.iTDGlobalInc();
                                    this.stats.iTDLocalInc();
                                    this.currentMarkup = "";
                                    if (this.trace) {
                                        System.err.println("TD end");
                                    }
                                    this.currentTR.getTDs().addItem(this.currentTD);
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("RESOURCE")) {
                                    if (this.trace) {
                                        System.err.println("RESOURCE end");
                                    }
                                    this.currentMarkup = "";
                                    if (this.includedResource > 1) {
                                        SavotResource tempo = this.currentResource;
                                        this.currentResource = this.getResourceStack();
                                        this.currentResource.getResources().addItem(tempo);
                                    } else {
                                        if (parsingType == FULL) {
                                            this.currentVOTable.getResources().addItem(this.currentResource);
                                        }
                                        if (this.trace) {
                                            System.err.println(">>>>>>>> RESOURCE COMPLETED");
                                        }
                                        this.resourceComplete = true;
                                    }
                                    --this.includedResource;
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("OPTION")) {
                                    if (this.trace) {
                                        System.err.println("OPTION end");
                                    }
                                    this.currentMarkup = "";
                                    if (this.includedOption > 1) {
                                        SavotOption tempo = this.currentOption;
                                        this.currentOption = this.getOptionStack();
                                        this.currentOption.getOptions().addItem(tempo);
                                        --this.includedOption;
                                        break;
                                    }
                                    if (parsingType != FULL || !this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("VALUES")) break;
                                    this.currentValues.getOptions().addItem(this.currentOption);
                                    if (this.trace) {
                                        System.err.println("OPTION from VALUES father = " + this.father);
                                    }
                                    --this.includedOption;
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("GROUP")) {
                                    if (this.trace) {
                                        System.err.println("GROUP end");
                                    }
                                    this.currentMarkup = "";
                                    if (this.includedGroup > 1) {
                                        SavotGroup tempo = this.currentGroup;
                                        this.currentGroup = this.getGroupStack();
                                        this.currentGroup.getGroups().addItem(tempo);
                                        --this.includedGroup;
                                        break;
                                    }
                                    if (parsingType != FULL && parsingType != ROWREAD || !this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("TABLE")) break;
                                    this.currentTable.getGroups().addItem(this.currentGroup);
                                    if (this.trace) {
                                        System.err.println("GROUP from TABLE father = " + this.father);
                                    }
                                    --this.includedGroup;
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("TABLEDATA")) {
                                    this.stats.iTRLocalReset();
                                    this.currentMarkup = "";
                                    this.currentData.setTableData(this.currentTableData);
                                    if (!this.trace) break;
                                    System.err.println(this.currentTable.getName());
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("COOSYS")) {
                                    this.currentMarkup = "";
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("DEFINITIONS")) {
                                        this.currentDefinitions.getCoosys().addItem(this.currentCoosys);
                                        if (!this.trace) break;
                                        System.err.println("COOSYS from DEFINITIONS father = " + this.father);
                                        break;
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("RESOURCE")) {
                                        this.currentResource.getCoosys().addItem(this.currentCoosys);
                                        if (!this.trace) break;
                                        System.err.println("COOSYS from RESOURCE father = " + this.father);
                                        break;
                                    }
                                    if (!this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("VOTABLE")) break;
                                    this.currentVOTable.getCoosys().addItem(this.currentCoosys);
                                    if (!this.trace) break;
                                    System.err.println("COOSYS from VOTABLE father = " + this.father);
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("PARAM")) {
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("DEFINITIONS")) {
                                        this.currentDefinitions.getParams().addItem(this.currentParam);
                                        if (!this.trace) break;
                                        System.err.println("PARAM from DEFINITIONS father = " + this.father);
                                        break;
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("RESOURCE")) {
                                        this.currentResource.getParams().addItem(this.currentParam);
                                        if (!this.trace) break;
                                        System.err.println("PARAM from RESOURCE father = " + this.father);
                                        break;
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("TABLE")) {
                                        this.currentTable.getParams().addItem(this.currentParam);
                                        if (!this.trace) break;
                                        System.err.println("PARAM from TABLE father = " + this.father);
                                        break;
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("GROUP")) {
                                        this.currentGroup.getParams().addItem(this.currentParam);
                                        if (!this.trace) break;
                                        System.err.println("PARAM from GROUP father = " + this.father);
                                        break;
                                    }
                                    if (!this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("VOTABLE")) break;
                                    this.currentVOTable.getParams().addItem(this.currentParam);
                                    if (!this.trace) break;
                                    System.err.println("PARAM from VOTABLE father = " + this.father);
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("PARAMref")) {
                                    if (!this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("GROUP")) break;
                                    this.currentGroup.getParamsRef().addItem(this.currentParamRef);
                                    if (!this.trace) break;
                                    System.err.println("PARAMRef from GROUP father = " + this.father);
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("LINK")) {
                                    this.currentMarkup = "";
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("RESOURCE")) {
                                        this.currentResource.getLinks().addItem(this.currentLink);
                                        if (!this.trace) break;
                                        System.err.println("LINK from RESOURCE father = " + this.father);
                                        break;
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("TABLE")) {
                                        this.currentTable.getLinks().addItem(this.currentLink);
                                        if (!this.trace) break;
                                        System.err.println("LINK from TABLE father = " + this.father);
                                        break;
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("FIELD")) {
                                        this.currentField.getLinks().addItem(this.currentLink);
                                        if (!this.trace) break;
                                        System.err.println("LINK from FIELD father = " + this.father);
                                        break;
                                    }
                                    if (!this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("PARAM")) break;
                                    this.currentParam.getLinks().addItem(this.currentLink);
                                    if (!this.trace) break;
                                    System.err.println("LINK from PARAM father = " + this.father);
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("VALUES")) {
                                    this.currentMarkup = "";
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("PARAM")) {
                                        this.currentParam.setValues(this.currentValues);
                                        if (!this.trace) break;
                                        System.err.println("VALUES from PARAM father = " + this.father + " ID : " + this.currentValues.getId());
                                        break;
                                    }
                                    if (!this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("FIELD")) break;
                                    this.currentField.setValues(this.currentValues);
                                    if (!this.trace) break;
                                    System.err.println("VALUES from FIELD father = " + this.father + " ID : " + this.currentValues.getId());
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("min")) {
                                    this.currentMarkup = "";
                                    this.currentValues.setMin(this.currentMin);
                                    if (!this.trace) break;
                                    System.err.println("MIN");
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("max")) {
                                    this.currentMarkup = "";
                                    this.currentValues.setMax(this.currentMax);
                                    if (!this.trace) break;
                                    System.err.println("MAX");
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("STREAM")) {
                                    this.currentMarkup = "";
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("BINARY")) {
                                        this.currentBinary.setStream(this.currentStream);
                                        if (!this.trace) break;
                                        System.err.println("STREAM from BINARY father = " + this.father);
                                        break;
                                    }
                                    if (!this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("FITS")) break;
                                    this.currentFits.setStream(this.currentStream);
                                    if (!this.trace) break;
                                    System.err.println("STREAM from FITS father = " + this.father);
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("BINARY")) {
                                    this.currentMarkup = "";
                                    this.currentData.setBinary(this.currentBinary);
                                    if (!this.trace) break;
                                    System.err.println("BINARY");
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("FITS")) {
                                    this.currentMarkup = "";
                                    this.currentData.setFits(this.currentFits);
                                    if (!this.trace) break;
                                    System.err.println("FITS");
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("INFO")) {
                                    this.currentMarkup = "";
                                    if (this.trace) {
                                        System.err.println("INFO father = " + this.father);
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("VOTABLE")) {
                                        if (this.currentVOTable.getResources() != null && this.currentVOTable.getResources().getItemCount() != 0) {
                                            this.currentVOTable.getInfosAtEnd().addItem(this.currentInfo);
                                            System.out.println("ds Infos at End");
                                        } else {
                                            this.currentVOTable.getInfos().addItem(this.currentInfo);
                                        }
                                        if (!this.trace) break;
                                        System.err.println("INFO from VOTABLE father = " + this.father);
                                        break;
                                    }
                                    if (this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("RESOURCE")) {
                                        if (this.currentResource.getResources() != null && this.currentResource.getResources().getItemCount() != 0 || this.currentResource.getTables() != null && this.currentResource.getTables().getItemCount() != 0 || this.currentResource.getLinks() != null && this.currentResource.getLinks().getItemCount() != 0) {
                                            this.currentResource.getInfosAtEnd().addItem(this.currentInfo);
                                        } else {
                                            this.currentResource.getInfos().addItem(this.currentInfo);
                                        }
                                        if (!this.trace) break;
                                        System.err.println("INFO from RESOURCE father = " + this.father);
                                        break;
                                    }
                                    if (!this.father.elementAt(this.father.size() - 1).equalsIgnoreCase("TABLE")) break;
                                    this.currentTable.getInfosAtEnd().addItem(this.currentInfo);
                                    if (!this.trace) break;
                                    System.err.println("INFO from TABLE father = " + this.father);
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("DEFINITIONS")) {
                                    this.currentMarkup = "";
                                    if (this.trace) {
                                        System.err.println("DEFINITIONS");
                                    }
                                    this.currentVOTable.setDefinitions(this.currentDefinitions);
                                    break;
                                }
                                if (this.name.equalsIgnoreCase("VOTABLE")) {
                                    this.currentMarkup = "";
                                    if (!this.trace) break;
                                    System.err.println("VOTABLE");
                                    break;
                                }
                                System.err.println("VOTable markup error : " + this.name + " at line " + parser.getLineNumber());
                            }
                            catch (Exception e) {
                                System.err.println("Exception FATHER : " + this.father + " END_TAG (" + this.name + ") : " + e + " at line " + parser.getLineNumber());
                            }
                            break;
                        }
                        case 1: {
                            try {
                                if (!this.trace) break;
                                System.err.println("Document end reached!");
                            }
                            catch (Exception e) {
                                System.err.println("Exception END_DOCUMENT : " + e + " at line " + parser.getLineNumber());
                            }
                            break;
                        }
                        case 4: {
                            try {
                                if (this.currentMarkup.equalsIgnoreCase("TD")) {
                                    if (this.trace) {
                                        System.err.println("TD : " + parser.getText().trim());
                                    }
                                    this.currentTD.setContent(parser.getText().trim());
                                    break;
                                }
                                if (this.currentMarkup.equalsIgnoreCase("STREAM")) {
                                    if (this.trace) {
                                        System.err.println("STREAM : " + parser.getText().trim());
                                    }
                                    this.currentStream.setContent(parser.getText().trim());
                                    break;
                                }
                                if (this.currentMarkup.equalsIgnoreCase("DESCRIPTION")) {
                                    if (this.trace) {
                                        System.err.println("DESCRIPTION : " + parser.getText().trim());
                                    }
                                    this.currentDescription = parser.getText().trim();
                                    break;
                                }
                                if (this.currentMarkup.equalsIgnoreCase("min")) {
                                    if (this.trace) {
                                        System.err.println("MIN : " + parser.getText().trim());
                                    }
                                    this.currentMin.setContent(parser.getText().trim());
                                    break;
                                }
                                if (this.currentMarkup.equalsIgnoreCase("max")) {
                                    if (this.trace) {
                                        System.err.println("MAX : " + parser.getText().trim());
                                    }
                                    this.currentMax.setContent(parser.getText().trim());
                                    break;
                                }
                                if (this.currentMarkup.equalsIgnoreCase("COOSYS")) {
                                    if (this.trace) {
                                        System.err.println("COOSYS : " + parser.getText().trim());
                                    }
                                    this.currentCoosys.setContent(parser.getText().trim());
                                    break;
                                }
                                if (this.currentMarkup.equalsIgnoreCase("LINK")) {
                                    if (this.trace) {
                                        System.err.println("LINK : " + parser.getText().trim());
                                    }
                                    this.currentLink.setContent(parser.getText().trim());
                                    break;
                                }
                                if (this.currentMarkup.equalsIgnoreCase("OPTION")) {
                                    if (!this.trace) break;
                                    System.err.println("OPTION : " + parser.getText().trim());
                                    break;
                                }
                                if (this.currentMarkup.equalsIgnoreCase("GROUP")) {
                                    if (!this.trace) break;
                                    System.err.println("GROUP : " + parser.getText().trim());
                                    break;
                                }
                                if (!this.currentMarkup.equalsIgnoreCase("INFO")) break;
                                this.currentInfo.setContent(parser.getText().trim());
                                if (!this.trace) break;
                                System.err.println("INFO : " + parser.getText().trim());
                            }
                            catch (Exception e) {
                                System.err.println("Exception TEXT : " + e + " at line " + parser.getLineNumber());
                            }
                            break;
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            if (!this.trace) break;
                            System.err.println(" ignoring some other (legacy) event at line : " + parser.getLineNumber());
                        }
                    }
                    eventType = parser.next();
                    if (parser.getEventType() == 2) {
                        if (this.trace) {
                            System.err.println("> FATHER, add : " + parser.getName());
                        }
                        this.father.addElement(parser.getName());
                    } else if (parser.getEventType() == 3) {
                        if (parser.getName() != null) {
                            if (this.trace) {
                                System.err.println("> FATHER, remove : " + parser.getName());
                            }
                            this.father.removeElementAt(this.father.size() - 1);
                        } else if (this.trace) {
                            System.err.println("> FATHER, case null");
                        }
                    }
                    if (parsingType == RESOURCEREAD && this.resourceComplete) {
                        eventType = 1;
                        if (this.trace) {
                            System.err.println(">>>>>>>>>>>>>>> RESOURCEREAD case : RESOURCE end");
                        }
                    }
                    if (parsingType != ROWREAD || !this.TRComplete) continue;
                    eventType = 1;
                    if (!this.trace) continue;
                    System.err.println(">>>>>>>>>>>>>>> ROWREAD case : TR end");
                }
            }
            catch (Exception f) {
                if (!this.trace) break block369;
                System.err.println("Exception parse : " + f + " at line " + parser.getLineNumber());
            }
        }
        return 0;
    }

    public SavotResource getNextResource() {
        block2: {
            this.currentResource = null;
            try {
                this.parse(this.parser, RESOURCEREAD);
            }
            catch (IOException e) {
                if (!this.trace) break block2;
                System.err.println("Exception getNextResource : " + e);
            }
        }
        return this.currentResource;
    }

    public SavotTR getNextTR() {
        block2: {
            this.currentTR = null;
            try {
                this.parse(this.parser, ROWREAD);
            }
            catch (IOException e) {
                if (!this.trace) break block2;
                System.err.println("Exception getNextTR : " + e);
            }
        }
        return this.currentTR;
    }

    public SavotVOTable getVOTable() {
        return this.currentVOTable;
    }

    public void sequentialTester() {
        do {
            this.currentResource = this.getNextResource();
        } while (this.currentResource != null);
    }

    public long getResourceCount() {
        return this.resourceCounter;
    }

    public long getTableCount() {
        return this.tableCounter;
    }

    public long getTRCount() {
        return this.rowCounter;
    }

    public long getDataCount() {
        return this.dataCounter;
    }

    public Hashtable getIdRefLinks() {
        return this.idRefLinks;
    }

    public SavotResource getResourceFromRef(String ref) {
        return (SavotResource)this.idRefLinks.get(ref);
    }

    public SavotField getFieldFromRef(String ref) {
        return (SavotField)this.idRefLinks.get(ref);
    }

    public SavotFieldRef getFieldRefFromRef(String ref) {
        return (SavotFieldRef)this.idRefLinks.get(ref);
    }

    public SavotParam getParamFromRef(String ref) {
        return (SavotParam)this.idRefLinks.get(ref);
    }

    public SavotParamRef getParamRefFromRef(String ref) {
        return (SavotParamRef)this.idRefLinks.get(ref);
    }

    public SavotTable getTableFromRef(String ref) {
        return (SavotTable)this.idRefLinks.get(ref);
    }

    public SavotGroup getGroupFromRef(String ref) {
        return (SavotGroup)this.idRefLinks.get(ref);
    }

    public SavotInfo getInfoFromRef(String ref) {
        return (SavotInfo)this.idRefLinks.get(ref);
    }

    public SavotValues getValuesFromRef(String ref) {
        return (SavotValues)this.idRefLinks.get(ref);
    }

    public SavotLink getLinkFromRef(String ref) {
        return (SavotLink)this.idRefLinks.get(ref);
    }

    public SavotCoosys getCoosysFromRef(String ref) {
        return (SavotCoosys)this.idRefLinks.get(ref);
    }

    public SavotVOTable getAllResources() {
        return this.currentVOTable;
    }

    public void enableDebug(boolean debug) {
        this.trace = debug;
    }
}

