/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EPSGraphics
extends Graphics {
    private PrintStream out;
    private Image preview;
    private String title;
    private int xmin;
    private int ymin;
    private int xmax;
    private int ymax;
    private int height;
    private int mode = 0;
    private int size;
    static final int STROKE = 0;
    static final int FILL = 1;
    static final int CLIP = 2;
    private Font font = new Font("Helvetica", 0, 10);
    private Color color = Color.black;
    private String HEX = "0123456789abcdef";

    public EPSGraphics(PrintStream out, String title, Image preview, int xmin, int ymin, int xmax, int ymax) {
        this.out = out;
        this.title = title;
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
        this.height = ymax - ymin;
        this.preview = preview;
        this.head();
    }

    public void end() {
        this.tail();
        this.out.flush();
    }

    private void flushIfRequired(int n) {
        this.size += n;
        if (this.size > 10000) {
            this.out.flush();
            this.size = 0;
        }
    }

    private void print(String s) {
        this.out.print(s);
        this.flushIfRequired(s.length());
    }

    private void print(char c) {
        this.out.print(c);
        this.flushIfRequired(1);
    }

    private void head() {
        String d = new SimpleDateFormat("dd/MM/yyyy HH:mm").format(new Date(System.currentTimeMillis()));
        this.print("%!PS-Adobe-3.0 EPSF-3.0\n%%BoundingBox: " + this.xmin + " " + this.ymin + " " + this.xmax + " " + this.ymax + "\n" + "%%Creator: Aladin [CDS]\n" + "%%Title: " + this.title + "\n" + "%%CreationDate: " + d + "\n" + "%%LanguageLevel: 2\n" + "%%EndComments\n");
        if (this.preview != null) {
            this.preview(this.preview);
        }
        this.print("0.5 setlinewidth\n0 setlinejoin\n/Helvetica findfont 10 scalefont setfont\n/l { newpath moveto lineto stroke } def\n/t { newpath moveto show } def\n");
        this.clipRect(this.xmin, this.ymin, this.xmax - this.xmin + 1, this.ymax - this.ymin + 1);
    }

    private void preview(Image img) {
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        int depth = 8;
        int lines = height * (width / 36 + (width % 36 != 0 ? 1 : 0));
        this.print("%%BeginPreview: " + width + " " + height + " " + depth + " " + lines + "\n");
        try {
            PixelGrabber pg = new PixelGrabber(img, 0, 0, width, height, true);
            pg.grabPixels();
            int[] pixel = (int[])pg.getPixels();
            for (int i = height - 1; i >= 0; --i) {
                this.writePixelsPreviewHexStr(pixel, i * width, width);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.print("%%EndPreview\n");
    }

    private void tail() {
        this.print("0 0 0 setrgbcolor\nnewpath\n" + this.xmin + " " + this.ymin + " moveto\n" + this.xmin + " " + this.ymax + " lineto\n" + this.xmax + " " + this.ymax + " lineto\n" + this.xmax + " " + this.ymin + " lineto\n" + "closepath\n" + "1 setlinewidth\n" + "stroke\n" + "showpage\n" + "%%EOF\n");
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.setColor(Color.white);
        this.fillRect(x, y, width, height);
        this.setColor(this.color);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.mode = 2;
        this.drawRect(x, y, width, height);
        this.mode = 0;
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public Graphics create() {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc1((double)x + (double)width / 2.0, (double)y + (double)height / 2.0, width, height, startAngle, arcAngle, 0.0);
    }

    public void drawEllipse(double xc, double yc, double semiMA, double semiMI, double rot) {
        this.drawArc1(xc, yc, semiMA * 2.0, semiMI * 2.0, 0.0, 360.0, rot);
    }

    private void drawArc1(double xc, double yc, double width, double height, double startAngle, double arcAngle, double rot) {
        double r = width / 2.0;
        double prop = height / width;
        startAngle += 180.0;
        rot = 180.0 - rot;
        yc = (double)this.height - yc;
        this.print("gsave\n" + xc + " " + yc + " translate\n");
        if (rot != 0.0) {
            this.print(rot + " rotate\n");
        }
        if (!Double.isNaN(prop) && prop != 1.0) {
            this.print("1 " + prop + " scale\n");
        }
        this.print("newpath\n0 0 " + r + " " + startAngle + " " + (arcAngle + startAngle) + " arc " + (this.mode == 1 ? "fill" : "stroke") + "\n" + "grestore\n");
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        try {
            int width = img.getWidth(observer);
            int height = img.getHeight(observer);
            int w = this.xmax - this.xmin + 1;
            int h = this.ymax - this.ymin + 1;
            if (width > w) {
                width = w;
            }
            if (height > h) {
                height = h;
            }
            PixelGrabber pg = new PixelGrabber(img, 0, 0, width, height, true);
            pg.grabPixels();
            int[] pixel = (int[])pg.getPixels();
            this.print("gsave\n" + width + " " + height + " scale\n" + x + " " + y + " translate\n" + width + " " + height + " 8 [" + width + " 0 0 " + height + " 0 0]\n" + "{ currentfile " + 3 * width + " string readhexstring pop } bind\n" + "false 3 colorimage\n");
            for (int i = height - 1; i >= 0; --i) {
                this.writePixelsHexStr(pixel, i * width, width);
            }
            this.print("grestore\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return false;
    }

    private void writePixelsHexStr(int[] pix, int offset, int width) {
        for (int i = 0; i < width; ++i) {
            if (i > 0 && i % 24 == 0) {
                this.out.println();
            }
            int r = pix[offset + i] >> 16 & 0xFF;
            int g = pix[offset + i] >> 8 & 0xFF;
            int b = pix[offset + i] & 0xFF;
            this.print(this.HEX.charAt(r / 16));
            this.print(this.HEX.charAt(r % 16));
            this.print(this.HEX.charAt(g / 16));
            this.print(this.HEX.charAt(g % 16));
            this.print(this.HEX.charAt(b / 16));
            this.print(this.HEX.charAt(b % 16));
        }
        if (width % 72 != 0) {
            this.out.println();
        }
    }

    private void writePixelsPreviewHexStr(int[] pix, int offset, int width) {
        this.print('%');
        for (int i = 0; i < width; ++i) {
            if (i > 0 && i % 36 == 0 && i != width - 1) {
                this.print("\n%");
            }
            int r = pix[offset + i] >> 16 & 0xFF;
            int g = pix[offset + i] >> 8 & 0xFF;
            int b = pix[offset + i] & 0xFF;
            r = (r + g + b) / 3;
            this.print(this.HEX.charAt(r / 16));
            this.print(this.HEX.charAt(r % 16));
        }
        this.out.println();
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.print(x1 + " " + (this.height - y1 - 1) + " " + x2 + " " + (this.height - y2 - 1) + " l\n");
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.drawArc(x, y, width, height, 0, 360);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.drawPolygon(xPoints, yPoints, nPoints, false);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.drawPolygon(xPoints, yPoints, nPoints, true);
    }

    private void drawPolygon(int[] xPoints, int[] yPoints, int nPoints, boolean close) {
        this.print("newpath\n");
        for (int i = 0; i < nPoints; ++i) {
            if (i == 0) {
                this.print(xPoints[i] + " " + (this.height - yPoints[i] - 1) + " moveto\n");
                continue;
            }
            this.print(xPoints[i] + " " + (this.height - yPoints[i] - 1) + " lineto\n");
        }
        if (nPoints > 0 && close) {
            this.print(xPoints[0] + " " + (this.height - yPoints[0] - 1) + " lineto\n");
        }
        this.print("closepath\n" + (this.mode == 0 ? "stroke" : (this.mode == 2 ? "clip" : "fill")) + "\n");
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.drawRect(x, y, width, height);
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (str.indexOf(40) >= 0 || str.indexOf(41) >= 0) {
            char[] a = str.toCharArray();
            StringBuffer res = new StringBuffer();
            for (int i = 0; i < a.length; ++i) {
                char c = a[i];
                if (c == '(' || c == ')') {
                    res.append('\\');
                }
                res.append(c);
            }
            str = res.toString();
        }
        this.print("(" + str + ") " + x + " " + (this.height - y - 1) + "  t\n");
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.mode = 1;
        this.drawArc(x, y, width, height, startAngle, arcAngle);
        this.mode = 0;
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.mode = 1;
        this.drawOval(x, y, width, height);
        this.mode = 0;
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.mode = 1;
        this.drawPolygon(xPoints, yPoints, nPoints);
        this.mode = 0;
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        y = this.height - y - 1;
        int xmax = x + width - 1;
        int ymax = y - height + 1;
        this.print("newpath\n" + x + " " + y + " moveto\n" + x + " " + ymax + " lineto\n" + xmax + " " + ymax + " lineto\n" + xmax + " " + y + " lineto\n" + "closepath\n" + (this.mode == 0 ? "stroke" : (this.mode == 2 ? "clip" : "fill")) + "\n");
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.mode = 1;
        this.drawRect(x, y, width, height);
        this.mode = 0;
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    @Override
    public Shape getClip() {
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        return null;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    @Override
    public void setClip(Shape clip) {
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
    }

    @Override
    public void setColor(Color c) {
        if (c == null || c == this.color) {
            return;
        }
        double r = (double)c.getRed() / 256.0;
        double g = (double)c.getGreen() / 256.0;
        double b = (double)c.getBlue() / 256.0;
        this.print(r + " " + g + " " + b + " setrgbcolor\n");
        this.color = c;
    }

    @Override
    public void setFont(Font font) {
        int style;
        this.font = font;
        String italic = "Italic";
        String f = font.getName();
        if (f.equals("Serif")) {
            f = "Times-Roman";
        } else if (f.equals("Monospaced")) {
            f = "Courrier";
        } else if (f.equals("SansSerif")) {
            f = "Helvetica";
        }
        if (f.indexOf("Courier") >= 0 || f.indexOf("Helvetica") >= 0) {
            italic = "Oblique";
        }
        if (((style = font.getStyle()) & 1) == 1) {
            f = f + "-" + "Bold";
        }
        if ((style & 2) == 2) {
            f = f + "-" + italic;
        }
        this.print("/" + f + " findfont " + font.getSize() + " scalefont setfont\n");
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public void translate(int x, int y) {
        this.print(x + " " + y + " translate\n");
    }
}

