/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Coo;
import cds.astro.Coocube;
import cds.astro.Qbox;
import cds.astro.Region;

public class CircularRegion
extends Region {
    double sh2;
    double s2r;

    CircularRegion(Coo coo, double d) {
        if (DEBUG) {
            System.out.println("#...new Circle(" + coo + ", r=" + d + ")");
        }
        this.centroid = new Coo(coo);
        this.minrad = this.maxrad = d;
        if (d >= 180.0) {
            System.err.println("#+++Circle(" + coo + ", r=" + d + "): radius set to 180deg!");
            this.maxrad = 180.0;
            this.minrad = 180.0;
        }
        this.s2r = AstroMath.sind(d);
        this.s2r *= this.s2r;
        this.sh2 = 2.0 * AstroMath.sind(d / 2.0);
        this.sh2 *= this.sh2;
        if (this.centroid.x == 0.0 && this.centroid.y == 0.0 && this.centroid.z == 0.0) {
            this.centroid = null;
            this.sh2 = -1.0;
            this.s2r = -1.0;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.centroid == null) {
            stringBuffer.append("*INVALID*");
        }
        stringBuffer.append("Circle(");
        if (this.centroid != null) {
            stringBuffer.append(this.centroid.toString());
        }
        stringBuffer.append(", r=" + this.minrad + ")");
        return stringBuffer.toString();
    }

    public double area() {
        if (this.centroid == null) {
            return Double.NaN;
        }
        return 32400.0 * this.sh2 / Math.PI;
    }

    public boolean checkCoo(Coo coo) {
        if (this.centroid == null) {
            return false;
        }
        return this.centroid.dist2(coo) <= this.sh2;
    }

    public int checkCircle(Coo coo, double d) {
        if (this.centroid == null) {
            return 0;
        }
        return this.check1(coo, d);
    }

    public int checkQbox(int n) {
        int n2;
        if (this.centroid == null) {
            return 0;
        }
        Qbox qbox = new Qbox();
        qbox.set(n);
        Coocube coocube = qbox.center();
        double d = Qbox.maxRadius(n);
        int n3 = this.check1(coocube, d);
        if (DEBUG) {
            System.out.println("#...CheckQbox(" + n + "=" + qbox + "[" + coocube + "]" + "\n    in Region " + this + " => " + n3);
        }
        if (n3 == 3) {
            n3 = this.check1(coocube, Qbox.minRadius(n));
            if (DEBUG) {
                System.out.println("#   [minRad?] " + this + " => " + n3);
            }
            if (n3 != 3) {
                n3 = 1;
            }
        }
        if (n3 != 1) {
            return n3;
        }
        double[][] dArray = new double[5][3];
        Qbox.ucorners(qbox.qbox, dArray);
        int n4 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            if (!(this.centroid.dist2(dArray[n2]) <= this.sh2)) continue;
            ++n4;
        }
        if (DEBUG) {
            System.out.println("#...inside=" + n4);
        }
        if (n4 == 4) {
            return -1;
        }
        if (n4 > 0) {
            return 1;
        }
        double[] dArray2 = new double[3];
        Qbox.ucorners(qbox.qbox, dArray);
        if (DEBUG) {
            System.out.println(Coo.toString("#corners ", dArray));
        }
        dArray[4][0] = dArray[0][0];
        dArray[4][1] = dArray[0][1];
        dArray[4][2] = dArray[0][2];
        for (n2 = 0; n2 < 4; ++n2) {
            Coo.vecprod(dArray[n2], dArray[n2 + 1], dArray2);
            d = this.centroid.dotprod(dArray2);
            if (d >= 0.0) {
                ++n4;
            }
            if (DEBUG) {
                System.out.println("#   i=" + n2 + ", r=" + d + ", ||v||=" + Coo.norm2(dArray2));
            }
            if (!(d * d <= this.s2r * Coo.norm2(dArray2))) continue;
            return 1;
        }
        return n4 == 4 ? 3 : 0;
    }
}

