/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Astrotime;
import cds.astro.Coo;
import cds.astro.Ecliptic;
import cds.astro.Editing;
import cds.astro.FK4;
import cds.astro.FK5;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.astro.Parsing;
import cds.astro.Supergal;
import java.io.Serializable;

public abstract class Astroframe
implements Serializable {
    private static final boolean DEBUG = false;
    private static Editing edframe = new Editing("?frame?");
    public static String IAUframes = "JGBISE";
    public String name = "*undefined*";
    public double base_epoch = 2000.0;
    public double epoch = 2000.0;
    public double[][] ICRSmatrix = null;
    public boolean hms = false;
    public byte precision = (byte)8;
    public byte ed_lon = (byte)32;
    public byte ed_lat = (byte)48;

    public static Astroframe parse(Parsing parsing) {
        Astrotime astrotime;
        int n = parsing.pos;
        Astroframe astroframe = null;
        boolean bl = false;
        boolean bl2 = true;
        parsing.gobbleSpaces();
        boolean bl3 = parsing.match("(");
        char c = Character.toUpperCase(parsing.currentChar());
        if (c == 'I') {
            bl2 = parsing.match("ICRS");
            if (bl2) {
                astroframe = new ICRS();
            }
        } else if (c == 'G') {
            while (Character.isLetter(parsing.currentChar())) {
                parsing.advance(1);
            }
            astroframe = new Galactic();
        } else if (c == 'S') {
            while (Character.isLetter(parsing.currentChar())) {
                parsing.advance(1);
            }
            astroframe = new Supergal();
        } else if (c == 'F') {
            if (parsing.match("FK4")) {
                bl = parsing.match('(');
                astroframe = bl ? new FK4(parsing.parseDecimal()) : new FK4();
            } else if (parsing.match("FK5")) {
                bl = parsing.match('(');
                astroframe = bl ? new FK5(parsing.parseDecimal()) : new FK5();
            } else {
                bl2 = false;
            }
        } else if (c == 'B') {
            parsing.match('B');
            if (Character.isDigit(parsing.currentChar())) {
                astroframe = new FK4(parsing.parseDecimal());
            } else {
                bl2 = false;
            }
        } else if (c == 'J') {
            parsing.match('J');
            if (Character.isDigit(parsing.currentChar())) {
                astroframe = new FK5(parsing.parseDecimal());
            } else {
                bl2 = false;
            }
        } else if (c == 'E') {
            while (Character.isLetter(parsing.currentChar())) {
                parsing.advance(1);
            }
            bl = parsing.match('(');
            astroframe = bl ? ((astrotime = new Astrotime()).parsing(parsing) ? new Ecliptic(astrotime.getJyr()) : new Ecliptic()) : (Character.isDigit(parsing.currentChar()) ? new Ecliptic(parsing.parseDecimal()) : new Ecliptic());
        } else {
            bl2 = false;
        }
        if (!bl2) {
            parsing.set(n);
            return null;
        }
        n = parsing.pos;
        bl2 = true;
        if (!parsing.match(',') && !bl) {
            bl = parsing.match('(');
        }
        parsing.gobbleSpaces();
        if (Character.toUpperCase(parsing.currentChar()) == 'E') {
            parsing.advance(1);
            if (parsing.currentChar() == 'p') {
                while (Character.isLetter(parsing.currentChar())) {
                    parsing.advance(1);
                }
                bl2 = parsing.match('=');
            } else {
                bl2 = false;
            }
        }
        if (Character.isLetterOrDigit(parsing.currentChar()) && (bl2 = (astrotime = new Astrotime()).parsing(parsing))) {
            astroframe.setFrameEpoch(astrotime.getJyr());
        }
        if (bl && bl2) {
            bl2 = parsing.match(')');
        }
        if (bl3 && bl2) {
            bl2 = parsing.match(')');
        }
        if (bl2) {
            parsing.match(':');
        }
        if (!bl2) {
            parsing.set(n);
        }
        return astroframe;
    }

    public static Astroframe create(String string) {
        Parsing parsing = new Parsing(string);
        Astroframe astroframe = Astroframe.parse(parsing);
        parsing.gobbleSpaces();
        if (parsing.pos < parsing.length) {
            System.err.println("#+++Astroframe(" + string + "): " + parsing);
            return null;
        }
        return astroframe;
    }

    public static final boolean isIAU(char c) {
        return IAUframes.indexOf(Character.toUpperCase(c)) >= 0;
    }

    public static Astroframe create(char c) {
        switch (Character.toUpperCase(c)) {
            case 'J': {
                return new FK5();
            }
            case 'G': {
                return new Galactic();
            }
            case 'B': {
                return new FK4();
            }
            case 'I': {
                return new ICRS();
            }
            case 'S': {
                return new Supergal();
            }
            case 'E': {
                return new Ecliptic();
            }
        }
        return null;
    }

    public boolean equals(char c) {
        switch (Character.toUpperCase(c)) {
            case 'I': 
            case 'J': {
                return this instanceof ICRS || this.name.equals("FK5(J2000.0)");
            }
            case 'G': {
                return this instanceof Galactic;
            }
            case 'B': {
                return this.name.equals("FK4(B1950.0)");
            }
            case 'S': {
                return this instanceof Supergal;
            }
            case 'E': {
                return this instanceof Ecliptic;
            }
        }
        return false;
    }

    public String toString() {
        if (this.base_epoch == this.epoch) {
            return this.name;
        }
        return this.toString(this.epoch);
    }

    public String toString(double d) {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        int n = this.name.length() - 1;
        if (stringBuffer.charAt(n) == ')') {
            stringBuffer.setLength(n);
            stringBuffer.append(',');
        } else {
            stringBuffer.append('(');
        }
        stringBuffer.append("Ep=J");
        n = stringBuffer.length();
        stringBuffer.append(d);
        if (stringBuffer.length() - n > 6) {
            stringBuffer.setLength(n - 1);
            stringBuffer.append('B');
            edframe.editDecimal(stringBuffer, Astrotime.J2B(d), 4, -3, 0);
        }
        if (stringBuffer.length() - n > 6) {
            stringBuffer.setLength(n - 1);
            stringBuffer.append('J');
            edframe.editDecimal(stringBuffer, d, 4, -3, 0);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final void setICRSmatrix() {
        if (this.ICRSmatrix == null && this.toICRSmatrix() == null) {
            System.err.println("****Astroframe " + this + ": linkage to ICRS undefined!");
        }
    }

    public void setFrameEpoch(double d) {
        this.epoch = d;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Astroframe) {
            Astroframe astroframe = (Astroframe)object;
            bl = this.epoch == astroframe.epoch && this.name.equals(astroframe.name);
        }
        return bl;
    }

    public int hashCode() {
        int n = this.name.hashCode();
        long l = Double.doubleToLongBits(this.epoch);
        n = n * 123 + (int)(l ^ l >>> 32);
        return n;
    }

    public abstract double[][] toICRSmatrix();

    public void toICRS(Coo coo) {
        if (this.ICRSmatrix == null) {
            this.setICRSmatrix();
        }
        coo.rotate(this.ICRSmatrix);
    }

    public void fromICRS(Coo coo) {
        if (this.ICRSmatrix == null) {
            this.setICRSmatrix();
        }
        coo.rotate_1(this.ICRSmatrix);
    }

    public void toICRS(double[] dArray) {
        if (this.ICRSmatrix == null) {
            this.setICRSmatrix();
        }
        Coo.rotateVector(this.ICRSmatrix, dArray);
    }

    public void fromICRS(double[] dArray) {
        if (this.ICRSmatrix == null) {
            this.setICRSmatrix();
        }
        Coo.rotateVector_1(this.ICRSmatrix, dArray);
    }

    public double getEpoch() {
        return this.epoch;
    }
}

