/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

public class AstroMath {
    public static final double[] powers = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
    public static final double DEG = 57.29577951308232;
    public static final double DEG2 = 3282.806350011744;
    public static final double ARCSEC = 206264.80624709636;
    static final double ln10 = Math.log(10.0);

    public static final double cosd(double d) {
        return Math.cos(d / 57.29577951308232);
    }

    public static final double sind(double d) {
        return Math.sin(d / 57.29577951308232);
    }

    public static final double tand(double d) {
        return Math.tan(d / 57.29577951308232);
    }

    public static final double asind(double d) {
        return Math.asin(d) * 57.29577951308232;
    }

    public static final double atand(double d) {
        return Math.atan(d) * 57.29577951308232;
    }

    public static final double atan2d(double d, double d2) {
        return Math.atan2(d, d2) * 57.29577951308232;
    }

    public static final double cosh(double d) {
        double d2 = Math.exp(d);
        return 0.5 * (d2 + 1.0 / d2);
    }

    public static final double tanh(double d) {
        double d2 = Math.exp(d);
        double d3 = 1.0 / d2;
        return (d2 - d3) / (d2 + d3);
    }

    public static final double atanh(double d) {
        return 0.5 * Math.log((1.0 + d) / (1.0 - d));
    }

    public static final double sinc(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 <= 1.0E-4) {
            d3 *= d3;
            d2 = 1.0 - d3 * (1.0 - d3 / 20.0) / 6.0;
        } else {
            d2 = Math.sin(d3) / d3;
        }
        return d2;
    }

    public static final double asinc(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 <= 1.0E-4) {
            d3 *= d3;
            d2 = 1.0 + d3 * (6.0 + d3 * 0.45) / 6.0;
        } else {
            d2 = Math.asin(d3) / d3;
        }
        return d2;
    }

    public static final double dexp(int n) {
        int n2 = n;
        int n3 = powers.length - 1;
        double d = 1.0;
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n2 = -n;
        }
        while (n2 > n3) {
            d *= powers[n3];
            n2 -= n3;
        }
        d *= powers[n2];
        if (bl) {
            d = 1.0 / d;
        }
        return d;
    }

    public static final double dexp(double d) {
        return Math.exp(d * ln10);
    }

    public static final double log(double d) {
        return Math.log(d) / ln10;
    }

    public static final double ell1(double d, double d2) {
        double d3 = d;
        double d4 = d2;
        while (!(Math.abs(d3 - d4) < 1.0E-15 * d4)) {
            double d5 = (d3 + d4) / 2.0;
            double d6 = Math.sqrt(d3 * d4);
            d3 = d5;
            d4 = d6;
        }
        return Math.PI / (d3 + d4);
    }

    public static final double[][] m3p(double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray3[i][j] = dArray[i][0] * dArray2[0][j] + dArray[i][1] * dArray2[1][j] + dArray[i][2] * dArray2[2][j];
            }
        }
        return dArray3;
    }

    public static final double[][] m3t(double[][] dArray) {
        double[][] dArray2 = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray2[i][j] = dArray[j][i];
            }
        }
        return dArray2;
    }
}

