/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Chaine;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.prop.PropPanel;
import cds.allsky.Action;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.MainPanel;
import cds.allsky.Task;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class TabRgb
extends JPanel
implements ActionListener {
    private static String B;
    private static String G;
    private static String R;
    private String REP_DEST;
    private String RGBALLSKY;
    private String BROWSE;
    private String HELP;
    private String CHOOSE = "-- select a plane --";
    private JLabel dirLabel = new JLabel();
    private JButton browse = new JButton();
    private JTextField outputField = new JTextField(30);
    private JRadioButton radioMediane;
    private JRadioButton formatJpeg;
    JProgressBar progressBar = new JProgressBar(0, 100);
    private JComboBox[] ch;
    private JButton start;
    private JButton abort;
    private JButton pause;
    private JButton help = new JButton();
    private final Aladin aladin;
    private MainPanel mainPanel;
    private ContextGui context;
    private String titlehelp;
    private JLabel tileStat;
    private JLabel timeStat;

    public TabRgb(Aladin aladin, MainPanel mainPanel) {
        super(new BorderLayout());
        JRadioButton rb;
        this.aladin = aladin;
        this.mainPanel = mainPanel;
        this.context = mainPanel.context;
        this.createChaine(Aladin.getChaine());
        this.help = Util.getHelpButton(this, this.HELP);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel pCenter = new JPanel();
        pCenter.setLayout(new GridBagLayout());
        pCenter.setBorder(BorderFactory.createEmptyBorder(5, 55, 5, 55));
        JLabel info = new JLabel(Util.fold(this.RGBALLSKY, 80, true));
        info.setFont(info.getFont().deriveFont(2));
        c.gridwidth = 0;
        c.insets.bottom = 20;
        pCenter.add((Component)info, c);
        c.insets.bottom = 2;
        int n = 3;
        this.ch = new JComboBox[n];
        for (int i = 0; i < n; ++i) {
            this.ch[i] = new JComboBox();
            this.ch[i].addActionListener(this);
            this.ch[i].setPreferredSize(new Dimension(200, 20));
            JLabel ll = new JLabel(this.getLabelSelector(i));
            ll.setForeground(this.getColorLabel(i));
            c.gridwidth = -1;
            c.weightx = 0.0;
            pCenter.add((Component)ll, c);
            c.gridwidth = 0;
            pCenter.add((Component)this.ch[i], c);
            this.ch[i].addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TabRgb.this.init();
                }
            });
        }
        this.init();
        c.gridwidth = -1;
        c.weightx = 0.0;
        JPanel dirPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.dirLabel = new JLabel(this.REP_DEST);
        pCenter.add((Component)this.dirLabel, c);
        this.browse.setText(this.BROWSE);
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabRgb.this.dirBrowser(TabRgb.this.outputField);
            }
        });
        dirPanel.add(this.outputField);
        dirPanel.add(this.browse);
        c.gridwidth = 0;
        pCenter.add((Component)dirPanel, c);
        c.gridwidth = 0;
        c.fill = 2;
        int m = c.insets.top;
        c.insets.top = 20;
        JPanel p = new JPanel();
        JLabel l = new JLabel(this.getString("METHODJPG"));
        l.setFont(l.getFont().deriveFont(1));
        p.add(l);
        ButtonGroup bg1 = new ButtonGroup();
        this.radioMediane = rb = new JRadioButton(this.getString("MEDIANJPG"));
        rb.setSelected(true);
        bg1.add(rb);
        p.add(rb);
        rb = new JRadioButton(this.getString("AVERAGEJPG"));
        bg1.add(rb);
        p.add(rb);
        pCenter.add((Component)p, c);
        m = c.insets.top = m;
        c.insets.top = 0;
        p = new JPanel();
        l = new JLabel("Output tile format:");
        l.setFont(l.getFont().deriveFont(1));
        bg1 = new ButtonGroup();
        p.add(l);
        this.formatJpeg = rb = new JRadioButton("JPEG (faster)");
        bg1.add(rb);
        p.add(rb);
        rb = new JRadioButton("PNG (better)");
        rb.setSelected(true);
        bg1.add(rb);
        p.add(rb);
        pCenter.add((Component)p, c);
        c.insets.top = m;
        this.progressBar.setStringPainted(true);
        JPanel pProgress = new JPanel(new BorderLayout());
        pProgress.setBorder(new EmptyBorder(50, 0, 15, 0));
        pProgress.add((Component)this.progressBar, "Center");
        pProgress.add((Component)this.createStatPanel(), "South");
        pCenter.add((Component)pProgress, c);
        JPanel fin = new JPanel(new BorderLayout());
        JPanel pBtn = new JPanel();
        pBtn.setLayout(new BoxLayout(pBtn, 0));
        pBtn.add(Box.createHorizontalGlue());
        this.start = new JButton(this.getString("START"));
        this.start.addActionListener(this);
        pBtn.add(this.start);
        this.pause = new JButton(this.getString("PAUSE"));
        this.pause.addActionListener(this);
        pBtn.add(this.pause);
        this.abort = new JButton(this.getString("ABORT"));
        this.abort.addActionListener(this);
        pBtn.add(this.abort);
        pBtn.add(Box.createRigidArea(new Dimension(10, 0)));
        pBtn.add(Box.createHorizontalGlue());
        fin.add((Component)pBtn, "Center");
        fin.add((Component)this.help, "East");
        this.add((Component)pCenter, "Center");
        this.add((Component)fin, "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    protected String getLabelSelector(int i) {
        return i == 0 ? R : (i == 1 ? G : (i == 2 ? B : ""));
    }

    protected Color getColorLabel(int i) {
        return i == 0 ? Color.red : (i == 1 ? Color.green : (i == 2 ? Color.blue : Color.black));
    }

    private void createChaine(Chaine chaine) {
        this.BROWSE = this.getString("FILEBROWSE");
        this.REP_DEST = this.getString("REPDALLSKY");
        this.RGBALLSKY = this.getString("RGBALLSKY");
        this.HELP = this.getString("HELPRGBALLSKY");
        this.titlehelp = this.getString("HHELP");
        R = this.getString("RGBRED");
        G = this.getString("RGBGREEN");
        B = this.getString("RGBBLUE");
    }

    private String getString(String k) {
        MainPanel mainPanel = this.mainPanel;
        return mainPanel.aladin.getChaine().getString(k);
    }

    public Context.JpegMethod getMethod() {
        if (this.radioMediane.isSelected()) {
            return Context.JpegMethod.MEDIAN;
        }
        return Context.JpegMethod.MEAN;
    }

    public int getFormat() {
        if (this.formatJpeg.isSelected()) {
            return 1;
        }
        return 0;
    }

    protected PlanBG[] getPlan() {
        try {
            Vector<Plan> v = this.aladin.calque.getPlanBG();
            if (v == null) {
                return new PlanBG[0];
            }
            for (PlanBG planBG : v) {
                if (!planBG.isColored()) continue;
                v.remove(planBG);
            }
            Object[] pi = new PlanBG[v.size()];
            v.copyInto(pi);
            return pi;
        }
        catch (Exception e) {
            return new PlanBG[0];
        }
    }

    private JPanel createStatPanel() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 10, 2, 2);
        JPanel p = new JPanel(g);
        this.tileStat = new JLabel("--");
        PropPanel.addCouple(p, ".RGB tiles: ", this.tileStat, g, c);
        this.timeStat = new JLabel("--");
        PropPanel.addCouple(p, ".Time: ", this.timeStat, g, c);
        return p;
    }

    protected void setStat(int nbTile, long sizeTile, long time) {
        String s = nbTile == -1 ? "" : nbTile + " tile" + (nbTile > 1 ? "s" : "") + " for " + Util.getUnitDisk(sizeTile);
        this.tileStat.setText(s);
        s = time == -1L ? "" : Util.getTemps(time, true);
        this.timeStat.setText(s);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.start) {
            Object[] plans = new Object[3];
            for (int i = 0; i < 3; ++i) {
                plans[i] = this.ch[i].getSelectedItem();
            }
            if ("".equals(this.outputField.getText()) || !new File(this.outputField.getText()).isDirectory()) {
                Aladin.warning("Choose an output directory");
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.context.setRgbPlans(plans);
            this.context.setRgbOutput(this.outputField.getText());
            this.context.setRgbMethod(this.getMethod());
            this.context.setRgbFormat(this.getFormat());
            this.context.setProgressBar(this.progressBar);
            try {
                new Task((Context)this.context, Action.RGB, false);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource() == this.abort) {
            this.abort();
        } else if (e.getSource() == this.pause) {
            this.pause();
        }
        this.resumeWidgets();
    }

    private void pause() {
        if (this.context.isTaskPause()) {
            this.context.setTaskPause(false);
            this.pause.setText(this.getString("PAUSE"));
        } else {
            this.context.setTaskPause(true);
            this.pause.setText(this.getString("RESUME"));
        }
    }

    private void abort() {
        if (!Aladin.confirmation(this.mainPanel, "Do you really want to abort the RGB computation ?")) {
            return;
        }
        this.context.taskAbort();
    }

    private void dirBrowser(JTextField dir) {
        String t;
        String path = dir.getText().trim();
        if (path.length() == 0) {
            path = this.aladin.getDefaultDirectory();
        }
        if ((t = Util.dirBrowser(this, path)) == null) {
            return;
        }
        dir.setText(t);
        this.actionPerformed(new ActionEvent(dir, -1, "dirBrowser Action"));
    }

    protected void init() {
        Object[] save = new Object[]{this.ch[0].getSelectedItem(), this.ch[1].getSelectedItem(), this.ch[2].getSelectedItem()};
        PlanBG[] plans = this.getPlan();
        for (int i = 0; i < 3; ++i) {
            this.ch[i].removeAllItems();
            this.ch[i].addItem(this.CHOOSE);
        }
        for (PlanBG planBG : plans) {
            for (int i = 0; i < 3; ++i) {
                this.ch[i].addItem(planBG);
                if (save[i] == null || planBG != save[i]) continue;
                this.ch[i].setSelectedItem(planBG);
            }
        }
    }

    @Override
    public void show() {
        super.show();
        this.init();
    }

    public void help() {
        JOptionPane.showMessageDialog(this, this.HELP, this.titlehelp, 1);
    }

    private boolean hasPlanSelection() {
        int nb = 0;
        for (int i = 0; i < this.ch.length; ++i) {
            Object o = this.ch[i].getSelectedItem();
            if (!(o instanceof PlanBG)) continue;
            ++nb;
        }
        return nb > 1;
    }

    protected void resumeWidgets() {
        try {
            boolean readyToDo = this.hasPlanSelection() && this.outputField.getText().trim().length() > 0;
            boolean isRunning = this.context.isTaskRunning();
            this.start.setEnabled(readyToDo && !isRunning);
            this.pause.setEnabled(isRunning);
            this.abort.setEnabled(isRunning);
            this.setCursor(isRunning ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

