/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.allsky.Context;
import cds.allsky.FrameGlu;
import cds.allsky.MainPanel;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class TabPub
extends JPanel
implements ActionListener {
    private static String NEXT;
    private static String PUBLISH;
    private static String EXPORT;
    private static String OPEN;
    private static String LOCAL_FULL;
    private JTextField url = new JTextField(40);
    private JTextField pathLocal = new JTextField(40);
    private JButton bLocal = new JButton();
    private JButton bPublic = new JButton();
    private JButton bExport = new JButton();
    protected JButton bNext = new JButton();
    JProgressBar progressHpx = new JProgressBar(0, 100);
    private Aladin aladin;
    private MainPanel mainPanel;
    private Context context;
    private String mapfile;
    private boolean running = false;

    public TabPub(Aladin a, MainPanel mainPanel) {
        super(new BorderLayout());
        this.aladin = a;
        this.mainPanel = mainPanel;
        this.context = mainPanel.context;
        this.createChaine();
        Border emptyBorder = BorderFactory.createEmptyBorder(20, 0, 0, 0);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 2, 1, 2);
        c.anchor = 18;
        c.gridy = 0;
        this.initBtn();
        JPanel pCenter = new JPanel();
        pCenter.setLayout(new GridBagLayout());
        pCenter.setBorder(BorderFactory.createEmptyBorder(5, 20, 0, 20));
        ++c.gridy;
        c.gridx = 0;
        JLabel titleLocal = new JLabel(this.getString("PUBFORYOUALLSKY"));
        titleLocal.setFont(titleLocal.getFont().deriveFont(1));
        pCenter.add((Component)titleLocal, c);
        ++c.gridy;
        c.gridwidth = 0;
        pCenter.add((Component)new JLabel(LOCAL_FULL), c);
        ++c.gridy;
        pCenter.add((Component)this.pathLocal, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        JLabel titleHPX = new JLabel(Util.fold(this.getString("PUBMAPALLSKY"), 80, true));
        titleHPX.setFont(titleHPX.getFont().deriveFont(1));
        titleHPX.setBorder(emptyBorder);
        pCenter.add((Component)titleHPX, c);
        ++c.gridy;
        c.gridwidth = 0;
        pCenter.add((Component)new JLabel(Util.fold(this.getString("PUBMAPINFOALLSKY"), 80, true)), c);
        this.progressHpx.setStringPainted(true);
        c.fill = 2;
        c.gridwidth = 0;
        ++c.gridy;
        c.gridx = 0;
        JPanel pProgress = new JPanel(new BorderLayout());
        pProgress.setBorder(new EmptyBorder(5, 15, 5, 15));
        pProgress.add(this.progressHpx);
        pCenter.add((Component)this.progressHpx, c);
        c.fill = 0;
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        pCenter.add((Component)this.bExport, c);
        ++c.gridy;
        c.gridx = 0;
        JLabel titleRestricted = new JLabel(this.getString("PUBRESTALLSKY"));
        titleRestricted.setFont(titleLocal.getFont());
        titleRestricted.setBorder(emptyBorder);
        pCenter.add((Component)titleRestricted, c);
        ++c.gridy;
        c.gridwidth = 0;
        pCenter.add((Component)new JLabel(Util.fold(this.getString("PUBRESTINFOALLSKY"), 80, true)), c);
        ++c.gridy;
        c.fill = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        pCenter.add((Component)this.url, c);
        ++c.gridx;
        ++c.gridy;
        ++c.gridy;
        c.gridx = 0;
        JLabel titlePublic = new JLabel(this.getString("PUBLICALLSKY"));
        titlePublic.setFont(titleLocal.getFont());
        titlePublic.setBorder(emptyBorder);
        pCenter.add((Component)titlePublic, c);
        ++c.gridy;
        c.gridwidth = 0;
        pCenter.add((Component)new JLabel(Util.fold(this.getString("PUBLICINFOALLSKY"), 80, true)), c);
        c.gridwidth = 1;
        ++c.gridy;
        c.fill = 0;
        c.gridx = 0;
        pCenter.add((Component)this.bPublic, c);
        this.add((Component)pCenter, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void initBtn() {
        this.bNext = new JButton(NEXT);
        this.bNext.addActionListener(this);
        this.bExport.setText(EXPORT);
        this.bExport.addActionListener(this);
        this.bPublic.setText(PUBLISH);
        this.bPublic.addActionListener(this);
        this.bLocal.setText(OPEN);
        this.bLocal.addActionListener(this);
    }

    public void clearForms() {
        this.url.setText("");
    }

    private void createChaine() {
        LOCAL_FULL = this.getString("OPENALLSKY");
        OPEN = this.getString("MOPENLOAD");
        NEXT = this.getString("NEXT");
        PUBLISH = this.getString("PUBLISHALLSKY");
        EXPORT = this.getString("EXPORTALLSKY");
    }

    private String getString(String k) {
        TabPub tabPub = this;
        return tabPub.aladin.getChaine().getString(k);
    }

    public void newAllskyDir(String dir) {
        this.url.setText("http://servername.org/" + dir);
        this.url.repaint();
        this.pathLocal.setText(this.context.getOutputPath());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand() == PUBLISH) {
            new FrameGlu(this.aladin, this.context);
        } else if (ae.getSource() == this.bExport) {
            this.mapfile = this.dirBrowserHPX();
            if (this.mapfile == null) {
                return;
            }
            this.bExport.setSelected(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.mapfile = this.aladin.getFullFileName(this.mapfile);
            ExportThread hpxThread = new ExportThread(this.mainPanel, this.mapfile);
            hpxThread.start();
            new ThreadProgressBar(hpxThread).start();
        } else if (ae.getSource() == this.bNext) {
            this.mainPanel.showRgbTab();
        }
    }

    private String dirBrowserHPX() {
        FileDialog fd = new FileDialog((Frame)this.aladin.frameAllsky, "Running directory selection", 1);
        fd.setDirectory(this.context.getOutputPath());
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return null;
        }
        return fd.getDirectory() + fd.getFile();
    }

    public void setStartEnabled(boolean enabled) {
        this.resumeWidgets();
    }

    public void setProgress(int value) {
        this.progressHpx.setValue(value);
        if (value == 100) {
            Aladin.info(this, "Your HEALPix map has been successfully created\n" + this.mapfile);
        }
    }

    @Override
    public void show() {
        super.show();
        this.resumeWidgets();
    }

    protected void resumeWidgets() {
        try {
            boolean color = this.context.isColor();
            boolean allskyExist = this.context.isExistingAllskyDir();
            boolean isRunning = this.context.isTaskRunning() || this.running;
            this.bPublic.setEnabled(!isRunning && allskyExist);
            this.bExport.setEnabled(!isRunning && !color && allskyExist);
            this.setCursor(isRunning ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ExportThread
    implements Runnable {
        String outfile;
        MainPanel allsky;
        int progress = 0;

        public ExportThread(MainPanel allsky, String filename) {
            this.allsky = allsky;
            this.outfile = filename;
        }

        public int getProgress() {
            File f = new File(this.outfile);
            if (!f.exists()) {
                return 0;
            }
            long size = f.length() / 1024L / 1024L;
            long sizeFin = 0xC000000 * TabPub.this.context.getNpix() / 1024 / 1024;
            return (int)(100L * size / sizeFin);
        }

        public synchronized void start() {
            new Thread(this).start();
        }

        @Override
        public void run() {
            TabPub.this.running = true;
            File f = new File(this.outfile);
            f.delete();
            this.allsky.export(this.outfile);
            TabPub.this.running = false;
        }
    }

    class ThreadProgressBar
    implements Runnable {
        Object thread;

        public ThreadProgressBar(Object source) {
            this.thread = source;
        }

        public synchronized void start() {
            new Thread(this).start();
        }

        @Override
        public void run() {
            int value = 0;
            while (this.thread != null && value < 99) {
                value = ((ExportThread)this.thread).getProgress();
                TabPub.this.setProgress(value);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            TabPub.this.setProgress(100);
            TabPub.this.resumeWidgets();
        }
    }
}

