/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderMoc;
import cds.allsky.Constante;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.Mode;
import cds.allsky.ThreadBuilderTile;
import cds.fits.CacheFits;
import cds.fits.Fits;
import cds.moc.HealpixMoc;
import cds.moc.MocCell;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class BuilderTiles
extends Builder {
    private boolean isColor;
    protected int bitpix;
    protected double bzero;
    protected double bscale;
    protected double blank;
    private Context.JpegMethod method;
    protected ArrayList<ThreadBuilder> threadList = new ArrayList();
    private Mode coaddMode = Mode.REPLACETILE;
    protected int ordermin = 3;
    protected int ordermax;
    protected long nummin = 0L;
    protected long nummax = 0L;
    protected Iterator<Long> npixIterator;
    protected double automin = 0.0;
    protected double automax = 0.0;
    public static boolean DEBUG = true;
    public static String FS = System.getProperty("file.separator");
    private boolean stopped = false;
    protected int statNbThreadRunning = -1;
    protected int statNbThread;
    protected int statNbTile;
    protected long statMinTime;
    protected long statMaxTime;
    protected long statTotalTime;
    protected long statAvgTime;
    protected int statEmptyTile;
    protected int statNodeTile;
    protected long statNodeTotalTime;
    protected long statNodeAvgTime;
    protected long startTime;
    protected long totalTime;
    private Builder b = null;
    long lastTime = 0L;
    long lastNbTile = 0L;
    Hashtable<Thread, ArrayList<Fits>> memPerThread;
    private Object lockObj = new Object();

    public BuilderTiles(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.TILES;
    }

    @Override
    public void run() throws Exception {
        this.context.info("Creating " + this.context.getTileExt() + " tiles and allsky (max depth=" + this.context.getOrder() + ")...");
        this.context.info("sky area to process: " + this.context.getNbLowCells() + " low level HEALPix cells");
        if (!this.context.isColor()) {
            int b1;
            int b0 = this.context.getBitpixOrig();
            if (b0 != (b1 = this.context.getBitpix())) {
                this.context.info("BITPIX conversion from " + this.context.getBitpixOrig() + " to " + this.context.getBitpix());
                double[] cutOrig = this.context.getCutOrig();
                double[] cut = this.context.getCut();
                this.context.info("Map original raw pixel range [" + cutOrig[2] + " .. " + cutOrig[3] + "] to [" + cut[2] + " .. " + cut[3] + "]");
            } else {
                this.context.info("BITPIX = " + b1 + " (no conversion)");
            }
            if (this.context.getDiskMem() != -1L) {
                this.context.info("Disk requirement (upper approximation) : " + cds.tools.Util.getUnitDisk((long)((double)this.context.getDiskMem() * 1.25)));
            }
            double bs = this.context.getBScale();
            double bz = this.context.getBZero();
            if (bs != 1.0 || bz != 0.0) {
                this.context.info("BSCALE=" + bs + " BZERO=" + bz);
            }
            double bl0 = this.context.getBlankOrig();
            double bl1 = this.context.getBlank();
            if (this.context.hasAlternateBlank()) {
                this.context.info("BLANK conversion from " + (Double.isNaN(bl0) ? "NaN" : Double.valueOf(bl0)) + " to " + (Double.isNaN(bl1) ? "NaN" : Double.valueOf(bl1)));
            } else {
                this.context.info("BLANK=" + (Double.isNaN(bl1) ? "NaN" : Double.valueOf(bl1)));
            }
            if (this.context.good != null) {
                this.context.info("Good pixel values [" + this.ip(this.context.good[0], bz, bs) + " .. " + this.ip(this.context.good[1], bz, bs) + "] => other values are ignored");
            }
            this.context.info("Tile aggregation method=" + (Object)((Object)Context.JpegMethod.MEAN));
        }
        this.build();
        if (!this.context.isTaskAborting()) {
            this.b = new BuilderMoc(this.context);
            this.b.run();
            this.b = null;
        }
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).run();
            this.context.info("Allsky done");
        }
    }

    @Override
    public void validateContext() throws Exception {
        if (this.context instanceof ContextGui) {
            this.context.setProgressBar(((ContextGui)this.context).mainPanel.getProgressBarTile());
        }
        this.validateInput();
        this.validateOutput();
        try {
            this.validateOrder(this.context.getHpxFinderPath());
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.context.warning(e.getMessage());
            this.validateOrder(this.context.getOutputPath());
        }
        if (!this.context.isColor()) {
            double[] cutOrigBefore;
            String img = this.context.getImgEtalon();
            if (img == null) {
                img = this.context.justFindImgEtalon(this.context.getInputPath());
            }
            double[] memoCutOrig = this.context.getCutOrig();
            boolean hasAlternateBlank = this.context.hasAlternateBlank();
            double blankOrig = this.context.getBlankOrig();
            int bitpixOrig = this.context.getBitpixOrig();
            if (img == null) {
                throw new Exception("No source image found in " + this.context.getInputPath());
            }
            this.context.info("Reference image: " + img);
            try {
                this.context.setImgEtalon(img);
            }
            catch (Exception e) {
                this.context.warning("Reference image problem [" + img + "] => " + e.getMessage());
            }
            if (bitpixOrig == -1) {
                this.context.info("BITPIX found in the reference image => " + this.context.getBitpixOrig());
            } else if (bitpixOrig != this.context.getBitpixOrig()) {
                this.context.warning("The provided BITPIX (" + bitpixOrig + ") is different than the original one (" + this.context.getBitpixOrig() + ") => bitpix conversion will be applied");
                this.context.setBitpixOrig(bitpixOrig);
            }
            if (this.context.depth > 1) {
                this.context.info("Original images are cubes (depth=" + this.context.depth + ")");
            }
            if ((cutOrigBefore = this.context.getPixelRangeCut()) != null) {
                memoCutOrig = new double[4];
                for (int i = 0; i < 4; ++i) {
                    if (Double.isNaN(cutOrigBefore[i])) continue;
                    memoCutOrig[i] = (cutOrigBefore[i] - this.context.bZeroOrig) / this.context.bScaleOrig;
                }
            }
            double[] cutOrig = this.context.getCutOrig();
            double bs = this.context.bScaleOrig;
            double bz = this.context.bZeroOrig;
            if (memoCutOrig != null) {
                if (memoCutOrig[0] != 0.0 || memoCutOrig[1] != 0.0) {
                    cutOrig[0] = memoCutOrig[0];
                    cutOrig[1] = memoCutOrig[1];
                }
                if (memoCutOrig[2] != 0.0 || memoCutOrig[3] != 0.0) {
                    cutOrig[2] = memoCutOrig[2];
                    cutOrig[3] = memoCutOrig[3];
                }
                this.context.setCutOrig(cutOrig);
            }
            if (cutOrig[0] == cutOrig[1]) {
                this.context.warning("BAD PIXEL CUT: [" + this.ip(cutOrig[0], bz, bs) + " .. " + this.ip(cutOrig[1], bz, bs) + "] => YOU WILL HAVE TO CHANGE/EDIT THE properties FILE VALUES");
            }
            this.context.setValidateCut(true);
            if (hasAlternateBlank) {
                this.context.setBlankOrig(blankOrig);
            }
            this.context.initParameters();
            this.context.info("Data range [" + this.ip(cutOrig[2], bz, bs) + " .. " + this.ip(cutOrig[3], bz, bs) + "], pixel cut [" + this.ip(cutOrig[0], bz, bs) + " .. " + this.ip(cutOrig[1], bz, bs) + "]");
        } else {
            this.context.initParameters();
        }
        if (!this.context.verifCoherence()) {
            throw new Exception("Uncompatible pre-existing HEALPix survey");
        }
        if (!this.context.isColor() && this.context.getBScale() == 0.0) {
            throw new Exception("Big bug => BSCALE=0 !! please contact CDS");
        }
        Mode m = this.context.getMode();
        if (!this.context.isColor() || m == Mode.KEEPTILE || m == Mode.REPLACETILE) {
            this.context.info("mode=" + Mode.getExplanation(m));
        }
    }

    @Override
    public void showStatistics() {
        if (this.b != null) {
            this.b.showStatistics();
            return;
        }
        if (this.statNbThreadRunning == 0 || this.statNbTile == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        this.totalTime = now - this.startTime;
        long deltaTime = now - this.lastTime;
        long deltaNbTile = (long)this.statNbTile - this.lastNbTile;
        this.lastTime = now;
        this.lastNbTile = this.statNbTile;
        this.context.showTilesStat(this.statNbThreadRunning, this.statNbThread, this.totalTime, this.statNbTile, this.statEmptyTile, this.statNodeTile, this.statMinTime, this.statMaxTime, this.statAvgTime, this.statNodeAvgTime, this.getUsedMem(), deltaTime, deltaNbTile);
    }

    private void initStat(int nbThread) {
        this.statNbThread = nbThread;
        this.statNbThreadRunning = 0;
        this.statNodeTile = 0;
        this.statNbTile = 0;
        this.statNodeTotalTime = 0L;
        this.statTotalTime = 0L;
        this.startTime = System.currentTimeMillis();
        this.totalTime = 0L;
        this.memPerThread = new Hashtable();
    }

    private void rmThread(Thread t) {
        Long key = new Long(t.hashCode());
        ArrayList<Fits> m = this.memPerThread.get(key);
        if (m != null) {
            for (Fits f : m) {
                f.free();
            }
        }
        this.memPerThread.remove(key);
    }

    protected void addFits(Thread t, Fits f) {
        ArrayList<Fits> m;
        if (f == null) {
            return;
        }
        if (f.width == 0) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((m = this.memPerThread.get(t)) == null) {
            m = new ArrayList();
            this.memPerThread.put(t, m);
        }
        m.add(f);
    }

    protected void rmFits(Thread t, Fits f) {
        ArrayList<Fits> m = this.memPerThread.get(t);
        if (m == null) {
            return;
        }
        m.remove(f);
    }

    private long getUsedMem() {
        long mem = 0L;
        try {
            for (Thread t : this.memPerThread.keySet()) {
                ArrayList<Fits> m = this.memPerThread.get(t);
                mem += this.getUsedMem(m);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mem;
    }

    private String showMem() {
        StringBuffer s = new StringBuffer();
        for (Thread t : this.memPerThread.keySet()) {
            ArrayList<Fits> m = this.memPerThread.get(t);
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append(t.getName() + ":" + m.size() + "tiles" + "/" + cds.tools.Util.getUnitDisk(this.getUsedMem(m)));
        }
        return s.toString();
    }

    private long getUsedMem(ArrayList<Fits> m) {
        if (m == null) {
            return 0L;
        }
        long mem = 0L;
        try {
            for (Fits f : m) {
                mem += f.getMem();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return mem;
    }

    protected void updateStat(int deltaNbThread, int deltaTile, int deltaEmptyTile, long timeTile, int deltaNodeTile, long timeNodeTile) {
        this.statNbThreadRunning += deltaNbThread;
        this.statNbTile += deltaTile;
        this.statNodeTile += deltaNodeTile;
        this.statEmptyTile += deltaEmptyTile;
        if (timeTile > 0L) {
            if (this.statNbTile == 1 || timeTile < this.statMinTime) {
                this.statMinTime = timeTile;
            }
            if (this.statNbTile == 1 || timeTile > this.statMaxTime) {
                this.statMaxTime = timeTile;
            }
            if (deltaTile == 1) {
                this.statTotalTime += timeTile;
                this.statAvgTime = this.statTotalTime / (long)this.statNbTile;
            }
        }
        if (timeNodeTile > 0L && deltaNodeTile == 1) {
            this.statNodeTotalTime += timeNodeTile;
            this.statNodeAvgTime = this.statNodeTotalTime / (long)this.statNodeTile;
        }
    }

    protected void build() throws Exception {
        this.ordermax = this.context.getOrder();
        long t = System.currentTimeMillis();
        HealpixMoc moc = new HealpixMoc();
        moc.add(this.context.getRegion());
        moc.setMocOrder(3);
        this.npixIterator = moc.pixelIterator();
        this.isColor = this.context.isColor();
        this.bitpix = this.context.getBitpix();
        this.coaddMode = this.context.getMode();
        this.method = this.context.getJpegMethod();
        if (!this.isColor) {
            this.bzero = this.context.getBZero();
            this.bscale = this.context.getBScale();
            this.blank = this.context.getBlank();
        }
        int nbProc = Runtime.getRuntime().availableProcessors();
        long size = this.context.getMem();
        long bufMem = 0x400000L * (long)this.context.getNpixOrig();
        long oneRhomb = this.context.getTileSide() * this.context.getTileSide() * this.context.getNpix();
        long maxMemPerThread = 4L * oneRhomb + bufMem;
        if (this.isColor) {
            maxMemPerThread += oneRhomb * (long)(this.ordermax - this.ordermin);
        }
        int nbThread = (int)(size / maxMemPerThread);
        int maxNbThread = this.context.getMaxNbThread();
        if (maxNbThread > 0 && nbThread > maxNbThread) {
            nbThread = maxNbThread;
        }
        if (nbThread == 0) {
            nbThread = 1;
        }
        if (nbThread > nbProc) {
            nbThread = nbProc;
        }
        Aladin.trace(4, "BuildController.build(): Found " + nbProc + " processor(s) for " + size / 0x100000L + "MB RAM => Launch " + nbThread + " thread(s)");
        this.context.info("Will use " + nbThread + " thread" + (nbThread > 1 ? "s" : ""));
        long sizeCache = 2L * size / 3L;
        this.context.setCache(new CacheFits(sizeCache));
        this.context.info("Available RAM: " + cds.tools.Util.getUnitDisk(size) + " => Cache size: " + cds.tools.Util.getUnitDisk(sizeCache));
        this.launchThreadBuilderHpx(nbThread);
        while (this.stillAlive()) {
            if (this.stopped) {
                this.destroyThreadBuilderHpx();
                return;
            }
            cds.tools.Util.pause(1000);
        }
        if (!this.context.isTaskAborting()) {
            if (ThreadBuilderTile.statMaxOverlays > 0) {
                this.context.info("Tile overlay stats : max overlays=" + ThreadBuilderTile.statMaxOverlays + ", " + ThreadBuilderTile.statOnePass + " in one step, " + ThreadBuilderTile.statMultiPass + " in multi steps");
            }
            Aladin.trace(3, "Cache FITS status: " + this.context.cacheFits);
            Aladin.trace(3, "Healpix survey build in " + cds.tools.Util.getTemps(System.currentTimeMillis() - t));
        }
        this.context.cacheFits.reset();
    }

    private Fits createHpx(ThreadBuilderTile hpx, String path, int order, long npix, int z) throws Exception {
        Fits oldOut;
        String file = Util.getFilePath(path, order, npix, z);
        if (this.stopped) {
            return null;
        }
        if (!this.context.isInMocTree(order, npix)) {
            return this.findLeaf(file);
        }
        if (this.coaddMode == Mode.KEEPTILE && (oldOut = this.findLeaf(file)) != null) {
            HealpixMoc moc = this.context.getRegion();
            moc = moc.intersection(new HealpixMoc(order + "/" + npix));
            int nbTiles = (int)moc.getUsedArea();
            this.updateStat(0, 0, nbTiles, 0L, nbTiles / 4, 0L);
            oldOut.releaseBitmap();
            return oldOut;
        }
        Fits f = null;
        if (order == this.ordermax) {
            try {
                f = this.createLeaveHpx(hpx, file, order, npix, z);
            }
            catch (Exception e) {
                System.err.println("BuilderTiles.createLeave error: " + file);
                e.printStackTrace();
                return null;
            }
        }
        Fits[] fils = new Fits[4];
        for (int i = 0; !this.stopped && i < 4; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            fils[i] = this.createHpx(hpx, path, order + 1, npix * 4L + (long)i, z);
        }
        try {
            f = this.createNodeHpx(file, path, order, npix, fils, z);
        }
        catch (Exception e) {
            System.err.println("BuilderTiles.createNodeHpx error: " + file);
            e.printStackTrace();
            return null;
        }
        if (f != null && f.isReleasable()) {
            f.releaseBitmap();
        }
        return f;
    }

    protected void setProgressBar(int npix) {
        this.context.setProgressLastNorder3(npix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MocCell getNextNpix() {
        MocCell pix = null;
        Object object = this.lockObj;
        synchronized (object) {
            if (!this.npixIterator.hasNext()) {
                return null;
            }
            pix = new MocCell(this.ordermin, this.npixIterator.next());
        }
        return pix;
    }

    private void launchThreadBuilderHpx(int nbThreads) throws Exception {
        this.initStat(nbThreads);
        this.context.createHealpixOrder(this.context.getTileOrder());
        ThreadBuilderTile.nbThreadRunning = nbThreads;
        ThreadBuilderTile.hashPolygon = new HashMap();
        for (int i = 0; i < nbThreads; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            ThreadBuilderTile threadBuilderTile = new ThreadBuilderTile(this.context, this);
            ThreadBuilder t = new ThreadBuilder("Builder" + i, threadBuilderTile);
            this.threadList.add(t);
            t.start();
        }
    }

    void destroyOneThreadBuilderHpx(ThreadBuilder x) {
    }

    void destroyThreadBuilderHpx() {
        Iterator<ThreadBuilder> it = this.threadList.iterator();
        while (it.hasNext()) {
            it.next().tue();
        }
    }

    int nbThreadRunning() {
        int n = 0;
        Iterator<ThreadBuilder> it = this.threadList.iterator();
        while (it.hasNext()) {
            if (!it.next().isExec()) continue;
            ++n;
        }
        return n;
    }

    boolean stillAlive() {
        Iterator<ThreadBuilder> it = this.threadList.iterator();
        while (it.hasNext()) {
            if (it.next().isDied()) continue;
            return true;
        }
        return false;
    }

    protected Fits createNodeHpx(String file, String path, int order, long npix, Fits[] fils, int z) throws Exception {
        Fits oldOut;
        long t = System.currentTimeMillis();
        int w = this.context.getTileSide();
        double[] px = new double[4];
        boolean inTree = this.context.isInMocTree(order, npix);
        if (!inTree || fils[0] == null && fils[1] == null && fils[2] == null && fils[3] == null) {
            if (this.isColor) {
                return null;
            }
            Fits f = this.findLeaf(file);
            this.addFits(Thread.currentThread(), f);
            return f;
        }
        for (Fits f : fils) {
            if (f == null) continue;
            f.reloadBitmap();
        }
        Fits out = new Fits(w, w, this.bitpix);
        if (!this.isColor) {
            out.setBlank(this.blank);
            out.setBzero(this.bzero);
            out.setBscale(this.bscale);
        }
        for (int dg = 0; dg < 2; ++dg) {
            for (int hb = 0; hb < 2; ++hb) {
                int quad = dg << 1 | hb;
                int offX = dg * w >>> 1;
                int offY = (1 - hb) * w >>> 1;
                Fits in = fils[quad];
                for (int y = 0; y < w; y += 2) {
                    for (int x = 0; x < w; x += 2) {
                        if (this.isColor) {
                            int pix = 0;
                            if (in != null) {
                                int alpha;
                                int p;
                                int gy;
                                int gx;
                                int i;
                                int nbPix;
                                if (this.method == Context.JpegMethod.MEAN) {
                                    int pixR = 0;
                                    int pixG = 0;
                                    int pixB = 0;
                                    nbPix = 0;
                                    for (i = 0; i < 4; ++i) {
                                        gx = i == 1 || i == 3 ? 1 : 0;
                                        p = in.getPixelRGBJPG(x + gx, y + (gy = i > 1 ? 1 : 0));
                                        alpha = p >> 24 & 0xFF;
                                        if (alpha == 0) continue;
                                        ++nbPix;
                                        pixR += p >> 16 & 0xFF;
                                        pixG += p >> 8 & 0xFF;
                                        pixB += p & 0xFF;
                                    }
                                    if (nbPix != 0) {
                                        pix = 0xFF000000 | pixR / nbPix << 16 | pixG / nbPix << 8 | pixB / nbPix;
                                    }
                                } else if (this.method == Context.JpegMethod.MEDIAN) {
                                    int[] pixR = new int[4];
                                    int[] pixG = new int[4];
                                    int[] pixB = new int[4];
                                    nbPix = 0;
                                    for (i = 0; i < 4; ++i) {
                                        gx = i == 1 || i == 3 ? 1 : 0;
                                        p = in.getPixelRGBJPG(x + gx, y + (gy = i > 1 ? 1 : 0));
                                        alpha = p >> 24 & 0xFF;
                                        if (alpha == 0) continue;
                                        ++nbPix;
                                        pixR[i] = p >> 16 & 0xFF;
                                        pixG[i] = p >> 8 & 0xFF;
                                        pixB[i] = p & 0xFF;
                                    }
                                    if (nbPix != 0) {
                                        int pR = pixR[0] > pixR[1] && (pixR[0] < pixR[2] || pixR[0] < pixR[3]) || pixR[0] < pixR[1] && (pixR[0] > pixR[2] || pixR[0] > pixR[3]) ? pixR[0] : (pixR[1] > pixR[0] && (pixR[1] < pixR[2] || pixR[1] < pixR[3]) || pixR[1] < pixR[0] && (pixR[1] > pixR[2] || pixR[1] > pixR[3]) ? pixR[1] : (pixR[2] > pixR[0] && (pixR[2] < pixR[1] || pixR[2] < pixR[3]) || pixR[2] < pixR[0] && (pixR[2] > pixR[1] || pixR[2] > pixR[3]) ? pixR[2] : pixR[3]));
                                        int pG = pixG[0] > pixG[1] && (pixG[0] < pixG[2] || pixG[0] < pixG[3]) || pixG[0] < pixG[1] && (pixG[0] > pixG[2] || pixG[0] > pixG[3]) ? pixG[0] : (pixG[1] > pixG[0] && (pixG[1] < pixG[2] || pixG[1] < pixG[3]) || pixG[1] < pixG[0] && (pixG[1] > pixG[2] || pixG[1] > pixG[3]) ? pixG[1] : (pixG[2] > pixG[0] && (pixG[2] < pixG[1] || pixG[2] < pixG[3]) || pixG[2] < pixG[0] && (pixG[2] > pixG[1] || pixG[2] > pixG[3]) ? pixG[2] : pixG[3]));
                                        int pB = pixB[0] > pixB[1] && (pixB[0] < pixB[2] || pixB[0] < pixB[3]) || pixB[0] < pixB[1] && (pixB[0] > pixB[2] || pixB[0] > pixB[3]) ? pixB[0] : (pixB[1] > pixB[0] && (pixB[1] < pixB[2] || pixB[1] < pixB[3]) || pixB[1] < pixB[0] && (pixB[1] > pixB[2] || pixB[1] > pixB[3]) ? pixB[1] : (pixB[2] > pixB[0] && (pixB[2] < pixB[1] || pixB[2] < pixB[3]) || pixB[2] < pixB[0] && (pixB[2] > pixB[1] || pixB[2] > pixB[3]) ? pixB[2] : pixB[3]));
                                        pix = 0xFF000000 | pR << 16 | pG << 8 | pB;
                                    }
                                } else {
                                    pix = in.getPixelRGBJPG(x, y);
                                }
                            }
                            out.setPixelRGBJPG(offX + (x >>> 1), offY + (y >>> 1), pix);
                            continue;
                        }
                        double pix = this.blank;
                        int nbPix = 0;
                        if (in != null) {
                            int i;
                            for (i = 0; i < 4; ++i) {
                                int gx = i == 1 || i == 3 ? 1 : 0;
                                int gy = i > 1 ? 1 : 0;
                                px[i] = in.getPixelDouble(x + gx, y + gy);
                                if (in.isBlankPixel(px[i])) continue;
                                ++nbPix;
                            }
                            if (nbPix == 0) {
                                pix = this.blank;
                            } else {
                                pix = 0.0;
                                for (i = 0; i < 4; ++i) {
                                    if (in.isBlankPixel(px[i])) continue;
                                    pix += px[i] / (double)nbPix;
                                }
                            }
                        }
                        out.setPixelDouble(offX + (x >>> 1), offY + (y >>> 1), pix);
                    }
                }
            }
        }
        if (!this.isColor && this.coaddMode != Mode.REPLACETILE && this.coaddMode != Mode.KEEPTILE && (oldOut = this.findLeaf(file)) != null) {
            out.mergeOnNaN(oldOut);
        }
        this.write(file, out);
        long duree = System.currentTimeMillis() - t;
        if (npix % 10L == 0L || DEBUG) {
            Aladin.trace(4, Thread.currentThread().getName() + ".createNodeHpx(" + order + "/" + npix + ") " + (Object)((Object)this.coaddMode) + " in " + duree + "ms");
        }
        this.updateStat(0, 0, 0, 0L, 1, duree);
        for (int i = 0; i < 4; ++i) {
            if (fils[i] == null) continue;
            this.rmFits(Thread.currentThread(), fils[i]);
            fils[i].free();
            fils[i] = null;
        }
        this.addFits(Thread.currentThread(), out);
        return out;
    }

    protected void write(String file, Fits out) throws Exception {
        String filename = file + this.context.getTileExt();
        if (this.isColor) {
            out.writeCompressed(filename, 0.0, 0.0, null, Constante.TILE_MODE[this.context.targetColorMode]);
        } else {
            out.writeFITS(filename);
        }
    }

    protected Fits createLeaveHpx(ThreadBuilderTile hpx, String file, int order, long npix, int z) throws Exception {
        long t = System.currentTimeMillis();
        Fits oldOut = null;
        boolean isInList = this.context.isInMoc(order, npix);
        if (!(isInList || this.coaddMode == Mode.REPLACETILE || (oldOut = this.findLeaf(file)) == null && this.context.isMocDescendant(order, npix))) {
            this.addFits(Thread.currentThread(), oldOut);
            return oldOut;
        }
        Fits out = hpx.buildHealpix(this, order, npix, z);
        if (out != null && this.coaddMode != Mode.REPLACETILE) {
            if (oldOut == null) {
                oldOut = this.findLeaf(file);
            }
            if (oldOut != null && this.coaddMode == Mode.KEEPTILE) {
                out = null;
                this.addFits(Thread.currentThread(), oldOut);
                return oldOut;
            }
            if (oldOut != null) {
                if (oldOut.bitpix > 0 && Double.isNaN(oldOut.blank)) {
                    oldOut.setBlank(this.blank);
                }
                if (this.coaddMode == Mode.AVERAGE) {
                    out.coadd(oldOut, true);
                } else if (this.coaddMode == Mode.ADD) {
                    out.coadd(oldOut, false);
                } else if (this.coaddMode == Mode.OVERWRITE) {
                    out.mergeOnNaN(oldOut);
                } else if (this.coaddMode == Mode.KEEP) {
                    oldOut.mergeOnNaN(out);
                    out = oldOut;
                    oldOut = null;
                }
            }
        }
        if (out != null) {
            this.write(file, out);
            long duree = System.currentTimeMillis() - t;
            this.updateStat(0, 1, 0, duree, 0, 0L);
        } else {
            long duree = System.currentTimeMillis() - t;
            this.updateStat(0, 0, 1, duree, 0, 0L);
        }
        this.addFits(Thread.currentThread(), out);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fits findLeaf(String file) throws Exception {
        String filename = file + this.context.getTileExt();
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        Fits out = new Fits();
        MyInputStream is = null;
        try {
            is = new MyInputStream(new FileInputStream(f));
            if (this.isColor) {
                out.loadPreview(is, true);
            } else {
                out.loadFITS(is);
            }
            out.setFilename(filename);
        }
        catch (Exception e) {
            Fits fits = null;
            return fits;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return out;
    }

    private class ThreadBuilder
    extends Thread {
        ThreadBuilderTile threadBuilderTile;
        static final int WAIT = 0;
        static final int EXEC = 1;
        static final int DIED = 3;
        private int mode;
        private boolean encore;

        public ThreadBuilder(String name, ThreadBuilderTile threadBuilderTile) {
            super(name);
            this.mode = 0;
            this.encore = true;
            this.threadBuilderTile = threadBuilderTile;
            Aladin.trace(3, "Creating " + this.getName());
        }

        public boolean isDied() {
            return this.mode == 3;
        }

        public boolean isExec() {
            return this.mode == 1;
        }

        public void tue() {
            this.encore = false;
        }

        @Override
        public void run() {
            MocCell cell;
            this.mode = 1;
            BuilderTiles.this.updateStat(1, 0, 0, 0L, 0, 0L);
            while (this.encore && (cell = BuilderTiles.this.getNextNpix()) != null) {
                this.mode = 1;
                try {
                    if (BuilderTiles.this.stopped || BuilderTiles.this.context.isTaskAborting()) break;
                    for (int z = 0; z < BuilderTiles.this.context.depth; ++z) {
                        BuilderTiles.this.createHpx(this.threadBuilderTile, BuilderTiles.this.context.getOutputPath(), cell.order, cell.npix, z);
                    }
                    if (cell.order != 3) continue;
                    BuilderTiles.this.setProgressBar((int)cell.npix);
                }
                catch (Throwable e) {
                    Aladin.trace(1, "*** " + Thread.currentThread().getName() + " exception !!! (" + e.getMessage() + ")");
                    e.printStackTrace();
                    BuilderTiles.this.context.taskAbort();
                }
            }
            BuilderTiles.this.updateStat(-1, 0, 0, 0L, 0, 0L);
            this.mode = 3;
            BuilderTiles.this.rmThread(Thread.currentThread());
        }
    }
}

