/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;

public class BuilderMoc
extends Builder {
    protected HealpixMoc moc;
    protected int mocOrder;
    protected int fileOrder;
    protected int tileOrder;
    protected boolean isMocHight;
    private String ext = null;
    long startTime = 0L;
    int nbTiles = -1;

    public BuilderMoc(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MOC;
    }

    @Override
    public void run() throws Exception {
        this.createMoc(this.context.getOutputPath());
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        if (!this.context.verifTileOrder()) {
            throw new Exception("Uncompatible tileOrder !");
        }
    }

    public HealpixMoc getMoc() {
        return this.moc;
    }

    protected void createMoc(String path) throws Exception {
        this.moc = new HealpixMoc();
        this.fileOrder = this.mocOrder = Util.getMaxOrderByPath(path);
        this.tileOrder = this.context.getTileOrder();
        boolean isLarge = true;
        try {
            if (this.context.mocIndex == null) {
                this.context.loadMocIndex();
            }
            isLarge = this.context.mocIndex.getCoverage() > 0.16666666666666666;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.context.getMocOrder() != -1) {
            this.mocOrder = this.context.getMocOrder();
        } else {
            if (this.mocOrder < 8 || !isLarge) {
                this.mocOrder = this.context.getOrder() + this.context.getTileOrder() - 4;
            }
            if (this.mocOrder < 8) {
                this.mocOrder = 8;
            }
        }
        if (this.mocOrder > this.tileOrder + this.fileOrder) {
            this.mocOrder = this.tileOrder + this.fileOrder;
        }
        if (this.context.isColor()) {
            this.mocOrder = this.fileOrder;
        }
        this.ext = this.getDefaultExt(path);
        if (this.ext != null) {
            this.context.info("MOC generation based on " + this.ext + " tiles");
        }
        this.isMocHight = this.mocOrder > this.fileOrder && this.ext != null && this.ext.equals("fits");
        this.moc.setMocOrder(this.mocOrder);
        String outputFile = path + cds.tools.Util.FS + "Moc.fits";
        long t = System.currentTimeMillis();
        this.context.info("MOC generation (" + (this.isMocHight ? "hight resolution" : "low resolution") + " mocOrder=" + this.moc.getMocOrder() + ")...");
        this.moc.setCoordSys(this.getFrame());
        this.moc.setCheckConsistencyFlag(false);
        this.generateMoc(this.moc, this.fileOrder, path);
        this.moc.setCheckConsistencyFlag(true);
        this.moc.write(outputFile);
        long time = System.currentTimeMillis() - t;
        this.context.info("MOC done in " + cds.tools.Util.getTemps(time, true) + ": mocOrder=" + this.moc.getMocOrder() + " size=" + cds.tools.Util.getUnitDisk(this.moc.getSize()));
    }

    private String getDefaultExt(String path) {
        if (new File(path + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky.fits").exists()) {
            return "fits";
        }
        if (new File(path + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky.jpg").exists()) {
            return "jpg";
        }
        if (new File(path + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky.png").exists()) {
            return "png";
        }
        return null;
    }

    private void initStat() {
        this.startTime = System.currentTimeMillis();
        this.nbTiles = 1;
    }

    private void updateStat() {
        ++this.nbTiles;
    }

    @Override
    public void showStatistics() {
        long now = System.currentTimeMillis();
        long cTime = now - this.startTime;
        if (cTime < 2000L) {
            return;
        }
        this.context.stat(this.nbTiles + " tile" + (this.nbTiles > 1 ? "s" : "") + " scanned in " + cds.tools.Util.getTemps(cTime));
    }

    public long getUsedArea() {
        return this.moc.getUsedArea();
    }

    public long getArea() {
        return this.moc.getArea();
    }

    protected void generateMoc(HealpixMoc moc, int fileOrder, String path) throws Exception {
        this.initStat();
        File f = new File(path + Util.FS + "Norder" + fileOrder);
        File[] sf = f.listFiles();
        if (sf == null || sf.length == 0) {
            throw new Exception("No tiles found !");
        }
        for (int i = 0; i < sf.length; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            if (!sf[i].isDirectory()) continue;
            File[] sf1 = sf[i].listFiles();
            for (int j = 0; j < sf1.length; ++j) {
                String file = sf1[j].getAbsolutePath();
                long npix = Util.getNpixFromPath(file);
                if (npix == -1L) continue;
                String e = this.getExt(file);
                if (this.ext == null) {
                    this.ext = e;
                } else if (!this.ext.equals(e)) continue;
                this.generateTileMoc(moc, sf1[j], fileOrder, npix);
            }
            moc.checkAndFix();
        }
    }

    private void generateTileMoc(HealpixMoc moc, File f, int fileOrder, long npix) throws Exception {
        this.updateStat();
        if (this.isMocHight) {
            this.generateHighTileMoc(moc, fileOrder, f, npix);
        } else {
            moc.add(fileOrder, npix);
        }
    }

    private void generateHighTileMoc(HealpixMoc moc, int fileOrder, File f, long npix) throws Exception {
        Fits fits = new Fits();
        MyInputStream dis = new MyInputStream(new FileInputStream(f));
        dis = dis.startRead();
        try {
            fits.loadFITS(dis);
        }
        catch (Exception e) {
            System.err.println("f=" + f.getAbsolutePath());
            throw e;
        }
        dis.close();
        long nside = fits.width;
        long min = nside * nside * npix;
        int mocOrder = moc.getMocOrder();
        int tileOrder = (int)CDSHealpix.log2(nside);
        int div = (fileOrder + tileOrder - mocOrder) * 2;
        this.context.createHealpixOrder(tileOrder);
        long oNpix = -1L;
        for (int y = 0; y < fits.height; ++y) {
            for (int x = 0; x < fits.width; ++x) {
                try {
                    double pixel;
                    npix = min + (long)this.context.xy2hpx(y * fits.width + x);
                    if ((npix >>>= div) == oNpix || fits.isBlankPixel(pixel = fits.getPixelDouble(x, y))) continue;
                    moc.add(mocOrder, npix);
                    oNpix = npix;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        moc.checkAndFix();
    }

    private String getExt(String file) {
        int offset = file.lastIndexOf(46);
        if (offset == -1) {
            return "";
        }
        int pos = file.indexOf(Util.FS, offset);
        if (pos != -1) {
            return "";
        }
        return file.substring(offset + 1, file.length());
    }
}

