/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.CanvasColorMap;
import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderTiles;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;
import cds.tools.Util;
import java.awt.image.IndexColorModel;

public class BuilderJpg
extends BuilderTiles {
    private double[] cut;
    protected byte[] tcm;
    private int bitpix;
    private int width;
    private double blank;
    private double bscale;
    private double bzero;
    private int statNbFile;
    protected String fmt;
    protected String ext;
    private boolean first = true;

    public BuilderJpg(Context context) {
        super(context);
        this.init();
    }

    protected void init() {
        this.fmt = "jpeg";
        this.ext = ".jpg";
    }

    @Override
    public Action getAction() {
        return Action.JPEG;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        if (!this.context.isExistingAllskyDir()) {
            throw new Exception("No Fits tile found");
        }
        this.validateOrder(this.context.getOutputPath());
        if (!this.context.isColor()) {
            this.validateCut();
        }
        try {
            this.context.loadMoc();
        }
        catch (Exception e) {
            this.context.warning("Tile MOC not found => use index MOC");
        }
        if (!this.context.hasFrame()) {
            this.context.setFrameName(this.getFrame());
        }
        this.context.initRegion();
    }

    protected int getMinCM() {
        return 0;
    }

    @Override
    public void run() throws Exception {
        IndexColorModel cm = this.context.getFct() == null ? null : CanvasColorMap.getCM(0, 128, 255, false, 0, this.context.getFct().code());
        this.tcm = cm == null ? null : Util.getTableCM(cm, 2);
        this.cut = this.context.getCut();
        double bz = this.context.bzero;
        double bs = this.context.bscale;
        this.context.info("Map pixel cut [" + this.ip(this.cut[0], bz, bs) + " .. " + this.ip(this.cut[1], bz, bs) + "] to [" + this.getMinCM() + "..255] (" + this.context.getTransfertFct() + ")");
        this.context.info("Tile aggregation method=" + (Object)((Object)this.context.getJpegMethod()));
        this.build();
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).runJpegOrPngOnly(this.fmt);
            if (this.context instanceof ContextGui && ((ContextGui)this.context).mainPanel.planPreview != null) {
                if (this.fmt.equals("jpeg")) {
                    ((ContextGui)this.context).mainPanel.planPreview.inJPEG = true;
                } else {
                    ((ContextGui)this.context).mainPanel.planPreview.inPNG = true;
                }
            }
        }
    }

    @Override
    public boolean isAlreadyDone() {
        if (this.context.isColor()) {
            this.context.info("Jpeg conversion not required for Healpix colored survey");
            return true;
        }
        if (!this.context.actionPrecedeAction(Action.INDEX, Action.TILES)) {
            return false;
        }
        if (!this.context.actionPrecedeAction(Action.TILES, this.getAction())) {
            return false;
        }
        this.context.info("Pre-existing HEALPix JPEG survey seems to be ready");
        return true;
    }

    @Override
    public void showStatistics() {
        this.context.showJpgStat(this.statNbFile, this.totalTime, this.statNbThread, this.statNbThreadRunning);
        if (!(this.context instanceof ContextGui)) {
            super.showStatistics();
        }
    }

    @Override
    public void build() throws Exception {
        this.initStat();
        super.build();
    }

    @Override
    protected Fits createLeaveHpx(ThreadBuilderTile hpx, String file, int order, long npix, int z) throws Exception {
        Fits out = this.createLeaveJpg(file);
        if (out == null) {
            return null;
        }
        out.writeCompressed(file + this.ext, this.cut[0], this.cut[1], this.tcm, this.fmt);
        this.updateStat();
        return out;
    }

    @Override
    protected Fits createNodeHpx(String file, String path, int order, long npix, Fits[] fils, int z) throws Exception {
        Context.JpegMethod method = this.context.getJpegMethod();
        Fits out = this.createNodeJpg(fils, method);
        if (out == null) {
            return null;
        }
        out.writeCompressed(file + this.ext, this.cut[0], this.cut[1], this.tcm, this.fmt);
        return out;
    }

    @Override
    protected void setProgressBar(int npix) {
        this.context.setProgress(npix);
    }

    private void initStat() {
        this.context.setProgressMax(768.0);
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    private Fits createLeaveJpg(String file) throws Exception {
        Fits out = null;
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        try {
            out = new Fits();
            out.loadFITS(file + ".fits");
            if (this.first) {
                this.first = false;
                this.setConstantes(out);
            }
        }
        catch (Exception e) {
            out = null;
        }
        return out;
    }

    private void setConstantes(Fits f) {
        this.bitpix = f.bitpix;
        this.blank = f.blank;
        this.bscale = f.bscale;
        this.bzero = f.bzero;
        this.width = f.width;
    }

    private Fits createNodeJpg(Fits[] fils, Context.JpegMethod method) throws Exception {
        if (this.width == 0 || fils[0] == null && fils[1] == null && fils[2] == null && fils[3] == null) {
            return null;
        }
        Fits out = new Fits(this.width, this.width, this.bitpix);
        out.setBlank(this.blank);
        out.setBscale(this.bscale);
        out.setBzero(this.bzero);
        double[] p = new double[4];
        double[] coef = new double[4];
        for (int dg = 0; dg < 2; ++dg) {
            for (int hb = 0; hb < 2; ++hb) {
                int quad = dg << 1 | hb;
                Fits in = fils[quad];
                int offX = dg * this.width / 2;
                int offY = (1 - hb) * this.width / 2;
                for (int y = 0; y < this.width; y += 2) {
                    for (int x = 0; x < this.width; x += 2) {
                        double pix = this.blank;
                        if (in != null) {
                            if (method == Context.JpegMethod.MEAN) {
                                int i;
                                double totalCoef = 0.0;
                                for (i = 0; i < 4; ++i) {
                                    int dx = i == 1 || i == 3 ? 1 : 0;
                                    int dy = i >= 2 ? 1 : 0;
                                    p[i] = in.getPixelDouble(x + dx, y + dy);
                                    coef[i] = in.isBlankPixel(p[i]) ? 0.0 : 1.0;
                                    totalCoef += coef[i];
                                }
                                if (totalCoef != 0.0) {
                                    pix = 0.0;
                                    for (i = 0; i < 4; ++i) {
                                        if (coef[i] == 0.0) continue;
                                        pix += p[i] * (coef[i] / totalCoef);
                                    }
                                }
                            } else {
                                double p4;
                                double p3;
                                double p2;
                                double p1 = in.getPixelDouble(x, y);
                                if (in.isBlankPixel(p1)) {
                                    p1 = Double.NaN;
                                }
                                if (in.isBlankPixel(p2 = in.getPixelDouble(x + 1, y))) {
                                    p1 = Double.NaN;
                                }
                                if (in.isBlankPixel(p3 = in.getPixelDouble(x, y + 1))) {
                                    p1 = Double.NaN;
                                }
                                if (in.isBlankPixel(p4 = in.getPixelDouble(x + 1, y + 1))) {
                                    p1 = Double.NaN;
                                }
                                pix = p1 > p2 && (p1 < p3 || p1 < p4) || p1 < p2 && (p1 > p3 || p1 > p4) ? p1 : (p2 > p1 && (p2 < p3 || p2 < p4) || p2 < p1 && (p2 > p3 || p2 > p4) ? p2 : (p3 > p1 && (p3 < p2 || p3 < p4) || p3 < p1 && (p3 > p2 || p3 > p4) ? p3 : p4));
                            }
                        }
                        out.setPixelDouble(offX + x / 2, offY + y / 2, pix);
                    }
                }
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (fils[i] == null) continue;
            fils[i].free();
        }
        return out;
    }
}

