/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderMocIndex;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.fits.Fits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class BuilderIndex
extends Builder {
    private int[] borderSize = new int[]{0, 0, 0, 0};
    private String currentfile = null;
    private boolean partitioning;
    private double maxRatio;
    private int[] hdu = null;
    private int statNbFile;
    private int statNbZipFile;
    private int statBlocFile;
    private long statMemFile;
    private long statPixSize;
    private long statMaxSize;
    private long statTime;
    private int statMaxWidth;
    private int statMaxHeight;
    private int statMaxDepth;
    private int statMaxNbyte;
    boolean stopped = false;
    private ArrayList<String> badFiles = null;

    public BuilderIndex(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.INDEX;
    }

    @Override
    public void run() throws Exception {
        this.build();
        this.report();
        this.context.writeHpxFinderProperties();
        BuilderMocIndex builderMocIndex = new BuilderMocIndex(this.context);
        builderMocIndex.run();
        this.context.setMocIndex(builderMocIndex.getMoc());
    }

    private void addBadFile(String file, String error) {
        if (this.badFiles == null) {
            this.badFiles = new ArrayList();
        }
        this.badFiles.add(file + (error != null && error.length() > 0 ? " => " + error : ""));
    }

    private void report() throws Exception {
        if (this.badFiles != null) {
            int n = this.badFiles.size();
            this.context.warning("Index report: " + n + " input file" + (n > 1 ? "s" : "") + " not incorporated:");
            for (String s : this.badFiles) {
                this.context.warning("   " + s);
            }
        }
        if (this.statNbFile == 0) {
            throw new Exception("No available image found ! => Aborted");
        }
    }

    @Override
    public boolean isAlreadyDone() {
        if (!this.context.isExistingIndexDir()) {
            return false;
        }
        if (!this.context.actionAlreadyDone(Action.INDEX)) {
            return false;
        }
        if (this.context.getMocIndex() == null) {
            try {
                this.context.loadMocIndex();
            }
            catch (Exception e) {
                return false;
            }
        }
        this.context.info("Pre-existing HEALPix index seems to be ready");
        return true;
    }

    @Override
    public void validateContext() throws Exception {
        if (this.context instanceof ContextGui) {
            this.context.setProgressBar(((ContextGui)this.context).mainPanel.getProgressBarIndex());
        }
        this.partitioning = this.context.partitioning;
        if (this.partitioning) {
            this.context.info("Partitioning large original image files in blocks of 1024x1024 pixels");
        }
        this.validateInput();
        this.validateOutput();
        this.validateLabel();
        int order = this.context.getOrder();
        if (order == -1) {
            String img = this.context.getImgEtalon();
            if (img == null && (img = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                this.context.info("Use this reference image => " + img);
            }
            if (img == null) {
                throw new Exception("No source image found in " + this.context.getInputPath());
            }
            try {
                Fits file = new Fits();
                file.loadHeaderFITS(img);
                long nside = BuilderIndex.calculateNSide(file.getCalib().GetResol()[0] * 3600.0);
                order = Util.order((int)nside) - this.context.getTileOrder();
                if (order < 3) {
                    order = 3;
                }
                this.context.setOrder(order);
            }
            catch (Exception e) {
                this.context.warning("The reference image has no astrometrical calibration [" + img + "] => order can not be computed");
            }
        }
        if (order == -1) {
            throw new Exception("Argument \"order\" is required");
        }
        if (order < this.context.getOrder()) {
            this.context.warning("The provided order [" + order + "] is less than the optimal order [" + this.context.getOrder() + "] => OVER-sample will be applied");
        } else if (order > this.context.getOrder()) {
            this.context.warning("The provided order [" + order + "] is greater than the optimal order [" + this.context.getOrder() + "] => SUB-sample will be applied");
        } else {
            this.context.info("Order=" + this.context.getOrder() + " => PixelAngularRes=" + Coord.getUnit(CDSHealpix.pixRes(CDSHealpix.pow2(this.context.getOrder() + this.context.getTileOrder())) / 3600.0));
        }
        int w = this.context.getTileSide();
        this.context.info("TileOrder=" + this.context.getTileOrder() + " => tileSize=" + w + "x" + w + " pixels");
        this.hdu = this.context.getHDU();
        if (this.hdu == null) {
            this.context.info("MEF stategy => extension 0, otherwise 1");
        } else if (this.hdu.length > 0 && this.hdu[0] == -1) {
            this.context.info("MEF stategy => all images found in the MEF");
        } else {
            StringBuilder s = new StringBuilder("MEF stategy: extensions ");
            for (int i = 0; i < this.hdu.length; ++i) {
                if (i > 0) {
                    s.append(',');
                }
                s.append(this.hdu[i] + "");
            }
            this.context.info(s + "");
        }
        if (this.context.fitsKeys != null) {
            StringBuilder res = null;
            for (String key : this.context.fitsKeys) {
                if (res == null) {
                    res = new StringBuilder();
                } else {
                    res.append(", ");
                }
                res.append(key);
            }
            this.context.info("Extended metadata extraction based on FITS keys: " + res);
        }
    }

    public static int calculateNSide(double pixsize) {
        double arcsec2rad = 4.84813681109536E-6;
        double nsd = Math.sqrt(1.0471975511965976) / (arcsec2rad * pixsize);
        int order_req = Math.max(0, Math.min(29, 1 + (int)CDSHealpix.log2((long)nsd)));
        return 1 << order_req;
    }

    @Override
    public void showStatistics() {
        if (this.statNbFile <= 0) {
            return;
        }
        long statDuree = System.currentTimeMillis() - this.statTime;
        this.context.showIndexStat(this.statNbFile, this.statBlocFile, this.statNbZipFile, this.statMemFile, this.statPixSize, this.statMaxSize, this.statMaxWidth, this.statMaxHeight, this.statMaxDepth, this.statMaxNbyte, statDuree);
    }

    private boolean build() throws Exception {
        this.initStat();
        String input = this.context.getInputPath();
        String output = this.context.getOutputPath();
        int order = this.context.getOrder();
        this.borderSize = this.context.getBorderSize();
        this.maxRatio = this.context.getMaxRatio();
        File f = new File(output);
        if (!f.exists()) {
            f.mkdir();
        }
        String pathDest = this.context.getHpxFinderPath();
        this.create(input, pathDest, order);
        return true;
    }

    private void initStat() {
        this.statBlocFile = 0;
        this.statNbZipFile = 0;
        this.statNbFile = 0;
        this.statMemFile = 0L;
        this.statPixSize = 0L;
        this.statMaxSize = -1L;
        this.statTime = System.currentTimeMillis();
    }

    private void updateStat(File f, int code, int width, int height, int depth, int nbyte, int deltaBlocFile) {
        ++this.statNbFile;
        this.statBlocFile += deltaBlocFile;
        if ((code & 1) != 0) {
            ++this.statNbZipFile;
        }
        long size = f.length();
        this.statPixSize += (long)(width * height * depth);
        this.statMemFile += size;
        if (this.statMaxSize < size) {
            this.statMaxSize = size;
            this.statMaxWidth = width;
            this.statMaxHeight = height;
            this.statMaxDepth = depth;
            this.statMaxNbyte = nbyte;
        }
    }

    private FileOutputStream openFile(String filename) throws Exception {
        File f = new File(filename);
        if (!f.exists()) {
            cds.tools.Util.createPath(filename);
            return new FileOutputStream(f);
        }
        return new FileOutputStream(f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAFile(FileOutputStream out, String filename, Coord center, String stc, String fitsVal) throws IOException {
        int o3;
        int o1 = filename.lastIndexOf(47);
        int o1b = filename.lastIndexOf(92);
        if (o1b > o1) {
            o1 = o1b;
        }
        int o2 = filename.lastIndexOf(46);
        int n = o3 = filename.charAt(filename.length() - 1) == ']' ? filename.lastIndexOf(91) : -1;
        if (o3 > o2) {
            o2 = o3;
        }
        if (o2 == -1 || o2 <= o1) {
            o2 = filename.length();
        }
        String name = filename.substring(o1 + 1, o2);
        if (fitsVal == null) {
            fitsVal = "";
        }
        DataOutputStream dataoutputstream = null;
        try {
            dataoutputstream = new DataOutputStream(out);
            dataoutputstream.writeBytes("{ \"name\": \"" + name + "\", \"path\": \"" + filename + "\", " + "\"ra\": \"" + center.al + "\", \"dec\": \"" + center.del + "\", " + "\"stc\": \"" + stc + "\"" + fitsVal + " }\n");
            dataoutputstream.flush();
        }
        finally {
            if (dataoutputstream != null) {
                dataoutputstream.close();
            }
        }
    }

    private void create(String pathSource, String pathDest, int order) throws Exception {
        File[] list;
        File[] fileArray;
        File main = new File(pathSource);
        ArrayList<File> dir = new ArrayList<File>();
        if (this.context.isInputFile) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = main;
        } else {
            fileArray = list = main.listFiles();
        }
        if (list == null) {
            return;
        }
        int i = 0;
        this.context.setProgress(0.0, list.length - 1);
        block6: for (File file : list) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            this.context.setProgress(i++);
            if (file.isDirectory()) {
                dir.add(file);
                continue;
            }
            this.currentfile = file.getPath();
            Fits fitsfile = new Fits();
            boolean flagDefaultHDU = this.hdu == null;
            boolean flagAllHDU = this.hdu != null && this.hdu.length > 0 && this.hdu[0] == -1;
            int cellSize = 1024;
            int firstDepth = 0;
            for (int j = 0; flagAllHDU || flagDefaultHDU || j < this.hdu.length; ++j) {
                block22: {
                    int ext = flagDefaultHDU ? 0 : (flagAllHDU ? j : this.hdu[j]);
                    try {
                        int code = fitsfile.loadHeaderFITS(this.currentfile + (ext == 0 ? "" : "[" + ext + "]"));
                        if (flagAllHDU && (code & 0x10) != 0) continue;
                        if (fitsfile.calib == null) {
                            if (!flagDefaultHDU) continue;
                            continue block6;
                        }
                        if (firstDepth == 0) {
                            firstDepth = fitsfile.depth;
                        } else if (fitsfile.depth != firstDepth) continue;
                        Aladin.trace(4, "HiPS indexing " + this.currentfile + (ext == 0 ? "" : "[" + ext + "]..."));
                        try {
                            if (!this.partitioning) {
                                this.testAndInsert(fitsfile, pathDest, this.currentfile, null, order);
                                this.updateStat(file, code, fitsfile.width, fitsfile.height, fitsfile.depth, fitsfile.bitpix == 0 ? 4 : Math.abs(fitsfile.bitpix) / 8, 0);
                            } else {
                                int width = fitsfile.width - this.borderSize[3];
                                int height = fitsfile.height - this.borderSize[2];
                                for (int x = this.borderSize[1]; x < width; x += cellSize) {
                                    for (int y = this.borderSize[0]; y < height; y += cellSize) {
                                        fitsfile.widthCell = x + cellSize > width ? width - x : cellSize;
                                        fitsfile.heightCell = y + cellSize > height ? height - y : cellSize;
                                        fitsfile.depth = 1;
                                        fitsfile.depthCell = 1;
                                        fitsfile.xCell = x;
                                        fitsfile.yCell = y;
                                        fitsfile.zCell = 0;
                                        fitsfile.ext = ext;
                                        String currentCell = fitsfile.getCellSuffix();
                                        this.testAndInsert(fitsfile, pathDest, this.currentfile, currentCell, order);
                                    }
                                }
                                this.updateStat(file, code, width, height, fitsfile.depth, fitsfile.bitpix == 0 ? 4 : Math.abs(fitsfile.bitpix) / 8, 1);
                            }
                            break block22;
                        }
                        catch (Exception e1) {
                            this.addBadFile(this.currentfile, e1.getMessage());
                        }
                    }
                    catch (Exception e) {
                        Aladin.trace(3, e.getMessage() + " " + this.currentfile);
                    }
                    continue block6;
                }
                if (flagDefaultHDU) continue block6;
            }
        }
        list = null;
        if (dir.size() > 0) {
            for (File f1 : dir) {
                if (!f1.isDirectory()) continue;
                this.currentfile = f1.getPath();
                try {
                    this.create(this.currentfile, pathDest, order);
                }
                catch (Exception e) {
                    Aladin.trace(3, e.getMessage() + " " + this.currentfile);
                }
            }
        }
    }

    private void testAndInsert(Fits fitsfile, String pathDest, String currentFile, String suffix, int order) throws Exception {
        Coord center = new Coord();
        String fitsVal = null;
        Calib c = fitsfile.getCalib();
        ArrayList<double[]> cooList = new ArrayList<double[]>(4);
        Coord coo = new Coord();
        Coord[] corner = new Coord[4];
        StringBuffer stc = new StringBuffer("POLYGON J2000");
        boolean hasCell = fitsfile.hasCell();
        for (int i = 0; i < 4; ++i) {
            coo.x = i == 0 || i == 3 ? fitsfile.xCell : fitsfile.xCell + fitsfile.widthCell;
            coo.y = i < 2 ? fitsfile.yCell : fitsfile.yCell + fitsfile.heightCell;
            coo.y = (double)fitsfile.height - coo.y - 1.0;
            c.GetCoord(coo);
            cooList.add(this.context.ICRS2galIfRequired(coo.al, coo.del));
            if (hasCell) {
                coo.x = i == 0 || i == 3 ? 0 : fitsfile.width;
                coo.y = i < 2 ? 0 : fitsfile.height;
                coo.y = (double)fitsfile.height - coo.y - 1.0;
                c.GetCoord(coo);
            }
            stc.append(" " + coo.al + " " + coo.del);
            corner[i] = new Coord(coo.al, coo.del);
        }
        if (this.maxRatio > 0.0) {
            double w = Coord.getDist(corner[0], corner[1]) / (double)fitsfile.width;
            double h = Coord.getDist(corner[1], corner[2]) / (double)fitsfile.height;
            if (h > w * this.maxRatio || w > h * this.maxRatio) {
                throw new Exception("Suspicious image calibration (pixel size=" + Coord.getUnit(w) + "x" + Coord.getUnit(h) + ")");
            }
        }
        center.x = fitsfile.width / 2;
        center.y = fitsfile.height / 2;
        center.y = (double)fitsfile.height - center.y - 1.0;
        c.GetCoord(center);
        if (this.context.fitsKeys != null) {
            StringBuilder res = null;
            for (String key : this.context.fitsKeys) {
                String val = fitsfile.headerFits.getStringFromHeader(key);
                if (val == null && (fitsfile.headerFits0 == null || fitsfile.headerFits0 != null && (val = fitsfile.headerFits0.getStringFromHeader(key)) == null)) continue;
                if (res == null) {
                    res = new StringBuilder();
                }
                res.append(", \"" + key + "\": \"" + val.replace("\"", "\\\"") + "\"");
            }
            if (res != null) {
                fitsVal = res.toString();
            }
        }
        long[] npixs = CDSHealpix.query_polygon(CDSHealpix.pow2(order), cooList);
        for (int i = 0; i < npixs.length; ++i) {
            long npix = npixs[i];
            if (!this.isInImage(fitsfile, Util.getCorners(order, npix))) continue;
            String hpxname = cds.tools.Util.concatDir(pathDest, Util.getFilePath("", order, npix));
            FileOutputStream out = this.openFile(hpxname);
            String filename = currentFile + (suffix == null ? "" : suffix);
            this.createAFile(out, filename, center, stc.toString(), fitsVal);
            out.close();
        }
    }

    private boolean isInImage(Fits f, Coord[] corners) {
        int signeX = 0;
        int signeY = 0;
        try {
            int marge = 2;
            for (int i = 0; i < corners.length; ++i) {
                Coord coo = corners[i];
                if (this.context.getFrame() != 0) {
                    double[] radec = this.context.gal2ICRSIfRequired(coo.al, coo.del);
                    coo.al = radec[0];
                    coo.del = radec[1];
                }
                f.getCalib().GetXY(coo);
                if (Double.isNaN(coo.x)) continue;
                coo.y = (double)f.height - coo.y - 1.0;
                int width = f.widthCell + marge;
                int height = f.heightCell + marge;
                if (coo.x >= (double)(f.xCell - marge) && coo.x < (double)(f.xCell + width) && coo.y >= (double)(f.yCell - marge) && coo.y < (double)(f.yCell + height)) {
                    return true;
                }
                signeX += coo.x >= (double)(f.xCell + width) ? 1 : (coo.x < (double)(f.xCell - marge) ? -1 : 0);
                signeY += coo.y >= (double)(f.yCell + height) ? 1 : (coo.y < (double)(f.yCell - marge) ? -1 : 0);
            }
        }
        catch (Exception e) {
            return false;
        }
        return Math.abs(signeX) != Math.abs(corners.length) && Math.abs(signeY) != Math.abs(corners.length);
    }
}

