/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.moc.Healpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class BuilderGzip
extends Builder {
    private int nbFile = 0;

    public BuilderGzip(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.GZIP;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.validateDepth();
    }

    @Override
    public void run() throws Exception {
        this.gzipRec(true);
    }

    @Override
    public boolean isAlreadyDone() {
        if (!this.context.actionPrecedeAction(Action.INDEX, Action.TILES)) {
            return false;
        }
        if (!this.context.actionPrecedeAction(Action.TILES, Action.GZIP)) {
            return false;
        }
        if (this.context.actionAlreadyDone(Action.GUNZIP) && !this.context.actionPrecedeAction(Action.GZIP, Action.GUNZIP)) {
            return false;
        }
        this.context.info("GZIP seems to be already done");
        return true;
    }

    protected void gzipRec(boolean compress) throws Exception {
        String path = this.context.getOutputPath();
        int maxOrder = Util.getMaxOrderByPath(path);
        for (File nOrder : new File(path).listFiles()) {
            int order;
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            String name = nOrder.getName();
            if (!name.startsWith("Norder") || !nOrder.isDirectory()) continue;
            try {
                order = Integer.parseInt(name.substring(6));
            }
            catch (Exception e) {
                continue;
            }
            for (int z = 0; z < this.context.depth; ++z) {
                String allsky;
                if (order == 3 && new File(allsky = path + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky" + (z == 0 ? "" : "_" + z) + ".fits").isFile()) {
                    this.gzip(allsky, compress);
                    ++this.nbFile;
                }
                if (compress && (order > 5 || order == maxOrder)) continue;
                long maxNpix = Healpix.pow2(order);
                maxNpix = 12L * maxNpix * maxNpix;
                for (long npix = 0L; npix < maxNpix; ++npix) {
                    String filename = Util.getFilePath(path, order, npix, z) + ".fits";
                    if (!new File(filename).isFile()) continue;
                    this.gzip(filename, compress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gzip(String file, boolean compress) throws Exception {
        MyInputStream mis = null;
        OutputStream mos = null;
        OutputStream fos = null;
        try {
            int n;
            String outFile;
            File out;
            File in = new File(file);
            if (!in.isFile()) {
                throw new Exception(file + " does not exist !");
            }
            mis = new MyInputStream(new FileInputStream(in));
            if (compress) {
                if (mis.isGZ()) {
                    throw new Exception(file + " already gzipped");
                }
            } else {
                if (!mis.isGZ()) {
                    throw new Exception(file + " not gzipped");
                }
                mis = mis.startRead();
            }
            if ((out = new File(outFile = file + ".tmp")).isFile()) {
                out.delete();
            }
            fos = new FileOutputStream(outFile);
            mos = compress ? new GZIPOutputStream(fos) : fos;
            byte[] buf = new byte[8192];
            while ((n = mis.read(buf)) >= 0) {
                mos.write(buf, 0, n);
                if (!this.context.isTaskAborting()) continue;
            }
            if (this.context.isTaskAborting()) {
                out.delete();
            } else {
                in.delete();
                out.renameTo(in);
                ++this.nbFile;
                if (this.context != null) {
                    this.context.setProgress(this.nbFile);
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            if (mis != null) {
                mis.close();
            }
            if (mos != null) {
                mos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
    }
}

