/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Constante;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.tools.Util;
import java.io.File;

public class BuilderCheck
extends Builder {
    private static final String fileIn = "fileIn.log";
    private static final String fileErr = "fileErr.log";

    protected BuilderCheck(Context context) {
        super(context);
    }

    @Override
    public void validateContext() throws Exception {
        this.validateInput();
    }

    @Override
    public void run() throws Exception {
        this.context.info("Check your input files...");
        String pathSource = this.context.getInputPath();
        String readFiles = "";
        String errFiles = "";
        this.testReadFiles(pathSource, readFiles, errFiles);
        this.context.done("Read files are listed in : fileIn.log");
        this.context.done("Erroneous files are listed in : fileErr.log");
    }

    private void testReadFiles(String pathSource, String readFiles, String errFiles) {
        File main = new File(pathSource);
        String currentpath = pathSource;
        String[] list = main.list();
        for (int f = 0; f < list.length; ++f) {
            String currentfile = pathSource + Util.FS + list[f];
            File file = new File(currentfile);
            if (file.isDirectory() && !list[f].equals(Constante.SURVEY)) {
                this.testReadFiles(currentfile, readFiles, errFiles);
                currentpath = pathSource;
                continue;
            }
            Fits fitsfile = new Fits();
            try {
                fitsfile.loadFITS(currentfile);
                readFiles = readFiles + currentfile;
                continue;
            }
            catch (Exception e) {
                errFiles = errFiles + currentfile;
            }
        }
    }

    @Override
    public Action getAction() {
        return null;
    }
}

