/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyProperties;
import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderCheck;
import cds.allsky.BuilderClean;
import cds.allsky.BuilderCleanDetails;
import cds.allsky.BuilderCleanFits;
import cds.allsky.BuilderCleanIndex;
import cds.allsky.BuilderCleanJpg;
import cds.allsky.BuilderCleanPng;
import cds.allsky.BuilderCleanTiles;
import cds.allsky.BuilderConcat;
import cds.allsky.BuilderCube;
import cds.allsky.BuilderDetails;
import cds.allsky.BuilderGunzip;
import cds.allsky.BuilderGzip;
import cds.allsky.BuilderIndex;
import cds.allsky.BuilderJpg;
import cds.allsky.BuilderMapTiles;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderMocIndex;
import cds.allsky.BuilderPng;
import cds.allsky.BuilderRgb;
import cds.allsky.BuilderTiles;
import cds.allsky.BuilderTree;
import cds.allsky.BuilderUpdate;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.fits.Fits;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;

public abstract class Builder {
    protected Context context;

    protected Builder(Context context) {
        this.context = context;
    }

    public static Builder createBuilder(Context context, Action action) throws Exception {
        switch (action) {
            case INDEX: {
                return new BuilderIndex(context);
            }
            case TILES: {
                return new BuilderTiles(context);
            }
            case ALLSKY: {
                return new BuilderAllsky(context);
            }
            case JPEG: {
                return new BuilderJpg(context);
            }
            case PNG: {
                return new BuilderPng(context);
            }
            case MOC: {
                return new BuilderMoc(context);
            }
            case MOCINDEX: {
                return new BuilderMocIndex(context);
            }
            case CLEAN: {
                return new BuilderClean(context);
            }
            case CLEANINDEX: {
                return new BuilderCleanIndex(context);
            }
            case CLEANDETAILS: {
                return new BuilderCleanDetails(context);
            }
            case CLEANTILES: {
                return new BuilderCleanTiles(context);
            }
            case CLEANFITS: {
                return new BuilderCleanFits(context);
            }
            case CLEANJPEG: {
                return new BuilderCleanJpg(context);
            }
            case CLEANPNG: {
                return new BuilderCleanPng(context);
            }
            case CHECK: {
                return new BuilderCheck(context);
            }
            case GZIP: {
                return new BuilderGzip(context);
            }
            case GUNZIP: {
                return new BuilderGunzip(context);
            }
            case RGB: {
                return new BuilderRgb(context);
            }
            case TREE: {
                return new BuilderTree(context);
            }
            case CONCAT: {
                return new BuilderConcat(context);
            }
            case CUBE: {
                return new BuilderCube(context);
            }
            case DETAILS: {
                return new BuilderDetails(context);
            }
            case MAPTILES: {
                return new BuilderMapTiles(context);
            }
            case UPDATE: {
                return new BuilderUpdate(context);
            }
        }
        throw new Exception("No builder associated to this action");
    }

    public abstract void validateContext() throws Exception;

    public boolean isAlreadyDone() {
        return false;
    }

    public abstract void run() throws Exception;

    public abstract Action getAction();

    public void showStatistics() {
    }

    public boolean isFake() {
        if (!this.context.fake) {
            return false;
        }
        this.context.info("Action " + (Object)((Object)this.getAction()) + " not run due to the -n option");
        return true;
    }

    protected void validateInput() throws Exception {
        if (this.context.isValidateInput()) {
            return;
        }
        String input = this.context.getInputPath();
        if (input == null) {
            throw new Exception("Argument \"input\" is required");
        }
        File f = new File(input);
        if (!f.canRead()) {
            throw new Exception("Input not available [" + input + "]");
        }
        if (f.isFile()) {
            this.context.info("Unique input image detected");
            this.context.setFlagInputFile(true);
        }
        this.context.setValidateInput(true);
    }

    protected void validateOutput() throws Exception {
        File f;
        if (this.context.isValidateOutput()) {
            return;
        }
        String output = this.context.getOutputPath();
        if (output == null) {
            output = this.context.getInputPath() + "HiPS";
            this.context.setOutputPath(output);
            this.context.info("the output directory will be " + output);
        }
        if (!(!(f = new File(output)).exists() || f.isDirectory() && f.canWrite() && f.canRead())) {
            throw new Exception("Ouput directory not available [" + output + "]");
        }
        this.context.setValidateOutput(true);
    }

    protected void validateOrder(String path) throws Exception {
        int order = this.context.getOrder();
        int orderIndex = Util.getMaxOrderByPath(path);
        if (order == -1 || this.context instanceof ContextGui) {
            this.context.info("Order retrieved from [" + path + "] => " + orderIndex);
            this.context.setOrder(orderIndex);
        } else if (orderIndex != -1 && order != orderIndex) {
            throw new Exception("Detected order [" + orderIndex + "] does not correspond to the param order [" + order + "]");
        }
    }

    protected void validateDepth() throws Exception {
        String s;
        if (this.context.depthInit) {
            return;
        }
        String img = this.context.getImgEtalon();
        if (img == null && this.context.getInputPath() != null && (img = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
            this.context.info("Use this reference image => " + img);
        }
        if (img != null) {
            try {
                this.context.setImgEtalon(img);
            }
            catch (Exception e) {
                this.context.warning("Reference image problem [" + img + "] => " + e.getMessage());
            }
        }
        if (!this.context.depthInit) {
            try {
                int depth;
                this.context.loadProperties();
                s = this.context.prop.getProperty("hips_cube_depth");
                if (s == null) {
                    s = this.context.prop.getProperty("cubeDepth");
                }
                if (s != null && (depth = Integer.parseInt(s)) > 1) {
                    this.context.setDepth(depth);
                }
            }
            catch (Exception e) {
                this.context.warning("Propertie file problem => " + e.getMessage());
            }
        }
        if (this.context.depthInit && this.context.depth > 1) {
            s = "";
            if (this.context.isCubeCanal()) {
                s = " (crpix3=" + this.context.crpix3 + " crval3=" + this.context.crval3 + " cdelt3=" + this.context.cdelt3 + ")";
            }
            this.context.info("Working on HiPS cube => depth=" + this.context.depth + s);
        }
    }

    protected void validateCut() throws Exception {
        if (this.context.isValidateCut()) {
            return;
        }
        double[] cut = null;
        double[] pixelGood = this.context.pixelGood;
        boolean missingGood = pixelGood != null && this.context.good != null;
        boolean missingCut = cut == null || cut[0] == 0.0 && cut[1] == 0.0;
        boolean missingRange = cut == null || cut[2] == 0.0 && cut[3] == 0.0;
        double[] pixelRangeCut = this.context.getPixelRangeCut();
        if ((missingCut || missingRange) && pixelRangeCut != null || missingGood) {
            block24: {
                try {
                    this.setBzeroBscaleFromPreviousAllsky(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
                }
                catch (Exception e) {
                    String img = this.context.getImgEtalon();
                    if (img == null && this.context.getInputPath() != null && (img = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                        this.context.info("Use this reference image => " + img);
                    }
                    if (img == null) break block24;
                    try {
                        this.context.setImgEtalon(img);
                    }
                    catch (Exception e1) {
                        this.context.warning("Reference image problem [" + img + "] => " + e.getMessage());
                    }
                }
            }
            try {
                int i;
                if (cut == null) {
                    cut = new double[5];
                }
                for (i = 0; i < 4; ++i) {
                    if (Double.isNaN(pixelRangeCut[i])) continue;
                    cut[i] = (pixelRangeCut[i] - this.context.bzero) / this.context.bscale;
                }
                if (missingGood) {
                    this.context.good = new double[2];
                    for (i = 0; i < 2; ++i) {
                        this.context.good[i] = (this.context.pixelGood[i] - this.context.bzero) / this.context.bscale;
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("Cannot retrieve BZERO & BSCALE from previous Allsky.fits file or reference image");
            }
        }
        boolean bl = missingCut = cut == null || cut[0] == 0.0 && cut[1] == 0.0;
        if (missingCut) {
            String img = this.context.getImgEtalon();
            if (img == null && this.context.getInputPath() != null && (img = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                this.context.info("Use this reference image => " + img);
            }
            if (img != null) {
                try {
                    this.context.setImgEtalon(img);
                }
                catch (Exception e) {
                    this.context.warning("Reference image problem [" + img + "] => " + e.getMessage());
                }
            }
            this.context.initParameters();
            double[] imgCut = this.context.getCut();
            if (cut == null) {
                cut = new double[5];
            }
            if (missingCut) {
                cut[0] = imgCut[0];
                cut[1] = imgCut[1];
                if (cut[0] != cut[1]) {
                    this.context.info("Estimating pixel cut from the reference image => [" + cut[0] + " .. " + cut[1] + "]");
                }
            }
        }
        boolean bl2 = missingCut = cut == null || cut[0] == 0.0 && cut[1] == 0.0;
        if (missingCut) {
            this.updateCutByProperties(cut);
        }
        this.context.setCut(cut);
        double bz = this.context.bzero;
        double bs = this.context.bscale;
        if (cut == null || cut[0] == 0.0 && cut[1] == 0.0) {
            throw new Exception("Argument \"pixelCut\" required");
        }
        if (!(cut[0] < cut[1])) {
            throw new Exception("pixelCut error [" + this.ip(cut[0], bz, bs) + " .. " + this.ip(cut[1], bz, bs) + "]");
        }
        this.context.info("pixel cut [" + this.ip(cut[0], bz, bs) + " .. " + this.ip(cut[1], bz, bs) + "]");
        this.context.setValidateCut(true);
    }

    protected void updateCutByProperties(double[] cut) {
        try {
            String propFile = this.context.getOutputPath() + Util.FS + "properties";
            MyProperties prop = new MyProperties();
            File f = new File(propFile);
            if (f.exists()) {
                FileInputStream in = new FileInputStream(propFile);
                prop.load(in);
                in.close();
                String s = prop.getProperty("hips_pixel_cut");
                if (s == null) {
                    s = prop.getProperty("pixelCut");
                }
                this.context.setPixelCut(s);
                double[] pixelRangeCut = this.context.getPixelRangeCut();
                try {
                    this.setBzeroBscaleFromPreviousAllsky(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
                    if (cut == null) {
                        cut = new double[5];
                    }
                    for (int i = 0; i < 4; ++i) {
                        if (Double.isNaN(pixelRangeCut[i])) continue;
                        cut[i] = (pixelRangeCut[i] - this.context.bzero) / this.context.bscale;
                    }
                    this.context.info("Pixel cut from the propertie file => [" + this.ip(cut[0], this.context.bzero, this.context.bscale) + " .. " + this.ip(cut[1], this.context.bzero, this.context.bscale) + "]");
                }
                catch (Exception e) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void validateBitpix() {
        if (this.context.bitpix != -1) {
            return;
        }
        try {
            this.setBzeroBscaleFromPreviousAllsky(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void validateLabel() {
        if (this.context.label != null) {
            return;
        }
        String label = this.getALabel(this.context.getOutputPath(), this.context.getInputPath());
        if (label != null && label.length() > 0) {
            this.context.label = label;
        }
    }

    protected String getALabel(String outputPath, String inputPath) {
        String label = null;
        try {
            String propFile = outputPath + Util.FS + "properties";
            MyProperties prop = new MyProperties();
            File f = new File(propFile);
            if (f.exists()) {
                FileInputStream in = new FileInputStream(propFile);
                prop.load(in);
                in.close();
                String s = prop.getProperty("obs_collection");
                if (s == null) {
                    s = prop.getProperty("label");
                }
                if (s != null && s.length() > 0) {
                    label = s;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (label != null) {
            return label;
        }
        if (inputPath != null) {
            int offset = inputPath.lastIndexOf(Util.FS);
            if (offset < 0) {
                offset = inputPath.lastIndexOf(47);
            }
            label = offset >= 0 ? inputPath.substring(offset + 1) : inputPath;
        } else {
            int offset = outputPath.lastIndexOf(Util.FS);
            if (offset < 0) {
                offset = outputPath.lastIndexOf(47);
            }
            label = offset >= 0 ? outputPath.substring(offset + 1) : outputPath;
        }
        return label;
    }

    protected String getFrame() {
        if (this.context.hasFrame()) {
            return this.context.getFrameCode();
        }
        try {
            String s;
            if (this.context.prop == null) {
                this.context.loadProperties();
            }
            if ((s = this.context.prop.getProperty("hips_frame")) == null) {
                s = this.context.prop.getProperty("coordsys");
            }
            if (s == null) {
                s = "G";
            }
            if (s.equals("equatorial")) {
                return "C";
            }
            if (s.equals("ecliptic")) {
                return "E";
            }
            if (s.equals("galactic")) {
                return "G";
            }
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.context.getFrameCode();
        }
    }

    protected String ip(double raw, double bzero, double bscale) {
        return cds.tools.Util.myRound(raw) + (bzero != 0.0 || bscale != 1.0 ? "/" + cds.tools.Util.myRound(raw * bscale + bzero) : "");
    }

    protected void setFitsParamFromPreviousAllsky(String allskyFile) throws Exception {
        Fits f = new Fits();
        f.loadFITS(allskyFile);
        double[] cut = f.findAutocutRange(0.0, 0.0, true);
        this.context.setBitpix(f.bitpix);
        this.context.setCut(cut);
        try {
            double blank;
            this.context.blank = blank = f.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            double bzero;
            this.context.bzero = bzero = f.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            double bscale;
            this.context.bscale = bscale = f.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void setBzeroBscaleFromPreviousAllsky(String allskyFile) throws Exception {
        Fits f = new Fits();
        f.loadHeaderFITS(allskyFile);
        try {
            double bzero;
            this.context.bzero = bzero = f.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            double bscale;
            this.context.bscale = bscale = f.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.context.bitpix == -1) {
            try {
                double bitpix = f.headerFits.getDoubleFromHeader("BITPIX");
                this.context.bitpix = (int)bitpix;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

