/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

public enum Action {
    INDEX("Build index (in HpxFinder directory) + MOC index"),
    TILES("Build all true value pixel tiles (FITS) + Allsky.fits + MOC"),
    JPEG("Build all preview tiles (JPEG) + Allsky.jpg"),
    PNG("Build all preview tiles (PNG) + Allsky.png"),
    MOC("(Re)build the MOC (MultiOrder Coverage map)"),
    MOCINDEX("(Re)build the index MOC (MultiOrder Coverage map) in HpxFinder directory"),
    MOCHIGHT("Build a high resolution output coverage map (MOC order=pixelRes)"),
    ALLSKY("(Re)build all Allsky files + index.html"),
    GZIP("Compress some FITS tiles and Allsky.fits"),
    GUNZIP("Uncompress FITS tiles and Allsky.fits"),
    CLEAN("Delete all Hips files (index, tiles, dir, Allsky, MOC, ...)"),
    CLEANINDEX("Delete index (HpxFinder dir)"),
    CLEANDETAILS("Delete detail index (HpxFinder tree except last order dir)"),
    CLEANTILES("Delete all HiPS files except index (tiles, dir, Allsky, MOC, ...)"),
    CLEANFITS("Delete all FITS tiles and Allsky.fits"),
    CLEANJPEG("Delete all JPEG tiles and Allsky.jpg"),
    CLEANPNG("Delete all PNG tiles and Allsky.png"),
    TREE("(Re)build HiPS tree structure from already existing tiles"),
    CONCAT("Concatenate one HiPS to another HiPS"),
    CUBE("Create a HiPS cube based on a list of HiPS"),
    DETAILS("Adapt HiPS index for supporting the \"detail table\" facility"),
    UPDATE("Upgrade HiPS metadata additionnal files to HiPS version 1.3"),
    RGB("** In progress: Build and RGB HiPS from 2 or 3 other HiPS"),
    CHECK("** In progress: Check readability of all tiles"),
    MAPTILES("Build all FITS tiles from a HEALPix Fits map"),
    FINDER,
    PROGEN,
    ABORT,
    PAUSE,
    RESUME;

    private String doc;
    public long startTime;
    public long stopTime = 0L;
    public long nbFile;

    private Action() {
    }

    private Action(String s) {
        this.doc = s;
    }

    String doc() {
        return this.doc;
    }

    void startTime() {
        this.startTime = System.currentTimeMillis();
    }

    void stopTime() {
        this.stopTime = System.currentTimeMillis();
    }

    long getDuree() {
        return (this.stopTime == 0L ? System.currentTimeMillis() : this.stopTime) - this.startTime;
    }
}

