/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Forme;
import cds.aladin.Ligne;
import cds.aladin.Plan;
import cds.aladin.Position;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Graphics;
import java.awt.Point;

public class Vecteur
extends Forme {
    protected Vecteur(Plan plan, ViewSimple v, double xv, double yv, double w, double angle) {
        super(plan, new Position[2]);
        this.o[0] = new Position(plan, v, xv, yv, 0.0, 0.0, 5, null);
        double a = Math.toRadians(angle);
        double b = Math.toRadians(90.0);
        double d = b + a;
        double x = xv + w * Math.sin(d);
        double y = yv + w * Math.cos(d);
        this.o[1] = new Position(plan, v, x, y, 0.0, 0.0, 5, null);
        this.setObjet(this.o);
    }

    protected Vecteur(Plan plan, Coord c, double w, double angle) {
        super(plan, new Position[2]);
        this.o[0] = new Position(plan, null, 0.0, 0.0, c.al, c.del, 2, null);
        Coord c1 = this.applySphereRot(c, w, 270.0 + angle);
        this.o[1] = new Position(plan, null, 0.0, 0.0, c1.al, c1.del, 2, null);
        this.setObjet(this.o);
    }

    protected Vecteur(Plan plan, Position[] o) {
        super(plan, o);
    }

    @Override
    public String getObjType() {
        return "vector";
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        return this.in(v, x, y);
    }

    @Override
    protected boolean in(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.o[0].in(v, x, y) || this.o[1].in(v, x, y)) {
            return true;
        }
        return this.inLigne(1, v, x, y);
    }

    private boolean inLigne(int i, ViewSimple v, double x, double y) {
        return Ligne.inLigne(this.o[i - 1].xv[v.n], this.o[i - 1].yv[v.n], this.o[i].xv[v.n], this.o[i].yv[v.n], x, y, this.mouseDist(v));
    }

    @Override
    protected boolean inBout(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        for (int i = 0; i < this.o.length; ++i) {
            if (!this.o[i].in(v, x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean inRectangle(ViewSimple v, RectangleD r) {
        for (int i = 0; i < this.o.length; ++i) {
            if (!this.o[i].inRectangle(v, r)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        Point op = null;
        for (int i = 0; i < this.o.length; ++i) {
            if (this.o[i].xv == null) {
                return false;
            }
            Point p = v.getViewCoord(this.o[i].xv[v.n], this.o[i].yv[v.n]);
            if (p == null) {
                return false;
            }
            p.x += dx;
            p.y += dy;
            if (op != null) {
                g.setColor(this.getColor());
                Util.drawFleche(g, op.x, op.y, p.x, p.y, 5, null);
            }
            if (this.isSelected()) {
                this.drawSelect(g, v, i);
            }
            op = p;
        }
        return true;
    }
}

