/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.SliderPlusMoins;
import java.awt.Graphics;

public class SliderSize
extends SliderPlusMoins {
    public SliderSize(Aladin aladin) {
        super(aladin, aladin.getChaine().getString("SLIDERSIZE"), 0, 300, 10);
        this.setTooltip(aladin.getChaine().getString("SLIDERSIZETIP"));
    }

    @Override
    void submit(int inc) {
        Plan p = this.getPlans();
        if (p == null) {
            return;
        }
        float n = (float)((this.slider.getValue() + (double)inc) / 100.0);
        if (n < 0.0f) {
            n = 0.0f;
        }
        if (n > 4.0f) {
            n = 3.0f;
        }
        if (inc != 0) {
            this.slider.setValue((int)(n * 100.0f));
        }
        this.aladin.calque.setScalingFactor(n);
        this.aladin.calque.repaintAll();
    }

    Plan getPlans() {
        Plan p = this.aladin.calque.getFirstSelectedPlan();
        if (p == null || !p.isCatalog() && p.type != 9) {
            return null;
        }
        return p;
    }

    @Override
    public void paintComponent(Graphics g) {
        Plan p = this.getPlans();
        if (p != null) {
            this.setEnabled(true);
            this.slider.setValue((int)(p.getScalingFactor() * 100.0f));
        } else {
            this.slider.setValue(this.slider.min);
            this.setEnabled(false);
        }
        super.paintComponent(g);
    }
}

