/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.MyLabel;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.tools.CDSConstants;
import cds.vizier.VizieRCatalogs;
import cds.vizier.VizieRList;
import cds.vizier.VizieRPanel;
import cds.xml.XMLParser;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class ServerVizieR
extends Server
implements CDSConstants,
Runnable {
    String CATDESC;
    String CATMOC;
    String CATDMAP;
    String INFO1;
    String TAGGLU;
    String GETALL;
    String GETALL1;
    String CAT;
    static final String MOCGLU = "getMOC";
    static final String MOCERROR = "Catalog unknown or MOC server error";
    VizieRList vizierlist;
    JTextField catalog;
    JCheckBox cbGetAll;
    JCheckBox cbGetAllCat;
    MyLabel legende;
    JButton getReadMe;
    JButton getMoc;
    JButton getDMap;
    boolean hasPreviousFocus = false;
    Thread thread;
    Vector vSurveys;
    Vector vArchives;
    ServerDialog serverDialog;
    VizieRPanel vp = null;
    Vector catalogs = new Vector();
    VizieRCatalogs vcl = null;
    JPanel panelButtonRight = new JPanel();
    JPanel actions;
    private String oCat = null;

    protected ServerVizieR(Aladin aladin, ServerDialog serverDialog, JPanel actions) {
        this.aladin = aladin;
        this.createChaine();
        this.type = 2;
        this.aladinLogo = "VizieRLogo.gif";
        this.docUser = "http://vizier.u-strasbg.fr";
        this.TAGGLU = "VizieRXML++1";
        this.aladinLabel = "VizieR";
        if (!Aladin.CDS || aladin.glu.getURL(this.TAGGLU, "", false, false) == null) {
            this.TAGGLU = this.TAGGLU.substring(0, this.TAGGLU.length() - 1);
        } else {
            this.TESTSERVER = true;
        }
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int y = 0;
        this.actions = actions;
        this.serverDialog = serverDialog;
        JPanel tp = new JPanel();
        tp.setBackground(Aladin.BLUE);
        Dimension d = this.makeTitle(tp, this.title);
        if (this.TESTSERVER) {
            this.testServer.setText("(beta server)");
            d.width += 100;
            this.testServer.setSelected(false);
        }
        tp.setBounds(235 - d.width / 2, y, d.width, d.height);
        this.add(tp);
        JLabel info1 = new JLabel(this.INFO1);
        info1.setBounds(86, y += d.height + 10, 400, 20);
        this.add(info1);
        int yGetAll = (y += 20) + 15;
        int xGetAll = XWIDTH - 105;
        JPanel tPanel = new JPanel();
        tPanel.setBackground(Aladin.BLUE);
        int h = this.makeTargetPanel(tPanel, 8);
        tPanel.setBounds(0, y, xGetAll - 5, h);
        this.add(tPanel);
        this.modeCoo = 5;
        this.modeRad = 1;
        y += h;
        this.cbGetAll = new JCheckBox(this.GETALL, false);
        this.cbGetAll.setEnabled(false);
        this.cbGetAll.setBackground(Aladin.BLUE);
        this.cbGetAll.setBounds(xGetAll, yGetAll, 120, 20);
        yGetAll += 20;
        if (!Aladin.OUTREACH) {
            this.add(this.cbGetAll);
        }
        this.cbGetAllCat = new JCheckBox(this.GETALL1, false);
        this.cbGetAllCat.setEnabled(false);
        this.cbGetAllCat.setBackground(Aladin.BLUE);
        this.cbGetAllCat.setBounds(xGetAll, yGetAll, 140, 20);
        yGetAll += 20;
        this.cbGetAllCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean flag = !ServerVizieR.this.cbGetAllCat.isSelected();
                ServerVizieR.this.target.setEnabled(flag);
                ServerVizieR.this.radius.setEnabled(flag);
            }
        });
        if (!Aladin.OUTREACH) {
            this.add(this.cbGetAllCat);
        }
        JLabel label1 = new JLabel(this.addDot(this.CAT));
        label1.setFont(Aladin.BOLD);
        int l = 85;
        label1.setBounds(10, y, l, 30);
        this.add(label1);
        this.catalog = new JTextField(28);
        this.catalog.setBounds(l + 15, y, 120, HAUT);
        this.catalog.addKeyListener(this);
        this.catalog.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ServerVizieR.this.updateWidgets();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ServerVizieR.this.updateWidgets();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ServerVizieR.this.updateWidgets();
            }
        });
        this.add(this.catalog);
        JLabel label2 = new JLabel(this.addDot(this.RAD));
        label2.setFont(Aladin.BOLD);
        label2.setBounds(231, y, l, HAUT);
        this.add(label2);
        this.radius = new JTextField("10 arcmin");
        this.radius.setBounds(279, y, 105, HAUT);
        y += HAUT + MARGE - 2;
        this.radius.addKeyListener(this);
        this.radius.addActionListener(this);
        this.add(this.radius);
        Insets insets = new Insets(0, 10, 0, 10);
        this.getReadMe = new JButton(this.CATDESC);
        this.getReadMe.setMargin(insets);
        this.getReadMe.addActionListener(this);
        this.getReadMe.setFont(Aladin.BOLD);
        this.getReadMe.setEnabled(false);
        this.getMoc = new JButton(this.CATMOC);
        this.getMoc.setMargin(insets);
        this.getMoc.addActionListener(this);
        this.getMoc.setFont(Aladin.BOLD);
        this.getMoc.setEnabled(false);
        this.getDMap = new JButton(this.CATDMAP);
        this.getDMap.setMargin(insets);
        this.getDMap.addActionListener(this);
        this.getDMap.setFont(Aladin.BOLD);
        this.getDMap.setEnabled(false);
        JPanel catControl = new JPanel(new FlowLayout(0));
        catControl.setBounds(l + 15, y, 350, HAUT);
        catControl.setBackground(Aladin.BLUE);
        catControl.add(this.getReadMe);
        catControl.add(this.getMoc);
        if (Aladin.BETA) {
            catControl.add(this.getDMap);
        }
        if (!Aladin.OUTREACH) {
            this.add(catControl);
        }
        this.vp = new VizieRPanel(aladin.glu, 1, false, null, null, 10);
        this.vp.setBounds(10, y += HAUT + MARGE + 5, XWIDTH - 20, 280);
        y += 280;
        this.add(this.vp);
        String[] tab1 = this.vp.getSelection("SURVEY");
        this.vSurveys = new Vector();
        for (int i = 0; i < tab1.length; ++i) {
            this.vSurveys.addElement(tab1[i]);
        }
        String[] tab2 = this.vp.getSelection("MISSION");
        this.vArchives = new Vector();
        for (int i = 0; i < tab2.length; ++i) {
            this.vArchives.addElement(tab2[i]);
        }
        this.setMaxComp(this.vp);
    }

    private String getTagGlu() {
        if (this.TESTSERVER && !this.testServer.isSelected()) {
            return this.TAGGLU.substring(0, this.TAGGLU.length() - 1);
        }
        return this.TAGGLU;
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.title = Aladin.chaine.getString("VZTITLE");
        this.aladinLabel = Aladin.chaine.getString("VZNAME");
        this.description = Aladin.chaine.getString("VZINFO");
        this.verboseDescr = Aladin.chaine.getString("VZDESC");
        this.CATDESC = Aladin.chaine.getString("VZCATDESC");
        this.CATMOC = Aladin.chaine.getString("VZCATMOC");
        this.CATDMAP = Aladin.chaine.getString("VZCATDMAP");
        this.INFO1 = Aladin.chaine.getString("VZINFO1");
        this.GETALL = Aladin.chaine.getString("VZGETALL2");
        this.GETALL1 = Aladin.chaine.getString("VZGETALL3");
        this.CAT = Aladin.chaine.getString("VZCAT");
    }

    @Override
    protected boolean is(String s) {
        return s.equalsIgnoreCase("vizier") || s.equalsIgnoreCase("vizir") || s.equalsIgnoreCase("vizierX");
    }

    @Override
    protected int createPlane(String target, String radius, String criteria, String label, String origin) {
        criteria = ServerVizieR.specialUnQuoteCriteria(criteria);
        boolean allColumn = false;
        int i = criteria.indexOf("allcolumns");
        if (i >= 0) {
            criteria = criteria.substring(0, i) + criteria.substring(i + "allcolumns".length());
            criteria = criteria.trim();
            allColumn = true;
        }
        if (this.cbGetAllCat.isSelected()) {
            target = "";
        }
        if ((i = criteria.indexOf("allsky")) >= 0) {
            criteria = criteria.substring(0, i) + criteria.substring(i + "allsky".length());
            criteria = criteria.trim();
            target = "";
        }
        String catalogs = criteria;
        if (label == null) {
            label = catalogs;
        }
        return this.creatVizieRPlane(target, radius, catalogs, label, this.institute, allColumn);
    }

    protected int creatVizieRPlane(String target, String radius, String catalogs, String label, String origin, boolean allColumns) {
        URL u;
        radius = ServerVizieR.getRM(radius) + "";
        String s = Glu.quote(catalogs) + " " + Glu.quote(target) + " " + Glu.quote(radius);
        if (allColumns) {
            s = s + " -out.all";
        }
        if ((u = this.aladin.glu.getURL(this.getTagGlu(), s)) == null) {
            Aladin.warning(this, this.WERROR, 1);
            return -1;
        }
        String param = label + " " + radius + (allColumns ? " (all columns)" : "");
        if (!this.verif(8, target, param)) {
            return -1;
        }
        return this.aladin.calque.newPlanCatalog(u, label, target, param, origin, this);
    }

    @Override
    public void run() {
        String rad;
        this.ball.setMode(4);
        try {
            rad = ServerVizieR.getRM(this.radius.getText()) + "";
        }
        catch (Exception e) {
            rad = "";
        }
        this.vp.submit(this.target.getText(), rad);
        JList theTestList = this.vp.getResultList();
        this.catalogs.removeAllElements();
        for (int i = 0; i < theTestList.getModel().getSize(); ++i) {
            this.catalogs.addElement(theTestList.getModel().getElementAt(i));
        }
        if (this.vcl == null) {
            JButton controlButton = new JButton("SUBMIT");
            controlButton.setFont(LBOLD);
            controlButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerVizieR.this.submit();
                    ServerVizieR.this.vcl.resetCatList();
                    ServerVizieR.this.catalog.setText("");
                }
            });
            this.vcl = new VizieRCatalogs(this.catalog, null, null, this.catalogs, controlButton);
        } else {
            this.vcl.show(this.catalogs);
        }
        if (this.target.getText().compareTo("") == 0) {
            this.vcl.setTitle(this.catalogs.size() + " catalog(s) found " + this.target.getText());
        } else {
            this.vcl.setTitle(this.catalogs.size() + " catalog(s) found around " + this.target.getText());
        }
        if (this.catalogs.size() == 0) {
            this.ball.setMode(3);
        } else {
            this.ball.setMode(1);
        }
    }

    @Override
    public void submit() {
        double rm = 0.0;
        if (this.catalog.getText().compareTo("") == 0) {
            this.thread = new Thread((Runnable)this, "AladinVizieRQuery");
            this.thread.start();
            return;
        }
        boolean allCat = this.cbGetAllCat.isSelected();
        String objet = this.getTarget(false);
        String cata = this.catalog.getText().trim();
        if (objet == null || objet.length() == 0) {
            if (cata.length() == 0) {
                Aladin.warning(this, this.WNEEDCAT);
                return;
            }
            if (!Aladin.confirmation(this, "Do you really want to download\nall \"" + cata + "\" ?")) {
                return;
            }
            objet = "";
            rm = 0.0;
        } else if (!allCat) {
            String r = this.getRadius();
            if (r == null) {
                return;
            }
            rm = ServerVizieR.getRM(r);
        }
        this.waitCursor();
        String bookmarkCode = null;
        if (this.cbGetAll.isSelected()) {
            cata = cata + ",allcolumns";
        }
        if (!allCat && objet != null && objet.length() > 0) {
            bookmarkCode = "get VizieR(" + cata + ")";
            this.aladin.console.printCommand("get VizieR(" + cata + ") " + objet + " " + Coord.getUnit(rm / 60.0));
        } else {
            bookmarkCode = "get VizieRX(" + cata + ")";
            this.aladin.console.printCommand(bookmarkCode);
        }
        int n = this.createPlane(objet, rm + "", cata, null, null);
        if (n != -1) {
            this.aladin.calque.getPlan(n).setBookmarkCode(bookmarkCode + " $TARGET $RADIUS");
        }
        this.catalog.setText("");
        this.resetFlagBoxes();
        this.defaultCursor();
    }

    @Override
    protected boolean isDiscovery() {
        return true;
    }

    protected MyInputStream getMetaDataForCat(Vector list, String target, String radius) {
        try {
            int n = list.size();
            if (n == 0) {
                return null;
            }
            MyByteArrayStream bas = null;
            MyByteArrayStream out = bas = new MyByteArrayStream(10000);
            Aladin.writeBytes(out, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">\n<VOTABLE version=\"v1.0\">\n<RESOURCE type=\"results\">\n   <INFO name=\"QUERY_STATUS\" value=\"OK\"/>\n   <TABLE>\n<FIELD name=\"Resource\" datatype=\"char\" ucd=\"VOX:Image_Title\" arraysize=\"*\"/>\n<FIELD name=\"url\" datatype=\"char\" ucd=\"VOX:Image_AccessReference\" arraysize=\"*\"/>\n<FIELD ID=\"FORMAT\" datatype=\"char\" arraysize=\"*\"/>\n<DATA>\n<TABLEDATA>\n");
            for (int i = 0; i < n; ++i) {
                String item = XMLParser.XMLEncode((String)list.elementAt(i));
                int j = item.indexOf(9);
                if (j < 0) continue;
                String catalogs = item.substring(0, j);
                String s = Glu.quote(catalogs) + " " + Glu.quote(target) + " " + Glu.quote(radius);
                URL u = this.aladin.glu.getURL(this.getTagGlu(), s);
                if (u == null) continue;
                item = item.replace('\t', ' ');
                Aladin.writeBytes(out, "   <TR>\n      <TD>" + item + "</TD>\n" + "      <TD><![CDATA[" + u + "]]></TD>\n" + "      <TD>CATALOG</TD>\n" + "   </TR>\n");
            }
            Aladin.writeBytes(out, "</TABLEDATA>\n</DATA>\n</TABLE>\n</RESOURCE>\n</VOTABLE>\n");
            return new MyInputStream(bas.getInputStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected MyInputStream getMetaData(String target, String radius, StringBuffer infoUrl) {
        double rm = ServerVizieR.getRM(radius);
        Vector v = new Vector();
        if (!this.vp.getVizieRQuery().submit(target, rm + "", null, null, null, null, 1, v)) {
            return null;
        }
        return this.getMetaDataForCat(v, target, radius);
    }

    @Override
    protected void clear() {
        super.clear();
        this.catalog.setText("");
        this.vp.resetAll();
    }

    @Override
    protected void reset() {
        this.resetFlagBoxes();
        super.reset();
        this.vp.resetAll();
    }

    protected void resetFlagBoxes() {
        this.cbGetAll.setSelected(false);
        this.cbGetAllCat.setSelected(false);
        this.target.setEnabled(true);
        this.radius.setEnabled(true);
    }

    protected void reaffiche() {
        this.hide();
        this.show();
    }

    @Override
    protected boolean updateWidgets() {
        if (!super.updateWidgets()) {
            return false;
        }
        if (this.catalog == null) {
            return false;
        }
        String cat = this.catalog.getText().trim();
        if (this.oCat != null && this.oCat.equals(cat)) {
            return true;
        }
        this.oCat = cat;
        boolean catOk = cat.length() != 0;
        this.getReadMe.setEnabled(catOk);
        this.getMoc.setEnabled(catOk);
        this.getDMap.setEnabled(catOk);
        this.cbGetAll.setEnabled(catOk);
        this.cbGetAllCat.setEnabled(catOk);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action;
        super.actionPerformed(e);
        Object s = e.getSource();
        if (s instanceof JButton && ((action = ((JButton)s).getActionCommand()).equals(this.CATDESC) || action.equals(this.CATMOC) || action.equals(this.CATDMAP))) {
            try {
                String cata = this.catalog.getText().trim();
                if (cata.equals("")) {
                    Aladin.warning(this, this.WNEEDCAT);
                    return;
                }
                if (action.equals(this.CATDESC)) {
                    this.aladin.glu.showDocument("getReadMe", Glu.quote(cata));
                } else if (action.equals(this.CATMOC)) {
                    URL u = this.aladin.glu.getURL(MOCGLU, Glu.quote(cata) + " 512");
                    this.aladin.execAsyncCommand("'" + cata + " MOC'=get File(" + u + ")");
                } else if (action.equals(this.CATDMAP)) {
                    this.aladin.calque.newPlanDMap(cata);
                }
                this.defaultCursor();
                return;
            }
            catch (Exception e1) {
                Aladin.warning("Error: cannot load this product\n" + e1.getMessage());
            }
        }
    }

    protected void hideSFrame() {
    }
}

