/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.ServerTree;
import cds.aladin.Tok;
import cds.aladin.TreeNode;
import cds.aladin.TreeNodeAllsky;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

public class ServerHips
extends ServerTree {
    private boolean populated = false;
    private JRadioButton fitsRadio;
    private Coord oc = null;
    private double osize = -1.0;
    private boolean dynTree = false;

    @Override
    protected void init() {
        this.type = 8;
        this.aladinLabel = "hips";
        this.aladinLogo = "Hips.png";
    }

    @Override
    protected int addTailPanel(int y) {
        int h = 25;
        if (Aladin.OUTREACH) {
            return y;
        }
        JPanel formatPanel = new JPanel();
        ButtonGroup group = new ButtonGroup();
        JLabel l = new JLabel(Aladin.chaine.getString("ALADINDEFFMT"));
        formatPanel.add(l);
        JRadioButton b = new JRadioButton(Aladin.chaine.getString("ALLSKYJPEG"));
        b.setBackground(Aladin.BLUE);
        b.setSelected(true);
        group.add(b);
        formatPanel.add(b);
        this.fitsRadio = b = new JRadioButton(Aladin.chaine.getString("ALLSKYFITS"));
        b.setBackground(Aladin.BLUE);
        group.add(b);
        formatPanel.add(b);
        formatPanel.setBackground(Aladin.BLUE);
        formatPanel.setBounds(0, y, XWIDTH, h);
        this.add(formatPanel);
        return y += h;
    }

    @Override
    protected int makeTarget(int y) {
        JPanel tPanel = new JPanel();
        int h = this.makeTargetPanel(tPanel, 0);
        tPanel.setBackground(Aladin.BLUE);
        tPanel.setBounds(0, y, XWIDTH, h);
        this.add(tPanel);
        return y += h;
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.title = Aladin.chaine.getString("ALLSKYTITLE");
        this.info = null;
        this.info1 = null;
        this.description = Aladin.chaine.getString("ALLSKYDESC");
    }

    protected ServerHips(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected int createPlane(String target, String radius, String criteria, String label, String origin) {
        String survey;
        int defaultMode = 0;
        if (criteria == null || criteria.trim().length() == 0) {
            survey = "DSS colored";
        } else {
            Tok tok = new Tok(criteria, ", ");
            survey = tok.nextToken();
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken();
                if (s.equalsIgnoreCase("Fits")) {
                    defaultMode = 2;
                    continue;
                }
                if (!s.equalsIgnoreCase("Jpeg") && !s.equalsIgnoreCase("jpg") && !s.equalsIgnoreCase("png")) continue;
                defaultMode = 1;
            }
        }
        int j = this.aladin.glu.findGluSky(survey, 2);
        if (j < 0) {
            Aladin.warning(this, "Progressive survey (HiPS) unknown [" + survey + "]", 1);
            return -1;
        }
        TreeNodeAllsky gSky = this.aladin.glu.getGluSky(j);
        try {
            if (defaultMode != 0) {
                gSky.setDefaultMode(defaultMode);
            }
        }
        catch (Exception e) {
            this.aladin.command.printConsole("!!! " + e.getMessage());
        }
        return this.aladin.hips(gSky, label, target, radius);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hipsUpdate() {
        block13: {
            try {
                BufferedReader in = null;
                try {
                    String s;
                    ViewSimple v = this.aladin.view.getCurrentView();
                    if (v.isFree()) {
                        return;
                    }
                    Coord c = v.getCooCentre();
                    double size = v.getTaille();
                    if (c.equals(this.oc) && size == this.osize) {
                        return;
                    }
                    this.oc = c;
                    this.osize = size;
                    String params = "client_application=AladinDesktop" + (Aladin.BETA ? "*" : "") + "&hips_service_url=*&RA=" + c.al + "&DEC=" + c.del + "&SR=" + size * Math.sqrt(2.0);
                    URL u = this.aladin.glu.getURL("MocServer", params, true);
                    Aladin.trace(4, "ServerHips.hipsUpdate: Contacting MocServer : " + u);
                    in = new BufferedReader(new InputStreamReader(Util.openStream(u)));
                    HashSet<String> set = new HashSet<String>();
                    while ((s = in.readLine()) != null) {
                        set.add(this.getId(s));
                    }
                    Glu cfr_ignored_0 = this.aladin.glu;
                    for (TreeNodeAllsky gSky : Glu.vGluSky) {
                        gSky.ok = false;
                    }
                    Glu cfr_ignored_1 = this.aladin.glu;
                    for (TreeNodeAllsky gSky : Glu.vGluSky) {
                        gSky.ok = set.contains(gSky.internalId);
                    }
                    DefaultMutableTreeNode root = this.tree.getRoot();
                    this.tree.setOkTree(root);
                    this.validate();
                    this.repaint();
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Exception e1) {
                if (Aladin.levelTrace < 3) break block13;
                e1.printStackTrace();
            }
        }
    }

    private String getId(String ivorn) {
        if (ivorn.length() < 6) {
            return "";
        }
        int offset = ivorn.indexOf("/", 6);
        String id = ivorn.substring(offset + 1);
        return id;
    }

    @Override
    protected boolean is(String s) {
        return s.equalsIgnoreCase(this.aladinLabel);
    }

    @Override
    public void submit() {
        String mode = this.fitsRadio != null && this.fitsRadio.isSelected() ? ",fits" : "";
        for (TreeNode n : this.tree) {
            if (!(n instanceof TreeNodeAllsky) || !n.isCheckBoxSelected()) continue;
            TreeNodeAllsky ta = (TreeNodeAllsky)n;
            String target = this.getTarget(false);
            String radius = this.getRadius(false);
            String cible = target == null || target.trim().length() == 0 ? "" : " " + target + (radius == null ? "" : " " + radius);
            String id = ta.internalId != null ? ta.internalId : ta.id;
            String criteria = id + mode;
            String code = "get hips(" + Tok.quote(id) + mode + ")";
            this.aladin.console.printCommand(code + cible);
            int m = this.createPlane(target, radius, criteria, ta.aladinLabel, ta.copyright);
            if (m == -1) continue;
            this.aladin.calque.getPlan(m).setBookmarkCode(code + " $TARGET $RADIUS");
        }
        this.reset();
    }

    @Override
    protected void initTree() {
        if (this.dynTree) {
            return;
        }
        new Thread("initTree"){

            @Override
            public void run() {
                ServerHips.this.loadRemoteTree();
                Glu cfr_ignored_0 = ServerHips.this.aladin.glu;
                ServerHips.this.tree.populateTree(Glu.vGluSky.elements());
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRemoteTree() {
        if (this.dynTree) {
            return;
        }
        FilterInputStream dis = null;
        try {
            this.dynTree = true;
            Aladin.trace(3, "Loading Tree definitions...");
            String params = "client_application=AladinDesktop" + (Aladin.BETA ? "*" : "") + "&hips_service_url=*&fmt=glu&get=record";
            String u = this.aladin.glu.getURL("MocServer", params, true).toString();
            dis = new DataInputStream(Aladin.cache.getWithBackup(u));
            this.aladin.glu.loadGluDic((DataInputStream)dis, 0, false, true, false, false);
        }
        catch (Exception e1) {
            if (Aladin.levelTrace >= 3) {
                e1.printStackTrace();
            }
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

