/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.BasicTree;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.MetaDataTree;
import cds.aladin.MyInputStream;
import cds.aladin.Plan;
import cds.aladin.ResourceNode;
import cds.aladin.SIAPruner;
import cds.aladin.Server;
import cds.aladin.Tok;
import cds.aladin.TreeBuilder;
import cds.tools.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ServerGlu
extends Server
implements Runnable {
    String HELP;
    String ERR;
    private boolean flagSIAIDHA = false;
    private boolean flagTAP = false;
    int fmt;
    String actionName;
    String info1;
    String filter;
    String system;
    String dir;
    StringBuffer record;
    Vector vc;
    String planeLabel;
    String[] vD = null;
    Thread thread;
    protected int lastY;
    protected Plan lastPlan = null;
    URL uT;
    String posT;
    private boolean majChoiceSize = true;
    private int maxChoiceWidth = XWIDTH - 100;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.info1 = Aladin.chaine.getString("GLUINFO1");
        this.filter = Aladin.chaine.getString("SMBFILTER");
        this.HELP = Aladin.chaine.getString("GLUHELP");
        this.ERR = Aladin.chaine.getString("GLUERR");
    }

    protected ServerGlu(Aladin aladin, String actionName, String description, String verboseDescr, String aladinMenu, String aladinMenuNumber, String aladinLabel, String planeLabel, String docUser, String[] paramDescription, String[] paramDataType, String[] paramValue, String resultDataType, String institute, String[] aladinFilter, String aladinLogo, String dir, String system, StringBuffer record, String aladinProtocol) {
        this.aladin = aladin;
        this.createChaine();
        this.setBackground(Aladin.BLUE);
        this.record = record;
        this.actionName = actionName;
        this.aladinLogo = aladinLogo;
        this.aladinLabel = aladinLabel != null ? aladinLabel : (description != null ? description : actionName);
        this.description = description;
        this.verboseDescr = verboseDescr;
        this.aladinMenu = aladinMenu;
        this.institute = institute;
        this.planeLabel = planeLabel;
        this.docUser = docUser;
        this.ordre = aladinMenuNumber;
        this.system = system;
        this.dir = dir;
        if (aladinMenu != null && aladinMenu.equals("IVOA...")) {
            this.HIDDEN = true;
        }
        this.type = 1;
        if (resultDataType != null) {
            if (resultDataType.indexOf("ssa") >= 0) {
                this.type = 4;
            } else if (resultDataType.indexOf("x-votable+xml") >= 0) {
                this.type = 2;
            } else if (resultDataType.indexOf("application") >= 0) {
                this.type = resultDataType.indexOf("image") > 0 ? 16 : 8;
            } else if (resultDataType.indexOf("text") >= 0 || resultDataType.indexOf("txt") >= 0 || resultDataType.indexOf("tsv") >= 0 || resultDataType.indexOf("csv") >= 0 || resultDataType.indexOf("xml") >= 0) {
                this.type = 2;
            }
        }
        this.flagSIAIDHA = resultDataType != null && (resultDataType.indexOf("sia") >= 0 || resultDataType.indexOf("idha") >= 0 || resultDataType.indexOf("ssa") >= 0);
        boolean bl = this.flagTAP = aladinProtocol != null && Util.indexOfIgnoreCase(aladinProtocol, "tap") == 0;
        if (this.flagSIAIDHA && this.type != 4) {
            this.type = 1;
        }
        this.DISCOVERY = this.flagSIAIDHA || this.type == 4 || this.type == 2;
        this.fmt = this.getFmt(resultDataType);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        boolean flagInfo = true;
        int y = HEIGHT / 2 - (paramDescription.length * 35 + 50 + 60 + (docUser != null ? 30 : 0) + (this.flagSIAIDHA ? 180 : 0)) / 2;
        if (Aladin.OUTREACH) {
            y = 60;
        }
        if (y < 10) {
            y = 5;
            flagInfo = false;
        }
        JPanel tp = new JPanel();
        Dimension d = this.makeTitle(tp, description);
        int x = XWIDTH / 2 - d.width / 2;
        if (x < 0) {
            x = 5;
        }
        tp.setBackground(Aladin.BLUE);
        tp.setBounds(x, y, d.width, d.height);
        y += d.height + 10;
        this.add(tp);
        if (flagInfo) {
            JLabel l = new JLabel(this.info1);
            l.setBounds(110, y, 400, 20);
            y += 20;
            this.add(l);
        }
        boolean targetRequired = this.targetRequired(paramDataType);
        boolean radiusRequired = this.radiusRequired(paramDataType);
        if (targetRequired || radiusRequired) {
            JPanel tPanel = new JPanel();
            int mode = 0;
            if (!targetRequired) {
                mode |= 4;
            }
            if (!radiusRequired) {
                mode |= 2;
            }
            int h = this.makeTargetPanel(tPanel, mode);
            tPanel.setBackground(Aladin.BLUE);
            tPanel.setBounds(0, y, XWIDTH, h);
            y += h;
            this.add(tPanel);
        }
        this.vc = new Vector(5);
        int nc = 0;
        for (int i = 0; i < paramDescription.length; ++i) {
            JComponent co;
            StringTokenizer pv;
            boolean flagShow = true;
            StringTokenizer stringTokenizer = pv = paramValue[i] != null ? new StringTokenizer(paramValue[i], "\t") : null;
            if (pv != null && pv.countTokens() > 1) {
                JComboBox<String> ch = new JComboBox<String>();
                ch.setOpaque(false);
                while (pv.hasMoreTokens()) {
                    ch.addItem(pv.nextToken());
                }
                if (this.flagTAP) {
                    ch.addActionListener(this);
                }
                co = ch;
            } else {
                JTextField t;
                if (pv != null) {
                    if (this.vD == null) {
                        this.vD = new String[paramDescription.length];
                    }
                    this.vD[nc] = paramValue[i];
                    t = new JTextField(this.vD[nc], 40);
                } else {
                    t = new JTextField(40);
                }
                t.addKeyListener(this);
                if (this.flagTAP) {
                    t.addActionListener(this);
                }
                co = t;
                if (paramDataType != null && paramDataType[i] != null) {
                    co = this.setDedicatedFields(paramDataType[i], co);
                    flagShow = this.isShownField(paramDataType[i]);
                }
            }
            if (flagShow) {
                String s = paramDescription[i] == null ? "Parameter " + (i + 1) : paramDescription[i] + " ";
                JLabel pTitre = new JLabel(this.addDot(s));
                pTitre.setFont(Aladin.BOLD);
                pTitre.setBounds(10, y, 150, HAUT);
                this.add(pTitre);
                co.setBounds(160, y, XWIDTH - 160, HAUT);
                y += HAUT + MARGE;
                this.add(co);
                co.setName(s);
                ++nc;
            }
            this.vc.addElement(co);
        }
        JScrollPane sc = null;
        if (this.flagSIAIDHA) {
            this.tree = new MetaDataTree(aladin, null);
            sc = new JScrollPane(this.tree);
            this.tree.setScroll(sc);
            sc.setBackground(this.tree.bkgColor);
            sc.setBounds(10, y, XWIDTH - 20, 180);
            y += 180;
            this.add(sc);
        } else if (this.flagTAP) {
            this.tap = new JTextArea("", 8, 50);
            this.tap.setFont(Aladin.ITALIC);
            this.tap.setWrapStyleWord(true);
            this.tap.setLineWrap(true);
            this.tap.setEditable(false);
            sc = new JScrollPane(this.tap);
            sc.setBounds(10, y += 15, XWIDTH - 20, 180);
            y += 180;
            this.add(sc);
        }
        if (aladinFilter != null) {
            this.filters = aladinFilter;
            JComboBox filtersChoice = this.createFilterChoice();
            filtersChoice.setOpaque(false);
            JLabel pFilter = new JLabel(this.addDot(this.filter));
            pFilter.setFont(Aladin.BOLD);
            pFilter.setBounds(10, y += 10, 150, HAUT);
            this.add(pFilter);
            filtersChoice.setBounds(160, y, XWIDTH - 160, HAUT);
            y += HAUT + MARGE;
            this.add(filtersChoice);
        }
        if (docUser != null) {
            JButton b = new JButton(this.HELP);
            b.setOpaque(false);
            b.addActionListener(this);
            b.setBounds(290, y += 10, 140, HAUT);
            this.lastY = y;
            y += HAUT + MARGE;
            this.add(b);
        }
        if (this.flagSIAIDHA || this.flagTAP) {
            this.setMaxComp(sc);
        }
    }

    private boolean targetRequired(String[] PK) {
        return this.keyWordRequired(PK, "Target");
    }

    private boolean radiusRequired(String[] PK) {
        return this.keyWordRequired(PK, "Field");
    }

    private boolean keyWordRequired(String[] PK, String keyWord) {
        for (int i = 0; i < PK.length; ++i) {
            int j;
            if (PK[i] == null || (j = PK[i].indexOf(40)) < 0 || !PK[i].substring(0, j).equalsIgnoreCase(keyWord)) continue;
            return true;
        }
        return false;
    }

    private int getFmt(String R) {
        if (R == null || R.indexOf("image") < 0) {
            return 0;
        }
        return R.indexOf("/gfits") > 0 ? 4 : (R.indexOf("/hfits") > 0 ? 3 : (R.indexOf("/mrcomp") > 0 ? 5 : (R.indexOf("/fits") > 0 ? 2 : 7)));
    }

    private int getMode(StringBuffer mode, char[] a, int i) {
        while (i < a.length && a[i] != ')' && a[i] != '|' && a[i] != ',' && a[i] != ' ') {
            mode.append(a[i]);
            ++i;
        }
        return i;
    }

    private boolean isShownField(String PK) {
        char[] a = PK.toCharArray();
        int i = 0;
        for (i = 0; i < a.length && a[i] != '('; ++i) {
        }
        String prefixe = new String(a, 0, i);
        return !prefixe.equalsIgnoreCase("Target") && !prefixe.equalsIgnoreCase("Field");
    }

    private JComponent setDedicatedFields(String PK, JComponent f) {
        char[] a = PK.toCharArray();
        int i = 0;
        int nbField = 1;
        int ind = 0;
        for (i = 0; i < a.length && a[i] != '('; ++i) {
        }
        String prefixe = new String(a, 0, i);
        if (prefixe.equalsIgnoreCase("Target")) {
            while (true) {
                StringBuffer mode = new StringBuffer();
                i = this.getMode(mode, a, i + 1);
                if (mode.length() == 0) break;
                String s = mode.toString();
                if (s.equalsIgnoreCase("RA")) {
                    nbField = 2;
                    this.modeCoo |= 0x10;
                    continue;
                }
                if (s.equalsIgnoreCase("DE")) {
                    nbField = 2;
                    ind = 1;
                    this.modeCoo |= 0x10;
                    continue;
                }
                if (s.equalsIgnoreCase("RAb")) {
                    nbField = 2;
                    this.modeCoo |= 0x40;
                    continue;
                }
                if (s.equalsIgnoreCase("DEb")) {
                    nbField = 2;
                    ind = 1;
                    this.modeCoo |= 0x40;
                    continue;
                }
                if (s.equalsIgnoreCase("RAh")) {
                    nbField = 6;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("RAm")) {
                    nbField = 6;
                    ind = 1;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("RAs")) {
                    nbField = 6;
                    ind = 2;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("DEdg")) {
                    nbField = 6;
                    ind = 3;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("DEm")) {
                    nbField = 6;
                    ind = 4;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("DEs")) {
                    nbField = 6;
                    ind = 5;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("SIMBAD")) {
                    this.modeCoo |= 4;
                    continue;
                }
                if (s.equalsIgnoreCase("NED")) {
                    this.modeCoo |= 8;
                    continue;
                }
                if (s.equalsIgnoreCase("COO")) {
                    this.modeCoo |= 1;
                    continue;
                }
                if (s.equalsIgnoreCase("COOd")) {
                    this.modeCoo |= 0x100;
                    continue;
                }
                if (s.equalsIgnoreCase("COOb")) {
                    this.modeCoo |= 2;
                    continue;
                }
                if (s.equalsIgnoreCase("RAd")) {
                    nbField = 2;
                    this.modeCoo |= 0x20;
                    continue;
                }
                if (s.equalsIgnoreCase("DEd")) {
                    nbField = 2;
                    ind = 1;
                    this.modeCoo |= 0x20;
                    continue;
                }
                System.err.println("Server [" + this.aladinLabel + "]; unknown Target code [" + s + "] => assume COO");
                this.modeCoo |= 1;
            }
            if (this.coo == null) {
                this.coo = new JTextField[nbField];
            }
            this.coo[ind] = (JTextField)((Object)f);
        } else if (prefixe.equalsIgnoreCase("Field")) {
            while (true) {
                StringBuffer mode = new StringBuffer();
                i = this.getMode(mode, a, i + 1);
                if (mode.length() == 0) break;
                String s = mode.toString();
                if (s.equalsIgnoreCase("RA")) {
                    nbField = 2;
                    this.modeRad |= 4;
                    continue;
                }
                if (s.equalsIgnoreCase("DE")) {
                    nbField = 2;
                    ind = 1;
                    this.modeRad |= 4;
                    continue;
                }
                if (s.equalsIgnoreCase("RAd")) {
                    nbField = 2;
                    this.modeRad |= 0x40;
                    continue;
                }
                if (s.equalsIgnoreCase("DEd")) {
                    nbField = 2;
                    ind = 1;
                    this.modeRad |= 0x40;
                    continue;
                }
                if (s.equalsIgnoreCase("RAs")) {
                    nbField = 2;
                    this.modeRad |= 0x100;
                    continue;
                }
                if (s.equalsIgnoreCase("DEs")) {
                    nbField = 2;
                    ind = 1;
                    this.modeRad |= 0x100;
                    continue;
                }
                if (s.equalsIgnoreCase("SQR")) {
                    this.modeRad |= 2;
                    continue;
                }
                if (s.equalsIgnoreCase("SQRd")) {
                    this.modeRad |= 0x20;
                    continue;
                }
                if (s.equalsIgnoreCase("SQRs")) {
                    this.modeRad |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("RADIUS")) {
                    this.modeRad |= 1;
                    continue;
                }
                if (s.equalsIgnoreCase("RADIUSd")) {
                    this.modeRad |= 8;
                    continue;
                }
                if (s.equalsIgnoreCase("RADIUSs")) {
                    this.modeRad |= 0x10;
                    continue;
                }
                System.err.println("Server [" + this.aladinLabel + "]; unknown Field code [" + s + "] => assume RADIUS");
                this.modeRad |= 1;
            }
            if (this.rad == null) {
                this.rad = new JTextField[nbField];
            }
            this.rad[ind] = (JTextField)((Object)f);
        } else if (prefixe.equalsIgnoreCase("Date")) {
            while (true) {
                StringBuffer mode = new StringBuffer();
                i = this.getMode(mode, a, i + 1);
                if (mode.length() == 0) break;
                String s = mode.toString();
                if (s.equalsIgnoreCase("MJD")) {
                    this.modeDate |= 2;
                    continue;
                }
                if (s.equalsIgnoreCase("JD")) {
                    this.modeDate |= 1;
                    continue;
                }
                if (s.equalsIgnoreCase("YEARd")) {
                    this.modeDate |= 4;
                    continue;
                }
                System.err.println("Server [" + this.aladinLabel + "]; unknown Date code [" + s + "] => assume JD");
                this.modeDate |= 1;
            }
            this.date = (JTextField)((Object)f);
        } else if (prefixe.equalsIgnoreCase("Input")) {
            while (true) {
                StringBuffer mode = new StringBuffer();
                i = this.getMode(mode, a, i + 1);
                if (mode.length() == 0) break;
                String s = mode.toString();
                if (this.input == null) {
                    this.input = new JComponent[10];
                    this.modeInput = new int[10];
                    this.nbInput = 0;
                }
                if (s.equalsIgnoreCase("IMG")) {
                    int n = this.nbInput;
                    this.modeInput[n] = this.modeInput[n] | 1;
                    continue;
                }
                if (s.equalsIgnoreCase("ALLIMG")) {
                    int n = this.nbInput;
                    this.modeInput[n] = this.modeInput[n] | 0x10;
                    continue;
                }
                if (s.equalsIgnoreCase("IMGs")) {
                    int n = this.nbInput;
                    this.modeInput[n] = this.modeInput[n] | 2;
                    continue;
                }
                if (s.equalsIgnoreCase("CAT")) {
                    int n = this.nbInput;
                    this.modeInput[n] = this.modeInput[n] | 4;
                    continue;
                }
                if (s.equalsIgnoreCase("CATs")) {
                    int n = this.nbInput;
                    this.modeInput[n] = this.modeInput[n] | 8;
                    continue;
                }
                System.err.println("Server [" + this.aladinLabel + "]; unknown Input code [" + s + "] => assume IMG");
                int n = this.nbInput;
                this.modeInput[n] = this.modeInput[n] | 1;
            }
            if ((this.modeInput[this.nbInput] & 0x15) != 0) {
                JComboBox<String> c = new JComboBox<String>();
                c.addItem(this.NOINPUTITEM);
                f = c;
            }
            this.input[this.nbInput++] = f;
            this.DISCOVERY = false;
        }
        return f;
    }

    @Override
    protected boolean is(String s) {
        return s.equalsIgnoreCase(this.actionName) || super.is(s);
    }

    private String getComboItem(JComboBox c, String cr) {
        boolean flagNumeric = true;
        try {
            Double.parseDouble(cr);
        }
        catch (Exception e) {
            flagNumeric = false;
        }
        int n = c.getItemCount();
        for (int i = 0; i < n; ++i) {
            String s;
            String s1 = s = ((String)c.getItemAt(i)).toUpperCase();
            int m = s.indexOf(" - ");
            if (m > 0) {
                s1 = s.substring(m + 1).trim();
                s = s.substring(0, m).trim();
            }
            if ((flagNumeric || (s1 == s || !s.equals(cr) && s1.indexOf(cr) < 0) && (s1 != s || s.indexOf(cr) < 0)) && (!flagNumeric || !s.equals(cr))) continue;
            s = (String)c.getItemAt(i);
            m = s.indexOf(" - ");
            if (m > 0) {
                s = s.substring(0, m).trim();
            }
            return s;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int createPlane(String target, String radius, String criteria, String label, String origin) {
        String objet = "";
        String serverTaskId = this.aladin.synchroServer.start("ServerGlu.createPlane/" + target);
        try {
            int n;
            String[] param;
            int m;
            JComponent c;
            int j;
            String s;
            try {
                objet = this.resolveTarget(target);
                if (objet == null) {
                    throw new Exception(this.UNKNOWNOBJ);
                }
            }
            catch (Exception e1) {
                Aladin.warning(this, e1.getMessage(), 1);
                int n2 = -1;
                this.aladin.synchroServer.stop(serverTaskId);
                return n2;
            }
            if (radius != null && radius.length() > 0) {
                this.resolveRadius(radius, true);
            }
            if (this.date != null && this.date.getText().trim().length() == 0) {
                this.resolveDate(this.getDefaultDate());
            }
            Tok st = new Tok(criteria.trim(), ",");
            String[] crit = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                crit[i] = st.nextToken();
                ++i;
            }
            Vector<String> v = new Vector<String>(10);
            Vector<String> vbis = new Vector<String>(10);
            Enumeration e = this.vc.elements();
            while (e.hasMoreElements()) {
                v.addElement(null);
                vbis.addElement(null);
                e.nextElement();
            }
            block20: for (i = 0; i < crit.length; ++i) {
                String cr = crit[i];
                int posEgal = cr.indexOf(61);
                if (posEgal <= 0 || cr.charAt(posEgal - 1) == '\\') continue;
                String cName = cr.substring(0, posEgal).trim().toUpperCase();
                s = cr.substring(posEgal + 1).trim();
                s = Tok.unQuote(s);
                e = this.vc.elements();
                j = 0;
                while (e.hasMoreElements()) {
                    String coName;
                    JComponent c2 = (JComponent)e.nextElement();
                    if (!this.isFieldInput(c2) && !this.isFieldTargetOrRadius(c2) && (coName = c2.getName()) != null && (coName = coName.trim().toUpperCase()).indexOf(cName) >= 0) {
                        if (c2 instanceof JComboBox) {
                            s = this.getComboItem((JComboBox)c2, s.toUpperCase());
                        }
                        if (s == null) continue block20;
                        v.setElementAt(s, j);
                        vbis.setElementAt(s, j);
                        crit[i] = null;
                        continue block20;
                    }
                    ++j;
                }
            }
            e = this.vc.elements();
            j = 0;
            while (e.hasMoreElements()) {
                c = (JComponent)e.nextElement();
                boolean trouve = false;
                for (int k = 0; !trouve && k < crit.length; ++k) {
                    String cr = crit[k];
                    if (cr == null) continue;
                    cr = cr.toUpperCase();
                    if (!(c instanceof JComboBox) || this.isFieldInput(c) || (s = this.getComboItem((JComboBox)c, cr)) == null) continue;
                    m = s.indexOf(" - ");
                    if (m > 0) {
                        s = s.substring(0, m).trim();
                    }
                    trouve = true;
                    v.setElementAt(s, j);
                    vbis.setElementAt(s, j);
                    crit[k] = null;
                }
                ++j;
            }
            e = this.vc.elements();
            c = (JComponent)e.nextElement();
            j = 0;
            for (i = 0; i < crit.length; ++i) {
                if (crit[i] == null) continue;
                try {
                    while (v.elementAt(j) != null || this.isFieldTargetOrRadius(c)) {
                        c = (JComponent)e.nextElement();
                        ++j;
                    }
                }
                catch (NoSuchElementException nsee) {
                    continue;
                }
                if (this.isFieldInput(c)) {
                    this.setSelectedItem(c, crit[i]);
                    crit[i] = this.getInputUrl(c);
                    if (crit[i] == null) {
                        int nsee = -1;
                        return nsee;
                    }
                }
                v.setElementAt(crit[i], j);
                vbis.setElementAt(crit[i], j);
            }
            e = this.vc.elements();
            j = 0;
            while (e.hasMoreElements()) {
                c = (JComponent)e.nextElement();
                if (v.elementAt(j) == null) {
                    s = "";
                    if (c instanceof JTextField) {
                        s = ((JTextField)c).getText();
                    } else if (c instanceof JComboBox) {
                        s = (String)((JComboBox)c).getSelectedItem();
                        m = s.indexOf(" - ");
                        if (m > 0) {
                            vbis.addElement(s.substring(m + 3));
                        } else {
                            vbis.addElement(s);
                        }
                        m = s.indexOf(" - ");
                        if (m > 0) {
                            s = s.substring(0, m).trim();
                        } else if (s.equals("?") || s.startsWith("-") && s.endsWith("-")) {
                            s = "";
                        }
                        v.addElement(s);
                    }
                    v.setElementAt(s, j);
                    vbis.setElementAt(s, j);
                }
                ++j;
            }
            e = v.elements();
            StringBuffer p = null;
            StringBuffer p1 = null;
            while (e.hasMoreElements()) {
                s = (String)e.nextElement();
                if (p == null) {
                    p = new StringBuffer(Glu.quote(s));
                    p1 = new StringBuffer(s);
                    continue;
                }
                p.append(" " + Glu.quote(s));
                p1.append("/" + s);
            }
            URL u = this.aladin.glu.getURL(this.actionName, p.toString());
            if (this.flagSIAIDHA && (this.type == 1 || this.type == 4)) {
                ResourceNode[] nodesToLoad;
                block58: {
                    TreeBuilder tb = new TreeBuilder(this.aladin, u, -1, null, objet);
                    ResourceNode rootNode = tb.build();
                    Vector leaves = new Vector();
                    BasicTree.getAllLeaves(rootNode, leaves);
                    SIAPruner pruner = new SIAPruner(leaves.toArray(new ResourceNode[leaves.size()]), crit);
                    nodesToLoad = pruner.prune();
                    if (nodesToLoad != null) break block58;
                    int n3 = -1;
                    return n3;
                }
                try {
                    for (int idx = 0; idx < nodesToLoad.length; ++idx) {
                        ResourceNode node = nodesToLoad[idx];
                        if (this.type == 1) {
                            this.aladin.dialog.localServer.tree.load(node, label);
                            continue;
                        }
                        if (this.type != 4) continue;
                        this.aladin.getMessagingMgr().sendMessageLoadSpectrum(node.location, node.location, node.name, node.getMetadata(), null);
                    }
                }
                catch (Exception e2) {
                    this.aladin.command.println("error : " + e2.getMessage());
                    e2.printStackTrace();
                }
                int e2 = 1;
                return e2;
            }
            if (label == null) {
                if (this.planeLabel == null) {
                    label = this.aladinLabel;
                } else {
                    param = new String[vbis.size()];
                    for (i = 0; i < param.length; ++i) {
                        s = (String)vbis.elementAt(i);
                        if (s.equals("-")) {
                            s = "";
                        }
                        param[i] = s;
                    }
                    this.planeLabel = this.dollarQuerySet(this.planeLabel);
                    Glu cfr_ignored_0 = this.aladin.glu;
                    label = Glu.dollarSet(this.planeLabel, param, 2).trim();
                }
            }
            Object object = param = p1 != null ? p1.toString() : "";
            if (this.type == 1) {
                int n4;
                if (!this.verif(1, objet, (String)param)) {
                    int e2 = -1;
                    return e2;
                }
                if (this.fmt == 7) {
                    int n5;
                    int n6 = n5 = this.aladin.calque.newPlanImageColor(u, null, 2, label, objet, (String)param, "provided by " + this.institute, this.fmt, 0, null, null);
                    return n6;
                }
                int n7 = n4 = this.aladin.calque.newPlanImage(u, 2, label, objet, (String)param, "provided by " + this.institute, this.fmt, 0, null);
                return n7;
            }
            if (!this.verif(8, objet, (String)param)) {
                int n4 = -1;
                return n4;
            }
            int n8 = n = this.aladin.calque.newPlanCatalog(u, label, objet, (String)param, "provided by " + this.institute, this);
            return n8;
        }
        finally {
            this.aladin.synchroServer.stop(serverTaskId);
        }
    }

    @Override
    public void submit() {
        new Thread((Runnable)this, "GluServer submit"){

            @Override
            public void run() {
                ServerGlu.this.submit1(true);
            }
        }.start();
    }

    private void submit1(boolean flagDoIt) {
        String s;
        String objet = "";
        String code = null;
        boolean flagScriptEquiv = true;
        if (this.target != null) {
            try {
                objet = this.resolveQueryField();
                if (objet == null) {
                    throw new Exception(this.UNKNOWNOBJ);
                }
            }
            catch (Exception e1) {
                if (!flagDoIt) {
                    return;
                }
                Aladin.warning(this, e1.getMessage());
                this.ball.setMode(3);
                return;
            }
        }
        Vector<String> v = new Vector<String>(10);
        Vector<String> vbis = new Vector<String>(10);
        StringBuffer criteres = new StringBuffer();
        Enumeration e = this.vc.elements();
        while (e.hasMoreElements()) {
            JComponent c = (JComponent)e.nextElement();
            String crit = null;
            if (this.isFieldInput(c)) {
                v.addElement(this.getInputUrl(c));
                vbis.addElement(this.getInputPlaneName(c));
                flagScriptEquiv = false;
            } else if (c instanceof JTextField) {
                s = ((JTextField)c).getText();
                v.addElement(s);
                vbis.addElement(s);
                if (!this.isFieldTargetOrRadius(c)) {
                    crit = s;
                }
            } else if (c instanceof JComboBox) {
                Object t = null;
                crit = s = (String)((JComboBox)c).getSelectedItem();
                int j = s.indexOf(" - ");
                if (j > 0) {
                    crit = s.substring(j + 3);
                    vbis.addElement(crit);
                }
                if ((j = s.trim().indexOf("- ")) == 0) {
                    crit = s.substring(j + 2);
                    vbis.addElement(crit);
                } else {
                    vbis.addElement(s);
                }
                if (j >= 0) {
                    s = s.substring(0, j).trim();
                } else if (s.equals("?") || s.startsWith("-") && s.endsWith("-")) {
                    s = "";
                    crit = "";
                }
                v.addElement(s);
            }
            if (crit == null || crit.length() <= 0) continue;
            if (criteres.length() > 0) {
                criteres.append(",");
            }
            criteres.append(Tok.quote(crit));
        }
        e = v.elements();
        StringBuffer p = null;
        StringBuffer p1 = null;
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            if (p == null) {
                p = new StringBuffer(Glu.quote(s));
                p1 = new StringBuffer(s);
                continue;
            }
            p.append(" " + Glu.quote(s));
            p1.append("/" + s);
        }
        String label = null;
        if (this.planeLabel == null) {
            label = this.aladinLabel;
        } else {
            String[] param = new String[vbis.size()];
            for (int i = 0; i < param.length; ++i) {
                s = (String)vbis.elementAt(i);
                if (s.equals("-")) {
                    s = "";
                }
                param[i] = s;
            }
            Glu cfr_ignored_0 = this.aladin.glu;
            label = Glu.dollarSet(this.dollarQuerySet(this.planeLabel), param, 2).trim();
        }
        URL u = this.aladin.glu.getURL(this.actionName, p == null ? "" : p.toString());
        if (!flagDoIt && this.flagTAP) {
            this.setInTap(u);
            return;
        }
        if (this.system != null) {
            this.exec(label, p == null ? "" : p.toString());
            return;
        }
        if (flagScriptEquiv) {
            String r = this.getRadius(false);
            r = r == null ? "" : " " + Coord.getUnit(ServerGlu.getRM(r) / 60.0);
            code = "get " + this.actionName + (criteres.length() == 0 ? " " : "(" + criteres + ") ");
            this.aladin.console.printCommand(code + this.getTarget() + r);
        }
        if (this.flagSIAIDHA) {
            block38: {
                try {
                    if (this.tree != null && !this.tree.isEmpty()) {
                        if (this.tree.nbSelected() > 0) {
                            if (!this.tooManyChecked()) {
                                this.tree.loadSelected();
                                this.tree.resetCb();
                            }
                        } else {
                            Aladin.warning(this, this.WNEEDCHECK);
                        }
                        break block38;
                    }
                    this.waitCursor();
                    this.uT = u;
                    this.posT = new Coord(objet).toString();
                    this.thread = new Thread((Runnable)this, "AladinGluServerMetaData");
                    Util.decreasePriority(Thread.currentThread(), this.thread);
                    this.thread.start();
                    return;
                }
                catch (Exception e1) {
                    String message = e1.getMessage();
                    if (message == null) {
                        message = "unknown error";
                    }
                    Aladin.warning(this, this.ERR + "\n[" + message + "]");
                    if (Aladin.levelTrace >= 3) {
                        e1.printStackTrace();
                    }
                    this.defaultCursor();
                    this.ball.setMode(2);
                }
            }
            return;
        }
        this.defaultCursor();
        this.lastPlan = this.aladin.calque.createPlan(u + "", label, "provided by " + this.institute, this);
        if (code != null && this.lastPlan != null) {
            this.lastPlan.setBookmarkCode(code + " $TARGET $RADIUS");
        }
    }

    private void setInTap(URL u) {
        String s = u.toString();
        int offset = s.indexOf("QUERY=");
        s = s.substring(offset + 6);
        s = URLDecoder.decode(s);
        s = s.replace("FROM", "\n   FROM");
        s = s.replace("WHERE", "\n   WHERE");
        this.tap.setText(s);
    }

    private boolean exec(final String label, String params) {
        this.aladin.log("exec", this.actionName);
        final String dir = this.dir;
        final String command = Util.concatDir(dir, this.getCommand(params));
        Aladin.trace(1, "Exec: " + (dir != null ? "cd " + dir + ";" : "") + command);
        try {
            new Thread(this.actionName){

                @Override
                public void run() {
                    try {
                        Process p = Runtime.getRuntime().exec(command, null, dir == null ? null : new File(dir));
                        InputStream stdout = p.getInputStream();
                        ServerGlu.this.lastPlan = ServerGlu.this.aladin.calque.createPlan(stdout, label, "provided by " + ServerGlu.this.institute);
                    }
                    catch (Exception e1) {
                        String message = e1.getMessage();
                        if (message == null) {
                            message = "unknown error";
                        }
                        Aladin.warning(ServerGlu.this.ERR + "\n[" + message + "]");
                        if (Aladin.levelTrace >= 3) {
                            e1.printStackTrace();
                        }
                        ServerGlu.this.defaultCursor();
                        ServerGlu.this.ball.setMode(2);
                    }
                }
            }.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String getCommand(String params) {
        return this.aladin.glu.gluSystem(this.system, params);
    }

    private String dollarQuerySet(String template) {
        int i = template.indexOf("$query");
        if (this.target == null || i < 0) {
            return template;
        }
        String d = this.target.getText().trim();
        if (d.length() == 0) {
            d = this.getDefaultTarget();
        }
        return template.substring(0, i) + d + template.substring(i + 6);
    }

    @Override
    public void run() {
        URL u = this.uT;
        try {
            MyInputStream in = Util.openStream(u);
            this.updateMetaData(in, this, "", this.posT);
            this.aladin.dialog.show(this);
            this.defaultCursor();
            if (this.tree.isEmpty()) {
                this.ball.setMode(3);
            }
        }
        catch (Exception e1) {
            String message = e1.getMessage();
            if (message == null) {
                message = "unknown error";
            }
            Aladin.warning(this, this.ERR + "\n[" + message + "]");
            if (Aladin.levelTrace >= 3) {
                e1.printStackTrace();
            }
            this.defaultCursor();
            this.ball.setMode(2);
        }
    }

    @Override
    protected MyInputStream getMetaData(String target, String radius, StringBuffer infoUrl) throws Exception {
        String s;
        if (this.resolveTarget(target) == null) {
            return null;
        }
        this.resolveRadius(radius, true);
        Vector<String> v = new Vector<String>(10);
        Enumeration e = this.vc.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (c instanceof JTextField) {
                s = ((JTextField)c).getText();
                v.addElement(s);
                continue;
            }
            if (!(c instanceof JComboBox)) continue;
            s = (String)((JComboBox)c).getSelectedItem();
            int j = s.indexOf(" - ");
            if (j > 0) {
                s = s.substring(0, j).trim();
            } else if (s.equals("?") || s.startsWith("-") && s.endsWith("-")) {
                s = "";
            }
            v.addElement(s);
        }
        e = v.elements();
        StringBuffer p = null;
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            if (p == null) {
                p = new StringBuffer(Glu.quote(s));
                continue;
            }
            p.append(" " + Glu.quote(s));
        }
        URL u = this.aladin.glu.getURL(this.actionName, p.toString());
        infoUrl.append(u + "");
        if (this.type == 2) {
            return this.getMetaDataForCat(u);
        }
        return Util.openStream(u);
    }

    protected void majChoiceSize() {
        if (!this.majChoiceSize) {
            return;
        }
        Enumeration e = this.vc.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (!(c instanceof JComboBox)) continue;
            JComboBox choice = (JComboBox)c;
            int orgWidth = choice.getSize().width;
            if (orgWidth <= this.maxChoiceWidth) continue;
            choice.setSize(this.maxChoiceWidth, 30);
        }
        this.majChoiceSize = false;
    }

    @Override
    protected void reset() {
        if (this.tree != null) {
            this.tree.resetCb();
        }
        super.reset();
    }

    @Override
    protected void clear() {
        int j = 0;
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof JTextField) {
                if (this.vD != null && this.vD[j] != null) {
                    ((JTextField)c[i]).setText(this.vD[j]);
                } else {
                    ((JTextField)c[i]).setText("");
                }
                ++j;
                continue;
            }
            if (!(c[i] instanceof JComboBox)) continue;
            ((JComboBox)c[i]).setSelectedIndex(0);
            ++j;
        }
        if (this.tree != null) {
            this.tree.clear();
        }
        super.clear();
    }

    @Override
    protected boolean updateWidgets() {
        if (this.flagTAP) {
            System.out.println("Je dois r\u00e9\u00e9diter la chaine ADQL");
            this.submit1(false);
        }
        return super.updateWidgets();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o instanceof JButton && ((JButton)o).getActionCommand().equals(this.HELP)) {
            if (this.docUser.startsWith("http://")) {
                this.aladin.glu.showDocument("Http", this.docUser, true);
            } else {
                this.aladin.glu.showDocument(this.docUser, "");
            }
            return;
        }
        if (this.flagTAP) {
            this.updateWidgets();
        }
        super.actionPerformed(e);
    }
}

