/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Calque;
import cds.aladin.ComponentLocator;
import cds.aladin.Coord;
import cds.aladin.FrameInfo;
import cds.aladin.Glu;
import cds.aladin.MyButton;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.SelectDialog;
import cds.aladin.Server;
import cds.aladin.ServerAladin;
import cds.aladin.ServerAllVO;
import cds.aladin.ServerAlmaFootprint;
import cds.aladin.ServerFile;
import cds.aladin.ServerFoV;
import cds.aladin.ServerFolder;
import cds.aladin.ServerGlu;
import cds.aladin.ServerHips;
import cds.aladin.ServerMocQuery;
import cds.aladin.ServerNED;
import cds.aladin.ServerSWarp;
import cds.aladin.ServerSimbad;
import cds.aladin.ServerVizieR;
import cds.aladin.ServerVizieRMission;
import cds.aladin.ServerVizieRSurvey;
import cds.aladin.ServerWatch;
import cds.aladin.SwingWidgetFinder;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public final class ServerDialog
extends JFrame
implements SwingWidgetFinder,
Runnable,
ActionListener,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    static final int MAXSERVER = 10;
    static int ALADIN = 0;
    static int SIMBAD = 0;
    static int NED = 0;
    static int VIZIER = 0;
    static int FIELD = 0;
    static int LOCAL = 0;
    static final String VO_RESOURCES_BY_PLASTIC = "VO res.";
    static final String DEFAULTTAILLE = "14";
    protected String defaultTarget = "";
    protected String defaultTaille = "14";
    protected String defaultDate;
    String TITLE;
    String SUBMIT;
    String RESET;
    String CLEAR;
    String HELP;
    String CLOSE;
    String IMG;
    String CAT;
    String OTHER;
    String MESSAGE;
    String TIPRESET;
    String TIPCLEAR;
    String TIPSUBMIT;
    String TIPCLOSE;
    Server[] server;
    JPanel mp;
    CardLayout card;
    SelectDialog selectDialog;
    Label status;
    MyButton[] buttons;
    ServerFolder voResPopup;
    int current = 0;
    int bcurrent = 0;
    protected boolean flagSetPos = false;
    Server curServer;
    Server localServer;
    Server vizierServer;
    Server vizierArchives;
    Server vizierSurveys;
    Server vizierBestof;
    Server discoveryServer;
    Server aladinServer;
    Server fovServer;
    Server almaFovServer;
    Server vizierSED;
    Server hipsServer;
    JButton submit;
    Aladin aladin;
    Calque calque;
    private final JPanel buttonImg;
    long t1;
    long t;
    private boolean lock;
    protected boolean ivoaServersLoaded = false;
    private Thread threadUpdater = null;
    private boolean encore = true;

    protected String getDefaultTargetJ2000() {
        return this.defaultTarget.trim();
    }

    protected String getDefaultTarget() {
        return this.aladin.localisation.getFrameCoord(this.defaultTarget.trim());
    }

    protected String getDefaultTaille() {
        return this.defaultTaille.trim();
    }

    protected String getDefaultDate() {
        return this.defaultDate;
    }

    protected void setDefaultDate(String s) {
        this.defaultDate = s;
    }

    protected void setDefaultTarget(String s) {
        if (s.equals(" --   --")) {
            return;
        }
        this.defaultTarget = this.aladin.localisation.getICRSCoord(s);
    }

    protected void setDefaultTaille(Plan p) {
        if (!Projection.isOk(p.projd)) {
            return;
        }
        double rm = Math.max(p.projd.rm, p.projd.rm1);
        this.defaultTaille = rm > 0.0 ? 1.4142 * (rm / 2.0) + "" : DEFAULTTAILLE;
    }

    protected void setDefaultTaille(String s) {
        if (s == null) {
            s = DEFAULTTAILLE;
        }
        this.defaultTaille = s;
    }

    private void addGluServer(Vector<Server> sv, int type) {
        for (int j = Glu.vGluServer.size() - 1; j >= 0; --j) {
            int i;
            Server sTmp = (Server)Glu.vGluServer.elementAt(j);
            if ((sTmp.type & type) == 0) continue;
            sv.addElement(sTmp);
            if (sTmp.aladinMenu == null || sTmp.isHidden()) continue;
            for (i = sv.size() - 1; i >= 0; --i) {
                Server s = sv.elementAt(i);
                if (s.aladinLabel.equals(sTmp.aladinMenu) && s instanceof ServerFolder) break;
            }
            if (i < 0) {
                i = sv.size();
                sv.addElement(new ServerFolder(this.aladin, sTmp.aladinMenu, i, type == 1 ? 0 : (type == 2 ? 1 : 2)));
            }
            ((ServerFolder)sv.elementAt(i)).addItem(sTmp.aladinLabel);
        }
    }

    protected int getLastGluServerIndice() {
        return this.findIndiceServer(this.aladin.glu.lastGluServer);
    }

    private Vector triServer(Vector sv) {
        Vector<Server> v = new Vector<Server>(sv.size());
        Vector<Server> vFirst = new Vector<Server>(10);
        Vector<Server> vPop = new Vector<Server>(10);
        Vector<Server> vOther = new Vector<Server>(10);
        Vector<Server> vEnd1 = new Vector<Server>(10);
        Vector<Server> vEnd2 = new Vector<Server>(10);
        Vector<Server> vEnd3 = new Vector<Server>(10);
        Enumeration e = sv.elements();
        while (e.hasMoreElements()) {
            Server s = (Server)e.nextElement();
            if (s instanceof ServerFolder) {
                if (s.aladinLabel.startsWith("Other")) {
                    vOther.addElement(s);
                    continue;
                }
                if (s.aladinLabel.startsWith("Optical") || s.aladinLabel.startsWith("DSS")) {
                    vFirst.addElement(s);
                    continue;
                }
                vPop.addElement(s);
                continue;
            }
            if (s.aladinMenu != null) {
                if (s.aladinMenu.startsWith("Other")) {
                    vEnd2.addElement(s);
                    continue;
                }
                if (s.aladinMenu.startsWith("Optical")) {
                    vEnd3.addElement(s);
                    continue;
                }
                vEnd1.addElement(s);
                continue;
            }
            v.addElement(s);
        }
        int j = v.size();
        for (int i = 0; i < 6; ++i) {
            Enumeration enumeration = i == 0 ? vFirst.elements() : (i == 1 ? vPop.elements() : (i == 2 ? vOther.elements() : (i == 4 ? vEnd1.elements() : (e = i == 5 ? vEnd2.elements() : vEnd3.elements()))));
            while (e.hasMoreElements()) {
                Server s = (Server)e.nextElement();
                if (s instanceof ServerFolder) {
                    ((ServerFolder)s).numButton = j++;
                }
                v.addElement(s);
            }
        }
        return v;
    }

    protected int getMargeGauche() {
        return this.buttonImg.size().width;
    }

    protected void createChaine() {
        this.TITLE = Aladin.chaine.getString("SERVERTITLE");
        this.SUBMIT = Aladin.chaine.getString("SUBMIT");
        this.RESET = Aladin.chaine.getString("RESET");
        this.CLEAR = Aladin.chaine.getString("CLEAR");
        this.CLOSE = Aladin.chaine.getString("CLOSE");
        this.IMG = Aladin.chaine.getString("IMG");
        this.CAT = Aladin.chaine.getString("CAT");
        this.OTHER = Aladin.chaine.getString("OTHER");
        this.MESSAGE = Aladin.chaine.getString("SSHELP");
        this.TIPRESET = Aladin.chaine.getString("TIPRESET");
        this.TIPCLEAR = Aladin.chaine.getString("TIPCLEAR");
        this.TIPSUBMIT = Aladin.chaine.getString("TIPSUBMIT");
        this.TIPCLOSE = Aladin.chaine.getString("TIPCLOSE");
    }

    protected ServerDialog(Aladin aladin) {
        int i;
        JLabel l;
        this.aladin = aladin;
        Aladin.setIcon(this);
        Vector sv = new Vector(100);
        JPanel actions = new JPanel();
        this.createChaine();
        this.setTitle(this.TITLE);
        this.calque = aladin.calque;
        this.setFont(Aladin.BOLD);
        this.enableEvents(64L);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerDialog.this.trapESC();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerDialog.this.trapESC();
            }
        }, KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 2);
        JLabel status = new JLabel("");
        status.setFont(Aladin.LITALIC);
        status.setForeground(Color.blue);
        if (!Aladin.OUTREACH && Aladin.NETWORK) {
            this.aladinServer = new ServerAladin(aladin);
            sv.addElement((Server)this.aladinServer);
        }
        if (Aladin.NETWORK) {
            this.addGluServer(sv, 1);
        }
        if (Aladin.OUTREACH && Aladin.NETWORK) {
            this.aladinServer = new ServerAladin(aladin);
            sv.addElement(this.aladinServer);
        }
        if (Aladin.NETWORK) {
            ServerVizieR svizier = new ServerVizieR(aladin, this, actions);
            this.vizierServer = svizier;
            if (!Aladin.OUTREACH) {
                sv.addElement(svizier);
                this.vizierSurveys = new ServerVizieRSurvey(aladin, svizier.vSurveys);
                sv.addElement(this.vizierSurveys);
                this.vizierArchives = new ServerVizieRMission(aladin, svizier.vArchives);
                sv.addElement(this.vizierArchives);
                sv.addElement(new ServerSimbad(aladin));
                sv.addElement(new ServerNED(aladin));
                if (Aladin.PROTO) {
                    sv.addElement(new ServerSWarp(aladin));
                }
                if (Aladin.BETA) {
                    sv.addElement(new ServerMocQuery(aladin));
                }
            } else {
                sv.addElement(new ServerSimbad(aladin));
                this.vizierSurveys = new ServerVizieRSurvey(aladin, svizier.vSurveys);
                sv.addElement(this.vizierSurveys);
                this.vizierArchives = new ServerVizieRMission(aladin, svizier.vArchives);
                sv.addElement(this.vizierArchives);
                sv.addElement(svizier);
            }
        }
        if (Aladin.NETWORK) {
            this.addGluServer(sv, 2);
        }
        if (!Aladin.OUTREACH) {
            sv = this.triServer(sv);
        }
        this.hipsServer = new ServerHips(aladin);
        sv.addElement(this.hipsServer);
        this.localServer = new ServerFile(aladin);
        sv.addElement(this.localServer);
        this.discoveryServer = null;
        if (!Aladin.OUTREACH && Aladin.NETWORK) {
            this.discoveryServer = new ServerAllVO(aladin);
            sv.addElement(this.discoveryServer);
        }
        sv.addElement(new ServerWatch(aladin));
        if (!Aladin.OUTREACH && Aladin.NETWORK) {
            this.addGluServer(sv, 4);
        }
        if (!Aladin.OUTREACH) {
            this.fovServer = new ServerFoV(aladin);
            sv.addElement(this.fovServer);
            int n = sv.size();
            ServerFolder fovFolder = new ServerFolder(aladin, this.fovServer.aladinMenu, n, 2);
            sv.addElement(fovFolder);
            fovFolder.addItem(this.fovServer.aladinLabel);
            this.almaFovServer = new ServerAlmaFootprint(aladin);
            sv.addElement(this.almaFovServer);
            fovFolder.addItem(this.almaFovServer.aladinLabel);
        }
        if (!Aladin.OUTREACH && Aladin.NETWORK) {
            this.addGluServer(sv, 24);
        }
        JPanel buttonTop = new JPanel();
        this.buttonImg = new JPanel();
        JPanel buttonData = new JPanel();
        buttonTop.setOpaque(false);
        this.buttonImg.setOpaque(false);
        buttonData.setOpaque(false);
        GridBagLayout gbtop = new GridBagLayout();
        GridBagConstraints gctop = new GridBagConstraints();
        buttonTop.setLayout(gbtop);
        GridBagLayout gbimg = new GridBagLayout();
        GridBagConstraints gcimg = new GridBagConstraints();
        gcimg.gridx = 0;
        gcimg.weighty = 0.0;
        this.buttonImg.setLayout(gbimg);
        GridBagLayout gbdat = new GridBagLayout();
        GridBagConstraints gcdat = new GridBagConstraints();
        gcdat.gridx = 0;
        buttonData.setLayout(gbdat);
        gcimg.insets.bottom = 6;
        gcimg.insets.top = 12;
        JLabel limg = l = new JLabel(Util.fold("<center><i>" + this.IMG + "</i></center>", 80, true));
        l.setFont(Aladin.BOLD);
        l.setForeground(Aladin.DARKBLUE);
        gbimg.setConstraints(l, gcimg);
        this.buttonImg.add(l);
        gcimg.insets.bottom = 0;
        gcimg.insets.top = 0;
        gcdat.insets.bottom = 6;
        gcdat.insets.top = 12;
        JLabel ldat = l = new JLabel(Util.fold("<center><i>" + this.CAT + "</i></center>", 80, true));
        l.setFont(Aladin.BOLD);
        l.setForeground(Aladin.DARKBLUE);
        gbdat.setConstraints(l, gcdat);
        buttonData.add(l);
        gcdat.insets.bottom = 0;
        gcdat.insets.top = 0;
        gctop.insets.right = 12;
        l = new JLabel(Util.fold("<center><i>" + this.OTHER + "</i></center>", 80, true));
        l.setFont(Aladin.BOLD);
        l.setForeground(Aladin.DARKBLUE);
        gbtop.setConstraints(l, gctop);
        buttonTop.add(l);
        gctop.insets.right = 0;
        this.server = new Server[sv.size()];
        this.buttons = new MyButton[sv.size()];
        MyButton lastTop = null;
        MyButton lastLeft = null;
        MyButton lastRight = null;
        for (i = 0; i < this.server.length; ++i) {
            gcimg.insets.top = 0;
            this.server[i] = (Server)sv.elementAt(i);
            if (this.server[i].isHidden()) continue;
            if (this.server[i] instanceof ServerFile) {
                LOCAL = i;
            } else if (this.server[i] instanceof ServerFoV) {
                FIELD = i;
            } else if (this.server[i] instanceof ServerVizieR) {
                VIZIER = i;
                if (Aladin.OUTREACH) {
                    gcdat.insets.top = 45;
                    lastRight.setLastInColumn();
                }
            } else if (this.server[i] instanceof ServerAladin) {
                ALADIN = i;
                if (Aladin.OUTREACH && lastLeft != null) {
                    lastLeft.setLastInColumn();
                }
            } else if (this.server[i] instanceof ServerNED) {
                NED = i;
            } else if (this.server[i] instanceof ServerSimbad) {
                SIMBAD = i;
            } else if (Aladin.OUTREACH && this.server[i].aladinLabel.startsWith("Hubble")) {
                gcimg.insets.top = 45;
            }
            if (this.server[i].aladinMenu != null) continue;
            if (this.server[i].type == 1) {
                lastLeft = this.buttons[i] = new MyButton(aladin, status, 2, this.server[i].aladinLabel, this.server[i].description);
                gbimg.setConstraints(this.buttons[i], gcimg);
                this.buttonImg.add(this.buttons[i]);
            } else if (this.server[i].type == 2) {
                lastRight = this.buttons[i] = new MyButton(aladin, status, 3, this.server[i].aladinLabel, this.server[i].description);
                gbdat.setConstraints(this.buttons[i], gcdat);
                buttonData.add(this.buttons[i]);
            } else {
                lastTop = this.buttons[i] = new MyButton(aladin, status, 4, this.server[i].aladinLabel, this.server[i].description);
                gbtop.setConstraints(this.buttons[i], gctop);
                buttonTop.add(this.buttons[i]);
            }
            this.buttons[i].setAlwaysUp(false);
            this.buttons[i].setModeMenu(true);
            if (this.server[i].aladinLogo == null) continue;
            try {
                this.buttons[i].setBackGroundLogo(aladin.getImagette(this.server[i].aladinLogo), this.server[i] instanceof ServerFolder ? 1 : 0);
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        l = new JLabel();
        gcimg.weighty = 1.0;
        gcimg.fill = 1;
        gbimg.setConstraints(l, gcimg);
        this.buttonImg.add(l);
        l = new JLabel();
        gcdat.weighty = 1.0;
        gcdat.fill = 1;
        gbdat.setConstraints(l, gcdat);
        buttonData.add(l);
        l = new JLabel();
        gctop.fill = 1;
        gbtop.setConstraints(l, gctop);
        buttonTop.add(l);
        if (lastLeft == null) {
            limg.setText(Util.fold("<center><i>No image\nservers\nfound !</i></center>", 80, true));
        }
        if (lastRight == null) {
            ldat.setText(Util.fold("<center><i>No catalog\nservers\nfound !</i></center>", 80, true));
        }
        if (lastTop != null) {
            lastTop.setLastInColumn();
        }
        if (lastRight != null) {
            lastRight.setLastInColumn();
        }
        if (lastLeft != null) {
            lastLeft.setLastInColumn();
        }
        sv = null;
        this.buttons[this.bcurrent].push();
        this.setFont(Aladin.PLAIN);
        this.mp = new JPanel();
        this.mp.setOpaque(true);
        this.card = new CardLayout();
        this.mp.setLayout(this.card);
        for (i = 0; i < this.server.length; ++i) {
            if (this.server[i] == null || this.server[i].isHidden()) continue;
            this.server[i].setOpaque(true);
            this.mp.add(this.server[i].aladinLabel, this.server[i]);
        }
        this.selectDialog = new SelectDialog(this, this.mp);
        JPanel milieu = new JPanel();
        milieu.setOpaque(false);
        milieu.setLayout(new BorderLayout());
        Aladin.makeAdd(milieu, this.buttonImg, "West");
        Aladin.makeAdd(milieu, this.selectDialog, "Center");
        Aladin.makeAdd(milieu, buttonData, "East");
        JButton m = new JButton(this.RESET);
        actions.add(m);
        m.addActionListener(this);
        m.setOpaque(false);
        m.setToolTipText(this.TIPRESET);
        m = new JButton(this.CLEAR);
        actions.add(m);
        m.addActionListener(this);
        m.setOpaque(false);
        m.setToolTipText(this.TIPCLEAR);
        actions.add(new JLabel("           "));
        m = this.submit = new JButton(this.SUBMIT);
        m.addActionListener(this);
        m.setOpaque(false);
        m.setToolTipText(this.TIPSUBMIT);
        m.setForeground(Aladin.GREEN);
        m.setFont(m.getFont().deriveFont(1));
        actions.add(this.submit);
        m = new JButton(this.CLOSE);
        actions.add(m);
        m.addActionListener(this);
        m.setOpaque(false);
        m.setToolTipText(this.TIPCLOSE);
        m.setForeground(Color.red);
        m.setFont(m.getFont().deriveFont(1));
        m = Util.getHelpButton(this, this.MESSAGE);
        actions.add(m);
        actions.setFont(Aladin.BOLD);
        JPanel bas = new JPanel();
        bas.setOpaque(false);
        bas.setLayout(new BorderLayout(0, 0));
        Aladin.makeAdd(bas, status, "Center");
        Aladin.makeAdd(bas, actions, "South");
        actions.setOpaque(false);
        JPanel ct = (JPanel)this.getContentPane();
        ct.setOpaque(true);
        ct.setLayout(new BorderLayout(0, 0));
        ct.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 3));
        Aladin.makeAdd(ct, buttonTop, "North");
        Aladin.makeAdd(ct, milieu, "Center");
        Aladin.makeAdd(ct, bas, "South");
        aladin.manageDrop();
        this.setCurrent("hips");
        this.run();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent DragSourceDropEvent2) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public void dragExit(DragSourceEvent DragSourceEvent2) {
    }

    @Override
    public void dragOver(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent DragSourceDragEvent2) {
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.aladin.drop(dropTargetDropEvent);
    }

    @Override
    public void run() {
        this.pack();
        try {
            this.aladin.addServerMenu(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setLock(true);
    }

    private synchronized void setLock(boolean flag) {
        this.lock = flag;
    }

    private synchronized boolean packed() {
        return this.lock;
    }

    protected synchronized boolean appendIVOAServer() {
        if (this.ivoaServersLoaded) {
            return true;
        }
        URL url = null;
        try {
            url = this.aladin.glu.getURL("IVOAdic");
            Aladin.trace(1, "Loading the remote IVOA glu dictionary");
            Aladin.trace(3, "  => " + url);
            DataInputStream dis = new DataInputStream(Aladin.cache.getWithBackup(url.toString()));
            Glu cfr_ignored_0 = this.aladin.glu;
            Glu.vGluServer = new Vector(50);
            this.aladin.glu.loadGluDic(dis, true, false);
            Glu cfr_ignored_1 = this.aladin.glu;
            int n = Glu.vGluServer.size();
            if (n == 0) {
                this.ivoaServersLoaded = false;
                return false;
            }
            Server[] newServer = new Server[this.server.length + n];
            System.arraycopy(this.server, 0, newServer, 0, this.server.length);
            for (int i = 0; i < n; ++i) {
                Glu cfr_ignored_2 = this.aladin.glu;
                newServer[this.server.length + i] = (Server)Glu.vGluServer.elementAt(i);
            }
            this.server = newServer;
            newServer = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Remote IVOA Glu dictionary not reached");
            this.ivoaServersLoaded = false;
            return false;
        }
        this.ivoaServersLoaded = true;
        return true;
    }

    protected synchronized void appendServersFromStream(InputStream is) {
        try {
            DataInputStream dis = new DataInputStream(is);
            Glu cfr_ignored_0 = this.aladin.glu;
            Glu.vGluServer = new Vector(50);
            this.aladin.glu.loadGluDic(dis, true, false);
            Glu cfr_ignored_1 = this.aladin.glu;
            int n = Glu.vGluServer.size();
            if (n == 0) {
                return;
            }
            Server[] newServer = new Server[this.server.length + n];
            System.arraycopy(this.server, 0, newServer, 0, this.server.length);
            for (int i = 0; i < n; ++i) {
                Glu cfr_ignored_2 = this.aladin.glu;
                newServer[this.server.length + i] = (Server)Glu.vGluServer.elementAt(i);
            }
            this.server = newServer;
            newServer = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Problem while adding servers");
        }
    }

    protected int getServer(String s) {
        for (int j = 0; j < this.server.length; ++j) {
            if (!this.server[j].is(s)) continue;
            return j;
        }
        return -1;
    }

    private void trapESC() {
        if (this.aladin.command.robotMode) {
            this.aladin.stopRobot(this);
        } else {
            this.cache();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cache();
        }
        super.processWindowEvent(e);
    }

    protected void cache() {
        try {
            FrameInfo f;
            if (Aladin.NETWORK) {
                ((ServerVizieR)this.server[VIZIER]).hideSFrame();
            }
            if ((f = this.aladin.getFrameInfo()) != null) {
                f.setVisible(false);
            }
            if (this.discoveryServer != null && ((ServerAllVO)this.discoveryServer).frameServer != null) {
                ((ServerAllVO)this.discoveryServer).frameServer.setVisible(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
    }

    void popOtherButton() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (i == this.bcurrent || this.buttons[i] == null) continue;
            this.buttons[i].pop();
        }
    }

    protected void setGrabItCoord(double x, double y) {
        ViewSimple v = this.aladin.view.getCurrentView();
        Plan pr = v.pref;
        if (pr == null) {
            return;
        }
        Projection proj = pr.projd;
        if (proj == null) {
            return;
        }
        PointD p = v.getPosition(x, y);
        Coord c = new Coord();
        c.x = p.x;
        c.y = p.y;
        proj.getCoord(c);
        if (Double.isNaN(c.al)) {
            return;
        }
        this.server[this.current].setTarget(this.aladin.localisation.getFrameCoord(c.getSexa()));
    }

    protected void stopGrabIt() {
        JToggleButton grab = this.server[this.current].grab;
        if (grab != null) {
            Plan pref = this.aladin.calque.getPlanRef();
            grab.getModel().setSelected(false);
            grab.setEnabled(pref != null && Projection.isOk(pref.projd));
            Server s = this.server[this.current];
            if (s.tree != null && !s.tree.isEmpty()) {
                s.tree.clear();
            }
        }
        this.toFront();
    }

    protected void startGrabIt() {
        if (this.server[this.current].grab == null || !this.server[this.current].grab.getModel().isSelected()) {
            return;
        }
        this.aladin.f.toFront();
    }

    protected boolean isGrabIt() {
        return this.server[this.current].modeCoo != 0 && this.server[this.current].grab != null && this.server[this.current].grab.getModel().isSelected();
    }

    protected void setGrabItRadius(double x1, double y1, double x2, double y2) {
        if (this.server[this.current].modeRad == 0) {
            return;
        }
        if (Math.abs(x1 - x2) < 3.0 && Math.abs(y1 - y2) < 3.0) {
            return;
        }
        ViewSimple v = this.aladin.view.getCurrentView();
        Plan pr = v.pref;
        if (pr == null) {
            return;
        }
        Projection proj = pr.projd;
        if (proj == null) {
            return;
        }
        PointD p1 = v.getPosition(x1, y1);
        PointD p2 = v.getPosition(x2, y2);
        Coord c1 = new Coord();
        c1.x = p1.x;
        c1.y = p1.y;
        proj.getCoord(c1);
        if (Double.isNaN(c1.al)) {
            return;
        }
        Coord c2 = new Coord();
        c2.x = p2.x;
        c2.y = p2.y;
        proj.getCoord(c2);
        if (Double.isNaN(c2.al)) {
            return;
        }
        this.server[this.current].resolveRadius(Coord.getUnit(Coord.getDist(c1, c2)), true);
    }

    protected void adjustParameters() {
        this.setDefaultParameters(this.current, 3);
    }

    protected synchronized void setDefaultParameters(int i, int mode) {
        block20: {
            String defTarget;
            Projection proj;
            String lastTarget = null;
            String lastTaille = null;
            String radec = null;
            String taille = null;
            String epoch = null;
            String objet = null;
            if (mode == 1 || mode == 2 || mode == 5) {
                lastTarget = this.getDefaultTarget();
                if (lastTarget.length() == 0) {
                    lastTarget = null;
                }
                if ((lastTaille = this.getDefaultTaille()).length() == 0) {
                    lastTaille = null;
                }
            }
            boolean tooLarge = false;
            ViewSimple v = this.aladin.view.getCurrentView();
            if (v != null && !v.isFree() && v.pref != null && (proj = v.getProj()) != null) {
                if (mode == 1 || mode == 2 || mode == 4 || mode == 5) {
                    objet = v.pref.objet;
                }
                if (mode != 2 && mode != 3 && Projection.isOk(proj)) {
                    boolean bl = tooLarge = proj.rm > 10800.0;
                    if (v.pref.isImage()) {
                        Calib c = proj.c;
                        taille = Coord.getUnit(c.getImgWidth()) + " x " + Coord.getUnit(c.getImgHeight());
                    } else {
                        taille = Coord.getUnit(proj.rm / 120.0);
                    }
                }
                if (mode == 3) {
                    taille = v.getTaille(2);
                }
                radec = mode == 2 || mode == 3 || mode == 5 || v.pref instanceof PlanBG ? Coord.getSexa(this.aladin.view.repere.raj, this.aladin.view.repere.dej, ":") : v.getCentre();
                if (tooLarge) {
                    radec = null;
                    taille = null;
                }
            } else {
                lastTarget = this.getDefaultTarget();
                lastTaille = this.getDefaultTaille();
            }
            String string = lastTarget != null ? lastTarget : (objet != null ? this.aladin.localisation.getFrameCoord(objet) : (defTarget = radec != null ? this.aladin.localisation.getFrameCoord(radec) : ""));
            String defTaille = mode == 5 ? (lastTaille != null ? lastTaille : taille) : (taille != null ? taille : lastTaille);
            this.setDefaultTarget(defTarget);
            if (this.server[i].modeRad != 0) {
                this.setDefaultTaille(taille);
            }
            if (v != null) {
                epoch = v.getEpoch();
                if (epoch != null) {
                    this.server[i].setDate(epoch);
                } else if (v.pref instanceof PlanImage && (epoch = ((PlanImage)v.pref).getDateObs()) != null) {
                    this.server[i].setDate(epoch);
                }
                this.setDefaultDate(epoch);
            }
            if (!(this.server[i].tree == null || this.server[i].tree.isEmpty() || this.server[i].target != null && this.server[i].target.getText().trim().length() == 0)) {
                return;
            }
            this.server[i].setTarget(defTarget);
            try {
                if (defTaille != null && defTaille.trim().length() != 0 && this.server[i].modeRad != 0) {
                    this.server[i].resolveRadius(defTaille, true);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block20;
                e.printStackTrace();
            }
        }
    }

    protected void setGrab() {
        Plan pref = this.aladin.calque.getPlanRef();
        boolean flag = pref != null && pref.projd != null;
        for (int i = 0; i < this.server.length; ++i) {
            if (this.server[i] == null || this.server[i].grab == null) continue;
            this.server[i].grab.setEnabled(flag);
        }
    }

    void showNow() {
        while (!this.packed()) {
            Util.pause(100);
        }
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag) {
            super.setVisible(false);
            return;
        }
        if (!this.packed()) {
            return;
        }
        if (this.current >= 0) {
            this.server[this.current].resumeTargetLabel();
        }
        if (!this.flagSetPos) {
            this.setLocation(Aladin.computeLocation(this));
            if (this.current >= 0) {
                this.server[this.current].setInitialFocus();
                this.server[this.current].initServer();
            }
            this.flagSetPos = true;
        }
        this.setDefaultParameters(this.current, 2);
        try {
            super.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void resume() {
        this.setGrab();
        this.server[this.current].resumeTargetLabel();
        this.server[this.current].resumeInputChoice();
    }

    protected boolean submitServer(String nom) {
        int i = this.findIndiceServer(nom);
        if (i < 0 && this.vizierSurveys.setParam(nom)) {
            i = this.findIndiceServer(this.vizierSurveys);
        }
        if (i < 0 && this.vizierArchives.setParam(nom)) {
            i = this.findIndiceServer(this.vizierArchives);
        }
        if (i < 0) {
            return false;
        }
        this.setCurrent(i);
        if (!Aladin.OUTREACH || this.getDefaultTarget().length() == 0) {
            this.toFront();
        } else {
            this.server[i].submit();
        }
        return true;
    }

    public boolean show(String nom) {
        int i = this.findIndiceServer(nom);
        if (i < 0) {
            return false;
        }
        this.setCurrent(i);
        this.toFront();
        return true;
    }

    protected void show(Server x) {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.setCurrent(this.findIndiceServer(x));
        this.toFront();
    }

    protected boolean show(Server x, String param1) {
        if (x == null || !x.setParam(param1)) {
            return false;
        }
        this.setCurrent(this.findIndiceServer(x));
        this.toFront();
        return true;
    }

    @Override
    public void toFront() {
        this.setExtendedState(0);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        super.toFront();
    }

    private int findIndiceServer(Server x) {
        for (int i = 0; i < this.server.length; ++i) {
            if (this.server[i] != x) continue;
            return i;
        }
        return -1;
    }

    protected int findIndiceServer(String s) {
        for (int i = 0; i < this.server.length; ++i) {
            if (!this.server[i].sameNom(s)) continue;
            return i;
        }
        return -1;
    }

    protected int getCurrent() {
        return this.current;
    }

    protected String[] getServerNames(int type, boolean all) {
        int n = 0;
        String[] res = null;
        for (int j = 0; j < 2; ++j) {
            if (j == 1) {
                res = new String[n];
            }
            n = 0;
            for (int i = 0; i < this.server.length; ++i) {
                if (this.server[i] == null || this.server[i].isHidden() || this.server[i] instanceof ServerFolder || (this.server[i].type & type) == 0 || !all && !(this.server[i] instanceof ServerGlu)) continue;
                String[] s = this.server[i].getNomPaths();
                if (j == 1) {
                    for (int k = 0; k < s.length; ++k) {
                        res[n + k] = s[k];
                    }
                }
                n += s.length;
            }
        }
        return res;
    }

    protected String[] getServerLogos(int type) {
        int n = 0;
        String[] res = null;
        for (int j = 0; j < 2; ++j) {
            if (j == 1) {
                res = new String[n];
            }
            n = 0;
            for (int i = 0; i < this.server.length; ++i) {
                if (this.server[i] == null || this.server[i].isHidden() || this.server[i] instanceof ServerFolder || this.server[i].type != type) continue;
                String[] s = new String[]{this.server[i].aladinLogo};
                if (j == 1) {
                    for (int k = 0; k < s.length; ++k) {
                        res[n + k] = s[k];
                    }
                }
                n += s.length;
            }
        }
        return res;
    }

    protected void setCurrent(String s) {
        this.setCurrent(this.findIndiceServer(s));
    }

    protected void setCurrent(int i) {
        if (i < 0 || i >= this.server.length) {
            return;
        }
        if (this.buttons[i] != null) {
            this.buttons[i].push();
        }
        this.setDefaultParameters(i, 2);
        this.current = i;
        this.curServer = this.server[this.current];
        this.bcurrent = this.server[i].aladinMenu != null ? this.findIndiceServer(this.server[i].aladinMenu) : i;
        this.selectDialog.invalidate();
        this.selectDialog.repaint();
        this.popOtherButton();
        if (this.server[i] instanceof ServerGlu) {
            ((ServerGlu)this.server[i]).majChoiceSize();
        }
        this.card.show(this.mp, this.server[i].aladinLabel);
        if (this.server[i] instanceof ServerVizieR) {
            ((ServerVizieR)this.server[VIZIER]).hideSFrame();
        }
        this.server[i].setInitialFocus();
        this.server[i].initServer();
        this.invalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof JButton)) {
            return;
        }
        String s = ((JButton)e.getSource()).getActionCommand();
        if (this.CLOSE.equals(s)) {
            this.server[this.current].memTarget();
            this.cache();
            return;
        }
        if (this.CLEAR.equals(s)) {
            this.server[this.current].clear();
            return;
        }
        if (this.SUBMIT.equals(s)) {
            if ((e.getModifiers() & 1) != 0) {
                this.server[this.current].flagVerif = false;
            }
            this.server[this.current].submit();
            return;
        }
        if (this.RESET.equals(s)) {
            this.server[this.current].reset();
            return;
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (!(what instanceof String)) {
            return false;
        }
        this.server[this.current].memTarget();
        this.setCurrent((String)what);
        return false;
    }

    @Override
    public boolean findWidget(String name) {
        return name.equalsIgnoreCase("local") || name.equalsIgnoreCase("simbad") || name.equalsIgnoreCase("ned") || name.equals("vizier") || name.equals("aladin");
    }

    @Override
    public Point getWidgetLocation(String name) {
        ComponentLocator cl = new ComponentLocator();
        if (name.equalsIgnoreCase("local") || name.equalsIgnoreCase("mydata")) {
            return cl.getLocation(this.buttons[LOCAL], this);
        }
        if (name.equalsIgnoreCase("simbad")) {
            return cl.getLocation(this.buttons[SIMBAD], this);
        }
        if (name.equalsIgnoreCase("ned")) {
            return cl.getLocation(this.buttons[NED], this);
        }
        if (name.equalsIgnoreCase("vizier")) {
            return cl.getLocation(this.buttons[VIZIER], this);
        }
        if (name.equalsIgnoreCase("aladin")) {
            return cl.getLocation(this.buttons[ALADIN], this);
        }
        return null;
    }

    @Override
    public void show() {
        super.show();
        this.startHipsUpdater();
    }

    @Override
    public void hide() {
        this.stopHipsUpdater();
        super.hide();
    }

    private void startHipsUpdater() {
        if (this.threadUpdater == null) {
            this.threadUpdater = new Updater("HipsUpdater");
            this.threadUpdater.start();
        } else {
            this.encore = true;
        }
    }

    private void stopHipsUpdater() {
        this.encore = false;
    }

    class Updater
    extends Thread {
        public Updater(String s) {
            super(s);
        }

        @Override
        public void run() {
            ServerDialog.this.encore = true;
            while (ServerDialog.this.encore) {
                try {
                    ((ServerHips)ServerDialog.this.aladin.dialog.hipsServer).hipsUpdate();
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            ServerDialog.this.threadUpdater = null;
        }
    }
}

