/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Ball;
import cds.aladin.Coord;
import cds.aladin.Export;
import cds.aladin.FrameInfoServer;
import cds.aladin.MetaDataTree;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.Projection;
import cds.aladin.Tok;
import cds.aladin.View;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class Server
extends JPanel
implements ActionListener,
KeyListener,
Comparator {
    static final int IMAGE = 1;
    static final int CATALOG = 2;
    static final int SPECTRUM = 4;
    static final int APPLI = 8;
    static final int APPLIIMG = 16;
    static final int STATUS_OK = 0;
    static final int STATUS_NORESULT = 1;
    static final int STATUS_ERROR = 2;
    static final int STATUS_QUERYING = 3;
    static final int STATUS_ABORT = 4;
    static int WIDTH = Aladin.OUTREACH ? 430 : 500;
    static int HEIGHT = Aladin.OUTREACH ? 300 : 400;
    static final int YOUTREACH = 60;
    static final int MAXSELECTEDPLANE = 10;
    protected String TARGET;
    protected String RAD;
    protected String GRABIT = "";
    protected String DEFAULT_METHODE;
    protected String TARGET_EX;
    protected String RADIUS_EX;
    protected String WNEEDOBJ;
    protected String WNEEDRAD;
    protected String WNEEDDATE;
    protected String WNEEDCAT;
    protected String WERROR;
    protected String WTOOLARGE;
    protected String WERRORDATE;
    protected String WDEJA;
    protected String HASFILTER1;
    protected String HASFILTER2;
    protected String NOINPUTITEM;
    protected String WNEEDCHECK;
    protected String UNKNOWNOBJ;
    protected String NOTTOOMANY;
    static final int XTAB1 = 10;
    static final int XTAB2 = 160;
    static final int XWIDTH = WIDTH - 10;
    String ordre = "X";
    MetaDataTree tree = null;
    JTextArea tap = null;
    static boolean message = true;
    JTextField target = null;
    JTextField radius;
    protected boolean DISCOVERY = false;
    protected boolean TESTSERVER = false;
    protected boolean HIDDEN = false;
    protected static final int MAXINPUT = 10;
    protected JTextField[] coo;
    protected JTextField[] rad;
    protected JTextField date;
    protected JComponent[] input;
    protected int nbInput = 0;
    protected JLabel targetLabel = null;
    protected int modeDate = 0;
    protected int modeRad = 0;
    protected int modeCoo = 0;
    protected int[] modeInput;
    static final int NOMODE = 0;
    static final int COO = 1;
    static final int COOb = 2;
    static final int SIMBAD = 4;
    static final int NED = 8;
    static final int RADEC = 16;
    static final int RADEd = 32;
    static final int RADEb = 64;
    static final int RADE6 = 128;
    static final int COOd = 256;
    static final int RADIUS = 1;
    static final int RADSQR = 2;
    static final int RADBOX = 4;
    static final int RADIUSd = 8;
    static final int RADIUSs = 16;
    static final int RADSQRd = 32;
    static final int RADBOXd = 64;
    static final int RADSQRs = 128;
    static final int RADBOXs = 256;
    static final int JD = 1;
    static final int MJD = 2;
    static final int YEARd = 4;
    static final int IMG = 1;
    static final int IMGs = 2;
    static final int CAT = 4;
    static final int CATs = 8;
    static final int ALLIMG = 16;
    static int ORDRE = 0;
    int type;
    protected double aladinMenuNumber = 0.0;
    protected String title;
    protected String aladinLabel = "";
    protected String description;
    protected String verboseDescr;
    protected String institute;
    protected String aladinLogo;
    protected String docUser = null;
    JToggleButton grab = null;
    String aladinMenu = null;
    boolean flagVerif = true;
    boolean flagToFront = true;
    protected String[] filters;
    JComboBox filtersChoice = null;
    private Component maxComp = null;
    protected JCheckBox cbAllVO = null;
    protected boolean filterAllVO = true;
    protected JLabel statusAllVO;
    protected JButton statusReport = null;
    protected String statusUrl = null;
    protected String statusError = null;
    protected Ball ball;
    protected Aladin aladin;
    protected static int HAUT = 25;
    protected static int MARGE = 1;
    protected JCheckBox testServer = null;
    protected final int NOPICK = 1;
    protected final int NORADIUS = 2;
    protected final int NOTARGET = 4;
    protected final int FORVIZIER = 8;
    protected final int FORALADIN = 16;
    boolean initDone;
    private boolean maximizeInYOnly = false;
    private static String EXERGUE = ">>> ";

    protected String getTitle() {
        return this.aladinLabel;
    }

    protected String getOrigin() {
        return this.institute;
    }

    protected String getType() {
        return this.type == 1 ? "Image" : (this.type == 2 ? "Catalog" : (this.type == 4 ? "Spectra" : ""));
    }

    protected MyInputStream getMetaData(String target, String radius, StringBuffer infoUrl) throws Exception {
        return null;
    }

    protected boolean isHidden() {
        return this.HIDDEN;
    }

    protected boolean isDiscovery() {
        return this.DISCOVERY;
    }

    protected boolean isAllVOChecked() {
        if (!this.filterAllVO) {
            return false;
        }
        if (this.cbAllVO == null) {
            return true;
        }
        return this.cbAllVO.isSelected();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getSize() {
        return new Dimension(WIDTH, HEIGHT);
    }

    protected void createChaine() {
        this.TARGET = Aladin.chaine.getString("TARGET");
        this.TARGET_EX = Aladin.chaine.getString("TARGET_EX");
        this.RAD = Aladin.chaine.getString("RADIUS");
        this.RADIUS_EX = Aladin.chaine.getString("RADIUS_EX");
        this.GRABIT = Aladin.chaine.getString("GRABIT");
        this.WNEEDCHECK = Aladin.chaine.getString("WNEEDCHECK");
        this.WNEEDOBJ = Aladin.chaine.getString("WNEEDOBJ");
        this.WNEEDDATE = Aladin.chaine.getString("WNEEDDATE");
        this.WNEEDRAD = Aladin.chaine.getString("WNEEDRAD");
        this.WNEEDCAT = Aladin.chaine.getString("WNEEDCAT");
        this.WERROR = Aladin.chaine.getString("WERROR");
        this.WTOOLARGE = Aladin.chaine.getString("WTOOLARGE");
        this.WERRORDATE = Aladin.chaine.getString("WERRORDATE");
        this.WDEJA = Aladin.chaine.getString("WDEJA");
        this.HASFILTER1 = Aladin.chaine.getString("HASFILTER1");
        this.HASFILTER2 = Aladin.chaine.getString("HASFILTER2");
        this.NOINPUTITEM = Aladin.chaine.getString("NOINPUTITEM");
        this.UNKNOWNOBJ = Aladin.chaine.getString("UNKNOWNOBJ");
        this.NOTTOOMANY = Aladin.chaine.getString("NOTTOOMANY");
        this.statusAllVO = new JLabel(" ");
    }

    protected void resumeTargetLabel() {
        if (this.targetLabel == null) {
            return;
        }
        String t = this.TARGET;
        try {
            String frame = this.aladin.localisation.getFrameName();
            if (frame.length() > 0) {
                t = t + " (" + frame + ", name)";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.targetLabel.setText(this.addDot(t));
    }

    protected boolean updateMetaData(MyInputStream is, Server server, String target, String requestedPos, boolean append) {
        boolean rep = append ? this.aladin.treeView.appendToTree(is, this.tree, server, target, requestedPos) : this.aladin.treeView.updateTree(is, this.tree, server, target, requestedPos);
        this.aladin.setButtonMode();
        if (!this.aladin.dialog.isVisible()) {
            this.aladin.dialog.show();
        }
        return rep;
    }

    protected boolean updateMetaData(MyInputStream is, Server server, String target, String requestedPos) {
        return this.updateMetaData(is, server, target, requestedPos, false);
    }

    protected void setStatusAllVO(int status, String url) {
        if (this.statusAllVO == null) {
            return;
        }
        this.statusAllVO.setText(status == 0 ? "Ok    " : (status == 1 ? "No result    " : (status == 3 ? "Querying...    " : (status == 2 ? "Error    " : (status == 4 ? "Abort    " : "-")))));
        this.statusAllVO.setForeground(status == 0 ? Aladin.GREEN : (status == 2 ? Color.red : (status == 1 ? Color.blue : Color.black)));
        this.statusAllVO.setFont(Aladin.BOLD);
        this.statusUrl = url;
    }

    protected MyInputStream getMetaDataForCat(URL u) {
        try {
            Plan plan = new Plan();
            Pcat pcat = new Pcat(plan, null, this.aladin.calque, null, this.aladin);
            int count = pcat.setPlanCat(plan, u, false);
            if (count <= 0) {
                return null;
            }
            MyByteArrayStream bas = null;
            MyByteArrayStream out = bas = new MyByteArrayStream(10000);
            Aladin.writeBytes(out, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\"><VOTABLE version=\"v1.0\"><RESOURCE type=\"results\">   <INFO name=\"QUERY_STATUS\" value=\"OK\"/>   <TABLE><FIELD name=\"Resource\" datatype=\"char\" ucd=\"VOX:Image_Title\" arraysize=\"*\"/><FIELD name=\"Origin\" datatype=\"char\"/><FIELD name=\"url\" datatype=\"char\" ucd=\"VOX:Image_AccessReference\" arraysize=\"*\"/><FIELD ID=\"FORMAT\" datatype=\"char\" arraysize=\"*\"/><DATA><TABLEDATA>   <TR>      <TD>" + this.aladinLabel + ": " + count + " object" + (count > 1 ? "s" : "") + "</TD>" + "      <TD>" + this.institute + "</TD>" + "      <TD><![CDATA[" + u + "]]></TD>" + "      <TD>CATALOG</TD>" + "   </TR>" + "</TABLEDATA>" + "</DATA>" + "</TABLE>" + "</RESOURCE>" + "</VOTABLE>");
            return new MyInputStream(bas.getInputStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String sesameIfRequired(String s, String sep) throws Exception {
        Coord c = !View.notCoord(s) ? new Coord(s) : this.aladin.view.sesame(s);
        return c == null ? null : c.getSexa(sep);
    }

    protected String resolveTarget(String t) throws Exception {
        t = this.aladin.localisation.getICRSCoord(t);
        if (this.coo != null) {
            if ((this.modeCoo & 4) != 0) {
                this.coo[0].setText(t);
                return t;
            }
            Coord c = null;
            c = !View.notCoord(t) ? new Coord(t) : this.aladin.view.sesame(t);
            if (c == null) {
                return null;
            }
            if ((this.modeCoo & 1) != 0) {
                this.coo[0].setText(c.getSexa(":"));
            } else if ((this.modeCoo & 2) != 0) {
                this.coo[0].setText(c.getSexa(" "));
            } else if ((this.modeCoo & 0x100) != 0) {
                this.coo[0].setText(c.al + " " + (c.del >= 0.0 ? "+" : "") + c.del);
            } else if ((this.modeCoo & 0x10) != 0) {
                this.coo[0].setText(c.getRA());
                this.coo[1].setText(c.getDE());
            } else if ((this.modeCoo & 0x80) != 0) {
                StringTokenizer tok = new StringTokenizer(c.getRA(), ":");
                this.coo[0].setText(tok.nextToken());
                this.coo[1].setText(tok.nextToken());
                this.coo[2].setText(tok.nextToken());
                tok = new StringTokenizer(c.getDE(), ":");
                this.coo[3].setText(tok.nextToken());
                this.coo[4].setText(tok.nextToken());
                this.coo[5].setText(tok.nextToken());
            } else if ((this.modeCoo & 0x40) != 0) {
                this.coo[0].setText(c.getRA(' '));
                this.coo[1].setText(c.getDE(' '));
                System.out.println("c.getSexa=" + c.getSexa() + " coo[0]= " + c.getRA(' ') + " coo[1]=" + c.getDE(' '));
            } else if ((this.modeCoo & 0x20) != 0) {
                this.coo[0].setText(c.al + "");
                this.coo[1].setText(c.del + "");
            }
            return c.getSexa(":");
        }
        return t;
    }

    protected void resolveRadius(String s, boolean updateRadius) {
        double rm = Server.getRM(s);
        double wm = Server.getWM(s);
        double hm = Server.getHM(s);
        double bm = Math.max(wm, hm);
        if (this.rad != null) {
            if ((this.modeRad & 4) != 0) {
                this.rad[0].setText(wm + "");
                this.rad[1].setText(hm + "");
            } else if ((this.modeRad & 0x40) != 0) {
                this.rad[0].setText(wm / 60.0 + "");
                this.rad[1].setText(hm / 60.0 + "");
            } else if ((this.modeRad & 0x100) != 0) {
                this.rad[0].setText(wm * 60.0 + "");
                this.rad[1].setText(hm * 60.0 + "");
            } else if ((this.modeRad & 2) != 0) {
                this.rad[0].setText(bm + "");
            } else if ((this.modeRad & 0x20) != 0) {
                this.rad[0].setText(bm / 60.0 + "");
            } else if ((this.modeRad & 0x80) != 0) {
                this.rad[0].setText(bm * 60.0 + "");
            } else if ((this.modeRad & 1) != 0) {
                this.rad[0].setText(rm + "");
            } else if ((this.modeRad & 8) != 0) {
                this.rad[0].setText(rm / 60.0 + "");
            } else if ((this.modeRad & 0x10) != 0) {
                this.rad[0].setText(rm * 60.0 + "");
            }
        }
        if (updateRadius && this.modeRad != 0) {
            try {
                String newRadius = Coord.getUnit(rm / 60.0);
                this.radius.setText(newRadius);
                this.radius.setCaretPosition(Math.min(this.radius.getCaretPosition(), newRadius.length()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void resolveDate(String s) {
        this.setDate(s == null ? "" : s);
    }

    protected void waitCursor() {
        this.ball.setMode(4);
        this.makeCursor(1);
    }

    protected void defaultCursor() {
        this.ball.setMode(1);
        this.makeCursor(0);
    }

    protected void makeCursor(int c) {
        Aladin.makeCursor(this.aladin.dialog, c);
        Aladin.makeCursor(this.aladin, c);
        if (this.coo != null) {
            Aladin.makeCursor(this.coo[0], c);
            if (this.coo.length > 1) {
                Aladin.makeCursor(this.coo[1], c);
            }
        }
        if (this.rad != null) {
            Aladin.makeCursor(this.rad[0], c);
        }
        if (this.tree != null) {
            Aladin.makeCursor(this.tree, c);
        }
    }

    protected int stringSize(JLabel l) {
        FontMetrics m = l.getFontMetrics(l.getFont());
        int i = m.stringWidth(l.getText());
        return i + 60;
    }

    protected Dimension makeTitle(JPanel p, String title) {
        p.setLayout(new FlowLayout(1));
        this.ball = new Ball();
        p.add(this.ball);
        JLabel t = new JLabel(title.replace('\n', ' '));
        t.setFont(Aladin.LBOLD);
        p.add(t);
        JButton b = new JButton(new ImageIcon(Aladin.aladin.getImagette("Help.gif")));
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Server.this.showStatusReport();
            }
        });
        Insets m = b.getMargin();
        b.setMargin(new Insets(m.top, 3, m.bottom, 3));
        b.setOpaque(false);
        b.addActionListener(this);
        p.add(b);
        int width = this.stringSize(t) + 20;
        if (this.TESTSERVER) {
            this.testServer = new JCheckBox("test", true);
            this.testServer.setMargin(new Insets(m.top, 10, m.bottom, 3));
            this.testServer.setOpaque(false);
            this.testServer.setSelected(false);
            p.add(this.testServer);
            width += 120;
        }
        return new Dimension(width, HAUT + 5);
    }

    protected String addDot(String s) {
        return s;
    }

    protected int makeTargetPanel(JPanel p, int mode) {
        JLabel label;
        int l;
        int x = 0;
        int y = 0;
        int pickL = 75;
        boolean pickView = (mode & 1) == 0;
        boolean forVizieR = (mode & 8) != 0;
        boolean noRadius = (mode & 2) != 0;
        boolean noTarget = (mode & 4) != 0;
        p.setLayout(null);
        if (!noTarget) {
            l = 150;
            if (forVizieR) {
                l = 100;
            }
            this.targetLabel = label = new JLabel("");
            this.resumeTargetLabel();
            label.setFont(Aladin.BOLD);
            label.setBounds(10, y, l, HAUT);
            p.add(label);
            this.target = new JTextField(40);
            this.target.addKeyListener(this);
            this.target.addActionListener(this);
            x = 160;
            l = XWIDTH - 160;
            if (forVizieR) {
                l = XWIDTH - 180 - 30;
                x = 100;
            }
            if (pickView) {
                l -= pickL;
            }
            this.target.setBounds(x, y, l, HAUT);
            p.add(this.target);
            Util.toolTip(label, this.TARGET_EX);
            Util.toolTip(this.target, this.TARGET_EX);
            if (pickView) {
                this.grab = new JToggleButton(this.GRABIT);
                Insets m = this.grab.getMargin();
                this.grab.setMargin(new Insets(m.top, 2, m.bottom, 2));
                this.grab.setOpaque(false);
                this.grab.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Server.this.aladin.dialog.startGrabIt();
                    }
                });
                this.grab.setFont(Aladin.SBOLD);
                this.grab.setEnabled(false);
                this.grab.setBounds(x + l + 3, y + 2, pickL - 2, HAUT - 4);
                p.add(this.grab);
            }
            y += HAUT + MARGE;
        }
        if (noRadius || forVizieR) {
            return y;
        }
        x = 0;
        l = 55;
        String rad = this.RAD;
        if ((mode & 0x10) != 0) {
            rad = "Search cone";
        }
        label = new JLabel(this.addDot(rad));
        label.setFont(Aladin.BOLD);
        label.setBounds(10, y, 150, HAUT);
        x += l + 5;
        p.add(label);
        this.radius = new JTextField(50);
        this.radius.addKeyListener(this);
        this.radius.addActionListener(this);
        l = XWIDTH - 160;
        if (pickView) {
            l -= pickL;
        }
        this.radius.setBounds(160, y, l, HAUT);
        p.add(this.radius);
        Util.toolTip(label, this.RADIUS_EX);
        Util.toolTip(this.radius, this.RADIUS_EX);
        return (y += HAUT + MARGE) + 3;
    }

    protected void setInitialFocus() {
        if (this.target != null && this.isVisible()) {
            this.target.requestFocusInWindow();
            this.target.setCaretPosition(this.target.getText().length());
        }
    }

    protected void initServer() {
        if (this.initDone) {
            return;
        }
        if (this.tree != null) {
            this.tree.traverseTree();
            this.repaint();
        }
        this.initDone = true;
    }

    protected void setMaxComp(Component c) {
        this.maxComp = c;
    }

    protected void setMaxComp(Component c, boolean onlyInY) {
        this.maximizeInYOnly = onlyInY;
        this.setMaxComp(c);
    }

    private synchronized void maximizeComp() {
        if (this.maxComp == null || this.getBounds().height < 100) {
            return;
        }
        Component[] c = this.getComponents();
        int maxY = 0;
        for (int i = 0; i < c.length; ++i) {
            int y = c[i].getBounds().y + c[i].getBounds().height;
            if (y <= maxY) continue;
            maxY = y;
        }
        int gaph = this.getBounds().height - maxY;
        int yComp = this.maxComp.getBounds().y;
        for (int i = 0; i < c.length; ++i) {
            Rectangle rc = c[i].getBounds();
            if (c[i] == this.maxComp) {
                c[i].setBounds(rc.x, rc.y, this.maximizeInYOnly ? c[i].getBounds().width : this.getBounds().width - rc.x, rc.height + gaph);
                continue;
            }
            if (rc.y <= yComp) continue;
            c[i].setBounds(rc.x, rc.y + gaph, rc.width, rc.height);
        }
    }

    @Override
    public void layout() {
        this.maximizeComp();
        super.layout();
    }

    protected String resolveQueryField() throws Exception {
        if (this.radius != null) {
            this.resolveRadius(this.radius.getText().trim(), false);
        }
        if (this.target == null) {
            return null;
        }
        return this.resolveTarget(this.target.getText().trim());
    }

    protected String getTarget() {
        return this.getTarget(true);
    }

    protected String getTarget(boolean confirm) {
        if (this.target == null) {
            return null;
        }
        String s = this.target.getText().trim();
        if (confirm && s.length() == 0) {
            if (this.ball != null) {
                this.ball.setMode(3);
            }
            Aladin.warning(this, this.WNEEDOBJ);
            return null;
        }
        return this.aladin.localisation.getICRSCoord(s);
    }

    protected String getRadius() {
        return this.getRadius(true);
    }

    protected String getRadius(boolean confirm) {
        if (this.radius == null) {
            return null;
        }
        String s = this.radius.getText().trim();
        if (!confirm) {
            return s;
        }
        if (confirm && (s.length() == 0 || Server.getRM(s) <= 0.0)) {
            this.ball.setMode(3);
            Aladin.warning(this, this.WNEEDRAD);
            return null;
        }
        return s;
    }

    protected String getDate(boolean confirm) {
        if (this.date == null) {
            return null;
        }
        String s = this.date.getText().trim();
        if (s.length() == 0) {
            this.ball.setMode(3);
            if (confirm) {
                Aladin.warning(this, this.WNEEDDATE);
            }
            return null;
        }
        return s;
    }

    protected static double getAngle(String r, int modeRad) {
        int i;
        double fct = 1.0;
        int offsetD1 = r.indexOf(176);
        int offsetD = r.indexOf(100);
        int offsetS = r.indexOf(115);
        int offsetQ = r.indexOf(34);
        int offsetM = r.indexOf(39);
        int offsetM1 = r.indexOf(109);
        if (offsetD1 > 0 || offsetD > 0 && (offsetS == -1 || offsetD > offsetS)) {
            fct = 60.0;
        } else if (offsetS > 0 || offsetQ > 0) {
            fct = 0.016666666666666666;
        } else if (offsetM > 0 || offsetM1 > 0) {
            fct = 1.0;
        } else if (modeRad == 8) {
            fct = 60.0;
        } else if (modeRad == 16) {
            fct = 0.016666666666666666;
        }
        r = new StringTokenizer(r).nextToken();
        char[] a = r.toCharArray();
        for (i = 0; i < a.length && (a[i] >= '0' && a[i] <= '9' || a[i] == '.' || a[i] == '-'); ++i) {
        }
        r = new String(a, 0, i);
        return Double.valueOf(r) * fct;
    }

    protected static double getRM(String s) {
        return Server.getRWM(s, 0);
    }

    protected static double getWM(String s) {
        return Server.getRWM(s, 1);
    }

    protected static double getHM(String s) {
        return Server.getRWM(s, 2);
    }

    private static double getRWM(String s, int mode) {
        double hm;
        double wm;
        double rm;
        if (s.length() == 0) {
            return 0.0;
        }
        int i = s.indexOf(44);
        if (i < 0) {
            i = s.trim().indexOf(120);
        }
        if (i < 0) {
            rm = Server.getAngle(s, 1);
            hm = wm = 2.0 * rm;
        } else {
            wm = Server.getAngle(s.substring(0, i), 1);
            hm = Server.getAngle(s.substring(i + 1), 1);
            rm = Math.sqrt(wm * wm / 4.0 + hm * hm / 4.0);
        }
        switch (mode) {
            case 0: {
                return rm;
            }
            case 1: {
                return wm;
            }
            case 2: {
                return hm;
            }
        }
        return 0.0;
    }

    protected void clear() {
        this.ball.setMode(0);
        this.resolveRadius("14", true);
        if (this.target != null) {
            this.target.setText("");
        }
        this.aladin.dialog.setDefaultTarget("");
    }

    protected void setStepColor(JLabel step1, JLabel step2) {
        JLabel oldStep;
        JLabel step;
        if (this.tree == null) {
            return;
        }
        if (this.tree.isEmpty()) {
            step = step1;
            oldStep = step2;
        } else {
            oldStep = step1;
            step = step2;
        }
        step.setForeground(Color.blue);
        oldStep.setForeground(Color.black);
        String a = oldStep.getText();
        if (a.startsWith(EXERGUE)) {
            oldStep.setText(a.substring(EXERGUE.length()));
        }
        if (!(a = step.getText()).startsWith(EXERGUE)) {
            step.setText(EXERGUE + a);
        }
    }

    protected void reset() {
        this.ball.setMode(0);
        this.aladin.dialog.setDefaultParameters(this.aladin.dialog.getCurrent(), 5);
    }

    protected void setTarget(String s) {
        if (this.target == null || s.equals(this.aladin.GETOBJ)) {
            return;
        }
        this.target.setText(s);
    }

    protected boolean updateWidgets() {
        if (this.aladin.dialog == null) {
            return false;
        }
        if (!this.aladin.dialog.isGrabIt() && this.grab != null) {
            Plan pref = this.aladin.calque.getPlanRef();
            boolean grabEnable = pref != null && Projection.isOk(pref.projd);
            this.grab.setEnabled(grabEnable);
        }
        return true;
    }

    protected void setDate(String s) {
        if (this.date == null) {
            return;
        }
        try {
            double Yd = Double.valueOf(s);
            s = Astrodate.JDToDate(Astrodate.YdToJD(Yd));
            this.date.setText(s);
        }
        catch (Exception e) {
            this.date.setText(s);
        }
        try {
            this.date.setCaretPosition(Math.min(this.date.getCaretPosition(), s.length()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setSelectedItem(Component c, String s) {
        if (c instanceof TextField) {
            ((TextField)c).setText(s);
            return;
        }
        this.resumeInputChoice();
        ((JComboBox)c).setSelectedItem(s);
    }

    protected Plan[] getInputPlane(JComponent c) {
        String masq;
        int n = this.getFieldInput(c);
        if (n == -1) {
            return null;
        }
        if ((this.modeInput[n] & 0x15) != 0 ? (masq = (String)((JComboBox)c).getSelectedItem()).equals(this.NOINPUTITEM) : (masq = ((JTextField)c).getText().trim()).length() == 0) {
            return null;
        }
        Vector v = this.aladin.calque.getPlans(masq);
        if (v == null) {
            return null;
        }
        Vector<Plan> v1 = new Vector<Plan>();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Plan p = (Plan)e.nextElement();
            if (!p.flagOk || (this.modeInput[n] & 0xC) != 0 && !p.isSimpleCatalog() || (this.modeInput[n] & 0x13) != 0 && !p.isImage()) continue;
            v1.addElement(p);
            if ((this.modeInput[n] & 0x15) == 0) continue;
            break;
        }
        if (v1.size() == 0) {
            return null;
        }
        Object[] plan = new Plan[v1.size()];
        v1.copyInto(plan);
        return plan;
    }

    protected String getInputPlaneName(JComponent c) {
        Plan[] plan = this.getInputPlane(c);
        if (plan == null) {
            return "";
        }
        StringBuffer res = null;
        for (int i = 0; i < plan.length; ++i) {
            String name = plan[i].getLabel();
            if (res == null) {
                res = new StringBuffer(name);
                continue;
            }
            res.append(" " + name);
        }
        return res == null ? null : res.toString();
    }

    protected String getInputUrl(JComponent c) {
        Plan[] plan = this.getInputPlane(c);
        if (plan == null) {
            return "";
        }
        StringBuffer res = null;
        for (int i = 0; i < plan.length; ++i) {
            String url = plan[i].getUrl();
            if (url == null || url.startsWith("file:")) {
                url = Export.export(plan[i]);
            }
            if (url == null) continue;
            url = Server.backSlashPipe(url);
            if (res == null) {
                res = new StringBuffer(url);
                continue;
            }
            res.append("|" + url);
        }
        return res == null ? null : res.toString();
    }

    protected static String backSlashPipe(String s) {
        char[] a = s.toCharArray();
        StringBuffer res = new StringBuffer(100);
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == '|') {
                res.append("\\|");
                continue;
            }
            res.append(a[i]);
        }
        return res.toString();
    }

    protected boolean isFieldTargetOrRadius(JComponent c) {
        if (this.coo != null) {
            if (this.coo[0] == c) {
                return true;
            }
            if (this.coo.length > 1 && this.coo[1] == c) {
                return true;
            }
        }
        if (this.rad != null) {
            if (this.rad[0] == c) {
                return true;
            }
            if (this.rad.length > 1 && this.rad[1] == c) {
                return true;
            }
        }
        return false;
    }

    protected boolean isFieldDate(JComponent c) {
        return this.date != null;
    }

    protected boolean isFieldInput(JComponent c) {
        return this.getFieldInput(c) >= 0;
    }

    protected int getFieldInput(JComponent c) {
        if (this.input == null) {
            return -1;
        }
        for (int i = 0; i < this.nbInput; ++i) {
            if (this.input[i] != c) continue;
            return i;
        }
        return -1;
    }

    protected void resumeInputChoice() {
        if (this.input == null) {
            return;
        }
        Vector<Plan> vCat = this.aladin.calque.getPlanCat();
        Vector<Plan> vImg = this.aladin.calque.getPlanImg();
        Vector<Plan> vAllImg = this.aladin.calque.getPlanAllImg();
        for (int i = 0; i < this.nbInput; ++i) {
            if ((this.modeInput[i] & 0x15) == 0) continue;
            this.adjustInputChoice((JComboBox)this.input[i], (this.modeInput[i] & 1) != 0 ? vImg : ((this.modeInput[i] & 0x10) != 0 ? vAllImg : vCat), 0);
        }
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            this.resumeTargetLabel();
            this.resumeInputChoice();
        }
        super.setVisible(flag);
    }

    protected void adjustInputChoice(JComboBox c, Vector v, int defaut) {
        int i = c.getSelectedIndex();
        String s = i >= 0 ? (String)c.getItemAt(i) : null;
        c.removeAllItems();
        c.addItem(this.NOINPUTITEM);
        if (v != null) {
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                c.addItem(((Plan)e.nextElement()).label);
            }
        }
        if (defaut > 0) {
            c.setSelectedIndex(defaut);
        } else if (s == null || s.equals(this.NOINPUTITEM)) {
            c.setSelectedIndex(c.getItemCount() > 1 ? 1 : 0);
        } else {
            c.setSelectedItem(s);
        }
    }

    protected boolean is(String s) {
        if (s.endsWith("s")) {
            s = s.substring(0, s.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(this.aladinLabel, " .");
        while (st.hasMoreTokens()) {
            String m = st.nextToken(" ()");
            if (m.endsWith("s")) {
                m = m.substring(0, m.length() - 1);
            }
            if (!s.equalsIgnoreCase(m)) continue;
            return true;
        }
        return false;
    }

    protected int createPlane(String target, String radius, String criteria, String label, String origin) {
        return -1;
    }

    protected boolean verif(int type, String obj, String qual) {
        return this.verif(type, obj, qual, null);
    }

    protected boolean verif(int type, String obj, String qual, String other) {
        return true;
    }

    static String specialUnQuoteCriteria(String s) {
        if (s == null || s.length() < 2) {
            return s;
        }
        StringBuffer rep = null;
        Tok st = new Tok(s, " ,");
        while (st.hasMoreTokens()) {
            if (rep == null) {
                rep = new StringBuffer(st.nextToken());
                continue;
            }
            rep.append("," + st.nextToken());
        }
        return rep.toString();
    }

    protected boolean tooManyChecked() {
        int n = this.tree.nbSelected();
        if (n > 0 && n < 10) {
            return false;
        }
        return !Aladin.confirmation(this, this.NOTTOOMANY + " (" + n + ")");
    }

    public void submit() {
    }

    protected String getDefaultTarget() {
        return this.aladin.dialog.getDefaultTarget();
    }

    protected String getDefaultTaille() {
        return this.aladin.dialog.getDefaultTaille();
    }

    protected String getDefaultDate() {
        return this.aladin.dialog.getDefaultDate();
    }

    protected void memTarget() {
        if (this.target != null && this.modeCoo != 0) {
            this.aladin.dialog.setDefaultTarget(this.target.getText().trim());
        }
        if (this.radius != null && this.modeRad != 0) {
            this.aladin.dialog.setDefaultTaille(this.radius.getText().trim());
        }
    }

    protected void showStatusReport() {
        if (this.aladin.frameInfoServer == null) {
            this.aladin.frameInfoServer = new FrameInfoServer(this.aladin);
        }
        this.aladin.frameInfoServer.show(this);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object s = arg0.getSource();
        if (s instanceof JComboBox && this.tree != null && !this.tree.isEmpty()) {
            this.tree.clear();
        }
        this.updateWidgets();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() instanceof JTextField) {
            if (this.tree != null && !this.tree.isEmpty() && !e.isActionKey() && (e.getModifiers() == 0 || e.isShiftDown() && e.getKeyCode() != 16)) {
                this.tree.clear();
            }
            if (this.ball != null) {
                this.ball.setMode(0);
            }
            if (e.getKeyCode() == 10) {
                this.flagVerif = !e.isShiftDown();
                this.submit();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateWidgets();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected String[] getNomPaths() {
        char c;
        int i;
        StringBuffer res = new StringBuffer();
        if (this.aladinMenu != null) {
            for (i = 0; i < this.aladinMenu.length(); ++i) {
                c = this.aladinMenu.charAt(i);
                if (c == '/') {
                    res.append('\\');
                }
                res.append(c);
            }
            while (res.charAt(i = res.length() - 1) == '.') {
                res.deleteCharAt(i);
            }
            res.append('/');
        }
        for (i = 0; i < this.aladinLabel.length(); ++i) {
            c = this.aladinLabel.charAt(i);
            if (c == '/') {
                res.append('\\');
            }
            if (c == '\n') {
                c = ' ';
            }
            res.append(c);
        }
        return new String[]{res.toString()};
    }

    protected boolean sameNom(String s) {
        return Server.sameNom(this.aladinLabel, s);
    }

    protected static boolean sameNom(String nom, String s) {
        int n = nom.length();
        if (s.length() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int c = nom.charAt(i);
            int d = s.charAt(i);
            if (c == 10) {
                c = 32;
            }
            if (d == 10) {
                d = 32;
            }
            if (c == d) continue;
            return false;
        }
        return true;
    }

    protected boolean setParam(String param) {
        return false;
    }

    protected String getNom() {
        StringTokenizer st = new StringTokenizer(this.aladinLabel);
        return st.nextToken();
    }

    protected Frame getFrame(Component c) {
        while (c != null && !(c instanceof Frame)) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    protected static String getFilterDescription(String filter) {
        if (filter.charAt(0) != '#') {
            return null;
        }
        int i = filter.indexOf(10);
        if (i < 0) {
            return null;
        }
        return filter.substring(1, i).trim();
    }

    protected static String getFilterName(String filter) {
        int i = filter.indexOf((filter.charAt(0) == '#' ? "\n" : "") + "filter ");
        if (i < 0) {
            return null;
        }
        int j = filter.indexOf(123, i);
        String s = filter.substring(i + 7, j).trim();
        return s;
    }

    protected static String getFilter(String filter) {
        int i = filter.indexOf((filter.charAt(0) == '#' ? "\n" : "") + "filter ");
        if (i < 0) {
            return null;
        }
        return filter.substring(i).trim();
    }

    protected static int getFilterIndex(String[] filters, String name) {
        String n;
        int i;
        for (i = 0; i < filters.length; ++i) {
            n = Server.getFilterName(filters[i]);
            if (n == null || !n.equals(name)) continue;
            return i;
        }
        for (i = 0; i < filters.length; ++i) {
            n = Server.getFilterDescription(filters[i]);
            if (n == null || !n.equals(name)) continue;
            return i;
        }
        return -1;
    }

    protected static String getFilterScript(String filter) {
        int i = filter.indexOf(123);
        int j = filter.lastIndexOf(125);
        if (i < 0 || j < 0) {
            return null;
        }
        return filter.substring(i + 1, j).trim();
    }

    protected JComboBox createFilterChoice() {
        this.filtersChoice = new JComboBox();
        this.populateFilterChoice(this.filtersChoice);
        return this.filtersChoice;
    }

    protected void modifyFilterChoice(String[] AF) {
        this.filters = AF;
        if (this.filtersChoice == null) {
            this.filtersChoice = this.createFilterChoice();
        } else {
            this.filtersChoice.removeAll();
            this.populateFilterChoice(this.filtersChoice);
        }
    }

    private void populateFilterChoice(JComboBox c) {
        c.addItem(" - no filter -");
        for (int i = 0; i < this.filters.length; ++i) {
            String name = Server.getFilterDescription(this.filters[i]);
            if (name == null) {
                name = Server.getFilterName(this.filters[i]);
            }
            if (name == null) continue;
            c.addItem(name);
        }
        c.setSelectedIndex(this.aladin.configuration.getFilter() + 1);
    }

    protected void getGluFilters(String tagGlu) {
        Object f;
        if (this.aladin.glu.aladinDicFilters != null && (f = this.aladin.glu.aladinDicFilters.get(tagGlu)) != null) {
            this.filters = (String[])f;
        }
    }

    protected int getFilterChoiceIndex() {
        int nFilter = -1;
        if (this.filtersChoice != null) {
            nFilter = Server.getFilterIndex(this.filters, (String)this.filtersChoice.getSelectedItem());
        }
        return nFilter;
    }

    protected void setStatus() {
        Plan[] allPlan = this.aladin.calque.getPlans();
        for (int i = 0; i < allPlan.length; ++i) {
            Plan p = allPlan[i];
            if (p.server != this || p.type == 0) continue;
            if (!p.flagOk && p.error == null) {
                this.ball.setMode(4);
            } else if (p.error != null && !p.hasNoReduction()) {
                this.ball.setMode(5);
            } else if (p.error != null) {
                this.ball.setMode(3);
            } else {
                this.ball.setMode(1);
            }
            return;
        }
        if (this.ball.isBlinking()) {
            this.ball.setMode(0);
        }
    }

    protected int addFilterComment(int x, int y) {
        JLabel label = new JLabel(this.HASFILTER1);
        label.setFont(Aladin.ITALIC);
        label.setBounds(x, y, 455 - x, 20);
        y += 18;
        label.setForeground(Color.blue);
        this.add(label);
        label = new JLabel(this.HASFILTER2);
        label.setFont(Aladin.ITALIC);
        label.setBounds(x, y, 455 - x, 20);
        label.setForeground(Color.blue);
        this.add(label);
        return y += 18;
    }

    protected static Comparator getComparator() {
        return new Server();
    }

    public int compare(Object o1, Object o2) {
        Server a1 = (Server)o1;
        Server a2 = (Server)o2;
        if (a1.ordre == a2.ordre) {
            return 0;
        }
        if (a1.ordre == null) {
            return -1;
        }
        if (a2.ordre == null) {
            return 1;
        }
        return a1.ordre.compareTo(a2.ordre);
    }
}

