/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Obj;
import cds.aladin.ViewSimple;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Segment {
    static final int NOLABEL = 0;
    static final int GAUCHE = 1;
    static final int HAUT = 2;
    static final int MILIEURA = 3;
    static final int MILIEUDE = 4;
    static final int ISOUNKNOWN = 0;
    static final int ISORA = 1;
    static final int ISODE = 2;
    protected double al1;
    protected double del1;
    protected double al2;
    protected double del2;
    protected int iso = 0;
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;
    protected String label = null;
    protected int labelMode = 0;
    protected boolean horsChamp;
    private Rectangle clip = null;
    private Coord c = new Coord();
    static final int BETA = (int)(1.0 / Math.tan(0.08726646259971647));
    private static boolean col;

    protected Segment createNextSegment() {
        Segment seg = new Segment();
        seg.del1 = seg.del2 = this.del2;
        seg.al1 = seg.al2 = this.al2;
        seg.x1 = seg.x2 = this.x2;
        seg.y1 = seg.y2 = this.y2;
        return seg;
    }

    protected Segment copy(boolean withLabel) {
        Segment seg = new Segment();
        seg.al1 = this.al1;
        seg.al2 = this.al2;
        seg.del1 = this.del1;
        seg.del2 = this.del2;
        seg.x1 = this.x1;
        seg.x2 = this.x2;
        seg.y1 = this.y1;
        seg.y2 = this.y2;
        seg.iso = this.iso;
        seg.clip = this.clip;
        if (withLabel) {
            seg.labelMode = this.labelMode;
            seg.label = this.label;
        }
        return seg;
    }

    protected Segment[] subdivise(ViewSimple v) throws Exception {
        Segment[] seg = new Segment[]{this.copy(true), this.copy(false)};
        double al = (this.al2 + this.al1 - (double)(Math.abs(this.al2 - this.al1) > 180.0 ? 360 : 0)) / 2.0;
        double del = (this.del2 + this.del1) / 2.0;
        seg[0].al2 = seg[1].al1 = al;
        seg[0].del2 = seg[1].del1 = del;
        Point p = this.getXY(v, al, del);
        if (p == null) {
            p = new Point(-1, -1);
        }
        seg[0].x2 = seg[1].x1 = p.x;
        seg[0].y2 = seg[1].y1 = p.y;
        return seg;
    }

    private Point getXY(ViewSimple v, double al, double del) {
        this.c.al = al;
        this.c.del = del;
        this.c = v.aladin.localisation.frameToICRS(this.c);
        v.getProj().getXY(this.c);
        this.clip = null;
        if (Double.isNaN(this.c.x)) {
            return null;
        }
        return v.getViewCoord(this.c.x, this.c.y);
    }

    protected boolean projection(ViewSimple v) {
        Point p = this.getXY(v, this.al2, this.del2);
        if (p == null) {
            return false;
        }
        this.x2 = p.x;
        this.y2 = p.y;
        return true;
    }

    protected static boolean courbe(Segment s1, Segment s2) {
        double dx1 = s1.x2 - s1.x1;
        double dy2 = s2.y2 - s2.y1;
        double dx2 = s2.x2 - s2.x1;
        double dy1 = s1.y2 - s1.y1;
        return Math.abs(dx1 * dy2 - dx2 * dy1) > 1.0 + Math.abs(dx1 * dx2 + dy1 * dy2) / (double)BETA;
    }

    protected double distXY() {
        return Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
    }

    protected boolean inClip(Rectangle clip) {
        if (clip == null) {
            return true;
        }
        return Obj.intersectRect(clip, Math.min(this.x1, this.x2) - 2, Math.min(this.y1, this.y2) - 2, Math.abs(this.x2 - this.x1) + 4, Math.abs(this.y2 - this.y1) + 4);
    }

    protected void draw(Graphics g, ViewSimple v, Rectangle clip, int i, int dx, int dy) {
        if (this.label == null && !this.inClip(clip)) {
            return;
        }
        g.drawLine(this.x1 + dx, this.y1 + dy, this.x2 + dx, this.y2 + dy);
        if (this.label == null) {
            return;
        }
        Color c = g.getColor();
        if (this.labelMode == 3 || this.labelMode == 1) {
            g.setColor(v.view.gridColorDEC);
        } else {
            g.setColor(v.view.gridColorRA);
        }
        if (this.labelMode == 3) {
            g.drawString(this.label, (this.x1 + this.x2) / 2 + dx, this.y1 + dy - 5);
        } else if (this.labelMode == 4) {
            g.drawString(this.label, this.x1 - 30 + dx, (this.y1 + this.y2) / 2 + dy - 2);
        } else if (this.labelMode == 1 && this.y2 > 30) {
            g.drawString(this.label, 5 + dx, (this.y1 + this.y2) / 2 + dy - 2);
        } else if (this.labelMode == 2) {
            g.drawString(this.label, (this.x1 + this.x2) / 2 + dx, 25 + dy);
        }
        g.setColor(c);
    }
}

