/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class Search
extends JPanel
implements MouseListener {
    Aladin aladin;
    SearchText text;
    JLabel label;
    JButton left;
    JButton right;
    JButton out;
    JButton reduce;
    protected JPanel panelSearch;
    static String MFSEARCHIN = null;
    static String MFSEARCHOUT;
    static String MFSEARCHNO;
    static String YOURSEARCH;
    private boolean flagHideSearch = false;
    static String SELECT;
    static String UNSELECT;
    static String APPEND;
    static String SHOW;
    private Insets INSETS = new Insets(1, 0, 3, 0);
    boolean oEnable = true;
    static final int DEFAULT = 0;
    static final int IN = 1;
    static final int OUT = 2;
    static final int NO = 3;
    static final int DISABLE = 4;

    protected Search(Aladin aladin, boolean withReduceButton) {
        JButton b;
        this.aladin = aladin;
        if (MFSEARCHIN == null) {
            MFSEARCHIN = Aladin.chaine.getString("MFSEARCHIN");
            MFSEARCHOUT = Aladin.chaine.getString("VWNIF");
            MFSEARCHNO = Aladin.chaine.getString("MFSEARCHNO");
            YOURSEARCH = Aladin.chaine.getString("MFSEARCHFOCUS");
        }
        this.left = b = new JButton(new ImageIcon(aladin.getImagette("Left.gif")));
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setToolTipText(Aladin.chaine.getString("MFSEARCHLEFT"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Search.this.down();
            }
        });
        this.right = b = new JButton(new ImageIcon(aladin.getImagette("Right.gif")));
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setToolTipText(Aladin.chaine.getString("MFSEARCHRIGHT"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Search.this.up();
            }
        });
        if (withReduceButton) {
            this.reduce = b = new JButton(new ImageIcon(aladin.getImagette("Agrandir.gif")));
            b.setMargin(new Insets(0, 0, 0, 0));
            b.setBorderPainted(false);
            b.setContentAreaFilled(false);
            b.setToolTipText(Aladin.chaine.getString("REDUCEH"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Search.this.reduce();
                }
            });
        }
        this.out = b = new JButton(new ImageIcon(aladin.getImagette("Cross.gif")));
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setToolTipText(Aladin.chaine.getString("SPLITH"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Search.this.split();
            }
        });
        this.text = new SearchText();
        this.text.setFont(Aladin.BOLD);
        this.text.setToolTipText(Aladin.chaine.getString("MFSEARCHEX"));
        this.text.addMouseListener(this);
        this.setLayout(new BorderLayout(0, 0));
        JPanel searchPanel = new JPanel(new BorderLayout(0, 0));
        this.label = Aladin.createLabel(Aladin.chaine.getString("MFSEARCHL"));
        searchPanel.add((Component)this.label, "West");
        this.label.setToolTipText(Aladin.chaine.getString("MFSEARCHHELP"));
        JPanel pText = new JPanel(new BorderLayout());
        pText.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        pText.add((Component)this.text, "Center");
        searchPanel.add((Component)pText, "Center");
        this.panelSearch = new JPanel(new BorderLayout(0, 0));
        JPanel searchControlPanel = new JPanel(new BorderLayout(0, 0));
        searchControlPanel.add((Component)this.left, "Center");
        searchControlPanel.add((Component)this.right, "East");
        JPanel genericSearchPanel = new JPanel(new BorderLayout(0, 0));
        if (!Aladin.OUTREACH) {
            genericSearchPanel.add((Component)searchPanel, "West");
        }
        genericSearchPanel.add((Component)searchControlPanel, "Center");
        this.panelSearch.add((Component)genericSearchPanel, "West");
        if (!Aladin.OUTREACH) {
            this.panelSearch.add(Box.createHorizontalStrut(40), "Center");
        }
        JPanel buttonPanel = new JPanel(new BorderLayout(0, 0));
        if (this.reduce != null) {
            buttonPanel.add((Component)this.reduce, "West");
        }
        if (!Aladin.OUTREACH) {
            buttonPanel.add((Component)this.out, "East");
        }
        this.add((Component)this.panelSearch, "Center");
        this.add((Component)buttonPanel, "East");
        this.setEnabled(false);
        this.addMouseListener(this);
    }

    protected void hideSearch(boolean flag) {
        this.setIcon();
        if (flag == this.flagHideSearch) {
            return;
        }
        this.flagHideSearch = flag;
        if (this.flagHideSearch) {
            this.remove(this.panelSearch);
        } else {
            this.add((Component)this.panelSearch, "Center");
        }
        this.validate();
    }

    private void down() {
        if (this.aladin.mesure.nbSrc == 0) {
            this.text.execute(10, null, 0);
        } else {
            this.text.execute(40, null, 0);
        }
    }

    private void up() {
        if (this.aladin.mesure.nbSrc == 0) {
            this.text.execute(10, null, 0);
        } else {
            this.text.execute(38, null, 0);
        }
    }

    private void go() {
        this.text.execute(10, null, 0);
    }

    private void split() {
        this.aladin.mesure.split();
        this.setIcon();
    }

    protected void reduce() {
        this.aladin.mesure.switchReduced();
        this.setIcon();
    }

    protected void setIcon() {
        if (this.reduce == null) {
            return;
        }
        if (this.aladin.mesure.flagReduced || this.aladin.mesure.f != null) {
            this.reduce.setIcon(new ImageIcon(this.aladin.getImagette("Agrandir.gif")));
        } else {
            this.reduce.setIcon(new ImageIcon(this.aladin.getImagette("Reduire.gif")));
        }
    }

    private int getDefaultMode() {
        return 0;
    }

    protected void focus() {
        this.text.setText(YOURSEARCH);
        new Thread(){
            Color def;
            Color deff;
            {
                this.def = Search.this.text.getBackground();
                this.deff = Search.this.text.getForeground();
            }

            @Override
            public void run() {
                for (int i = 0; i < 3; ++i) {
                    Search.this.text.setBackground(Color.green);
                    Search.this.text.setForeground(Color.black);
                    Util.pause(200);
                    Search.this.text.setBackground(this.def);
                    Search.this.text.setForeground(this.deff);
                    Util.pause(200);
                }
                Search.this.text.setText("");
                Search.this.text.requestFocusInWindow();
            }
        }.start();
    }

    @Override
    public Insets getInsets() {
        return this.INSETS;
    }

    void setText(String s) {
        this.text.setText(s);
    }

    public String getText() {
        return this.text.getText();
    }

    @Override
    public void setEnabled(boolean flag) {
        boolean x = flag;
        if (this.aladin.mesure != null) {
            x = this.aladin.mesure.nbSrc > 0;
        }
        this.right.setEnabled(x);
        this.left.setEnabled(x);
        if (flag == this.oEnable) {
            return;
        }
        this.oEnable = flag;
        this.text.setEnabled(flag);
        this.setColor(flag ? 0 : 4);
        this.label.setForeground(flag ? Aladin.DARKBLUE : Color.lightGray);
        if (this.aladin.mesure != null) {
            flag = this.aladin.mesure.nbSrc > 0;
        }
        this.right.setEnabled(flag);
        this.left.setEnabled(flag);
    }

    protected void setColor(int mode) {
        switch (mode) {
            case 1: {
                this.text.setBackground(Color.white);
                this.text.setForeground(Color.magenta);
                break;
            }
            case 3: {
                this.text.setBackground(Color.red);
                this.text.setForeground(Color.white);
                break;
            }
            case 2: {
                this.text.setBackground(Color.orange);
                this.text.setForeground(Color.magenta);
                break;
            }
            case 4: {
                this.text.setBackground(this.getBackground());
                this.text.setForeground(this.getBackground());
                break;
            }
            default: {
                this.text.setBackground(Color.white);
                this.text.setForeground(Color.magenta);
            }
        }
    }

    protected String Help() {
        return Aladin.chaine.getString("Search.HELP");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.help.setText(this.Help());
            return;
        }
    }

    void execute(String s) {
        if (s == null) {
            s = this.text.getText();
        }
        int mode = s.equals("+") ? 1 : (s.equals("-") ? -1 : 0);
        switch (mode) {
            case -1: {
                this.text.execute(38, s, 0);
                break;
            }
            case 1: {
                this.text.execute(40, s, 0);
                break;
            }
            case 0: {
                this.text.execute(10, s, 0);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.oEnable) {
            return;
        }
        this.setColor(0);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    void setColorAndStatus(int rep) {
        this.setColor(rep == 0 ? 3 : (rep == 1 ? 1 : 2));
        if (rep == 0) {
            this.aladin.mesure.setStatus(MFSEARCHNO);
        } else if (rep == -1) {
            this.aladin.mesure.setStatus(MFSEARCHOUT);
        } else {
            this.aladin.mesure.setStatus(MFSEARCHIN);
        }
    }

    class SearchText
    extends JTextField
    implements KeyListener,
    MouseWheelListener {
        private Dimension DIM = new Dimension(100, 10);
        protected String previousSearch = "";
        protected int oNbSrc = 0;

        SearchText() {
            this.addKeyListener(this);
            this.addMouseWheelListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.DIM;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int mode = e.getWheelRotation();
            Search.this.setColorAndStatus(Search.this.aladin.mesure.searchString(this.getText(), mode));
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.execute(e.getKeyCode(), this.getText(), Search.this.getDefaultMode());
        }

        public boolean searchChanged() {
            try {
                return Search.this.aladin.mesure.nbSrc != this.oNbSrc || !this.previousSearch.equals(this.getText());
            }
            catch (Exception e) {
                return false;
            }
        }

        public void execute(int keyCode, String s, int flagAdd) {
            int mode;
            if (s == null) {
                s = this.getText();
            }
            if (keyCode == 10 && flagAdd != 2) {
                boolean rep;
                this.previousSearch = s;
                if (s.length() > 0 && (s.charAt(0) == '-' || s.charAt(0) == '+')) {
                    flagAdd = s.charAt(0) == '-' ? -1 : 1;
                    s = s.substring(1);
                    Search.this.text.setText(s);
                }
                Search.this.setColor((rep = Search.this.aladin.mesure.selectByString(s, flagAdd)) ? 0 : 3);
                Search.this.right.setEnabled(rep);
                Search.this.left.setEnabled(rep);
                Search.this.text.selectAll();
                this.oNbSrc = Search.this.aladin.mesure.nbSrc;
                return;
            }
            int n = keyCode == 38 ? -1 : (mode = keyCode == 40 || keyCode == 10 ? 1 : 0);
            if (mode != 0) {
                Search.this.text.setText(s);
                Search.this.setColorAndStatus(Search.this.aladin.mesure.searchString(s, mode));
                Search.this.text.selectAll();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Search.this.setColor(0);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

