/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ResourceNode;
import cds.aladin.Tok;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;

public class SIAPruner {
    private ResourceNode[] nodesToPrune;
    private String[] constraints;

    public SIAPruner(ResourceNode[] nodesToPrune, String[] constraints) {
        this.setNodesToPrune(nodesToPrune);
        this.setConstraints(constraints);
    }

    public ResourceNode[] prune() {
        if (this.nodesToPrune == null) {
            return null;
        }
        ArrayList<ResourceNode> nodesToKeep = new ArrayList<ResourceNode>(Arrays.asList(this.nodesToPrune));
        SIAPrunerConstraint prunerConstraint = new SIAPrunerConstraintFactory().create(this.constraints);
        Aladin.trace(1, "Constraint is: " + prunerConstraint);
        if (prunerConstraint.orderBy > 0 && prunerConstraint.orderBy == prunerConstraint.ORDERBYDIST) {
            Collections.sort(nodesToKeep, new Comparator(){

                public int compare(Object o1, Object o2) {
                    double dist2;
                    ResourceNode n1 = (ResourceNode)o1;
                    ResourceNode n2 = (ResourceNode)o2;
                    double dist1 = n1.getDistanceToCenter();
                    return dist1 == (dist2 = n2.getDistanceToCenter()) ? 0 : (dist1 > dist2 ? 1 : -1);
                }
            });
        }
        ArrayList<ResourceNode> nodesToRemove = new ArrayList<ResourceNode>();
        for (ResourceNode node : nodesToKeep) {
            Enumeration e = prunerConstraint.fieldConstraints.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)prunerConstraint.fieldConstraints.get(key);
                if (node.matchFieldConstraint(key, value = Tok.unQuote(value), true)) continue;
                nodesToRemove.add(node);
            }
            for (String constraint : prunerConstraint.freeConstraints) {
                if (node.matchFreeConstraint(constraint, true)) continue;
                nodesToRemove.add(node);
            }
        }
        nodesToKeep.removeAll(nodesToRemove);
        if (nodesToKeep.size() == 0) {
            Aladin.warning("Could not find any data corresponding to your request");
            return null;
        }
        int nbToCopy = Math.min(prunerConstraint.nbRequested, nodesToKeep.size());
        ResourceNode[] retNodes = new ResourceNode[nbToCopy];
        System.arraycopy(nodesToKeep.subList(0, nbToCopy).toArray(), 0, retNodes, 0, nbToCopy);
        return retNodes;
    }

    public void setNodesToPrune(ResourceNode[] nodesToPrune) {
        this.nodesToPrune = nodesToPrune;
    }

    public void setConstraints(String[] constraints) {
        this.constraints = constraints;
    }

    class SIAPrunerConstraint {
        final int ORDERBYDIST = 1;
        int orderBy = -1;
        int nbRequested = 1;
        ArrayList freeConstraints = new ArrayList();
        Hashtable fieldConstraints = new Hashtable();

        SIAPrunerConstraint() {
        }

        public String toString() {
            String s = "";
            s = s + "orderBy=" + this.orderBy;
            s = s + ", nbRequested=" + this.nbRequested;
            s = s + ", freeConstraints=" + this.freeConstraints;
            s = s + ", fieldConstraints=" + this.fieldConstraints;
            return s;
        }
    }

    class SIAPrunerConstraintFactory {
        SIAPrunerConstraintFactory() {
        }

        private SIAPrunerConstraint create(String[] constraints) {
            SIAPrunerConstraint prunerConstraints = new SIAPrunerConstraint();
            String value = null;
            String key = null;
            boolean keyValue = false;
            for (int i = 0; i < constraints.length; ++i) {
                String token = constraints[i];
                if (token == null) continue;
                int idx = (token = token.trim()).indexOf(61);
                if (idx >= 0) {
                    key = token.substring(0, idx).trim();
                    value = token.substring(idx + 1).trim();
                    if (!key.toLowerCase().equals("keyword")) {
                        keyValue = true;
                    } else {
                        keyValue = false;
                        token = value;
                    }
                } else {
                    keyValue = false;
                }
                if (keyValue && key.equalsIgnoreCase("sortby")) {
                    if (!value.equalsIgnoreCase("dist")) continue;
                    prunerConstraints.orderBy = prunerConstraints.ORDERBYDIST;
                    continue;
                }
                if (keyValue && key.equalsIgnoreCase("number")) {
                    try {
                        int nb = Integer.parseInt(value);
                        if (nb <= 0) continue;
                        prunerConstraints.nbRequested = nb;
                    }
                    catch (NumberFormatException nfe) {
                        Aladin.warning("Can't parse " + value + " as an integer !\nConstraint ignored");
                    }
                    continue;
                }
                if (keyValue) {
                    prunerConstraints.fieldConstraints.put(key, value);
                    continue;
                }
                prunerConstraints.freeConstraints.add(token);
            }
            return prunerConstraints;
        }
    }
}

