/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.BasicNode;
import cds.aladin.Calib;
import cds.aladin.Fov;
import cds.aladin.MetaDataTree;
import cds.aladin.Server;
import cds.aladin.ServerAladin;
import cds.aladin.TreeBuilder;
import cds.tools.Util;
import java.awt.Color;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class ResourceNode
extends BasicNode
implements Cloneable {
    static final int VOID = 0;
    static final int IMAGE = 1;
    static final int CAT = 2;
    static final int SPECTRUM = 3;
    static final int CUBE = 4;
    static final int INFO = 5;
    static final int CHARAC = 6;
    static final int OTHER = 7;
    String format;
    int type = 0;
    String[] formats;
    String curFormat;
    boolean[] hidden;
    boolean hasData = false;
    private double distanceToCenter = Double.NaN;
    String[] axes;
    String[] units;
    String[] dimeq;
    String[] scaleq;
    String[] modes;
    String curMode;
    private String pixSize;
    private double pixSizeDeg;
    String obsDate;
    String origin;
    String wavelength;
    String wavelengthExpla;
    String indexing;
    String[] siapSortFields;
    String objet;
    String targetObjet;
    String refNumber;
    Color col;
    private Fov fov;
    int ra = -1;
    int de = -1;
    boolean cutout = false;
    private String cutoutTarget;
    private String mosaicTarget;
    String curImgNumber = "1";
    String maxImgNumber = "1";
    double beginVel = 0.0;
    double velStep = 0.0;
    Server server;
    String location;
    String gluLink;
    String resol;
    String survey;
    String bandPass;
    String epoch;
    String machine;
    String plateNumber;
    String[] description;
    String[] explanation;
    String[] originalExpla;
    String[] ucds;
    String[] utypes;
    String[] allUnits;
    String[] filterDesc;
    String[] filterExpla;
    String criteria;
    String valueCriteria;
    String desc;
    String dataOrga;
    String xPos;
    String yPos;
    String[] sortCriteria;
    Hashtable criteriaVal;
    Hashtable properties;
    Hashtable links;
    boolean isSIAPEvol = false;
    Hashtable propertiesUnits;

    ResourceNode(Aladin aladin) {
        super(aladin);
    }

    ResourceNode(Aladin aladin, ResourceNode n) {
        super(aladin, n);
        this.properties = n.properties;
        this.links = n.links;
        this.propertiesUnits = n.propertiesUnits;
        this.type = n.type;
        this.ra = n.ra;
        this.de = n.de;
        this.col = null;
        this.fov = n.fov;
        this.cutout = n.cutout;
        this.survey = n.survey;
        this.bandPass = n.bandPass;
        this.epoch = n.epoch;
        this.resol = n.resol;
        this.machine = n.machine;
        this.plateNumber = n.plateNumber;
        this.description = n.description;
        if (n.explanation != null) {
            this.explanation = new String[n.explanation.length];
            for (int i = 0; i < n.explanation.length; ++i) {
                this.explanation[i] = n.explanation[i];
            }
        }
        this.filterDesc = n.filterDesc;
        this.filterExpla = n.filterExpla;
        this.sortCriteria = n.sortCriteria;
        this.criteriaVal = n.criteriaVal;
        this.criteria = n.criteria;
        this.valueCriteria = n.valueCriteria;
        this.location = n.location;
        this.gluLink = n.gluLink;
        this.server = n.server;
        this.cutoutTarget = n.cutoutTarget;
        this.formats = n.formats;
        this.curFormat = n.curFormat;
        this.pixSize = n.pixSize;
        this.pixSizeDeg = n.pixSizeDeg;
        this.obsDate = n.obsDate;
        this.modes = n.modes;
        this.curMode = n.curMode;
        this.objet = n.objet;
        this.targetObjet = n.targetObjet;
        this.origin = n.origin;
        this.wavelengthExpla = n.wavelengthExpla;
        this.indexing = n.indexing;
        this.curImgNumber = n.curImgNumber;
        this.maxImgNumber = n.maxImgNumber;
        this.desc = n.desc;
        this.refNumber = n.refNumber;
        this.axes = n.axes;
        this.units = n.units;
        this.dimeq = n.dimeq;
        this.scaleq = n.scaleq;
        this.format = n.format;
        this.siapSortFields = n.siapSortFields;
        this.originalExpla = n.originalExpla;
        this.ucds = n.ucds;
        this.utypes = n.utypes;
        this.allUnits = n.allUnits;
        this.hidden = n.hidden;
        this.dataOrga = n.dataOrga;
        this.xPos = n.xPos;
        this.yPos = n.yPos;
        this.hasData = n.hasData;
        this.distanceToCenter = n.distanceToCenter;
    }

    ResourceNode(Aladin aladin, String name) {
        super(aladin, name);
    }

    ResourceNode(Aladin aladin, String name, boolean isOpen, boolean isLeaf) {
        super(aladin, name, isOpen, isLeaf);
    }

    public Object clone() {
        ResourceNode o = null;
        try {
            o = (ResourceNode)super.clone();
        }
        catch (Exception e) {
            System.err.println("Can't clone !!");
            e.printStackTrace();
        }
        o.children = new Vector();
        o.nbChildren = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            o.addChild((ResourceNode)((ResourceNode)this.children.elementAt(i)).clone());
        }
        return o;
    }

    @Override
    public BasicNode createNode(String name) {
        return new ResourceNode(this.aladin, name);
    }

    public void setCutoutTarget(String t) {
        this.setCutoutTarget(t, true);
    }

    public void setCutoutTarget(String t, boolean updateInfo) {
        if (t != null && t.length() > 0) {
            this.cutoutTarget = t;
            if (updateInfo && this.aladin.getFrameInfo().getNode() != null && this.aladin.getFrameInfo().getNode().equals(this)) {
                this.aladin.getFrameInfo().setTargetTF(t);
            }
        }
    }

    public String getCutoutTarget() {
        return this.cutoutTarget;
    }

    public void setMosaicTarget(String t) {
        this.setMosaicTarget(t, true);
    }

    public void setMosaicTarget(String t, boolean updateInfo) {
        if (t != null && t.length() > 0) {
            this.mosaicTarget = t;
            if (updateInfo && this.aladin.getFrameInfo().getNode() != null && this.aladin.getFrameInfo().getNode().equals(this)) {
                this.aladin.getFrameInfo().setMosaicTargetTF(t);
            }
        }
    }

    public String getMosaicTarget() {
        return this.mosaicTarget;
    }

    public void setImagePosTarget(String x, String y) {
        this.setImagePosTarget(x, y, true);
    }

    public void setImagePosTarget(String x, String y, boolean updateInfo) {
        if (x != null && x.length() > 0) {
            this.xPos = x;
            this.yPos = y;
            if (updateInfo && this.aladin.getFrameInfo().getNode() != null && this.aladin.getFrameInfo().getNode().equals(this)) {
                this.aladin.getFrameInfo().setImagePosTargeTFt(x, y);
            }
        }
    }

    public String[] getImagePosTarget() {
        return new String[]{this.xPos == null ? "" : this.xPos, this.yPos == null ? "" : this.yPos};
    }

    protected boolean isAvailableFormat(String f) {
        if (this.formats == null || f == null) {
            return false;
        }
        for (int i = 0; i < this.formats.length; ++i) {
            if (!f.equalsIgnoreCase(this.formats[i])) continue;
            return true;
        }
        return false;
    }

    protected Fov getFov() {
        if (this.modes != null && this.modes.length > 0 && this.curMode.equals("MOSAIC")) {
            Fov fov;
            try {
                fov = new Fov(MetaDataTree.resolveTarget(this.getMosaicTarget(), this.aladin), this.fov.x, this.fov.y, this.fov.angle);
            }
            catch (Exception e) {
                return null;
            }
            return fov;
        }
        return this.fov;
    }

    protected void setFov(Fov fov) {
        this.fov = fov;
    }

    public String getFieldValFromUcd(String ucd, boolean useOriginalExpla) {
        int idx = Util.indexInArrayOf(ucd, this.ucds);
        if (idx < 0) {
            return null;
        }
        return useOriginalExpla ? this.originalExpla[idx] : this.explanation[idx];
    }

    public String getFieldValFromUcd(String ucd) {
        return this.getFieldValFromUcd(ucd, false);
    }

    public String getFieldValFromUtype(String utype) {
        int idx = Util.indexInArrayOf(utype, this.utypes);
        if (idx < 0) {
            return null;
        }
        return this.explanation[idx];
    }

    public String getFieldValFromName(String name) {
        int idx = Util.indexInArrayOf(name, this.description);
        if (idx < 0) {
            return null;
        }
        return this.explanation[idx];
    }

    public Calib getCalib() {
        double equinox;
        int naxis2;
        int naxis1;
        double cd11;
        double cd10;
        double cd01;
        double cd00;
        double crval2;
        double crval1;
        double crpix2;
        double crpix1;
        Aladin.trace(3, "Trying to build a calibration for a color image");
        Aladin.trace(3, "Looking for CRPIX");
        String crpixStr = this.getFieldValFromUcd("VOX:WCS_CoordRefPixel", true);
        if (crpixStr == null || crpixStr.length() == 0) {
            crpixStr = this.getFieldValFromUcd("pos.wcs.crpix", true);
        }
        if (crpixStr == null || crpixStr.length() == 0) {
            return null;
        }
        String[] crpix = TreeBuilder.split(crpixStr, " ,");
        if (crpix.length < 2) {
            return null;
        }
        try {
            crpix1 = Double.valueOf(crpix[0]);
            crpix2 = Double.valueOf(crpix[1]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        Aladin.trace(3, "Looking for CRVAL");
        String crvalStr = this.getFieldValFromUcd("VOX:WCS_CoordRefValue", true);
        if (crvalStr == null || crvalStr.length() == 0) {
            crvalStr = this.getFieldValFromUcd("pos.wcs.crval", true);
        }
        if (crvalStr == null || crvalStr.length() == 0) {
            return null;
        }
        String[] crval = TreeBuilder.split(crvalStr, " ,");
        if (crval.length < 2) {
            return null;
        }
        try {
            crval1 = Double.valueOf(crval[0]);
            crval2 = Double.valueOf(crval[1]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        Aladin.trace(3, "Looking for CDMatrix");
        String cdStr = this.getFieldValFromUcd("VOX:WCS_CDMatrix", true);
        if (cdStr == null || cdStr.length() == 0) {
            cdStr = this.getFieldValFromUcd("pos.wcs.cdmatrix", true);
        }
        if (cdStr == null || cdStr.length() == 0) {
            return null;
        }
        String[] cd = TreeBuilder.split(cdStr, " ,");
        if (cd.length < 4) {
            return null;
        }
        try {
            cd00 = Double.valueOf(cd[0]);
            cd01 = Double.valueOf(cd[1]);
            cd10 = Double.valueOf(cd[2]);
            cd11 = Double.valueOf(cd[3]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        Aladin.trace(3, "Looking for NAXIS");
        String naxisStr = this.getFieldValFromUcd("VOX:Image_Naxis", true);
        if (naxisStr == null || naxisStr.length() == 0) {
            naxisStr = this.getFieldValFromUcd("pos.wcs.naxis", true);
        }
        if (naxisStr == null || naxisStr.length() == 0) {
            return null;
        }
        String[] naxis = TreeBuilder.split(naxisStr, " ,");
        if (naxis.length < 2) {
            return null;
        }
        try {
            naxis1 = Integer.valueOf(naxis[0]);
            naxis2 = Integer.valueOf(naxis[1]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        Aladin.trace(3, "Looking for projection");
        String projStr = this.getFieldValFromUcd("VOX:WCS_CoordProjection", true);
        if (projStr == null || projStr.length() == 0) {
            projStr = this.getFieldValFromUcd("pos.wcs.ctype", true);
        }
        if (projStr == null || projStr.length() == 0) {
            return null;
        }
        int proj = Calib.getProjType(projStr);
        if (proj < 0) {
            return null;
        }
        Aladin.trace(3, "Looking for equinox");
        String equinoxStr = this.getFieldValFromUcd("VOX:STC_CoordEquinox", true);
        if (equinoxStr == null || equinoxStr.length() == 0) {
            double d = 2000.0;
        }
        try {
            equinox = Double.valueOf(equinoxStr);
        }
        catch (Exception e) {
            equinox = 2000.0;
        }
        Aladin.trace(3, "Looking for coord ref frame");
        String frameStr = this.getFieldValFromUcd("VOX:STC_CoordRefFrame", true);
        if (frameStr == null || frameStr.length() == 0) {
            frameStr = this.getFieldValFromUcd("pos.frame", true);
        }
        if (frameStr == null || frameStr.length() == 0) {
            frameStr = "ICRS";
        }
        return new Calib(crval1, crval2, crpix1, crpix2, naxis1, naxis2, cd00, cd01, cd10, cd11, equinox, 2000.0, proj);
    }

    protected boolean isColorImage() {
        return this.curFormat != null && (this.curFormat.indexOf("png") >= 0 || this.curFormat.indexOf("jpeg") >= 0 || this.curFormat.indexOf("gif") >= 0 || this.curFormat.indexOf("tif") >= 0);
    }

    protected Map getMetadata() {
        Hashtable<String, String> map;
        block4: {
            map = new Hashtable<String, String>();
            try {
                for (int i = 0; i < this.ucds.length; ++i) {
                    String value = this.originalExpla[i];
                    if (this.ucds[i] != null && this.ucds[i].length() > 0) {
                        map.put(this.ucds[i], value);
                    }
                    if (this.utypes[i] == null || this.utypes[i].length() <= 0) continue;
                    map.put(this.utypes[i], value);
                }
            }
            catch (Exception e) {
                System.out.println("problem while extracting metadata");
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
        return map;
    }

    protected String getPixSize() {
        return this.pixSize;
    }

    protected void setPixSize(String pixSize) {
        if (pixSize != null && pixSize.charAt(0) == '-') {
            pixSize = pixSize.substring(1);
        }
        this.pixSize = pixSize;
    }

    protected double getPixSizeDeg() {
        return this.pixSizeDeg;
    }

    protected void setPixSizeDeg(double pixSizeDeg) {
        this.pixSizeDeg = pixSizeDeg = Math.abs(pixSizeDeg);
    }

    protected AppMessagingInterface.AbstractMessage getPlasticMsg() {
        if (this.format != null && (this.format.equals("application/fits-euro3d") || this.format.equals("application/fits-flames-giraffe"))) {
            return AppMessagingInterface.ABSTRACT_MSG_LOAD_FITS;
        }
        if (this.type == 1) {
            return AppMessagingInterface.ABSTRACT_MSG_LOAD_FITS;
        }
        if (this.type == 2) {
            return AppMessagingInterface.ABSTRACT_MSG_LOAD_VOT_FROM_URL;
        }
        if (this.type == 3) {
            return AppMessagingInterface.ABSTRACT_MSG_LOAD_SPECTRUM_FROM_URL;
        }
        if (this.type == 6) {
            return AppMessagingInterface.ABSTRACT_MSG_LOAD_CHARAC_FROM_URL;
        }
        return null;
    }

    protected String getLocation() {
        if (this.curFormat != null && this.curFormat.indexOf("image/tif") >= 0 && this.location != null && this.location.startsWith("http")) {
            return this.getConvertProxyUrl(this.location);
        }
        return this.location;
    }

    protected boolean matchFreeConstraint(String c, boolean ignoreCase) {
        if (ignoreCase) {
            c = c.toLowerCase();
        }
        for (int i = 0; i < this.explanation.length; ++i) {
            String curExpla = this.explanation[i];
            if (curExpla != null && ignoreCase) {
                curExpla = curExpla.toLowerCase();
            }
            if (curExpla == null || curExpla.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    protected boolean matchFieldConstraint(String key, String value, boolean ignoreCase) {
        if (ignoreCase) {
            key = key.toLowerCase();
            value = value.toLowerCase();
        }
        for (int i = 0; i < this.description.length; ++i) {
            String curDesc = this.description[i];
            String curUcd = this.ucds[i];
            String curUtype = this.utypes[i];
            String curExpla = this.explanation[i];
            if (ignoreCase) {
                if (curDesc != null) {
                    curDesc = curDesc.toLowerCase();
                }
                if (curUcd != null) {
                    curUcd = curUcd.toLowerCase();
                }
                if (curUtype != null) {
                    curUtype = curUtype.toLowerCase();
                }
                if (curExpla != null) {
                    curExpla = curExpla.toLowerCase();
                }
            }
            if (!(curDesc != null && curDesc.indexOf(key) >= 0 || curUcd != null && curUcd.indexOf(key) >= 0) && (curUtype == null || curUtype.indexOf(key) < 0) || curExpla == null || curExpla.indexOf(value) < 0) continue;
            return true;
        }
        return false;
    }

    private String getConvertProxyUrl(String url) {
        URL baseUrl = this.aladin.glu.getURL("ConvertToJpg");
        if (url == null || baseUrl == null) {
            return null;
        }
        return baseUrl + URLEncoder.encode(url);
    }

    protected String getScriptCommand() {
        if (this.server == null || !(this.server instanceof ServerAladin)) {
            return null;
        }
        String cmd = "get aladin(";
        cmd = cmd + this.survey;
        if (this.bandPass != null) {
            cmd = cmd + "," + this.bandPass;
        }
        cmd = cmd + ") ";
        String position = this.cutoutTarget != null ? this.cutoutTarget : this.getFov().alpha + " " + this.getFov().delta;
        cmd = cmd + position;
        return cmd;
    }

    public double getDistanceToCenter() {
        return this.distanceToCenter;
    }

    public void setDistanceToCenter(double distanceToCenter) {
        this.distanceToCenter = distanceToCenter;
    }
}

