/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.swing.JComponent;

public class Rainbow
extends JComponent
implements Widget {
    static final int IN = 0;
    static final int HG = 1;
    static final int HD = 2;
    static final int BD = 3;
    static final int BG = 4;
    static final int H = 5;
    static final int D = 6;
    static final int B = 7;
    static final int G = 8;
    static final int START = 9;
    static final int[] CURSOR = new int[]{12, 6, 4, 5, 7, 8, 11, 9, 10, 5};
    static final int W = 16;
    static final int CLOSE = 0;
    protected Aladin aladin;
    protected RectangleD r;
    private boolean visible = false;
    protected double lastPos;
    protected boolean isIn = false;
    protected boolean isSelected = false;
    protected int lastButton = -1;
    private int lastPoignee = -1;
    private int dragPoignee = -1;
    private double dragX = -1.0;
    private double dragY = -1.0;
    private RectangleD closeButton = null;
    protected ColorModel cm = null;
    protected double min = 0.0;
    protected double max = 255.0;
    protected String title = null;
    private int DS = 5;
    private BufferedImage img = null;
    private Graphics g = null;
    private int oCursor = -1;
    private WidgetControl voc = null;

    public Rainbow(Aladin aladin) {
        this.aladin = aladin;
        this.visible = true;
    }

    public Rainbow(Aladin aladin, ColorModel cm, double min, double max) {
        this(aladin);
        this.r = new RectangleD(10.0, 40.0, 30.0, 300.0);
        this.setCM(cm);
        this.setMinMax(min, max);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCM(ColorModel cm) {
        this.cm = cm;
    }

    public void setMinMax(double min, double max) {
        this.min = min;
        this.max = max;
    }

    private double getZoom() {
        double n = this.aladin.view.getModeView();
        return n == 16.0 ? 4.0 : (n == 9.0 ? 3.0 : (n == 4.0 ? 2.0 : 1.0));
    }

    public void reset() {
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean flag) {
        this.visible = flag;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDragging() {
        return this.visible && this.dragPoignee != -1;
    }

    public boolean isUsed() {
        return this.isIn || this.isSelected;
    }

    public boolean mouseMove(double xview, double yview) {
        if (!this.visible) {
            return false;
        }
        double z = this.getZoom();
        this.isIn = this.r.x - 4.0 <= (xview *= z) && xview <= this.r.x + this.r.width + 4.0 && this.r.y - 4.0 <= (yview *= z) && yview <= this.r.y + this.r.height + 4.0;
        this.lastButton = this.getButton(xview, yview);
        this.lastPoignee = this.getPoignee(xview, yview);
        this.lastPos = this.r.height > this.r.width ? (this.r.y + this.r.height - yview) / this.r.height : (xview - this.r.x) / this.r.width;
        return this.isIn || this.isSelected;
    }

    public boolean startDrag(double xview, double yview) {
        if (!this.visible) {
            return false;
        }
        double z = this.getZoom();
        PointD p = new PointD(xview *= z, yview *= z);
        this.dragPoignee = this.getPoignee(p.x, p.y);
        if (this.dragPoignee == -1) {
            this.dragY = -1.0;
            this.dragX = -1.0;
            return false;
        }
        this.dragX = p.x;
        this.dragY = p.y;
        return true;
    }

    public boolean isInside(double xview, double yview) {
        return this.mouseMove(xview, yview);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean mouseDrag(ViewSimple vs, double xview, double yview, boolean shift) {
        if (!this.visible || !this.isIn) {
            return false;
        }
        double z = this.getZoom();
        PointD p = new PointD(xview *= z, yview *= z);
        double x = p.x;
        double y = p.y;
        double dx = x - this.dragX;
        double dy = y - this.dragY;
        if (shift && (this.dragPoignee == 1 || this.dragPoignee == 2 || this.dragPoignee == 4 || this.dragPoignee == 3)) {
            if (this.r.width < this.r.height) {
                this.r.width = this.r.height;
            } else {
                this.r.height = this.r.width;
            }
            if (Math.abs(dx) < Math.abs(dy)) {
                dx = dy;
            } else {
                dy = dx;
            }
        }
        switch (this.dragPoignee) {
            case 0: {
                this.r.x += dx;
                this.r.y += dy;
                break;
            }
            case 1: {
                this.r.x += dx;
                this.r.y += dy;
                this.r.width -= dx;
                this.r.height -= dy;
                break;
            }
            case 2: {
                this.r.y += dy;
                this.r.width += dx;
                this.r.height -= dy;
                break;
            }
            case 3: 
            case 9: {
                this.r.width += dx;
                this.r.height += dy;
                break;
            }
            case 4: {
                this.r.x += dx;
                this.r.width -= dx;
                this.r.height += dy;
                break;
            }
            case 5: {
                this.r.y += dy;
                this.r.height -= dy;
                break;
            }
            case 6: {
                this.r.width += dx;
                break;
            }
            case 7: {
                this.r.height += dy;
                break;
            }
            case 8: {
                this.r.x += dx;
                this.r.width -= dx;
                break;
            }
            default: {
                return false;
            }
        }
        if (this.r.width * vs.zoom < 1.0) {
            this.r.width = 1.0 / vs.zoom;
        }
        if (this.r.height * vs.zoom < 1.0) {
            this.r.height = 1.0 / vs.zoom;
        }
        this.dragX = x;
        this.dragY = y;
        return true;
    }

    public boolean submit(ViewSimple v) {
        if (this.lastButton == 0) {
            if (this == v.rainbow) {
                v.rainbow = null;
            }
            if (this == v.rainbowF) {
                v.rainbowF = null;
            }
            return true;
        }
        boolean oIsSelected = this.isSelected;
        this.isSelected = this.isIn;
        if (oIsSelected != this.isSelected) {
            return !this.isSelected;
        }
        return false;
    }

    public boolean endDrag() {
        if (this.dragPoignee == -1) {
            return false;
        }
        this.dragPoignee = -1;
        this.dragY = -1.0;
        this.dragX = -1.0;
        return true;
    }

    protected int getButton(double xview, double yview) {
        double z = this.getZoom();
        if (this.closeButton != null && this.closeButton.contains(xview /= z, yview /= z)) {
            return 0;
        }
        return -1;
    }

    private int getPoignee(double x, double y) {
        if (!this.visible) {
            return -1;
        }
        if (this.r.width == 1.0 || this.r.height == 1.0) {
            return 3;
        }
        for (int i = 1; i <= 8; ++i) {
            RectangleD rc = this.getRectPoignee(i);
            if (!rc.contains(x, y)) continue;
            return i;
        }
        return this.r.contains(x, y) ? 0 : -1;
    }

    private RectangleD getRectPoignee(int poignee) {
        if (!this.visible) {
            return null;
        }
        double w = 16.0;
        double w2 = w / 2.0;
        switch (poignee) {
            case 1: {
                return new RectangleD(this.r.x - w2, this.r.y - w2, w, w);
            }
            case 2: {
                return new RectangleD(this.r.x + this.r.width - w2, this.r.y - w2, w, w);
            }
            case 3: {
                return new RectangleD(this.r.x + this.r.width - w2, this.r.y + this.r.height - w2, w, w);
            }
            case 4: {
                return new RectangleD(this.r.x - w2, this.r.y + this.r.height - w2, w, w);
            }
            case 5: {
                return new RectangleD(this.r.x + w, this.r.y - w2, this.r.width - 2.0 * w, w);
            }
            case 6: {
                return new RectangleD(this.r.x + this.r.width - w2, this.r.y + w, w, this.r.height - 2.0 * w);
            }
            case 8: {
                return new RectangleD(this.r.x - w2, this.r.y + w, w, this.r.height - 2.0 * w);
            }
            case 7: {
                return new RectangleD(this.r.x + w, this.r.y + this.r.height - w2, this.r.width - 2.0 * w, w);
            }
        }
        return null;
    }

    private void drawSelect(Graphics g) {
        double z = this.getZoom();
        for (int i = 0; i < 8; ++i) {
            int x = (int)((i == 0 || i >= 6 ? this.r.x : (i == 1 || i == 5 ? this.r.x + this.r.width / 2.0 : this.r.x + this.r.width)) / z) - this.DS / 2;
            int y = (int)((i <= 2 ? this.r.y : (i == 3 || i == 7 ? this.r.y + this.r.height / 2.0 : this.r.y + this.r.height)) / z) - this.DS / 2;
            this.drawPoignee(g, x, y);
        }
    }

    protected void drawPoignee(Graphics g, int xc, int yc) {
        g.setColor(Color.green);
        g.fillRect(xc + 1, yc + 1, this.DS, this.DS);
        g.setColor(Color.black);
        g.drawRect(xc, yc, this.DS, this.DS);
    }

    private void drawClose(Graphics g) {
        double z = this.getZoom();
        int x = (int)((this.r.x + this.r.width - 2.0) / z);
        int y = (int)((this.r.y + 2.0) / z);
        int w = 5;
        g.setColor(Aladin.BKGD);
        g.fillRect(x - w - 4, y + 1, w + 4, w + 4);
        g.setColor(Color.red);
        g.drawLine(x - w - 3, y + 2, x - 3, y + w + 2);
        g.drawLine(x - w - 3, y + 3, x - 3, y + w + 3);
        g.drawLine(x - w - 3, y + w + 2, x - 3, y + 2);
        g.drawLine(x - w - 3, y + w + 3, x - 3, y + 3);
        this.closeButton = new RectangleD(x - w - 4, y + 1, w + 4, w + 4);
    }

    private void drawAxe(Graphics g, double min, double max, boolean lineSens, boolean haut, boolean gauche) {
        double z1;
        double z = this.getZoom();
        if (z >= 3.0) {
            g.setFont(Aladin.SBOLD);
            z1 = 1.8;
        } else {
            g.setFont(Aladin.BOLD);
            z1 = 1.0;
        }
        boolean vertical = !lineSens;
        double sizeLabel = (double)(vertical ? 40 : 80) / z1;
        double width = vertical ? this.r.height / z : this.r.width / z;
        FontMetrics fm = g.getFontMetrics();
        int nbLabel = (int)Math.max(width / sizeLabel, 1.0);
        double pos = 0.0;
        int h = fm.getAscent();
        int h2 = fm.getHeight();
        int w = z > 2.0 ? 2 : 5;
        double lastValue = this.getLastValue(min, max);
        float trans = 0.5f;
        double range = max - min;
        double incr = Math.pow(10.0, (int)(0.5 + Math.log10(range)));
        double val1 = Math.floor(min / incr) * incr;
        incr = range / (incr / 10.0) <= (double)nbLabel * 1.5 ? incr / 10.0 : (range / (incr / 4.0) < (double)nbLabel * 1.5 ? incr / 4.0 : incr);
        incr = range / incr >= (double)(nbLabel / 2) ? incr : incr / 2.0;
        boolean encore = true;
        boolean last = false;
        int i = 0;
        while (encore) {
            double val;
            double d = val = i > 30 ? max : val1;
            if (last) {
                encore = false;
                if (Double.isNaN(lastValue) || lastValue < min || lastValue > max) break;
                val = lastValue;
                g.setColor(Color.blue);
                trans = 0.8f;
            } else if (val < min) {
                val = min;
            } else if (val >= max) {
                val = max;
                last = true;
            }
            double valpos = (val - min) / (max - min);
            pos = width * valpos;
            if (!(val != lastValue && (val != min && valpos * width < (double)h2 || val != max && (1.0 - valpos) * width < (double)h2))) {
                int x = (int)((!vertical ? this.r.x : (gauche ? this.r.x + this.r.width : this.r.x - (double)w)) / z);
                int y = (int)((vertical ? this.r.y + this.r.height : (haut ? this.r.y + this.r.height : this.r.y - (double)w)) / z);
                if (vertical) {
                    y = (int)((double)y - pos);
                } else {
                    x = (int)((double)x + pos);
                }
                if (vertical) {
                    g.drawLine(x, y, x + w, y);
                } else {
                    g.drawLine(x, y, x, y + w);
                }
                String label = Util.myRound(val);
                int size = fm.stringWidth(label);
                int n = !vertical ? x - size / 2 : (x = gauche ? x + w + 2 : x - (size + 2));
                y = vertical ? y + h / 2 : (haut ? y + h + w + 2 : y - 2);
                Util.drawCartouche(g, x, y - h + 2, size, h, trans, null, Color.white);
                g.drawString(label, x, y);
            }
            ++i;
            val1 += incr;
        }
    }

    private double getLastValue(double min, double max) {
        if (this.lastPos == -1.0 || !this.isIn || this.isSelected) {
            return Double.NaN;
        }
        double val = min + this.lastPos * (max - min);
        return val;
    }

    protected void drawTitle(Graphics g) {
        if (this.title == null) {
            return;
        }
        g.setFont(g.getFont().deriveFont(2));
        double z = this.getZoom();
        FontMetrics fm = g.getFontMetrics();
        int size = fm.stringWidth(this.title);
        int d = fm.getDescent();
        int h = fm.getHeight();
        int x = (int)(this.r.x / z);
        int y = (int)(this.r.y / z - (double)(d * 2));
        Util.drawCartouche(g, x, y - h + 2, size, h, 0.5f, null, Color.white);
        g.drawString(this.title, x, y);
    }

    protected void drawOverlays(Graphics g) {
        if (this.isSelected) {
            this.drawSelect(g);
            this.drawClose(g);
        } else {
            this.closeButton = null;
        }
    }

    public void draw(Graphics gr, ViewSimple v, int dx, int dy) {
        block13: {
            if (!this.visible) {
                return;
            }
            gr.translate(dx, dy);
            try {
                boolean vertical;
                double z = this.getZoom();
                boolean gauche = this.r.x / z > (double)(v.getWidth() / 2);
                boolean haut = this.r.y / z > (double)(v.getHeight() / 2);
                boolean bl = vertical = this.r.width > this.r.height;
                if (vertical && (this.r.y / z < 30.0 || (double)v.getHeight() - (this.r.y + this.r.height) / z < 30.0)) {
                    boolean bl2 = haut = !haut;
                }
                if (!vertical && (this.r.x / z < 60.0 || (double)v.getWidth() - (this.r.x + this.r.width) / z < 60.0)) {
                    gauche = !gauche;
                }
                ColorModel cm = this.cm != null ? this.cm : ((PlanImage)v.pref).getCM();
                int w = (int)Math.ceil(this.r.width / z) + 1;
                int h = (int)Math.ceil(this.r.height / z) + 1;
                boolean y = false;
                boolean x = false;
                double currentPos = 0.0;
                double gap = (vertical ? this.r.width / z : this.r.height / z) / 256.0;
                double larg = vertical ? this.r.height / z : this.r.width / z;
                int j = vertical ? 255 : 0;
                gr.setColor(new Color(cm.getRed(j), cm.getGreen(j), cm.getBlue(j)));
                gr.fillRect((int)(this.r.x / z), (int)(this.r.y / z), (int)(this.r.width / z), (int)(this.r.height / z));
                double incr = currentPos;
                int i = 0;
                while (i < 256) {
                    j = vertical ? i : 255 - i;
                    gr.setColor(new Color(cm.getRed(j), cm.getGreen(j), cm.getBlue(j)));
                    if (vertical) {
                        gr.fillRect((int)(currentPos + this.r.x / z), (int)((double)y + this.r.y / z), (int)gap + 2, (int)larg);
                        gr.drawRect((int)(currentPos + this.r.x / z), (int)((double)y + this.r.y / z), (int)gap + 2, (int)larg);
                    } else {
                        gr.fillRect((int)((double)x + this.r.x / z), (int)(currentPos + this.r.y / z), (int)larg, (int)gap);
                        gr.drawRect((int)((double)x + this.r.x / z), (int)(currentPos + this.r.y / z), (int)larg, (int)gap);
                    }
                    ++i;
                    currentPos += gap;
                }
                gr.setColor(Color.black);
                gr.drawRect((int)(this.r.x / z), (int)(this.r.y / z), (int)(this.r.width / z), (int)(this.r.height / z));
                gr.setColor(Color.black);
                double min = this.cm != null ? this.min : ((PlanImage)v.pref).getPixelMin();
                double max = this.cm != null ? this.max : ((PlanImage)v.pref).getPixelMax();
                this.drawAxe(gr, min, max, vertical, haut, gauche);
                this.drawTitle(gr);
                this.drawOverlays(gr);
                if (this.isSelected) {
                    int cursor = 0;
                    if (this.lastButton != -1) {
                        cursor = 12;
                    } else {
                        int fleche;
                        int n = fleche = this.dragPoignee != -1 ? this.dragPoignee : this.lastPoignee;
                        if (fleche != -1) {
                            cursor = CURSOR[fleche];
                        }
                    }
                    if (cursor != this.oCursor) {
                        this.oCursor = cursor;
                        v.setCursor(new Cursor(cursor));
                    }
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block13;
                e.printStackTrace();
            }
        }
        gr.translate(-dx, -dy);
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int x, int y, int width, int height, float opacity, JComponent parent) {
        this.voc = new WidgetControl(this, x, y, width, height, opacity, parent);
        this.voc.setResizable(true);
    }

    @Override
    public void paintCollapsed(Graphics g) {
    }
}

