/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Legende;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.Source;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Plot {
    private Aladin aladin;
    private ViewSimple viewSimple;
    private Vector<PlotItem> plotTable = null;
    private Projection plotProj = null;
    private Coord c = new Coord();

    public Plot(ViewSimple viewSimple) {
        this.aladin = viewSimple.aladin;
        this.viewSimple = viewSimple;
    }

    public Projection getProj() {
        return this.plotProj;
    }

    public String getPlotLabel() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < 2 && i < this.plotTable.size(); ++i) {
            PlotItem p = this.plotTable.elementAt(i);
            if (s.length() > 0) {
                s.append(" + ");
            }
            Legende leg = p.plan.getFirstLegende();
            s.append(p.plan.label + "(" + leg.getName(p.index[0]) + "," + leg.getName(p.index[1]) + ")");
        }
        if (this.plotTable.size() > 2) {
            s.append("...");
        }
        return s.toString();
    }

    public void free() {
        this.plotTable = null;
        this.plotProj = null;
        this.viewSimple.newView(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Properties.majProp(2);
            }
        });
    }

    private void initPlot() {
        if (this.plotTable == null) {
            this.plotTable = new Vector(10);
        }
        this.plotProj = new Projection(0.0, 0.0, 0.0, 0.0, 500.0, 500.0, 500.0, 500.0, false, false, false, false);
    }

    protected Plot copyIn(ViewSimple v) {
        Plot plot = new Plot(v);
        plot.plotProj = this.plotProj;
        plot.plotTable = (Vector)this.plotTable.clone();
        return plot;
    }

    public void rmPlotTable(Plan plan) {
        PlotItem p = this.findPlotTable(plan);
        if (p == null) {
            return;
        }
        this.plotTable.remove(p);
        if (this.plotTable.size() == 0) {
            this.viewSimple.free();
        } else {
            this.viewSimple.newView(1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Properties.majProp(2);
            }
        });
    }

    public void addPlotTable(final Plan plan, int indexX, int indexY, boolean openProp) {
        if (this.plotTable == null) {
            this.initPlot();
        }
        if (plan.getLegende().size() > 1) {
            Aladin.warning("Only the first table of this plane\ncan be drawn in a scatter plot.");
        }
        PlotItem p = this.findPlotTable(plan);
        boolean modify = true;
        if (p == null) {
            p = new PlotItem();
            this.plotTable.addElement(p);
            modify = false;
        }
        p.index[0] = indexX;
        p.index[1] = indexY;
        p.plan = plan;
        Aladin.trace(4, "ViewSimple.addPlotTable: " + (modify ? "modify" : "add") + " plan=" + plan.label + " indexX=" + indexX + " indexY=" + indexY);
        if (this.isMainPlot(p)) {
            this.adjustPlot(p);
        }
        this.viewSimple.newView(1);
        if (openProp) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Properties.createProperties(plan);
                    Properties.majProp(2);
                }
            });
        }
    }

    private boolean isMainPlot(PlotItem p) {
        return p == this.plotTable.elementAt(0);
    }

    public double[] getXY(Source s) {
        return this.getXY(null, s);
    }

    public double[] getXY(double[] xy, Source s) {
        if (xy == null) {
            xy = new double[2];
        }
        if (Double.isNaN((xy = this.getValues(xy, s))[0])) {
            return xy;
        }
        try {
            this.c.al = xy[0];
            this.c.del = xy[1];
            this.plotProj.getXY(this.c);
            xy[0] = this.c.x;
            xy[1] = this.c.y;
        }
        catch (Exception e) {
            xy[0] = Double.NaN;
            xy[1] = Double.NaN;
        }
        return xy;
    }

    public double[] getValues(Source s) {
        return this.getValues(null, s);
    }

    public double[] getValues(double[] val, Source s) {
        if (val == null) {
            val = new double[2];
        }
        try {
            int[] index = this.getPlotIndex(s.plan);
            String sx = s.getValue(index[0]).trim();
            String sy = s.getValue(index[1]).trim();
            val[0] = Double.parseDouble(sx);
            val[1] = Double.parseDouble(sy);
        }
        catch (Exception e) {
            val[0] = Double.NaN;
            val[1] = Double.NaN;
        }
        return val;
    }

    public void adjustPlot(PlotItem p) {
        try {
            if (p == null) {
                p = this.plotTable.elementAt(0);
            }
            double min1Y = 0.0;
            double minY = 0.0;
            double max1Y = 0.0;
            double maxY = 0.0;
            double min1X = 0.0;
            double minX = 0.0;
            double max1X = 0.0;
            double maxX = 0.0;
            int n = 0;
            boolean first = true;
            Iterator<Obj> it = p.plan.iterator();
            double[] val = null;
            while (it.hasNext()) {
                Source s;
                Obj o = it.next();
                if (!(o instanceof Source) || Double.isNaN((val = this.getValues(val, s = (Source)o))[0]) || Double.isNaN(val[1])) continue;
                double cX = val[0];
                double cY = val[1];
                ++n;
                if (first) {
                    minX = min1X = cX;
                    max1X = min1X;
                    maxX = min1X;
                    minY = min1Y = cY;
                    max1Y = min1Y;
                    maxY = min1Y;
                    first = false;
                }
                if (minX > cX) {
                    minX = cX;
                } else if (maxX < cX) {
                    maxX = cX;
                }
                if (cX < min1X && cX > minX || min1X == minX && cX < max1X) {
                    min1X = cX;
                } else if (cX > max1X && cX < maxX || max1X == maxX && cX > min1X) {
                    max1X = cX;
                }
                if (minY > cY) {
                    minY = cY;
                } else if (maxY < cY) {
                    maxY = cY;
                }
                if (cY < min1Y && cY > minY || min1Y == minY && cY < max1Y) {
                    min1Y = cY;
                    continue;
                }
                if (!(cY > max1Y && cY < maxY) && (max1Y != maxY || !(cY > min1Y))) continue;
                max1Y = cY;
            }
            min1X = minX;
            max1X = maxX;
            min1Y = minY;
            max1Y = maxY;
            Aladin.trace(4, "ViewSimple.adjustPlot: nsrc=" + n + " X=[" + minX + " (" + min1X + ") .. (" + max1X + ") " + maxX + "] Y=[" + minY + " (" + min1Y + ") .. (" + max1Y + ") " + maxY + "]");
            int w = this.viewSimple.getWidth();
            int h = this.viewSimple.getHeight();
            this.plotProj = new Projection(min1X, min1Y, 0.0, 0.0, max1X - min1X, max1Y - min1Y, (double)w, (double)h, this.plotProj.isFlipXPlot(), this.plotProj.isFlipYPlot(), this.plotProj.isLogXPlot(), this.plotProj.isLogYPlot());
            this.viewSimple.newView(1);
            this.viewSimple.setZoomRaDec(1.0, (min1X + max1X) / 2.0, (min1Y + max1Y) / 2.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int nbRound(double val) {
        int n;
        if (val == 0.0) {
            return 0;
        }
        if ((val = Math.abs(val)) > 1.0) {
            return 0;
        }
        for (n = 0; val < 1.0 && n < 10; val *= 10.0, ++n) {
        }
        return n;
    }

    private double getIncr(double val, int index, int sens, int n) {
        double fct = index == 0 ? this.plotProj.getFctXPlot() : this.plotProj.getFctYPlot();
        double x = val * fct * this.viewSimple.getZoom();
        if (n > 20) {
            return 0.0;
        }
        if (x >= 50.0 && x <= 200.0) {
            return val;
        }
        if (x < 50.0) {
            if (sens == -1) {
                return val * 2.0;
            }
            return this.getIncr(val * 10.0, index, 1, ++n);
        }
        if (sens == 1) {
            return val / 2.0;
        }
        return this.getIncr(val / 10.0, index, -1, ++n);
    }

    private double getIncrX() {
        return this.getIncr(1.0, 0, 0, 0);
    }

    private double getIncrY() {
        return this.getIncr(1.0, 1, 0, 0);
    }

    public void drawPlotGrid(Graphics g, int dx, int dy) {
        try {
            String s1;
            Point p1;
            int i;
            double incrY;
            double incrX = this.plotProj.isLogXPlot() ? 1.0E-10 : this.getIncrX();
            double d = incrY = this.plotProj.isLogYPlot() ? 1.0E-10 : this.getIncrY();
            if (incrX == 0.0 || incrY == 0.0) {
                return;
            }
            int w = this.viewSimple.getWidth();
            int h = this.viewSimple.getHeight();
            Coord c0 = new Coord();
            PointD p = this.viewSimple.getPosition(0.0, 0.0);
            c0.x = p.x;
            c0.y = p.y;
            this.plotProj.getCoord(c0);
            Coord c1 = new Coord();
            p = this.viewSimple.getPosition((double)w, (double)h);
            c1.x = p.x;
            c1.y = p.y;
            this.plotProj.getCoord(c1);
            double initValX = this.plotProj.isLogXPlot() ? 0.0 : (double)((int)(c0.al / incrX)) * incrX;
            double initValY = this.plotProj.isLogYPlot() ? 0.0 : (double)((int)(c0.del / incrY)) * incrY;
            int nbRoundX = this.nbRound(incrX);
            int nbRoundY = this.nbRound(incrY);
            Coord c = new Coord();
            c.del = this.plotProj.isLogYPlot() ? 0.1 : initValY;
            c.al = initValX;
            for (i = -10; i < 10; ++i) {
                this.plotProj.getXY(c);
                p1 = this.viewSimple.getViewCoord(c.x, c.y);
                if (p1 != null) {
                    g.setColor(Color.lightGray);
                    g.drawLine(p1.x + dx, 0 + dy, p1.x + dx, h + dy);
                    g.setColor(Color.black);
                    s1 = this.plotProj.isLogXPlot() ? (i < 0 ? "1e" + i : (i == 0 ? "1" : "1e+" + i)) : c.al + "";
                    g.drawString(Util.myRound(s1, nbRoundX), p1.x + 2 + dx, h - 5 + dy);
                }
                if (this.plotProj.isLogXPlot()) {
                    incrX *= 10.0;
                }
                c.al += incrX;
            }
            c.al = this.plotProj.isLogXPlot() ? 0.1 : initValX;
            c.del = initValY;
            for (i = -10; i < 10; ++i) {
                this.plotProj.getXY(c);
                p1 = this.viewSimple.getViewCoord(c.x, c.y);
                if (p1 != null) {
                    g.setColor(Color.lightGray);
                    g.drawLine(0 + dx, p1.y + dy, w + dx, p1.y + dy);
                    g.setColor(Color.black);
                    s1 = this.plotProj.isLogYPlot() ? (i < 0 ? "1e" + i : (i == 0 ? "1" : "1e+" + i)) : c.del + "";
                    g.drawString(Util.myRound(s1, nbRoundY), 4 + dx, p1.y - 5 + dy);
                }
                if (this.plotProj.isLogYPlot()) {
                    incrY *= 10.0;
                }
                c.del = c.del + (this.plotProj.isLogYPlot() ? incrY : -incrY);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int[] getPlotIndex(Plan plan) {
        PlotItem p = this.findPlotTable(plan);
        return p.index;
    }

    private PlotItem findPlotTable(Plan plan) {
        Enumeration<PlotItem> e = this.plotTable.elements();
        while (e.hasMoreElements()) {
            PlotItem p = e.nextElement();
            if (p.plan != plan) continue;
            return p;
        }
        return null;
    }

    public JPanel getPlotControlPanelForPlan(Plan plan) {
        PlotItem p = this.findPlotTable(plan);
        if (p == null) {
            return null;
        }
        return this.getPlotControlPanelForOneTable(p);
    }

    private JPanel getPlotControlPanelForOneTable(PlotItem p) {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.add((Component)this.getPlotControlPanelForOneIndex(p, 0), "North");
        panel.add((Component)this.getPlotControlPanelForOneIndex(p, 1), "Center");
        panel.add((Component)this.getPlotButtonPanel(p), "South");
        return panel;
    }

    private JPanel getPlotButtonPanel(final PlotItem p) {
        JPanel panel = new JPanel();
        JButton b = new JButton("zoom all");
        b.setMargin(new Insets(2, 2, 2, 2));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot.this.adjustPlot(p);
                Plot.this.viewSimple.repaint();
            }
        });
        panel.add(b);
        b = new JButton("delete");
        b.setMargin(new Insets(2, 2, 2, 2));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot.this.rmPlotTable(p.plan);
                Plot.this.viewSimple.repaint();
            }
        });
        panel.add(b);
        return panel;
    }

    private JPanel getPlotControlPanelForOneIndex(final PlotItem p, final int n) {
        JPanel panel = new JPanel();
        panel.add(new JLabel(n == 0 ? "X: " : "Y: "));
        final Plan plan = p.plan;
        final JComboBox combo = plan.getFirstLegende().createCombo();
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotItem p = Plot.this.findPlotTable(plan);
                int nindex = combo.getSelectedIndex();
                if (nindex == p.index[n]) {
                    return;
                }
                p.index[n] = nindex;
                Plot.this.adjustPlot(p);
                Plot.this.viewSimple.repaint();
            }
        });
        combo.setSelectedIndex(p.index[n]);
        panel.add(combo);
        final JCheckBox b = new JCheckBox("Flip");
        b.setSelected(n == 0 ? this.plotProj.isFlipXPlot() : this.plotProj.isFlipYPlot());
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot.this.aladin;
                Aladin.trace(4, "Plot.getPlotControlPanelForOneIndex: flipPlot(" + n + " => " + b.isSelected());
                Plot.this.plotProj.flipPlot(n, b.isSelected());
                Plot.this.adjustPlot(p);
                Plot.this.viewSimple.repaint();
            }
        });
        panel.add(b);
        final JCheckBox b1 = new JCheckBox("Log");
        b1.setSelected(n == 0 ? this.plotProj.isLogXPlot() : this.plotProj.isLogYPlot());
        b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot.this.aladin;
                Aladin.trace(4, "Plot.getPlotControlPanelForOneIndex: flipLog(" + n + " => " + b1.isSelected());
                Plot.this.plotProj.logPlot(n, b1.isSelected());
                Plot.this.adjustPlot(p);
                Plot.this.viewSimple.repaint();
            }
        });
        panel.add(b1);
        return panel;
    }

    private class PlotItem {
        Plan plan;
        int[] index = new int[2];

        private PlotItem() {
        }
    }
}

