/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.HealpixKey;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PlanMoc;
import cds.aladin.Position;
import cds.moc.Healpix;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.CDSHealpix;
import java.util.Iterator;

public class PlanMocGen
extends PlanMoc {
    private Plan[] p;
    private double radius;
    private double pixMin;
    private double pixMax;
    private int res;
    private double gapPourcent;

    protected PlanMocGen(Aladin aladin, String label, Plan[] p, int res, double radius, double pixMin, double pixMax) {
        super(aladin, null, null, label, p[0].co, 30.0);
        this.p = p;
        this.res = res;
        this.radius = radius;
        this.pixMin = pixMin;
        this.pixMax = pixMax;
        this.pourcent = 0.0;
        this.gapPourcent = 100 / p.length;
        this.suiteSpecific();
        this.threading();
        this.log();
    }

    @Override
    protected void suite1() {
    }

    private void addMocFromCatalog(Plan p1, double radius) {
        Iterator<Obj> it = p1.iterator();
        Healpix hpx = new Healpix();
        int order = this.res;
        Coord coo = new Coord();
        int n = 0;
        int m = p1.getCounts();
        double incrPourcent = this.gapPourcent / (double)m;
        while (it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof Position)) continue;
            if (m < 100 || n % 100 == 0) {
                this.pourcent += incrPourcent;
            }
            try {
                coo.al = ((Position)o).raj;
                coo.del = ((Position)o).dej;
                long[] npix = radius == 0.0 ? new long[]{hpx.ang2pix(order, coo.al, coo.del)} : hpx.queryDisc(order, coo.al, coo.del, radius);
                for (long pix : npix) {
                    this.moc.add(order, pix);
                }
                if ((n += npix.length) <= 10000) continue;
                this.moc.checkAndFix();
                n = 0;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) continue;
                e.printStackTrace();
            }
        }
    }

    private void addMocFromImage(Plan p1, double pixMin, double pixMax) {
        boolean flagRange = !Double.isNaN(pixMin) || !Double.isNaN(pixMax);
        PlanImage pimg = (PlanImage)p1;
        Healpix hpx = new Healpix();
        int order = this.res;
        Coord coo = new Coord();
        double gap = 1.0;
        double gapA = 0.0;
        double gapD = 0.0;
        try {
            gapA = Math.min(p1.projd.getPixResAlpha(), p1.projd.getPixResDelta());
            order = this.res;
            while (CDSHealpix.pixRes(CDSHealpix.pow2(order)) / 3600.0 <= gapA * 2.0) {
                --order;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        gapD = CDSHealpix.pixRes(CDSHealpix.pow2(order)) / 3600.0;
        pimg.setLockCacheFree(true);
        pimg.pixelsOriginFromCache();
        double incrPourcent = this.gapPourcent / (double)pimg.naxis2;
        long oNpix = -1L;
        for (double y = 0.0; y < (double)pimg.naxis2; y += gap) {
            this.pourcent += incrPourcent;
            for (double x = 0.0; x < (double)pimg.naxis1; x += gap) {
                try {
                    coo.x = x;
                    coo.y = (double)pimg.naxis2 - y - 1.0;
                    if (pimg.getPixel8Byte((int)x, (int)coo.y) == 0 && Double.isNaN(pimg.getPixel((int)x, (int)y))) continue;
                    if (flagRange) {
                        double pix = pimg.getPixel((int)x, (int)y);
                        if (!Double.isNaN(pixMin) && pix < pixMin || !Double.isNaN(pixMax) && pix > pixMax) continue;
                    }
                    pimg.projd.getCoord(coo);
                    long npix = 0L;
                    npix = hpx.ang2pix(order, coo.al, coo.del);
                    if (npix == oNpix) continue;
                    this.moc.add(order, npix);
                    oNpix = npix;
                    continue;
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) continue;
                    e.printStackTrace();
                }
            }
        }
        pimg.setLockCacheFree(false);
    }

    private void addMocFromPlanBG(Plan p1, int res, double pixMin, double pixMax) {
        boolean flagRange = !Double.isNaN(pixMin) || !Double.isNaN(pixMax);
        PlanBG p = (PlanBG)p1;
        int order = p.getTileOrder();
        int z = (int)p.getZ();
        int divOrder = 0;
        int fileOrder = res - order;
        if (fileOrder < 3) {
            divOrder = (3 - fileOrder) * 2;
            fileOrder = 3;
        }
        if (fileOrder > p.getMaxFileOrder()) {
            fileOrder = p.getMaxFileOrder();
            res = fileOrder + order;
        }
        this.moc.setCoordSys(p.frameOrigin == 3 ? "G" : (p.frameOrigin == 2 ? "E" : "C"));
        this.frameOrigin = p.frameOrigin;
        int n = (int)CDSHealpix.pow2(fileOrder);
        n = 12 * n * n;
        System.out.println("Nombre de losanges \u00e0 traiter : " + n);
        try {
            p.createHealpixOrder(order);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        long nsize = CDSHealpix.pow2(order);
        double incrPourcent = this.gapPourcent / (double)n;
        for (int npixFile = 0; npixFile < n; ++npixFile) {
            System.out.println("Traitement de " + npixFile);
            this.pourcent += incrPourcent;
            HealpixKey h = p.getHealpixLowLevel(fileOrder, npixFile, z, 2);
            if (h == null) continue;
            long min = nsize * nsize * (long)npixFile;
            try {
                int nb = 0;
                long oNpix = -1L;
                for (int y = 0; y < h.height; ++y) {
                    for (int x = 0; x < h.width; ++x) {
                        try {
                            long npix;
                            int idx = y * h.width + x;
                            double pixel = h.getPixel(idx, 0);
                            if (Double.isNaN(pixel) || pixel == this.blank || flagRange && (!Double.isNaN(pixMin) && pixel < pixMin || !Double.isNaN(pixMax) && pixel > pixMax) || (npix = min + (long)p.xy2hpx(idx)) == oNpix) continue;
                            this.moc.add(res, npix >>> divOrder);
                            oNpix = npixFile;
                            ++nb;
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (nb <= 1000) continue;
                this.moc.checkAndFix();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.moc = this.toReferenceFrame("C");
            this.frameOrigin = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean waitForPlan() {
        try {
            this.moc = new HealpixMoc();
            this.moc.setMinLimitOrder(3);
            this.moc.setMaxLimitOrder(this.res);
            this.moc.setCoordSys("C");
            this.frameOrigin = 0;
            this.moc.setCheckConsistencyFlag(false);
            for (Plan p1 : this.p) {
                if (p1.isCatalog()) {
                    this.addMocFromCatalog(p1, this.radius);
                    continue;
                }
                if (p1.isImage()) {
                    this.addMocFromImage(p1, this.pixMin, this.pixMax);
                    continue;
                }
                if (!(p1 instanceof PlanBG)) continue;
                this.addMocFromPlanBG(p1, this.res, this.pixMin, this.pixMax);
            }
            this.moc.setCheckConsistencyFlag(true);
        }
        catch (Exception e) {
            this.error = e.getMessage();
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return false;
        }
        this.flagProcessing = false;
        this.flagOk = true;
        return true;
    }
}

