/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.moc.Healpix;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.CDSHealpix;
import java.util.ArrayList;

public class PlanMocAlgo
extends PlanMoc {
    static final int UNION = 0;
    static final int INTERSECTION = 1;
    static final int SUBTRACTION = 2;
    static final int DIFFERENCE = 3;
    static final int COMPLEMENT = 4;
    static final int TOORDER = 5;
    private static final String[] FCT = new String[]{"union", "inter", "sub", "diff", "compl", "ord"};

    private static String getFct(int fct) {
        return FCT[fct];
    }

    public PlanMocAlgo(Aladin aladin, String label, PlanMoc[] pList, int op, int order) {
        super(aladin);
        PlanMoc p1 = pList[0];
        p1.copy(this);
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        String s = this.getFonction(p1, pList, op, order);
        if (label == null) {
            label = s;
        }
        this.setLabel(label);
        Aladin.trace(3, "AllSky computation: " + Plan.Tp[this.type] + " => " + s);
        try {
            this.moc = (HealpixMoc)p1.getMoc().clone();
            if (op == 4) {
                this.moc = this.moc.complement();
            } else if (op == 5) {
                this.moc.setMocOrder(order);
            } else {
                block8: for (int i = 1; i < pList.length; ++i) {
                    HealpixMoc m1 = this.moc;
                    HealpixMoc m2 = pList[i].toReferenceFrame(m1.getCoordSys());
                    switch (op) {
                        case 0: {
                            this.moc = m1.union(m2);
                            continue block8;
                        }
                        case 1: {
                            this.moc = m1.intersection(m2);
                            continue block8;
                        }
                        case 2: {
                            this.moc = m1.subtraction(m2);
                            continue block8;
                        }
                        case 3: {
                            this.moc = m1.difference(m2);
                        }
                    }
                }
            }
            this.moc.setMinLimitOrder(3);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.moc.clear();
            Aladin.error = this.error = e.getMessage();
            this.flagOk = false;
        }
        this.copyright = "Computed by Aladin";
        this.flagProcessing = false;
        if (this.moc.getSize() == 0) {
            this.error = "Empty MOC";
            this.flagOk = false;
        } else {
            this.flagOk = true;
        }
        this.setActivated(this.flagOk);
        aladin.calque.repaintAll();
        this.sendLog("Compute", " [" + this + " = " + s + "]");
    }

    protected PlanMocAlgo(Aladin aladin, String label, PlanMoc mocSource, Coord[] cooPolygon) {
        super(aladin);
        mocSource.copy(this);
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        String s = "crop";
        if (label == null) {
            label = s;
        }
        this.setLabel(label);
        Aladin.trace(3, "MOC cropping: " + Plan.Tp[this.type] + " => " + s);
        try {
            CDSHealpix hpx = new CDSHealpix();
            int order = mocSource.moc.getMaxOrder();
            long nside = Healpix.pow2(order);
            ArrayList<double[]> a = new ArrayList<double[]>();
            for (Coord c : cooPolygon) {
                a.add(new double[]{c.al, c.del});
            }
            long[] npix = CDSHealpix.query_polygon(nside, a);
            this.moc.clear();
            this.moc.setCheckConsistencyFlag(false);
            for (long pix : npix) {
                this.moc.add(order, pix);
            }
            this.moc.setCheckConsistencyFlag(true);
            this.moc = this.moc.intersection(mocSource.moc);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.moc.clear();
            Aladin.error = this.error = e.getMessage();
            this.flagOk = false;
        }
        this.copyright = "Computed by Aladin";
        this.flagProcessing = false;
        if (this.moc.getSize() == 0) {
            this.error = "Empty MOC";
            this.flagOk = false;
        } else {
            this.flagOk = true;
        }
        this.setActivated(this.flagOk);
        aladin.calque.repaintAll();
        this.sendLog("Compute", " [" + this + " = " + s + "]");
    }

    @Override
    protected void suite1() {
        System.out.println("Je fais rien");
    }

    private String getFonction(PlanMoc p1, PlanMoc[] pList, int op, int order) {
        if (op == 5) {
            return p1.label + ":" + order;
        }
        String lab2 = pList.length > 1 ? pList[1].label : null;
        String lab3 = pList.length > 2 ? pList[2].label : null;
        return p1.label + " " + PlanMocAlgo.getFct(op) + (lab2 == null ? " " : lab2 + (lab3 == null ? "" : " ..."));
    }
}

