/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.CanvasColorMap;
import cds.aladin.Chaine;
import cds.aladin.Coord;
import cds.aladin.FrameColorMap;
import cds.aladin.FrameHeaderFits;
import cds.aladin.FrameHeaderPDS;
import cds.aladin.GreyMemory;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImageAlgo;
import cds.aladin.PlanImageColor;
import cds.aladin.PlanImageCube;
import cds.aladin.PlanImageHuge;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanImageResamp;
import cds.aladin.PlaneLoadEvent;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.ResourceNode;
import cds.aladin.ServerAladin;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.image.Hdecomp;
import cds.image.Iqefunc;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.Inflater;

public class PlanImage
extends Plan {
    protected static final int PIX_ARGB = 0;
    protected static final int PIX_RGB = 1;
    protected static final int PIX_TRUE = 2;
    protected static final int PIX_256 = 3;
    protected static final int PIX_255 = 4;
    public static final String[] PIX_MODE = new String[]{"RGB composite & transparency", "RGB composite", "true pixel mode & transparency", "256 grey levels", "255 grey levels & transparency"};
    protected int pixMode = -1;
    protected static int LASTID = 0;
    private static float DEFAULT_OPACITITY = 1.0f;
    static String DEFIMG;
    static String LOOKCALIB;
    static String INPROGRESS;
    static String OK;
    static String FAIL;
    static String IMGERR;
    static String ERROR;
    static String CALIBERR;
    static String IMGERR1;
    static String LOADIMG;
    static String HTTPERR;
    static String UNK;
    static String ONEDIM;
    static String NAXIS2;
    static String LOCFILE;
    static String VOAPP;
    static final int CMGRAY = 0;
    static final int CMBB = 1;
    static final int CMA = 2;
    static final int CMSTERN = 3;
    public static final int VIDEO_NORMAL = 0;
    public static final int VIDEO_INVERSE = 1;
    protected static final int ALADIN = 0;
    protected static final int LOCAL = 1;
    protected static final int OTHER = 2;
    protected static final int COMPUTED = 3;
    protected static final int UNDEF = 0;
    protected static final int FULL = 1;
    protected static final int LOW = 2;
    protected static final int PLATE = 3;
    protected static final int STAND = 4;
    protected static final int UNKNOWN = 0;
    protected static final int JPEG = 1;
    protected static final int FITS = 2;
    protected static final int HFITS = 3;
    protected static final int GFITS = 4;
    protected static final int MRCOMP = 5;
    protected static final int RGB = 6;
    protected static final int NATIVE = 7;
    protected static final int PDS = 8;
    public static final int ASINH = 0;
    public static final int LOG = 1;
    public static final int SQRT = 2;
    public static final int LINEAR = 3;
    public static final int SQR = 4;
    public static final int MULTFCT = 5;
    public static final String[] TRANSFERTFCT;
    protected RandomAccessFile fCache;
    protected byte[] pixels;
    protected byte[] pixelsZoom;
    protected byte[] pixelsOrigin;
    protected ColorModel cm;
    public int typeCM;
    public int[] cmControl;
    public int transfertFct;
    protected double[] hist = new double[256];
    protected boolean flagHist;
    protected int width;
    protected int height;
    public int video;
    protected int bitpix;
    protected int naxis1;
    protected int naxis2;
    protected int npix;
    protected double dataMinFits = 0.0;
    protected double dataMaxFits = 0.0;
    protected double dataMin;
    protected double dataMax;
    protected double pixelMin;
    protected double pixelMax;
    protected boolean isBlank;
    protected double blank;
    public double bZero;
    public double bScale = 1.0;
    Obj o = null;
    protected int fmt = 0;
    protected int res = 0;
    protected int orig = 0;
    protected int imgID = -1;
    String status;
    String progress;
    protected ResourceNode imgNode;
    protected Plan forPourcent;
    private InputStream inputStream;
    static int id;
    protected int histID = 0;
    protected int[] lastHistID = new int[]{-1, -1, -1};
    protected String cacheID = null;
    protected boolean cacheFromOriginalFile = false;
    protected long cacheOffset = 0L;
    protected String cacheFileName = null;
    private static int MAXCACHEID;
    private boolean cache = true;
    private boolean lockCacheFree = false;
    protected Image image;
    protected int oImgID = -2;
    protected byte[] onePixelOrigin = null;
    static byte[] tmp_inv;
    protected int offsetLoad = -1;
    protected long tailleLoad = -1L;

    protected PlanImage() {
    }

    protected PlanImage(Aladin aladin, String file, MyInputStream inImg) {
        int fmt = 2;
        int i = file.lastIndexOf(Util.FS);
        String label = i >= 0 ? file.substring(i + 1) : file;
        try {
            this.filename = new File(file).getCanonicalPath();
            this.u = new URL("file:" + new File(file).getCanonicalPath());
            this.dis = inImg;
        }
        catch (Exception e) {
            String s = file + " " + ERROR + " !\n" + e;
            Aladin.warning(s, 1);
            return;
        }
        this.Suite(aladin, 1, label, null, "", LOCFILE + " [" + file + "]", fmt, 0, null);
    }

    protected PlanImage(Aladin aladin, MyInputStream inImg, String label) {
        int fmt = 2;
        if (label == null) {
            label = "VOApp";
        }
        this.dis = inImg;
        this.Suite(aladin, 1, label, null, "", VOAPP, fmt, 0, null);
    }

    protected PlanImage(Aladin aladin, InputStream inImg, String label, String from) {
        int fmt = 2;
        if (label == null) {
            label = "";
        }
        this.inputStream = inImg;
        this.Suite(aladin, 1, label, null, "", from, fmt, 0, null);
    }

    protected PlanImage(Aladin aladin, String file, MyInputStream inImg, String label, String from, Obj o, ResourceNode imgNode, boolean skip, boolean doClose, Plan forPourcent) {
        this.doClose = doClose;
        int fmt = 2;
        this.imgNode = imgNode;
        this.flagSkip = skip;
        this.forPourcent = forPourcent;
        if (forPourcent != null) {
            this.noBestPlacePost = true;
        }
        this.flagWaitTarget = true;
        if (file != null) {
            int i = file.lastIndexOf(Util.FS);
            if (label == null) {
                this.setLabel(i >= 0 ? file.substring(i + 1) : file);
            }
            if (from == null) {
                from = file;
            }
        }
        if (label == null) {
            label = "";
        }
        if (from == null) {
            from = "";
        }
        try {
            if (file != null) {
                if (file.startsWith("http:") || file.startsWith("https:") || file.startsWith("ftp:")) {
                    this.u = new URL(file);
                } else {
                    this.filename = new File(file).getCanonicalPath();
                    this.u = new URL("file:" + new File(file).getCanonicalPath());
                }
            } else {
                this.u = null;
            }
            this.dis = inImg;
        }
        catch (Exception e) {
            this.error = "_END_XFITS_";
            String s = file + " error !\n" + e;
            Aladin.warning(s, 1);
            return;
        }
        this.Suite(aladin, 1, label, null, "", from, fmt, 0, o);
    }

    protected static void createChaine(Chaine chaine) {
        DEFIMG = "";
        LOOKCALIB = chaine.getString("PILOOKCALIB");
        INPROGRESS = chaine.getString("PIINPROGRESS");
        OK = chaine.getString("PIOK");
        FAIL = chaine.getString("PIFAIL");
        IMGERR = chaine.getString("PIIMGERR");
        ERROR = chaine.getString("PIERROR");
        CALIBERR = chaine.getString("PICALIBERR");
        IMGERR1 = chaine.getString("PIIMGERR1");
        LOADIMG = chaine.getString("PILOADIMG");
        HTTPERR = chaine.getString("PIHTTPERR");
        UNK = chaine.getString("PIUNK");
        ONEDIM = chaine.getString("PIONEDIM");
        NAXIS2 = chaine.getString("PINAXIS2");
        LOCFILE = chaine.getString("PILOCFILE");
        VOAPP = chaine.getString("PIVOAPP");
    }

    protected PlanImage(Aladin aladin, MyInputStream inImg, int orig, URL u, String label, String objet, String param, String from, int fmt, int res, Obj o) {
        this.u = u;
        this.dis = inImg;
        this.Suite(aladin, orig, label, objet, param, from, fmt, res, o);
    }

    protected PlanImage(Aladin aladin, MyInputStream inImg, int orig, URL u, String label, String objet, String param, String from, int fmt, int res, Obj o, ResourceNode imgNode) {
        this.imgNode = imgNode;
        this.server = this.server != null ? imgNode.server : null;
        this.u = u;
        this.dis = inImg;
        this.Suite(aladin, orig, label, objet, param, from, fmt, res, o);
    }

    protected PlanImage(Aladin aladin) {
        this.initImage(aladin);
    }

    protected void initImage(Aladin aladin) {
        this.aladin = aladin;
        this.type = 1;
        this.c = Color.black;
        this.askActive = true;
        this.isOldPlan = true;
        this.cmControl = new int[3];
        this.cmControl[0] = 0;
        this.cmControl[1] = 128;
        this.cmControl[2] = 255;
        this.transfertFct = 3;
        this.opacityLevel = DEFAULT_OPACITITY;
    }

    protected PlanImage(Aladin aladin, PlanImage p) {
        this(aladin);
        p.copy(this);
    }

    protected void Suite(Aladin aladin, int orig, String label, String objet, String param, String from, int fmt, int res, Obj o) {
        this.setLogMode(true);
        this.aladin = aladin;
        this.orig = orig;
        this.objet = objet;
        this.param = param;
        this.fmt = fmt;
        this.res = res;
        this.copyright = from;
        this.opacityLevel = DEFAULT_OPACITITY;
        this.type = 1;
        this.setLabel(label);
        this.c = Color.black;
        aladin.calque.selectPlan(this);
        this.isBlank = false;
        this.video = aladin.configuration.getCMVideo();
        this.transfertFct = aladin.configuration.getCMFct();
        this.typeCM = aladin.configuration.getCMMap();
        this.o = o;
        if (this.cmControl == null) {
            this.cmControl = new int[3];
        }
        this.cmControl[0] = 0;
        this.cmControl[1] = 128;
        this.cmControl[2] = 255;
        if (this.dis != null) {
            this.setFmt();
        } else if (res == 4) {
            this.fmt = 2;
        }
        if (this.u == null && this.dis == null && this.inputStream == null) {
            return;
        }
        this.threading();
    }

    protected boolean setCacheFromFile(MyInputStream in) {
        this.cacheOffset = 0L;
        try {
            if (this.filename == null) {
                return false;
            }
            long t = in.getType();
            if ((t & 1L) == 0L) {
                return false;
            }
            if ((t & 0x30L) != 0L) {
                return false;
            }
            File f = new File(this.filename);
            if (f.isFile() && f.canRead()) {
                this.cacheID = this.filename;
                this.cacheFromOriginalFile = true;
                this.cacheOffset = in.getPos();
                Aladin.trace(3, "Direct pixel file access [" + this.cacheID + "] pos=" + this.cacheOffset);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected void copy(Plan p1) {
        super.copy(p1);
        PlanImage p = (PlanImage)p1;
        try {
            if (this.pixels != null) {
                p.pixels = new byte[this.pixels.length];
                System.arraycopy(this.pixels, 0, p.pixels, 0, this.pixels.length);
            } else {
                p.pixels = null;
            }
        }
        catch (Exception e) {
            p.pixels = null;
        }
        p.pixMode = this.pixMode;
        p.pixelsOrigin = this.pixelsOrigin;
        p.projD = null;
        p.projInit = null;
        p.projd = null;
        if (this.projd != null) {
            p.setNewProjD(this.projd.copy());
        }
        p.transfertFct = this.transfertFct;
        p.headerFits = this.headerFits;
        p.width = this.width;
        p.height = this.height;
        p.naxis1 = this.naxis1;
        p.naxis2 = this.naxis2;
        p.video = this.video;
        p.bitpix = this.bitpix;
        p.npix = this.npix;
        p.dataMin = this.dataMin;
        p.dataMax = this.dataMax;
        p.pixelMin = this.pixelMin;
        p.pixelMax = this.pixelMax;
        p.dataMinFits = this.dataMinFits;
        p.dataMaxFits = this.dataMaxFits;
        p.isBlank = this.isBlank;
        p.blank = this.blank;
        p.bZero = this.bZero;
        p.bScale = this.bScale;
        p.o = this.o;
        p.fmt = this.fmt;
        p.res = this.res;
        p.orig = this.orig;
        p.cacheID = this.cacheID;
        p.fCache = null;
        p.cacheOffset = this.cacheOffset;
        p.cacheFromOriginalFile = this.cacheFromOriginalFile;
        p.typeCM = this.typeCM;
        System.arraycopy(this.cmControl, 0, p.cmControl, 0, 3);
        p.cm = CanvasColorMap.getCM(p.cmControl[0], p.cmControl[1], p.cmControl[2], p.video == 1, p.typeCM, p.transfertFct, p.isTransparent());
    }

    protected boolean crop(double x, double y, double w, double h, boolean repaint) {
        int test = 0;
        if (x <= 0.0) {
            w += x;
            x = 0.0;
            ++test;
        }
        if (y <= 0.0) {
            h += y;
            y = 0.0;
            ++test;
        }
        if (x + w >= (double)this.width) {
            w = (double)this.width - x;
            ++test;
        }
        if (y + h >= (double)this.height) {
            h = (double)this.height - y;
            ++test;
        }
        if (test == 4) {
            return false;
        }
        int wi = (int)Math.ceil(w);
        int hi = (int)Math.ceil(h);
        int xi = (int)Math.floor(x);
        int yi = (int)Math.floor(y);
        byte[] npixels = new byte[wi * hi];
        this.getPixels(npixels, xi, yi, wi, hi);
        this.setBufPixels8(npixels);
        if (this.hasOriginalPixels()) {
            byte[] npixelsOrigin = new byte[wi * hi * this.npix];
            if (this.pixelsOrigin == null) {
                this.getPixelsFromCache(npixelsOrigin, this.npix, xi, yi, wi, hi);
            } else {
                this.getPixelsOrigin(npixelsOrigin, this.npix, xi, yi, wi, hi);
            }
            this.pixelsOrigin = npixelsOrigin;
            this.cacheID = null;
            this.noCacheFromOriginalFile();
        }
        this.crop1(x, y, w, h, repaint);
        return true;
    }

    protected boolean cropHuge(double x, double y, double w, double h, boolean repaint) {
        double r = 256.0 / (this.pixelMax - this.pixelMin);
        try {
            int wi = (int)Math.ceil(w);
            int hi = (int)Math.ceil(h);
            int xi = (int)Math.floor(x);
            int yi = (int)Math.floor(y);
            int size = wi * hi;
            this.setBufPixels8(new byte[size]);
            this.pixelsOrigin = new byte[size * this.npix];
            byte[] buf = new byte[wi * this.npix];
            int len = wi;
            int pos = 0;
            int posOrig = 0;
            this.openCache();
            int i = this.naxis2 - (yi + hi);
            int ligne = 0;
            while ((double)i < (double)this.naxis2 - y) {
                this.fCache.seek(this.cacheOffset + ((long)i * (long)this.naxis1 + (long)xi) * (long)this.npix);
                this.fCache.readFully(buf);
                System.arraycopy(buf, 0, this.pixelsOrigin, posOrig, buf.length);
                posOrig += buf.length;
                for (int j = 0; j < len; ++j) {
                    double c = this.getPixVal(buf, this.bitpix, j);
                    if (Double.isNaN(c)) {
                        this.getBufPixels8()[pos++] = 0;
                        continue;
                    }
                    this.getBufPixels8()[pos++] = (byte)(c <= this.pixelMin ? 0 : (c >= this.pixelMax ? 255 : (int)((c - this.pixelMin) * r) & 0xFF));
                }
                this.setPourcent(99.0 * (double)ligne / h);
                ++i;
                ++ligne;
            }
            PlanImage.invImageLine(wi, hi, this.getBufPixels8());
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return false;
        }
        this.cacheID = null;
        this.noCacheFromOriginalFile();
        this.crop1(x, y, w, h, repaint);
        return true;
    }

    protected void crop1(double x, double y, double w, double h, boolean repaint) {
        if (Projection.isOk(this.projd)) {
            this.projd.crop(x, y, w, h);
        }
        this.naxis1 = this.width = (int)Math.ceil(w);
        this.naxis2 = this.height = (int)Math.ceil(h);
        this.setHasSpecificCalib();
        this.changeImgID();
        if (repaint) {
            this.aladin.view.newView(1);
            this.aladin.calque.repaintAll();
        }
    }

    @Override
    protected String getLogInfo() {
        return (this.transfertFct != 3 ? TRANSFERTFCT[this.transfertFct] + "/" : "") + super.getLogInfo();
    }

    @Override
    protected boolean contains(Coord c) {
        try {
            this.projd.getXY(c);
            if (Double.isNaN(c.x)) {
                return false;
            }
            return !(c.x < 0.0 || c.x >= (double)this.naxis1 || c.y < 0.0) && !(c.y >= (double)this.naxis2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static boolean sameFmtRes(Plan pa, Plan pb) {
        PlanImage p2;
        PlanImage p1;
        try {
            p1 = (PlanImage)pa;
            p2 = (PlanImage)pb;
        }
        catch (Exception e) {
            return false;
        }
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        return p1.fmt == p2.fmt && p1.res == p2.res;
    }

    protected String survey() {
        if (this.orig == 0 && (this.param == null || this.param.trim().length() == 0)) {
            return DEFIMG;
        }
        if (this.orig == 0) {
            return ServerAladin.whichQualifier(this.param).trim();
        }
        return this.param;
    }

    protected static String describeFmtRes(MyInputStream dis, int res) {
        String a = null;
        try {
            a = MyInputStream.decodeType(dis.getType());
        }
        catch (Exception e) {
            a = null;
        }
        String r = res == 1 ? "Full resolution" : (res == 2 ? "Low resolution" : (res == 3 ? "Plate view" : (res == 4 ? "(Aladin standalone image)" : null)));
        StringBuffer s = new StringBuffer();
        if (a != null) {
            s.append(a + " ");
        }
        if (r != null) {
            s.append("- " + r);
        }
        return s.toString();
    }

    @Override
    protected String getUrl() {
        if (this.u == null) {
            return null;
        }
        String url = this.u.toString();
        if (this.isAladinJpeg()) {
            url = ServerAladin.change2FITS(url);
        }
        return url;
    }

    protected Color getBackGroundColor() {
        if (this.colorBackground != null) {
            return this.colorBackground;
        }
        return this.isPixel() && this.active && this.video == 0 ? Color.black : Color.white;
    }

    public ColorModel getCM() {
        return this.cm;
    }

    public void restoreCM() {
        IndexColorModel ic = CanvasColorMap.getCM(this.cmControl[0], this.cmControl[1], this.cmControl[2], this.video == 1, this.typeCM, this.transfertFct, this.isTransparent());
        this.setCM(ic);
    }

    protected double[] getPixelSize() {
        if (!Projection.isOk(this.projd)) {
            return null;
        }
        try {
            double resAlpha = this.projd.getPixResAlpha();
            double resDelta = this.projd.getPixResDelta();
            return new double[]{resAlpha, resDelta};
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean isAladinJpeg() {
        return this.orig == 0 && this.fmt == 1;
    }

    protected static String getFormat(int fmt) {
        return fmt == 1 ? "JPEG" : (fmt == 2 ? "FITS" : (fmt == 4 ? "GFITS" : (fmt == 3 ? "HFITS" : (fmt == 5 ? "MRCOMP" : "UNKNOWN"))));
    }

    protected static String getResolution(int r) {
        return r == 1 ? "FULL" : (r == 2 ? "LOW" : (r == 3 ? "PLATE" : (r == 4 ? "STAND" : "UNDEF")));
    }

    protected static int getFmt(String fmt) {
        return fmt.equalsIgnoreCase("FITS") ? 2 : (fmt.equalsIgnoreCase("GFITS") ? 4 : (fmt.equalsIgnoreCase("HFITS") ? 3 : (fmt.equalsIgnoreCase("MRCOMP") ? 5 : (fmt.equalsIgnoreCase("JPEG") ? 1 : 0))));
    }

    protected static int getRes(String res) {
        return res.equalsIgnoreCase("FULL") ? 1 : (res.equalsIgnoreCase("LOW") ? 2 : (res.equalsIgnoreCase("PLATE") ? 3 : (res.equalsIgnoreCase("STAND") ? 4 : 0)));
    }

    protected void resetHist() {
        ++this.histID;
    }

    protected byte[] getPixelHist(int rgb) {
        return this.pixels;
    }

    protected double[] getHistArray(int rgb) {
        return this.hist;
    }

    protected long getHistID() {
        return this.histID;
    }

    protected double[] getHist(int rgb) {
        double max = 0.0;
        double[] hist = this.getHistArray(rgb);
        if (this.histID != this.lastHistID[rgb < 0 ? 0 : rgb]) {
            int i;
            this.lastHistID[rgb < 0 ? 0 : rgb] = this.histID;
            double[] histA = new double[hist.length];
            byte[] pixels = this.getPixelHist(rgb);
            if (pixels == null) {
                return hist;
            }
            for (i = 0; i < pixels.length; ++i) {
                double c;
                int pix;
                int n = pix = pixels[i] & 0xFF;
                histA[n] = histA[n] + 1.0;
                if (!(c > max)) continue;
                max = c;
            }
            max = Math.log(max + 1.0);
            for (i = 0; i < hist.length; ++i) {
                hist[i] = i > 0 && histA[i] == 0.0 ? 0.0 : Math.log(histA[i] + 1.0);
            }
            max += max / 5.0;
            double total = pixels.length;
            for (int i2 = 0; i2 < hist.length; ++i2) {
                hist[i2] = hist[i2] * 120.0 / max;
                histA[i2] = histA[i2] / total;
            }
        }
        return hist;
    }

    @Override
    protected void setPourcent(double x) {
        if (this.forPourcent != null) {
            this.forPourcent.setPourcent(x);
        }
        this.pourcent = x;
    }

    @Override
    protected boolean isSync() {
        return this.flagOk && !this.flagProcessing && !this.flagUpdating || this.error != null;
    }

    @Override
    protected boolean Free() {
        this.aladin.view.free(this);
        super.Free();
        if (this.dis != null) {
            try {
                this.dis.close();
                this.dis = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.fCache != null) {
            try {
                this.fCache.close();
                this.fCache = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dataMaxFits = 0.0;
        this.dataMinFits = 0.0;
        this.headerFits = null;
        this.setBufPixels8(null);
        this.pixelsOrigin = null;
        this.removeFromCache();
        this.cacheFromOriginalFile = false;
        this.cacheID = null;
        this.cacheOffset = 0L;
        this.height = -1;
        this.width = -1;
        this.naxis2 = -1;
        this.naxis1 = -1;
        this.setPourcent(-1.0);
        this.tailleLoad = -1L;
        this.cm = null;
        this.res = 0;
        this.fmt = 0;
        this.video = this.aladin.configuration.getCMVideo();
        this.typeCM = this.aladin.configuration.getCMFct();
        this.resetHist();
        this.isBlank = false;
        this.forPourcent = null;
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
        this.changeImgID();
        return true;
    }

    private static String getNextCacheID() {
        return "f" + MAXCACHEID++ + ".tmp";
    }

    protected void cacheAvailable(boolean flag) {
        this.cache = flag;
    }

    protected void noCacheFromOriginalFile() {
        this.cacheFromOriginalFile = false;
        this.cacheOffset = 0L;
        this.cacheID = null;
    }

    protected boolean rewriteInCache(byte[] buf) {
        return this.setInCache(1, buf);
    }

    private boolean setInCache(byte[] buf) {
        return this.setInCache(0, buf);
    }

    private boolean setInCache(int mode, byte[] buf) {
        if (!Aladin.STANDALONE || !this.cache || this.cacheFromOriginalFile) {
            return false;
        }
        if (mode != 1 && this.cacheID != null) {
            return true;
        }
        this.cacheOffset = 0L;
        RandomAccessFile f = this.beginInCache(buf);
        if (f != null) {
            try {
                f.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    protected synchronized RandomAccessFile beginInCache(byte[] buf) {
        if (!Aladin.STANDALONE || !this.cache || this.cacheFromOriginalFile) {
            return null;
        }
        if (buf == null || !this.aladin.createCache()) {
            return null;
        }
        try {
            if (this.cacheID == null) {
                this.cacheID = Aladin.CACHEDIR + Util.FS + PlanImage.getNextCacheID();
            }
            if (this.fCache != null) {
                try {
                    this.fCache.close();
                    this.fCache = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            File f = new File(this.cacheID);
            RandomAccessFile rf = new RandomAccessFile(f, "rw");
            int bloc = 0x400000;
            int len = 0;
            for (int pos = 0; pos < buf.length; pos += len) {
                len = buf.length - pos < bloc ? buf.length - pos : bloc;
                rf.write(buf, pos, len);
            }
            this.aladin.setInCache(buf.length);
            Aladin.trace(3, "Original pixels saved in cache [" + this.cacheID + "]");
            return rf;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cacheID = null;
            return null;
        }
    }

    protected boolean getFromCache() {
        if (!Aladin.STANDALONE) {
            return false;
        }
        if (this.pixelsOrigin != null) {
            return true;
        }
        if (this.cacheID == null) {
            return false;
        }
        try {
            this.openCache();
            this.fCache.seek(this.cacheOffset);
            byte[] pixelsOrigin1 = new byte[this.width * this.height * this.npix];
            int bloc = 0x400000;
            int len = 0;
            for (int pos = 0; pos < pixelsOrigin1.length; pos += len) {
                len = pixelsOrigin1.length - pos < bloc ? pixelsOrigin1.length - pos : bloc;
                this.fCache.readFully(pixelsOrigin1, pos, len);
            }
            this.pixelsOrigin = pixelsOrigin1;
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.trace(3, "Original pixels lost [" + this.cacheID + "]");
            this.cacheID = null;
            this.pixelsOrigin = null;
            this.bitpix = 8;
            return false;
        }
        Aladin.trace(3, "Original pixels reloaded " + (this.cacheOffset != 0L ? "offset=" + this.cacheOffset + " " : "") + (this.cacheFromOriginalFile ? "" : "from cache ") + "[" + this.cacheID + "]");
        return true;
    }

    protected boolean getPixelsFromCache(byte[] pixels, int npix, int x, int y, int w, int h) {
        if (!Aladin.STANDALONE) {
            return false;
        }
        if (this.cacheID == null) {
            return false;
        }
        try {
            this.openCache();
            int len = w * npix;
            int i = this.naxis2 - y - h;
            int k = 0;
            while (i < this.naxis2 - y) {
                this.fCache.seek(this.cacheOffset + ((long)i * (long)this.naxis1 + (long)x) * (long)npix);
                this.fCache.readFully(pixels, k * w * npix, len);
                ++i;
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        Aladin.trace(3, "Original pixel sub-image (" + x + "," + y + "," + w + "," + h + ") extracted" + (this.cacheOffset != 0L ? "offset=" + this.cacheOffset + " " : "") + (this.cacheFromOriginalFile ? "" : "from cache ") + "[" + this.cacheID + "]");
        return true;
    }

    protected boolean pixelsOriginFromDisk() {
        if (this.cacheID == null) {
            return false;
        }
        if (this.aladin.view.getPixelMode() == 2) {
            return false;
        }
        return this.naxis1 * this.naxis2 * this.npix > 0x800000;
    }

    protected void openCache() {
        if (this.fCache == null && this.cacheID != null) {
            try {
                File f = new File(this.cacheID);
                this.fCache = new RandomAccessFile(f, "r");
            }
            catch (Exception e) {
                this.fCache = null;
                this.cacheID = null;
                this.cacheOffset = 0L;
            }
        }
    }

    protected boolean getOnePixelFromCache(byte[] pixels, int npix, int x, int y) {
        if (!Aladin.STANDALONE) {
            return false;
        }
        if (this.cacheID == null) {
            return false;
        }
        try {
            this.openCache();
            this.fCache.seek(this.cacheOffset + ((long)(this.naxis2 - y - 1) * (long)this.naxis1 + (long)x) * (long)npix);
            this.fCache.readFully(pixels, 0, npix);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean cacheCanBeFree() {
        if (this.lockCacheFree) {
            return false;
        }
        Plan[] allPlan = this.aladin.calque.getPlans();
        for (int i = 0; i < allPlan.length; ++i) {
            if (allPlan[i] == this || !(allPlan[i] instanceof PlanImage) || ((PlanImage)allPlan[i]).cacheID == null || !((PlanImage)allPlan[i]).cacheID.equals(this.cacheID)) continue;
            return false;
        }
        return true;
    }

    protected void setLockCacheFree(boolean flag) {
        this.lockCacheFree = flag;
    }

    private void removeFromCache() {
        block7: {
            block6: {
                if (this.cacheFromOriginalFile || this.cacheID == null) break block6;
                if (Aladin.CACHEDIR == null) break block6;
                if (this.cacheID.startsWith(Aladin.CACHEDIR)) break block7;
            }
            return;
        }
        if (this.cacheCanBeFree()) {
            try {
                File f = new File(this.cacheID);
                this.aladin.setInCache(-f.length());
                f.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Aladin.trace(3, "Original pixels removed from cache [" + this.cacheID + "]");
        }
        this.cacheID = null;
    }

    protected boolean pixelsOriginIntoCache() {
        if (this.pixelsOrigin != null && (this.cacheFromOriginalFile || this.setInCache(this.pixelsOrigin))) {
            Aladin.trace(3, "Original pixels RAM free for " + this.label);
            this.pixelsOrigin = null;
            return true;
        }
        return false;
    }

    protected boolean pixelsOriginFromCache() {
        return this.getFromCache();
    }

    @Override
    synchronized void changeImgID() {
        this.imgID = LASTID++;
        this.pixelsZoom = null;
    }

    synchronized void nextImgID() {
        this.imgID = LASTID++;
    }

    protected int getImgID() {
        return this.imgID;
    }

    protected Image getImage(ViewSimple v, boolean now) {
        if (this.oImgID == this.imgID) {
            return this.image;
        }
        this.image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, this.cm, this.getBufPixels8(), 0, this.width));
        this.oImgID = this.imgID;
        return this.image;
    }

    protected void getPixels(byte[] newpixels, int x, int y, int w, int h) {
        this.getPixels(newpixels, this.pixels, this.width, this.height, x, y, w, h);
    }

    protected void getPixels(byte[] newpixels, byte[] pixels, int width, int height, int x, int y, int w, int h) {
        int k = 0;
        int ah = 0;
        int aw = 0;
        if (x + w > width) {
            aw = x + w - width;
            w -= aw;
        }
        if (y + h > height) {
            ah = y + h - height;
            h -= ah;
        }
        int n = y + h;
        for (int i = y; i < n; ++i) {
            System.arraycopy(pixels, i * width + x, newpixels, k, w);
            k += w + aw;
        }
    }

    protected void getPixelsOrigin(byte[] newpixels, int bitpix, int x, int y, int w, int h) {
        int i = this.height - y - h;
        int k = 0;
        while (i < this.height - y) {
            System.arraycopy(this.pixelsOrigin, (i * this.width + x) * bitpix, newpixels, k * w * bitpix, w * bitpix);
            ++i;
            ++k;
        }
    }

    protected double[][] getPixels() {
        double[][] doublePixels = new double[this.width][this.height];
        this.getPixels(doublePixels, 0, 0, this.width, this.height);
        return doublePixels;
    }

    protected void setPixels(double[][] pix) {
        this.setPixels(pix, this.bitpix == 0 ? -32 : this.bitpix);
    }

    protected void setPixels(double[][] pix, int bitpix) {
        this.naxis1 = this.width = pix.length;
        this.height = this.width == 0 ? 0 : pix[0].length;
        this.naxis2 = this.height;
        this.bitpix = bitpix;
        this.npix = Math.abs(bitpix) / 8;
        if (this.pixelsOrigin == null || this.pixelsOrigin.length != this.width * this.height * this.npix) {
            this.pixelsOrigin = new byte[this.width * this.height * this.npix];
        }
        if (this.getBufPixels8() == null || this.getBufPixels8().length != this.width * this.height) {
            this.setBufPixels8(new byte[this.width * this.height]);
        }
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.setPixelOriginInDouble(x, y, pix[x][y]);
            }
        }
        this.npix = Math.abs(bitpix) / 8;
    }

    protected void reUseOriginalPixels() {
        this.noCacheFromOriginalFile();
        this.rewriteInCache(this.pixelsOrigin);
        this.recut(0.0, 0.0, this.aladin.configuration.getCMCut());
    }

    protected void getPixelsCentroid(double[] newpixels, Point p, int w) {
        this.getPixels(newpixels, p.x - w / 2, p.y - w / 2, w, w);
        int pos = w / 2 * w + w / 2;
        double max = newpixels[pos];
        for (int i = 0; i < newpixels.length; ++i) {
            if (newpixels[i] <= max) continue;
            pos = i;
            max = newpixels[i];
        }
        p.y = p.y - w / 2 + pos / w;
        p.x = p.x - w / 2 + pos % w;
        this.getPixels(newpixels, p.x - w / 2, p.y - w / 2, w, w);
    }

    protected void getPixels(double[] newpixels, int x, int y, int w, int h) {
        int ah = 0;
        int aw = 0;
        if (x + w > this.width) {
            aw = x + w - this.width;
            w -= aw;
        }
        if (y + h > this.height) {
            ah = y + h - this.height;
            h -= ah;
        }
        if (this.pixelsOriginFromDisk()) {
            byte[] b = new byte[this.npix];
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    this.getOnePixelFromCache(b, this.npix, j + x, i + y);
                    newpixels[i * w + j] = this.getPixVal(this.onePixelOrigin, this.bitpix, 0) * this.bScale + this.bZero;
                }
            }
        } else if (this.hasOriginalPixels() && this.getFromCache()) {
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    newpixels[i * w + j] = this.getPixelOriginInDouble(j + x, i + y);
                }
            }
        } else {
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    newpixels[i * w + j] = this.getBufPixels8()[(this.height - (i + y) - 1) * this.width + j + x] & 0xFF;
                }
            }
        }
    }

    protected void getPixels(double[][] newpixels, int x, int y, int w, int h) {
        int ah = 0;
        int aw = 0;
        if (x + w > this.width) {
            aw = x + w - this.width;
            w -= aw;
        }
        if (y + h > this.height) {
            ah = y + h - this.height;
            h -= ah;
        }
        if (this.hasOriginalPixels() && this.getFromCache()) {
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    newpixels[j][i] = this.getPixelOriginInDouble(j + x, i + y);
                }
            }
        } else {
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    newpixels[j][i] = this.getBufPixels8()[(this.height - (i + y) - 1) * this.width + j + x] & 0xFF;
                }
            }
        }
    }

    protected String getStatus() {
        return this.status + ": " + this.progress;
    }

    protected void close() {
        if (this.dis == null) {
            return;
        }
        try {
            if ((this.dis.getType() & 0x20000L) != 0L) {
                return;
            }
            this.dis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getGluTabCalib(String tag) {
        StringTokenizer st = new StringTokenizer(tag.substring(2), " >");
        StringBuffer buf = null;
        while (st.hasMoreTokens()) {
            String p = st.nextToken();
            if (p.indexOf("FITS") >= 0 || p.indexOf("JPEG") >= 0) continue;
            if (p.indexOf("Image,") == 0) {
                p = "Calibration," + p.substring("Image,".length());
            }
            if (buf == null) {
                buf = new StringBuffer("<&");
            } else {
                buf.append(' ');
            }
            buf.append(p);
        }
        buf.append('>');
        return buf.toString();
    }

    private boolean openUrlImage() {
        this.status = LOADIMG;
        this.progress = INPROGRESS;
        Aladin.trace(3, "Load the image at: " + this.u);
        try {
            this.dis = Util.openStream(this.u);
        }
        catch (Exception e) {
            if (this.orig == 1) {
                // empty if block
            }
            Aladin.trace(3, "Second try for opening the stream due to: " + e + "...");
            try {
                this.dis = Util.openStream(this.u);
            }
            catch (Exception e1) {
                if (this.u != null) {
                    System.err.println("Pb with: " + this.u);
                }
                this.error = Aladin.error = HTTPERR;
                Aladin.warning(this.error, 1);
                this.close();
                return false;
            }
        }
        this.setFmt();
        return true;
    }

    private void setFmt() {
        try {
            long type = this.dis.getType();
            this.fmt = (type & 0x20L) != 0L ? 4 : ((type & 0x10L) != 0L ? 3 : ((type & 8L) != 0L ? 5 : ((type & 0x800000000L) != 0L ? 8 : ((type & MyInputStream.NativeImage()) != 0L ? 1 : 2))));
            this.pixMode = this.fmt == 1 ? 3 : 2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected boolean waitForPlan() {
        if (this.dis == null && this.inputStream != null) {
            try {
                this.dis = new MyInputStream(this.inputStream);
                this.dis = this.dis.startRead();
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.ERROR, "error"));
                return false;
            }
        }
        try {
            boolean r;
            if (this.type == 5) {
                return ((PlanImageResamp)this).resample();
            }
            if (this.type == 7) {
                return ((PlanImageAlgo)this).compute();
            }
            Calib c = null;
            if (this.orig == 1) {
                this.status = LOADIMG;
                this.progress = INPROGRESS;
            }
            if (this.fmt != 5 && this.dis == null && !this.openUrlImage()) {
                this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.ERROR, "error"));
                return false;
            }
            if (this.fmt == 1 || this instanceof PlanImageColor) {
                r = this.cacheImageNatif(this.dis);
            } else if (this.fmt == 8) {
                r = this.cacheImagePDS(this.dis);
            } else if (this.fmt == 2 || this.fmt == 3 || this.fmt == 4) {
                r = this.cacheImageFits(this.dis);
            } else {
                this.close();
                return false;
            }
            if (!this.flagSkip) {
                if (!r) {
                    this.status = this.status + ": " + FAIL + "\n";
                    this.progress = "";
                    this.close();
                    return false;
                }
                this.status = this.status + ": " + OK + "\n";
                this.progress = "";
                try {
                    if (this.fmt == 1 || this.fmt == 6) {
                        if (this.dis.hasCommentCalib()) {
                            try {
                                this.headerFits = this.dis.createFrameHeaderFitsFromCommentCalib(this);
                                c = new Calib(this.headerFits.getHeaderFits());
                            }
                            catch (Exception e) {
                                this.dis.jpegCalibAddNAXIS(this.width, this.height);
                                this.headerFits = this.dis.createFrameHeaderFitsFromCommentCalib(this);
                                c = new Calib(this.headerFits.getHeaderFits());
                            }
                            if (c != null) {
                                Aladin.trace(3, "Reading FITS key words embedded in the comment segment");
                            }
                        }
                        if (c == null && this.imgNode != null) {
                            c = this.imgNode.getCalib();
                            if (c == null) {
                                throw new Exception();
                            }
                            this.setHasSpecificCalib();
                            Aladin.trace(3, "Creating calibration from SIA metadata");
                        }
                        if (c == null && this.fmt == 1) {
                            try {
                                this.headerFits = this.DSShhh();
                                c = new Calib(this.headerFits.getHeaderFits());
                                Aladin.trace(3, "Creating calibration from hhh additional file");
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (c == null) {
                            throw new Exception();
                        }
                    } else {
                        c = new Calib(this.headerFits.getHeaderFits());
                    }
                    if (c != null) {
                        this.co = c.getImgCenter();
                        this.setNewProjD(new Projection(2, c));
                        if (this.objet == null) {
                            this.objet = this.co.getSexa();
                            this.aladin.dialog.setDefaultTarget(this.objet);
                            this.aladin.dialog.setDefaultTaille(this);
                        } else {
                            this.co = null;
                        }
                    }
                }
                catch (Exception e3) {
                    this.error = NOREDUCTION;
                    this.progress = "";
                }
            }
            this.close();
            if (!this.flagSkip) {
                this.setExtName();
                this.changeImgID();
                this.aladin.view.setRepere(this);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            long t = 0L;
            try {
                t = this.dis.getType();
            }
            catch (Exception e) {
                // empty catch block
            }
            if ((t & 0x20000L) != 0L) {
                this.error = "_END_XFITS_";
                return false;
            }
            ex.printStackTrace();
            this.error = Aladin.error != null ? Aladin.error : ex.toString();
            Aladin.warning(this.error, 1);
            this.close();
            this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.ERROR, this.error));
            return false;
        }
        catch (Error eall) {
            eall.printStackTrace();
            this.error = Aladin.error = eall.toString();
            Aladin.warning(this.error + " ", 1);
            this.close();
            this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.ERROR, this.error));
            return false;
        }
        this.callAllListeners(new PlaneLoadEvent(this, PlaneLoadEvent.SUCCESS, null));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameHeaderFits DSShhh() throws Exception {
        FrameHeaderFits h;
        RandomAccessFile rf = null;
        String f = this.filename;
        f = f.substring(0, f.lastIndexOf(46)) + ".hhh";
        if (!new File(f).exists()) {
            FrameHeaderFits frameHeaderFits = null;
            return frameHeaderFits;
        }
        rf = new RandomAccessFile(new File(f), "r");
        byte[] b = new byte[(int)rf.length()];
        rf.readFully(b);
        FrameHeaderFits frameHeaderFits = h = new FrameHeaderFits(this, new String(b), true);
        return frameHeaderFits;
        finally {
            if (rf != null) {
                try {
                    rf.close();
                }
                catch (Exception e1) {}
            }
        }
    }

    private int[] getMinMaxBean(int[] bean) {
        int i;
        double minLimit = 0.003;
        double maxLimit = 0.9995;
        int[] mmBean = new int[2];
        int totInfo = 0;
        for (i = 0; i < bean.length; ++i) {
            totInfo += bean[i];
        }
        mmBean[1] = -1;
        mmBean[0] = -1;
        int curInfo = 0;
        for (i = 0; i < bean.length; ++i) {
            double p = (double)(curInfo += bean[i]) / (double)totInfo;
            if (mmBean[0] == -1) {
                if (!(p > minLimit)) continue;
                mmBean[0] = i;
                continue;
            }
            if (!(p > maxLimit)) continue;
            mmBean[1] = i;
            break;
        }
        return mmBean;
    }

    public static final int getByte(byte[] t, int i) {
        return t[i] & 0xFF;
    }

    public static final int getShort(byte[] t, int i) {
        return t[i] << 8 | t[i + 1] & 0xFF;
    }

    public static final int getShortLSB(byte[] t, int i) {
        return (t[i + 1] & 0xFF) << 8 | t[i] & 0xFF;
    }

    public static final int getInt(byte[] t, int i) {
        return t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
    }

    public static final int getIntLSB(byte[] t, int i) {
        return t[i + 3] << 24 | (t[i + 2] & 0xFF) << 16 | (t[i + 1] & 0xFF) << 8 | t[i] & 0xFF;
    }

    public static final long getLong(byte[] t, int i) {
        return (long)(t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF) << 32 | (long)(t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final long getLongLSB(byte[] t, int i) {
        return (long)(t[i + 7] << 24 | (t[i + 6] & 0xFF) << 16 | (t[i + 5] & 0xFF) << 8 | t[i + 4] & 0xFF) << 32 | (long)(t[i + 3] << 24 | (t[i + 2] & 0xFF) << 16 | (t[i + 1] & 0xFF) << 8 | t[i] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final double getFloat(byte[] t, int i) {
        return Float.intBitsToFloat(t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF);
    }

    public static final double getDouble(byte[] t, int i) {
        long a = (long)(t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF) << 32 | (long)(t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF) & 0xFFFFFFFFL;
        return Double.longBitsToDouble(a);
    }

    public static final double getPixVal1(byte[] t, int bitpix, int i) {
        try {
            switch (bitpix) {
                case 8: {
                    return PlanImage.getByte(t, i);
                }
                case 16: {
                    return PlanImage.getShort(t, i * 2);
                }
                case 32: {
                    return PlanImage.getInt(t, i * 4);
                }
                case 64: {
                    return PlanImage.getLong(t, i * 8);
                }
                case -32: {
                    return PlanImage.getFloat(t, i * 4);
                }
                case -64: {
                    return PlanImage.getDouble(t, i * 8);
                }
                case 17: {
                    return PlanImage.getShortLSB(t, i * 2);
                }
                case 33: {
                    return PlanImage.getIntLSB(t, i * 2);
                }
                case 65: {
                    return PlanImage.getLongLSB(t, i * 2);
                }
            }
            return Double.NaN;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    protected final double getPixVal(byte[] t, int bitpix, int i) {
        double pix = PlanImage.getPixVal1(t, bitpix, i);
        if (this.isBlank && pix == this.blank) {
            return Double.NaN;
        }
        return pix;
    }

    public static final void setInt(byte[] t, int i, int val) {
        t[i] = (byte)(0xFF & val >>> 24);
        t[i + 1] = (byte)(0xFF & val >>> 16);
        t[i + 2] = (byte)(0xFF & val >>> 8);
        t[i + 3] = (byte)(0xFF & val);
    }

    protected static final void setIntLSB(byte[] t, int i, int val) {
        t[i + 3] = (byte)(0xFF & val >>> 24);
        t[i + 2] = (byte)(0xFF & val >>> 16);
        t[i + 1] = (byte)(0xFF & val >>> 8);
        t[i] = (byte)(0xFF & val);
    }

    protected static final void setPixVal(byte[] t, int bitpix, int i, double val) {
        switch (bitpix) {
            case 8: {
                t[i] = (byte)(0xFF & (int)val);
                break;
            }
            case 16: {
                int c = (int)val;
                t[i *= 2] = (byte)(0xFF & c >>> 8);
                t[i + 1] = (byte)(0xFF & c);
                break;
            }
            case 32: {
                PlanImage.setInt(t, i *= 4, (int)val);
                break;
            }
            case 64: {
                long c1 = (long)val;
                int c = (int)(0xFFFFFFFFL & c1 >>> 32);
                PlanImage.setInt(t, i *= 8, c);
                c = (int)(0xFFFFFFFFL & c1);
                PlanImage.setInt(t, i + 4, c);
                break;
            }
            case -32: {
                int c = Float.floatToIntBits((float)val);
                PlanImage.setInt(t, i *= 4, c);
                break;
            }
            case -64: {
                long c1 = Double.doubleToLongBits(val);
                int c = (int)(0xFFFFFFFFL & c1 >>> 32);
                PlanImage.setInt(t, i *= 8, c);
                c = (int)(0xFFFFFFFFL & c1);
                PlanImage.setInt(t, i + 4, c);
                break;
            }
            case 17: {
                int c = (int)val;
                t[(i *= 2) + 1] = (byte)(0xFF & c >>> 8);
                t[i] = (byte)(0xFF & c);
                break;
            }
            case 33: {
                PlanImage.setIntLSB(t, i *= 4, (int)val);
                break;
            }
            case 65: {
                long c1 = (long)val;
                int c = (int)(0xFFFFFFFFL & c1 >>> 32);
                PlanImage.setIntLSB(t, i *= 8, c);
                c = (int)(0xFFFFFFFFL & c1);
                PlanImage.setIntLSB(t, i + 4, c);
            }
        }
    }

    protected void copyPixVal(byte[] src, int pos1, byte[] dst, int pos2) {
        System.arraycopy(src, pos1 * this.npix, dst, pos2 * this.npix, this.npix);
    }

    protected final boolean setTransfertFct(int fct) {
        return this.setTransfertFct(fct, false);
    }

    protected final boolean setTransfertFct(int fct, boolean recut) {
        int oldTransfertFct = this.transfertFct;
        boolean rep = true;
        this.transfertFct = fct;
        if (!rep) {
            this.transfertFct = oldTransfertFct;
        }
        return rep;
    }

    protected double getInvPixel(double pix8) {
        return this.pixelMin + pix8 * (this.pixelMax - this.pixelMin) / 256.0;
    }

    protected double getGreyPixel(double pixel) {
        return (pixel - this.pixelMin) * 256.0 / (this.pixelMax - this.pixelMin);
    }

    protected byte[] getPix8Bits(byte[] pOut, byte[] pIn, int bitpix, int width, int height, double minCut, double maxCut, boolean autocut, int xc, int yc, int wc) {
        this.findMinMax(pIn, bitpix, width, height, minCut, maxCut, autocut, xc, yc, wc, 0);
        if (pOut == null) {
            pOut = new byte[width * height];
        }
        int npix = Math.abs(bitpix / 8);
        this.to8bits(pOut, 0, pIn, pIn.length / npix, bitpix, this.pixelMin, this.pixelMax, true);
        return pOut;
    }

    @Override
    protected boolean isOnPixel(int xImg, int yImg) {
        byte pixel = this.getPixel8Byte(xImg, yImg);
        return pixel >= 20;
    }

    protected boolean isBlank(int pixel) {
        return this.isBlank && (double)pixel == this.blank;
    }

    protected boolean isBlank(double pixel) {
        return this.isBlank && pixel == this.blank || Double.isNaN(pixel);
    }

    protected boolean isInside(int x, int y) {
        return x >= 0 && x < this.naxis1 && y >= 0 && y < this.naxis2;
    }

    protected void findMinMax(byte[] pIn, int bitpix, int width, int height, double minCut, double maxCut, boolean autocut, int xc, int yc, int wc, int ntest) {
        int j;
        int i;
        int finx;
        int debx;
        int finy;
        int deby;
        boolean flagCut;
        boolean bl = flagCut = ntest > 0 || minCut != 0.0 && maxCut != 0.0;
        if (!(this instanceof PlanImageCube) && !(this instanceof PlanImageRGB)) {
            this.setPourcent(75.0);
        }
        double max = 0.0;
        double max1 = 0.0;
        double min = 0.0;
        double min1 = 0.0;
        if (wc <= 0) {
            int margew = (int)((double)width * 0.05);
            int margeh = (int)((double)height * 0.05);
            if (width - 2 * margew > 1000) {
                margew = (width - 1000) / 2;
            }
            if (height - 2 * margeh > 1000) {
                margeh = (height - 1000) / 2;
            }
            deby = margeh;
            finy = height - margeh;
            debx = margew;
            finx = width - margew;
        } else {
            debx = xc - wc / 2;
            finx = xc + wc;
            deby = yc - wc / 2;
            finy = yc + wc;
            if (debx < 0) {
                debx = 0;
            }
            if (finx >= width) {
                finx = width - 1;
            }
            if (deby < 0) {
                deby = 0;
            }
            if (finy >= height) {
                finy = height - 1;
            }
        }
        if (!(autocut || minCut == 0.0 && maxCut == 0.0)) {
            max = maxCut;
            min = minCut;
        } else {
            boolean first = true;
            for (i = deby; i < finy; ++i) {
                for (j = debx; j < finx; ++j) {
                    double c = this.getPixVal(pIn, bitpix, i * width + j);
                    if (this.isBlank(c) || flagCut && (c < minCut || c > maxCut)) continue;
                    if (first) {
                        min = min1 = c;
                        max1 = min1;
                        max = min1;
                        first = false;
                    }
                    if (min > c) {
                        min = c;
                    } else if (max < c) {
                        max = c;
                    }
                    if (c < min1 && c > min || min1 == min && c < max1) {
                        min1 = c;
                        continue;
                    }
                    if (!(c > max1 && c < max) && (max1 != max || !(c > min1))) continue;
                    max1 = c;
                }
            }
            if (autocut && max - min > 256.0) {
                if (min1 - min > max1 - min1 && min1 != Double.MAX_VALUE && min1 != max) {
                    min = min1;
                }
                if (max - max1 > max1 - min1 && max1 != -1.7976931348623157E308 && max1 != min) {
                    max = max1;
                }
            }
        }
        if (autocut) {
            if (!(this instanceof PlanImageCube || this instanceof PlanImageHuge || this instanceof PlanImageRGB)) {
                this.setPourcent(80.0);
            }
            int nbean = 10000;
            double l = (max - min) / (double)nbean;
            int[] bean = new int[nbean];
            for (i = deby; i < finy; ++i) {
                for (int k = debx; k < finx; ++k) {
                    double c = this.getPixVal(pIn, bitpix, i * width + k);
                    if (this.isBlank(c)) continue;
                    j = (int)((c - min) / l);
                    if (j == bean.length) {
                        --j;
                    }
                    if (j >= bean.length || j < 0) continue;
                    int n = j;
                    bean[n] = bean[n] + 1;
                }
            }
            int[] mmBean = this.getMinMaxBean(bean);
            if (mmBean[0] == -1 || mmBean[1] == -1) {
                min1 = this.dataMinFits;
                max1 = this.dataMaxFits;
            } else {
                min1 = min;
                max1 = (double)mmBean[1] * l + min1;
                min1 += (double)mmBean[0] * l;
            }
            if (mmBean[0] != -1 && mmBean[0] > mmBean[1] - 5 && ntest < 3) {
                if (min1 > min) {
                    min = min1;
                }
                if (max1 < max) {
                    max = max1;
                }
                this.findMinMax(pIn, bitpix, width, height, min, max, autocut, xc, yc, wc, ntest + 1);
                return;
            }
            min = min1;
            max = max1;
        }
        if (Aladin.levelTrace >= 4 && (!(this instanceof PlanImageCube) || autocut)) {
            Aladin.trace(4, "PlanImage.findMinMax(minCut=" + minCut + ",maxCut" + maxCut + ",autocut=" + autocut + ",ntest=" + ntest + ") => min=" + min + " max=" + max);
        }
        this.pixelMin = min;
        this.pixelMax = max;
        if (!autocut) {
            this.dataMin = this.pixelMin;
            this.dataMax = this.pixelMax;
        }
    }

    public boolean isTransparent() {
        return this.pixMode != 3 && this.pixMode != 1;
    }

    protected final void to8bits(byte[] pOut, int offsetOut, byte[] pIn, int len, int bitpix, double min, double max, boolean memoMinMax) {
        int gapTransp;
        int range = this.isTransparent() ? 255 : 256;
        int n = gapTransp = this.isTransparent() ? 1 : 0;
        if (memoMinMax) {
            this.dataMin = Double.MAX_VALUE;
            this.dataMax = -1.7976931348623157E308;
        }
        double r = (double)range / (max - min);
        --range;
        for (int i = 0; i < len; ++i) {
            double c = this.getPixVal(pIn, bitpix, i);
            if (this.isBlank(c)) {
                pOut[i + offsetOut] = 0;
                continue;
            }
            if (memoMinMax) {
                if (c > this.dataMax) {
                    this.dataMax = c;
                } else if (c < this.dataMin) {
                    this.dataMin = c;
                }
            }
            pOut[i + offsetOut] = (byte)(gapTransp + (c <= min ? 0 : (c >= max ? range : (int)((c - min) * r))) & 0xFF);
        }
    }

    protected void calculPixelsZoom() {
        this.calculPixelsZoom(this.getBufPixels8());
    }

    protected void calculPixelsZoom(byte[] pixels) {
        int w = this.aladin.calque.zoom.zoomView.getWidth();
        int h = this.aladin.calque.zoom.zoomView.getHeight();
        if (this.pixelsZoom == null || this.pixelsZoom.length != w * w) {
            this.pixelsZoom = new byte[w * h];
        }
        double fct = Math.max((double)this.width / (double)w, (double)this.height / (double)h);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int xi = (int)((double)x * fct + 0.5);
                int yi = (int)((double)y * fct + 0.5);
                this.pixelsZoom[y * w + x] = xi >= this.width || yi >= this.height ? (byte)0 : pixels[yi * this.width + xi];
            }
        }
    }

    protected String X(double x) {
        if (Double.isNaN(x)) {
            return "";
        }
        if (this.bitpix > 0) {
            return Util.myRound(x + "");
        }
        return this.Y(x);
    }

    protected String Y(double x) {
        if (Double.isNaN(x)) {
            return "";
        }
        return Util.myRound(x);
    }

    protected String getPixelCodingInfo(int bitpix) {
        String s = bitpix == -64 ? "double" : (bitpix == -32 ? "float" : (bitpix == 64 ? "long" : (bitpix == 65 ? "LSB-long" : (bitpix == 32 ? "integer" : (bitpix == 32 ? "LSB-integer" : (bitpix == 16 ? "short" : (bitpix == 17 ? "LSB-short" : (bitpix == 8 ? "byte" : "unknown"))))))));
        return s + (bitpix % 2 == 0 ? " (bitpix=" + bitpix + ")" : "");
    }

    protected String getPixModeInfo() {
        return PIX_MODE[this.pixMode];
    }

    protected String getSizeInfo() {
        return this.naxis1 + "x" + this.naxis2 + " / encoding:" + this.getPixelCodingInfo(this.bitpix) + " / " + Util.getUnitDisk(this.naxis1 * this.naxis2 * this.npix);
    }

    protected String getPixelInfo(int x, int y, int mode) {
        if (!this.flagOk || y < 0 || y >= this.height || x < 0 || x >= this.width) {
            return "";
        }
        switch (mode) {
            case 0: {
                return Util.align3(this.getBufPixels8()[y * this.width + x] & 0xFF);
            }
            case 2: {
                return this.pixelsOrigin == null ? UNK : this.X(this.getPixVal(this.pixelsOrigin, this.bitpix, (this.height - y - 1) * this.width + x));
            }
            case 1: 
            case 3: {
                if (this.fmt == 1) {
                    return UNK;
                }
                if (this.type != 16 && this.pixelsOrigin != null) {
                    double val = this.getPixVal(this.pixelsOrigin, this.bitpix, (this.height - y - 1) * this.width + x) * this.bScale + this.bZero;
                    if (Aladin.levelTrace < 4 || mode == 3) {
                        return this.Y(val);
                    }
                    double infileVal = PlanImage.getPixVal1(this.pixelsOrigin, this.bitpix, (this.height - y - 1) * this.width + x);
                    return this.Y(val) + (Double.isNaN(infileVal) || val != infileVal ? "(" + infileVal + ")" : "") + (this.isBlank && infileVal == this.blank ? " BLANK" : "");
                }
                if (!this.pixelsOriginFromDisk()) {
                    return UNK;
                }
                if (this.onePixelOrigin == null) {
                    this.onePixelOrigin = new byte[this.npix];
                }
                if (!this.getOnePixelFromCache(this.onePixelOrigin, this.npix, x, y)) {
                    return UNK;
                }
                double val = this.getPixVal(this.onePixelOrigin, this.bitpix, 0) * this.bScale + this.bZero;
                if (Aladin.levelTrace < 4 || mode == 3) {
                    return this.Y(val);
                }
                double infileVal = PlanImage.getPixVal1(this.onePixelOrigin, this.bitpix, 0);
                return this.Y(val) + (Double.isNaN(infileVal) || val != infileVal ? "(" + infileVal + ")" : "") + (this.isBlank && infileVal == this.blank ? " BLANK" : "");
            }
        }
        return null;
    }

    protected double getPixel(int x, int y) {
        if (this.pixelsOrigin == null && !this.isBigImage() || this.fmt == 1) {
            return this.getBufPixels8()[(this.height - y - 1) * this.width + x] & 0xFF;
        }
        try {
            double pix = this.getPixVal(this.pixelsOrigin, this.bitpix, y * this.width + x);
            if (Double.isNaN(pix)) {
                return Double.NaN;
            }
            return pix * this.bScale + this.bZero;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    protected double[] getPixelStats(Point p) {
        int w = 32;
        double[] pix = new double[w * w];
        int i = 0;
        for (int y1 = p.y - w / 2; y1 < p.y + w / 2; ++y1) {
            for (int x1 = p.x - w / 2; x1 < p.x + w / 2; ++x1) {
                pix[i++] = this.getPixelInDouble(x1, y1);
            }
        }
        double[] param = new double[8];
        double[] sdev = new double[8];
        int error = Iqefunc.iqe(pix, w, w, param, sdev);
        if (error != 0) {
            Aladin.trace(4, "PlanImage.getPixelStats(" + p.x + "," + p.y + ") : Iqefunc error: code " + error);
            return null;
        }
        Aladin.trace(4, "PlanImage.getPixelStats(" + p.x + "," + p.y + ") : mean=(" + param[0] + "," + param[2] + " fwhm=" + param[1] + "," + param[3] + " symetryAngle=" + param[4] + " objectPeak=" + param[5] + " meanBackground=" + param[6]);
        param[0] = (float)((double)p.x + 0.5 + (param[0] - (double)(w / 2)));
        param[2] = (float)((double)p.y + 0.5 + (param[2] - (double)(w / 2)));
        return param;
    }

    protected double getPixelInDouble(int x, int y) {
        if (this.pixelsOrigin == null && !this.isBigImage() || this.fmt == 1) {
            return this.getBufPixels8()[y * this.width + x] & 0xFF;
        }
        if (this.pixelsOriginFromDisk()) {
            if (this.onePixelOrigin == null) {
                this.onePixelOrigin = new byte[this.npix];
            }
            if (!this.getOnePixelFromCache(this.onePixelOrigin, this.npix, x, y)) {
                return Double.NaN;
            }
            return this.getPixVal(this.onePixelOrigin, this.bitpix, 0) * this.bScale + this.bZero;
        }
        return this.getPixVal(this.pixelsOrigin, this.bitpix, (this.height - y - 1) * this.width + x) * this.bScale + this.bZero;
    }

    protected double getPixelOriginInDouble(int x, int y) {
        if (this.pixelsOrigin == null || this.fmt == 1) {
            return Double.NaN;
        }
        try {
            return this.getPixVal(this.pixelsOrigin, this.bitpix, y * this.width + x) * this.bScale + this.bZero;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    protected void setPixelOriginInDouble(int x, int y, double val) {
        PlanImage.setPixVal(this.pixelsOrigin, this.bitpix, y * this.width + x, (val - this.bZero) / this.bScale);
    }

    public static String getTransfertFctInfo(int i) {
        return TRANSFERTFCT[i];
    }

    public String getTransfertFctInfo() {
        return PlanImage.getTransfertFctInfo(this.transfertFct);
    }

    public static int getTransfertFct(String s) {
        return Util.indexInArrayOf(s, TRANSFERTFCT, true);
    }

    public String getDataMinInfo() {
        return this.hasAvailablePixels() ? this.getSpecialPixel(this.dataMin) : "???";
    }

    public String getDataMaxInfo() {
        return this.hasAvailablePixels() ? this.getSpecialPixel(this.dataMax) : "???";
    }

    public String getPixelMinInfo() {
        return this.hasAvailablePixels() ? this.getSpecialPixel(this.pixelMin) : "???";
    }

    public String getPixelMaxInfo() {
        return this.hasAvailablePixels() ? this.getSpecialPixel(this.pixelMax) : "???";
    }

    protected String getSpecialPixel(double x) {
        if (this.aladin.view.getPixelMode() == 2) {
            return this.X(x);
        }
        return this.Y(x * this.bScale + this.bZero);
    }

    protected int getTransfertFct() {
        return this.transfertFct;
    }

    public double getPixelMin() {
        return this.pixelMin * this.bScale + this.bZero;
    }

    public double getPixelMax() {
        return this.pixelMax * this.bScale + this.bZero;
    }

    public double getPixelMiddle() {
        return this.getInvPixel(this.cmControl[1]) * this.bScale + this.bZero;
    }

    protected int getBitpix() {
        return this.bitpix;
    }

    public double getCutMin() {
        return this.pixelMin;
    }

    public double getCutMax() {
        return this.pixelMax;
    }

    public double getDataMin() {
        return this.dataMin;
    }

    public double getDataMax() {
        return this.dataMax;
    }

    protected String getPixelInfoFromGrey(int greyLevel) {
        return this.getPixelInfoFromGrey(greyLevel, this.aladin.view.getPixelMode());
    }

    protected String getPixelInfoFromGrey(int greyLevel, int mode) {
        if (greyLevel < 0 || greyLevel > 255) {
            return "";
        }
        switch (mode) {
            case 0: {
                return greyLevel + "";
            }
            case 2: {
                return this.X(this.getInvPixel(greyLevel));
            }
            case 1: {
                return this.Y(this.getInvPixel(greyLevel) * this.bScale + this.bZero);
            }
        }
        return null;
    }

    protected double getPixelValue(String s) {
        double pixel = Double.valueOf(s);
        pixel = (pixel - this.bZero) / this.bScale;
        return pixel;
    }

    public int getPixel8(int x, int y) {
        return this.pixels[y * this.width + x] & 0xFF;
    }

    protected byte getPixel8Byte(int x, int y) {
        return this.pixels == null ? (byte)0 : this.pixels[y * this.width + x];
    }

    protected String getDateObs() {
        if (!this.hasFitsHeader()) {
            return null;
        }
        String s = this.headerFits.getStringFromHeader("EPOCH");
        if (s == null) {
            this.headerFits.getStringFromHeader("DATE-OBS");
        } else {
            s = "J" + s;
        }
        return s;
    }

    @Override
    protected boolean hasFitsHeader() {
        return this.headerFits != null;
    }

    @Override
    protected boolean hasOriginalPixels() {
        return this.fmt != 1 && (this.pixelsOrigin != null || this.cacheID != null);
    }

    protected void noOriginalPixels() {
        this.pixelsOrigin = null;
        this.cacheID = null;
    }

    protected byte[] getFits8Pixels() {
        byte[] res = new byte[this.getBufPixels8().length];
        System.arraycopy(this.getBufPixels8(), 0, res, 0, this.getBufPixels8().length);
        PlanImage.invImageLine(this.width, this.height, res);
        return res;
    }

    protected synchronized byte[] getFitsPixels() {
        if (!this.hasOriginalPixels()) {
            return null;
        }
        boolean flagClear = false;
        if (this.pixelsOrigin == null) {
            this.getFromCache();
            flagClear = true;
        }
        byte[] res = this.pixelsOrigin;
        if (flagClear) {
            this.pixelsOrigin = null;
        }
        return res;
    }

    protected void flip(int methode) {
        this.setLockCacheFree(true);
        try {
            this.pixelsOriginFromCache();
            if (methode == 0 || methode == 2) {
                PlanImage.invImageLine(this.width, this.height, this.getBufPixels8());
                if (this.pixelsOrigin != null) {
                    PlanImage.invImageLine(this.width, this.height, this.pixelsOrigin, this.npix);
                }
            }
            if (methode == 1 || methode == 2) {
                PlanImage.invImageRow(this.width, this.height, this.getBufPixels8());
                if (this.pixelsOrigin != null) {
                    PlanImage.invImageRow(this.width, this.height, this.pixelsOrigin, this.npix);
                }
            }
            if (this.pixelsOrigin != null) {
                this.reUseOriginalPixels();
            }
        }
        finally {
            this.setLockCacheFree(false);
        }
        this.calculPixelsZoom();
        this.aladin.calque.zoom.zoomView.repaint();
        if (Projection.isOk(this.projd)) {
            this.projd.flip(methode);
        }
        this.changeImgID();
    }

    protected static void invImageLine(int width, int height, byte[] pixels) {
        PlanImage.invImageLine(width, height, pixels, 1);
    }

    protected static void invImageLine(int width, int height, byte[] pixels, int bitpix) {
        byte[] tmp = new byte[width * bitpix];
        for (int h = height / 2 - 1; h >= 0; --h) {
            int offset1 = h * width * bitpix;
            int offset2 = (height - h - 1) * width * bitpix;
            System.arraycopy(pixels, offset1, tmp, 0, width * bitpix);
            System.arraycopy(pixels, offset2, pixels, offset1, width * bitpix);
            System.arraycopy(tmp, 0, pixels, offset2, width * bitpix);
        }
        tmp = null;
    }

    protected static void invImageRow(int width, int height, byte[] pixels) {
        PlanImage.invImageRow(width, height, pixels, 1);
    }

    protected static void invImageRow(int width, int height, byte[] pixels, int bitpix) {
        for (int h = 0; h < height; ++h) {
            int offset1 = h * width * bitpix;
            for (int w = width / 2 - 1; w >= 0; --w) {
                int offset2 = offset1 + (width - w - 1) * bitpix;
                System.arraycopy(pixels, offset1 + w * bitpix, tmp_inv, 0, bitpix);
                System.arraycopy(pixels, offset2, pixels, offset1 + w * bitpix, bitpix);
                System.arraycopy(tmp_inv, 0, pixels, offset2, bitpix);
            }
        }
    }

    protected boolean cacheImageNatif(MyInputStream dis) {
        ImageProducer source = null;
        Date d = new Date();
        Aladin.trace(2, "Loading Native image");
        Image itmp = this.aladin.getToolkit().createImage(dis.readFully());
        this.aladin.waitImage(itmp);
        if (this.width == 0) {
            this.naxis1 = this.width = itmp.getWidth(this.aladin);
            this.naxis2 = this.height = itmp.getHeight(this.aladin);
        }
        source = itmp.getSource();
        Date d1 = new Date();
        int temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Waiting for server during " + temps + " ms");
        this.setPourcent(10.0);
        this.pixelsOrigin = new byte[this.width * this.height];
        GreyMemory gm = new GreyMemory(source, this.pixelsOrigin);
        if (!gm.waitImage()) {
            return false;
        }
        this.setPourcent(66.0);
        d1 = new Date();
        temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Loading in " + temps + " ms");
        this.bitpix = 8;
        this.npix = 1;
        this.setBufPixels8(this.getPix8Bits(null, this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, this.aladin.configuration.getCMCut(), 0, 0, 0));
        d1 = new Date();
        temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Autocutting in " + temps + " ms");
        this.creatDefaultCM();
        this.setPourcent(99.0);
        this.calculPixelsZoom();
        return true;
    }

    protected boolean cacheImageFits(URL u) throws Exception {
        Date d = new Date();
        try {
            this.dis = Util.openStream(u);
        }
        catch (Exception e) {
            this.sendLog("Error", "cacheImageFits(" + (u == null ? "null" : u.toString()) + ") [" + e + "]");
            return false;
        }
        Date d1 = new Date();
        int temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Waiting for server during " + temps + " ms");
        this.setFmt();
        return this.cacheImageFits(this.dis);
    }

    @Override
    protected String getProgress() {
        if (!this.flagOk && this.error == null && this.pourcent >= 0.0 && this.tailleLoad > 0L) {
            return "  - " + (int)this.pourcent + "% of " + this.tailleLoad / 1024L + "KB ...";
        }
        return super.getProgress();
    }

    protected String getBlankString() {
        return !this.isBlank ? "--" : (Double.isNaN(this.blank) ? "NaN" : "" + this.blank);
    }

    protected void setBlankString(String b) {
        block3: {
            try {
                String s = b.trim();
                this.blank = s.equalsIgnoreCase("NaN") ? Double.NaN : Double.parseDouble(s);
                this.isBlank = true;
                if (this.pixMode == 3) {
                    this.pixMode = 4;
                }
            }
            catch (Exception e) {
                this.isBlank = false;
                this.blank = Double.NaN;
                if (this.pixMode != 4) break block3;
                this.pixMode = 3;
            }
        }
        this.recut(this.pixelMin, this.pixelMax, false);
        this.restoreCM();
        this.changeImgID();
    }

    protected boolean recut() {
        return this.recut(this.pixelMin, this.pixelMax, false);
    }

    protected boolean recut(double min, double max, boolean autocut) {
        if (min == -1.0 && max == -1.0) {
            min = this.dataMinFits;
            max = this.dataMaxFits;
        }
        int xc = 0;
        int yc = 0;
        int ycc = 0;
        int wc = 0;
        if (autocut && Projection.isOk(this.projd)) {
            Coord c = new Coord(this.aladin.view.repere.raj, this.aladin.view.repere.dej);
            this.projd.getXY(c);
            xc = (int)c.x;
            yc = ycc = (int)c.y;
            ViewSimple v = this.aladin.view.getCurrentView();
            if (v.pref == this) {
                try {
                    wc = (int)(v.getTaille() / this.projd.getPixResDelta()) / 2;
                    yc = ((PlanImage)v.pref).height - yc - 1;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (this.pixelsOrigin == null && this.isBigImage()) {
            byte[] buf;
            int taille = this.width * this.height * this.npix;
            int offsetLoad = 0;
            int len = 512;
            this.flagUpdating = true;
            this.flagOk = false;
            this.aladin.calque.select.repaint();
            try {
                int w = this.width / 2 - Math.min(1024, this.width) / 2;
                int h = Math.min(1024, this.height);
                int x = this.width / 2 - w / 2;
                int y = this.height / 2 - h / 2;
                if (wc > 0) {
                    w = h = Math.min(1024, wc);
                    x = xc - w / 2;
                    y = ycc - w / 2;
                }
                double dataMinTmp = this.dataMin;
                double dataMaxTmp = this.dataMax;
                buf = new byte[w * h * this.npix];
                this.getPixelsFromCache(buf, this.npix, x, y, w, h);
                this.findMinMax(buf, this.bitpix, w, h, min, max, autocut, 0, 0, 0, 0);
                min = this.pixelMin;
                max = this.pixelMax;
                this.dataMin = dataMinTmp;
                this.dataMax = dataMaxTmp;
                Aladin.trace(4, "PlanImage.recut(" + min + "," + max + "," + autocut + ") on [" + x + "," + y + "-" + w + "x" + h + "] => min=" + min + " max=" + max);
                buf = new byte[len];
                this.openCache();
                this.fCache.seek(this.cacheOffset);
                while (offsetLoad < taille) {
                    if (taille - offsetLoad < len) {
                        len = taille - offsetLoad;
                    }
                    this.fCache.readFully(buf, 0, len);
                    this.to8bits(this.getBufPixels8(), offsetLoad / this.npix, buf, len / this.npix, this.bitpix, min, max, false);
                    this.setPourcent((double)(offsetLoad += len) * 100.0 / (double)taille);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.flagUpdating = false;
            this.flagOk = true;
            buf = null;
            this.aladin.gc();
        } else {
            if (!this.pixelsOriginFromCache()) {
                return false;
            }
            this.setBufPixels8(this.getPix8Bits(this.getBufPixels8(), this.pixelsOrigin, this.bitpix, this.width, this.height, min, max, autocut, xc, yc, wc));
        }
        if (this.fmt != 1) {
            PlanImage.invImageLine(this.width, this.height, this.getBufPixels8());
        }
        this.changeImgID();
        this.resetHist();
        this.setPourcent(-1.0);
        return true;
    }

    protected void loadFitsHeaderParam(FrameHeaderFits headerfits) {
        try {
            int b = this.headerFits.getIntFromHeader("BLANK");
            this.blank = b;
            this.isBlank = true;
            Aladin.trace(3, " => BLANK value = " + this.blank);
        }
        catch (Exception eblank) {
            this.isBlank = false;
        }
        try {
            this.bZero = this.headerFits.getDoubleFromHeader("BZERO");
            Aladin.trace(3, " => BZERO = " + this.bZero);
        }
        catch (Exception ebzero) {
            this.bZero = 0.0;
        }
        try {
            this.bScale = this.headerFits.getDoubleFromHeader("BSCALE");
            Aladin.trace(3, " => BZERO = " + this.bZero + " BSCALE = " + this.bScale);
        }
        catch (Exception ebscale) {
            this.bScale = 1.0;
        }
        try {
            this.dataMinFits = this.headerFits.getDoubleFromHeader("GOODMIN");
            this.dataMaxFits = this.headerFits.getDoubleFromHeader("GOODMAX");
            this.dataMaxFits = 150000.0;
            Aladin.trace(3, " => GOODMIN = " + this.dataMinFits + " GOODMAX = " + this.dataMaxFits);
            this.dataMinFits = (this.dataMinFits - this.bZero) / this.bScale;
            this.dataMaxFits = (this.dataMaxFits - this.bZero) / this.bScale;
        }
        catch (Exception ebzero) {
            this.dataMaxFits = 0.0;
            this.dataMinFits = 0.0;
        }
        if (this.label == null || this.label.length() == 0) {
            try {
                String name = this.headerFits.getStringFromHeader("EXTNAME");
                if (name != null && name.length() > 0) {
                    this.setLabel(name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean isBigImage() {
        return this.width * this.height * this.npix > 0x800000 && this.cacheID != null;
    }

    protected boolean cacheImageFits(MyInputStream dis) throws Exception {
        int temps;
        Date d1;
        int n;
        int naxis = 2;
        Aladin.trace(2, "Loading FITS image");
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, dis);
        }
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        naxis = this.headerFits.getIntFromHeader("NAXIS");
        if (naxis <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
            this.error = "_HEAD_XFITS_";
            if (naxis == 1) {
                try {
                    this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                    dis.skip(this.naxis1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        this.width = this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
        this.height = this.naxis2 = this.headerFits.getIntFromHeader("NAXIS2");
        if (naxis <= 1 || this.width <= 0 || this.height <= 0) {
            this.error = Aladin.error = ONEDIM;
            Aladin.warning(this.error, 1);
            this.close();
            return false;
        }
        if (this.bitpix == 0) {
            Aladin.error = "FITS format error: BITPIX=0 !";
            this.error = "FITS format error: BITPIX=0 !";
            Aladin.warning(this.error, 1);
            this.close();
            return false;
        }
        this.npix = n = Math.abs(this.bitpix) / 8;
        int taille = this.width * this.height * n;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " BITPIX=" + this.bitpix + " => size=" + taille);
        this.loadFitsHeaderParam(this.headerFits);
        this.setCacheFromFile(dis);
        Date d = new Date();
        this.tailleLoad = taille;
        boolean cut = this.aladin.configuration.getCMCut();
        this.setBufPixels8(new byte[this.width * this.height]);
        if ((dis.getType() & 0x10L) != 0L) {
            Aladin.trace(2, "Hdecompressing");
            this.fmt = 3;
            this.pixelsOrigin = Hdecomp.decomp(dis);
            d1 = new Date();
            temps = (int)(d1.getTime() - d.getTime());
            d = d1;
            Aladin.trace(3, " => Hdecompressing in " + temps + " ms");
            this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, cut, 0, 0, 0, 0);
            this.to8bits(this.getBufPixels8(), this.offsetLoad / this.npix, this.pixelsOrigin, this.width * this.height, this.bitpix, this.pixelMin, this.pixelMax, true);
        } else if (this.flagSkip) {
            dis.skip(taille);
        } else if (this.isBigImage()) {
            int w = Math.min(1024, this.width);
            int h = Math.min(1024, this.height);
            int x = this.width / 2 - w / 2;
            int y = this.height / 2 - h / 2;
            byte[] buf = new byte[w * h * this.npix];
            this.getPixelsFromCache(buf, this.npix, x, y, w, h);
            this.findMinMax(buf, this.bitpix, w, h, this.dataMinFits, this.dataMaxFits, cut, 0, 0, 0, 0);
            this.offsetLoad = 0;
            int len = 512;
            buf = new byte[len];
            while (this.offsetLoad < taille) {
                if (taille - this.offsetLoad < len) {
                    len = taille - this.offsetLoad;
                }
                dis.readFully(buf, 0, len);
                this.to8bits(this.getBufPixels8(), this.offsetLoad / this.npix, buf, len / this.npix, this.bitpix, this.pixelMin, this.pixelMax, true);
                this.offsetLoad += len;
                this.setPourcent((double)this.offsetLoad * 99.0 / (double)taille);
            }
        } else {
            this.pixelsOrigin = new byte[taille];
            this.offsetLoad = 0;
            int len = taille / 100;
            if (len < 512) {
                len = 512;
            }
            try {
                while (this.offsetLoad < taille) {
                    if (taille - this.offsetLoad < len) {
                        len = taille - this.offsetLoad;
                    }
                    dis.readFully(this.pixelsOrigin, this.offsetLoad, len);
                    this.offsetLoad += len;
                    this.setPourcent((double)this.offsetLoad * 85.0 / (double)taille);
                }
            }
            catch (Exception e) {
                this.error = Aladin.error = "Loading error: " + e.getMessage();
                e.printStackTrace();
                this.close();
                return false;
            }
            this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, cut, 0, 0, 0, 0);
            this.to8bits(this.getBufPixels8(), 0, this.pixelsOrigin, this.width * this.height, this.bitpix, this.pixelMin, this.pixelMax, true);
        }
        if (naxis > 2) {
            try {
                long offset = n * this.naxis1 * this.naxis2;
                for (int i = 2; i < naxis; ++i) {
                    offset *= (long)this.headerFits.getIntFromHeader("NAXIS" + (i + 1));
                }
                dis.skip(offset -= (long)(n * this.naxis1 * this.naxis2));
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.flagSkip) {
            return true;
        }
        d1 = new Date();
        temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Reading " + (cut ? "and autocutting " : "") + "in " + Util.round((double)temps / 1000.0, 3) + " s => " + Util.round((double)this.offsetLoad / (double)temps / 1048.576, 2) + " Mbyte/s");
        PlanImage.invImageLine(this.width, this.height, this.getBufPixels8());
        this.creatDefaultCM();
        this.setPourcent(99.0);
        return true;
    }

    private void mocDecode(byte[] src, byte[] target) throws Exception {
        Inflater decompresser = new Inflater();
        decompresser.setInput(src);
        decompresser.inflate(target);
        decompresser.end();
    }

    protected boolean cacheImagePDS(MyInputStream dis) throws Exception {
        boolean isCompressed;
        int suffixByte;
        int prefixByte;
        int tailleImg;
        Aladin.trace(2, "Loading PDS image");
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderPDS((Plan)this, dis);
        }
        this.width = this.naxis1 = this.headerFits.getIntFromHeader("LINE_SAMPLES");
        this.height = this.naxis2 = this.headerFits.getIntFromHeader("LINES");
        this.npix = this.headerFits.getIntFromHeader("SAMPLE_BITS") / 8;
        this.bitpix = this.npix * 8;
        String mode = this.headerFits.getStringFromHeader("SAMPLE_TYPE");
        if (mode.indexOf("REAL") >= 0) {
            this.bitpix = -this.bitpix;
        }
        int taille = tailleImg = this.width * this.height * this.npix;
        if (mode.indexOf("LSB") >= 0) {
            ++this.bitpix;
        }
        try {
            this.bScale = this.headerFits.getDoubleFromHeader("SCALING_FACTOR");
        }
        catch (Exception e1) {
            this.bScale = 1.0;
        }
        try {
            this.bZero = this.headerFits.getDoubleFromHeader("OFFSET");
        }
        catch (Exception e1) {
            this.bZero = 0.0;
        }
        int recordBytes = this.headerFits.getIntFromHeader("RECORD_BYTES");
        String s = this.headerFits.getStringFromHeader("^IMAGE");
        int offset = s.indexOf("BYTE");
        int skip = offset > 0 ? Integer.parseInt(s.substring(0, offset)) : (this.headerFits.getIntFromHeader("^IMAGE") - 1) * recordBytes;
        dis.skip((long)skip - dis.getPos());
        try {
            prefixByte = this.headerFits.getIntFromHeader("LINE_PREFIX_BYTES");
        }
        catch (Exception e) {
            prefixByte = 0;
        }
        try {
            suffixByte = this.headerFits.getIntFromHeader("LINE_SUFFIX_BYTES");
        }
        catch (Exception e) {
            suffixByte = 0;
        }
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " BITPIX=" + this.bitpix + " => size=" + taille + (prefixByte > 0 ? " PREFIX_BYTES=" + prefixByte : "") + (suffixByte > 0 ? " SUFFIX_BYTES=" + suffixByte : "") + " image offset=" + skip);
        this.setPourcent(0.0);
        boolean bl = isCompressed = this.headerFits.getStringFromHeader("ENCODING_TYPE") != null;
        if (isCompressed) {
            int fileSize = this.headerFits.getIntFromHeader("FILE_RECORDS") * recordBytes;
            taille = fileSize - skip;
        } else {
            this.setCacheFromFile(dis);
        }
        Date d = new Date();
        this.tailleLoad = taille;
        boolean cut = this.aladin.configuration.getCMCut();
        this.offsetLoad = 0;
        this.setBufPixels8(new byte[this.width * this.height]);
        this.pixelsOrigin = new byte[taille];
        try {
            for (int i = 0; i < this.height; ++i) {
                if (prefixByte > 0) {
                    dis.skip(prefixByte);
                }
                dis.readFully(this.pixelsOrigin, i * this.width * this.npix, this.width * this.npix);
                if (suffixByte > 0) {
                    dis.skip(suffixByte);
                }
                this.setPourcent((double)(i * this.width * this.npix) * 85.0 / (double)taille);
            }
        }
        catch (Exception e) {
            this.error = Aladin.error = "Loading error: " + e.getMessage();
            e.printStackTrace();
            this.close();
            return false;
        }
        if (isCompressed) {
            byte[] pixelsOrigin1 = new byte[tailleImg];
            this.mocDecode(this.pixelsOrigin, pixelsOrigin1);
            this.setPourcent(92.0);
            this.pixelsOrigin = pixelsOrigin1;
        }
        this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, cut, 0, 0, 0, 0);
        this.to8bits(this.getBufPixels8(), 0, this.pixelsOrigin, this.width * this.height, this.bitpix, this.pixelMin, this.pixelMax, true);
        PlanImage.invImageLine(this.width, this.height, this.getBufPixels8());
        Date d1 = new Date();
        int temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Reading " + (isCompressed ? ", uncompressing " : "") + (cut ? ", autocutting " : "") + "in " + Util.round((double)temps / 1000.0, 3) + " s => " + Util.round((double)this.offsetLoad / (double)temps / 1048.576, 2) + " Mbyte/s");
        this.creatDefaultCM();
        this.setPourcent(99.0);
        return true;
    }

    protected void creatDefaultCM() {
        this.cm = CanvasColorMap.getCM(0, 128, 255, this.aladin.configuration.getCMVideo() == 1, this.aladin.configuration.getCMMap(), this.aladin.configuration.getCMFct(), this.isTransparent());
    }

    protected void setCM(Object cm) {
        this.cm = (ColorModel)cm;
        this.changeImgID();
        if (Aladin.ISLINUX) {
            this.aladin.view.recreateMemoryBufferFor(this);
        }
    }

    public boolean setCmParam(String s) {
        boolean flagCM = false;
        boolean flagPixel = false;
        boolean flagRescan = false;
        double minPix = this.pixelMin;
        double maxPix = this.pixelMax;
        boolean autocut = false;
        Tok tok = new Tok(s);
        while (tok.hasMoreTokens()) {
            s = tok.nextToken();
            int i = Util.indexInArrayOf(s, FrameColorMap.CMA, true);
            if (i != -1) {
                if (i == this.typeCM) continue;
                this.typeCM = i;
                flagCM = true;
                continue;
            }
            if (CanvasColorMap.customCMName != null && (i = CanvasColorMap.customCMName.indexOf(s)) >= 0) {
                if (this.typeCM == 4 + i) continue;
                this.typeCM = 4 + i;
                flagCM = true;
                continue;
            }
            i = Util.indexInArrayOf(s, TRANSFERTFCT, true);
            if (i >= 0) {
                if (i == this.transfertFct) continue;
                this.transfertFct = i;
                flagCM = true;
                continue;
            }
            if (s.equalsIgnoreCase("reverse") || s.equalsIgnoreCase("inverse")) {
                if (this.video == 1) continue;
                this.video = 1;
                flagCM = true;
                continue;
            }
            if (s.equalsIgnoreCase("noreverse")) {
                if (this.video == 0) continue;
                this.video = 0;
                flagCM = true;
                continue;
            }
            if (s.equalsIgnoreCase("autocut") || s.equalsIgnoreCase("cut")) {
                autocut = true;
                flagPixel = true;
                continue;
            }
            if (s.equalsIgnoreCase("noautocut") || s.equalsIgnoreCase("nocut")) {
                autocut = false;
                flagPixel = true;
                continue;
            }
            if (s.equalsIgnoreCase("rescan") || s.equalsIgnoreCase("localcut")) {
                flagRescan = true;
                continue;
            }
            if (s.equalsIgnoreCase("all")) {
                minPix = this.dataMin;
                maxPix = this.dataMax;
                flagPixel = true;
                continue;
            }
            i = s.indexOf("..");
            if (i <= 0) continue;
            try {
                int sgn = 1;
                int deb = 0;
                if (s.charAt(deb) == '-') {
                    ++deb;
                    sgn = -1;
                }
                minPix = (double)sgn * Double.parseDouble(s.substring(deb, i));
                minPix = (minPix - this.bZero) / this.bScale;
                sgn = 1;
                deb = i + 2;
                if (s.charAt(deb) == '-') {
                    ++deb;
                    sgn = -1;
                }
                maxPix = (double)sgn * Double.parseDouble(s.substring(deb));
                flagPixel = true;
                maxPix = (maxPix - this.bZero) / this.bScale;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (flagCM) {
            IndexColorModel cm = CanvasColorMap.getCM(this.cmControl[0], this.cmControl[1], this.cmControl[2], this.video == 1, this.typeCM, this.transfertFct);
            this.setCM(cm);
        }
        if (flagRescan) {
            if (!(this instanceof PlanBG) || !((PlanBG)this).isTruePixels()) {
                return false;
            }
            ((PlanBG)this).forceReload();
        } else if (flagPixel) {
            this.recut(minPix, maxPix, autocut);
        }
        if (!(flagCM || flagPixel || flagRescan)) {
            return false;
        }
        if (this.aladin.frameCM != null) {
            this.aladin.frameCM.majCMByScript(this);
        }
        this.changeImgID();
        return true;
    }

    public void reverse() {
        if (!(this.cm instanceof IndexColorModel)) {
            return;
        }
        this.video = this.video == 1 ? 0 : 1;
        IndexColorModel cm = CanvasColorMap.getCM(this.cmControl[0], this.cmControl[1], this.cmControl[2], this.video == 1, this.typeCM, this.transfertFct);
        this.setCM(cm);
    }

    protected boolean isPlanBase() {
        return this.aladin.calque.getPlanBase() == this;
    }

    protected void drawBord(Graphics g, ViewSimple v, int dx, int dy, float opacite, boolean aplat) {
        Coord c;
        Projection projv;
        if (v.isFree() || !Projection.isOk(projv = v.getProj())) {
            return;
        }
        g.setColor(Color.red);
        try {
            c = this.projd.c.getImgCenter();
        }
        catch (Exception e) {
            return;
        }
        double x = c.x;
        double y = c.y;
        Coord ct = new Coord();
        int[] polX = new int[4];
        int[] polY = new int[4];
        for (int i = 0; i < 4; ++i) {
            int sgnX = i < 2 ? -1 : 1;
            int sgnY = i == 1 || i == 2 ? 1 : -1;
            ct.x = c.x + (double)sgnX * x;
            ct.y = c.y + (double)sgnY * y;
            this.projd.getCoord(ct);
            if (Double.isNaN(ct.al)) {
                return;
            }
            projv.getXY(ct);
            if (Double.isNaN(ct.x)) {
                return;
            }
            Point p = v.getViewCoord(ct.x, ct.y);
            if (p == null) {
                return;
            }
            polX[i] = p.x + dx;
            polY[i] = p.y + dy;
            if (i != 0) continue;
            g.setFont(Aladin.SSPLAIN);
            g.drawString(this.label, p.x + dx, p.y - 2 + dy);
        }
        if (aplat && opacite != 0.0f && Aladin.ENABLE_FOOTPRINT_OPACITY && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Composite saveComposite = g2d.getComposite();
            Composite myComposite = Util.getFootprintComposite(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL * opacite);
            g2d.setComposite(myComposite);
            g2d.fillPolygon(polX, polY, 4);
            g2d.setComposite(saveComposite);
        }
        g.drawPolygon(polX, polY, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(Graphics g, ViewSimple v, int dx, int dy, float op) {
        block23: {
            if (v == null) {
                return;
            }
            long t1 = Util.getTime();
            if (op == -1.0f) {
                op = this.getOpacityLevel();
            }
            Graphics2D g2d = null;
            Composite saveComposite = null;
            AffineTransform saveTransform = null;
            try {
                AffineTransform tr;
                if ((double)op <= 0.1) {
                    return;
                }
                if (!this.projd.agree(this.projd, v)) {
                    return;
                }
                if (!(g instanceof Graphics2D)) {
                    return;
                }
                g2d = (Graphics2D)g;
                saveComposite = g2d.getComposite();
                saveTransform = g2d.getTransform();
                if ((double)op < 0.9) {
                    Composite myComposite = Util.getImageComposite(op);
                    g2d.setComposite(myComposite);
                }
                if ((tr = this.getAffineTransform(v)) == null) {
                    g2d.setComposite(saveComposite);
                    if (g2d != null && saveComposite != null) {
                        g2d.setComposite(saveComposite);
                    }
                    if (g2d != null && saveTransform != null) {
                        g2d.setTransform(saveTransform);
                    }
                    return;
                }
                g2d.setTransform(tr);
                g2d.drawImage(this.getImage(v, false), dx, dy, this.aladin);
                long t2 = Util.getTime();
                this.statTimeDisplay = t2 - t1;
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                break block23;
            }
            finally {
                if (g2d != null && saveComposite != null) {
                    g2d.setComposite(saveComposite);
                }
                if (g2d != null && saveTransform != null) {
                    g2d.setTransform(saveTransform);
                }
            }
            if (g2d != null && saveComposite != null) {
                g2d.setComposite(saveComposite);
            }
            if (g2d != null && saveTransform != null) {
                g2d.setTransform(saveTransform);
            }
        }
    }

    protected AffineTransform getAffineTransform(ViewSimple v) {
        if (v == null) {
            return null;
        }
        PointD[] b = this.getBords(v);
        if (b == null) {
            return null;
        }
        double b03x = b[3].x - b[0].x;
        double b03y = b[3].y - b[0].y;
        double angle = Math.atan2(b03y, b03x);
        double d03 = Math.sqrt(b03x * b03x + b03y * b03y);
        double mx = d03 / (double)this.width;
        double b01x = b[1].x - b[0].x;
        double b01y = b[1].y - b[0].y;
        double d01 = Math.sqrt(b01x * b01x + b01y * b01y);
        double angle01 = Math.atan2(b01y, b01x) - angle;
        double my = d01 * Math.sin(angle01) / (double)this.height;
        double sx = d01 * Math.cos(angle01) / d03;
        AffineTransform tr = new AffineTransform();
        tr.translate(b[0].x, b[0].y);
        tr.rotate(angle);
        tr.scale(mx, my);
        tr.shear(sx, 0.0);
        return tr;
    }

    protected PointD[] getBords(ViewSimple v) {
        Coord c;
        Projection projv;
        if (v.isFree() || !Projection.isOk(projv = v.getProj())) {
            return null;
        }
        try {
            c = this.projd.c.getImgCenter();
        }
        catch (Exception e) {
            return null;
        }
        double x = c.x;
        double y = c.y;
        Coord ct = new Coord();
        PointD[] p = new PointD[4];
        for (int i = 0; i < 4; ++i) {
            int sgnX = i < 2 ? -1 : 1;
            int sgnY = i == 1 || i == 2 ? 1 : -1;
            ct.x = c.x + (double)sgnX * x;
            ct.y = c.y + (double)sgnY * y;
            this.projd.getCoord(ct);
            if (Double.isNaN(ct.al)) {
                return null;
            }
            projv.getXY(ct);
            if (Double.isNaN(ct.x)) {
                return null;
            }
            p[i] = v.getViewCoordDble(ct.x, ct.y);
        }
        return p;
    }

    protected Point getCenter(Graphics g, ViewSimple v, int dx, int dy) {
        Coord c;
        Plan pr = v.pref;
        if (pr == null || !Projection.isOk(pr.projd)) {
            return null;
        }
        Projection proj = pr.projd;
        g.setColor(v.getInfoColor());
        try {
            c = this.projd.c.getImgCenter();
        }
        catch (Exception e) {
            return null;
        }
        this.projd.getCoord(c);
        proj.getXY(c);
        return v.getViewCoord(c.x, c.y);
    }

    protected void setBufPixels8(byte[] pixels) {
        this.pixels = pixels;
    }

    protected byte[] getBufPixels8() {
        return this.pixels;
    }

    protected void setPixels(byte[] pixels) {
        this.pixels = pixels;
    }

    @Override
    protected String getBookmarkCode() {
        String s = super.getBookmarkCode();
        if (s == null) {
            return null;
        }
        if (this.typeCM != 0) {
            s = s + "\ncm " + CanvasColorMap.getCMName(this.typeCM);
            if (this.video == 0) {
                s = s + " noreverse";
            }
            if (this.transfertFct != 3) {
                s = s + " " + TRANSFERTFCT[this.transfertFct];
            }
        }
        return s;
    }

    protected byte[] getLinearPixels8() {
        return this.getLinearPixels8(null);
    }

    protected byte[] getLinearPixels8(byte[] buf) {
        if (buf == null) {
            buf = new byte[this.width * this.height];
        }
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = PlanImage.getGreyPixel8(this.cm, this.pixels[i]);
        }
        return buf;
    }

    public static byte getGreyPixel8(ColorModel cm, byte pix) {
        int p = 0xFF & pix;
        int red = cm.getRed(p);
        int green = cm.getGreen(p);
        int blue = cm.getBlue(p);
        return (byte)((double)red * 0.299 + (double)green * 0.587 + (double)blue * 0.114);
    }

    public void setBitpix(int b) {
        this.bitpix = b;
    }

    static {
        TRANSFERTFCT = new String[]{"Asinh", "Log", "Sqrt", "Linear", "Pow2", " -- "};
        id = 0;
        MAXCACHEID = 1;
        tmp_inv = new byte[8];
    }
}

